/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.files.ccsds.ndm.odm.ocm;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.orekit.data.DataContext;
import org.orekit.files.ccsds.ndm.NdmConstituent;
import org.orekit.files.ccsds.ndm.odm.ocm.OcmData;
import org.orekit.files.ccsds.ndm.odm.ocm.OcmMetadata;
import org.orekit.files.ccsds.ndm.odm.ocm.OcmSatelliteEphemeris;
import org.orekit.files.ccsds.ndm.odm.ocm.TrajectoryStateHistory;
import org.orekit.files.ccsds.section.Header;
import org.orekit.files.ccsds.section.Segment;
import org.orekit.files.general.EphemerisFile;
import org.orekit.utils.IERSConventions;
import org.orekit.utils.TimeStampedPVCoordinates;

public class Ocm
extends NdmConstituent<Header, Segment<OcmMetadata, OcmData>>
implements EphemerisFile<TimeStampedPVCoordinates, TrajectoryStateHistory> {
    public static final String ROOT = "ocm";
    public static final String FORMAT_VERSION_KEY = "CCSDS_OCM_VERS";
    public static final String TRAJ_LINE = "trajLine";
    public static final String COV_LINE = "covLine";
    public static final String MAN_LINE = "manLine";
    public static final String UNKNOWN_OBJECT = "UNKNOWN";
    private final double mu;

    public Ocm(Header header, List<Segment<OcmMetadata, OcmData>> segments, IERSConventions conventions, DataContext dataContext, double mu) {
        super(header, segments, conventions, dataContext);
        this.mu = mu;
    }

    public OcmMetadata getMetadata() {
        return (OcmMetadata)((Segment)this.getSegments().get(0)).getMetadata();
    }

    public OcmData getData() {
        return (OcmData)((Segment)this.getSegments().get(0)).getData();
    }

    @Override
    public Map<String, OcmSatelliteEphemeris> getSatellites() {
        String name = this.getMetadata().getObjectName() != null ? this.getMetadata().getObjectName() : (this.getMetadata().getInternationalDesignator() != null ? this.getMetadata().getInternationalDesignator() : (this.getMetadata().getObjectDesignator() != null ? this.getMetadata().getObjectDesignator() : UNKNOWN_OBJECT));
        List<TrajectoryStateHistory> histories = ((OcmData)((Segment)this.getSegments().get(0)).getData()).getOTrajectoryBlocks();
        OcmSatelliteEphemeris ose = new OcmSatelliteEphemeris(name, this.mu, histories);
        return Collections.singletonMap(name, ose);
    }
}

