/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.files.ccsds.ndm;

import org.orekit.data.DataContext;
import org.orekit.files.ccsds.ndm.tdm.RangeUnitsConverter;
import org.orekit.time.AbsoluteDate;
import org.orekit.utils.IERSConventions;

public abstract class AbstractBuilder<T extends AbstractBuilder<T>> {
    private final IERSConventions conventions;
    private final DataContext dataContext;
    private final AbsoluteDate missionReferenceDate;
    private final RangeUnitsConverter rangeUnitsConverter;

    protected AbstractBuilder(IERSConventions conventions, DataContext dataContext, AbsoluteDate missionReferenceDate, RangeUnitsConverter rangeUnitsConverter) {
        this.conventions = conventions;
        this.dataContext = dataContext;
        this.missionReferenceDate = missionReferenceDate;
        this.rangeUnitsConverter = rangeUnitsConverter;
    }

    protected abstract T create(IERSConventions var1, DataContext var2, AbsoluteDate var3, RangeUnitsConverter var4);

    public T withConventions(IERSConventions newConventions) {
        return this.create(newConventions, this.getDataContext(), this.getMissionReferenceDate(), this.getRangeUnitsConverter());
    }

    public IERSConventions getConventions() {
        return this.conventions;
    }

    public T withDataContext(DataContext newDataContext) {
        return this.create(this.getConventions(), newDataContext, this.getMissionReferenceDate(), this.getRangeUnitsConverter());
    }

    public DataContext getDataContext() {
        return this.dataContext;
    }

    public T withMissionReferenceDate(AbsoluteDate newMissionReferenceDate) {
        return this.create(this.getConventions(), this.getDataContext(), newMissionReferenceDate, this.getRangeUnitsConverter());
    }

    public AbsoluteDate getMissionReferenceDate() {
        return this.missionReferenceDate;
    }

    public T withRangeUnitsConverter(RangeUnitsConverter newRangeUnitsConverter) {
        return this.create(this.getConventions(), this.getDataContext(), this.getMissionReferenceDate(), newRangeUnitsConverter);
    }

    public RangeUnitsConverter getRangeUnitsConverter() {
        return this.rangeUnitsConverter;
    }
}

