/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.estimation.sequential;

import java.util.List;
import org.orekit.annotation.DefaultDataContext;
import org.orekit.estimation.sequential.AbstractKalmanModel;
import org.orekit.estimation.sequential.CovarianceMatrixProvider;
import org.orekit.estimation.sequential.KalmanEstimator;
import org.orekit.propagation.PropagationType;
import org.orekit.propagation.Propagator;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.analytical.tle.TLEJacobiansMapper;
import org.orekit.propagation.analytical.tle.TLEPartialDerivativesEquations;
import org.orekit.propagation.analytical.tle.TLEPropagator;
import org.orekit.propagation.conversion.OrbitDeterminationPropagatorBuilder;
import org.orekit.propagation.integration.AbstractJacobiansMapper;
import org.orekit.utils.ParameterDriversList;

public class TLEKalmanModel
extends AbstractKalmanModel {
    public TLEKalmanModel(List<OrbitDeterminationPropagatorBuilder> propagatorBuilders, List<CovarianceMatrixProvider> covarianceMatricesProviders, ParameterDriversList estimatedMeasurementParameters, CovarianceMatrixProvider measurementProcessNoiseMatrix) {
        super(propagatorBuilders, covarianceMatricesProviders, estimatedMeasurementParameters, measurementProcessNoiseMatrix, new TLEJacobiansMapper[propagatorBuilders.size()]);
    }

    @Override
    @DefaultDataContext
    protected void updateReferenceTrajectories(Propagator[] propagators, PropagationType pType, PropagationType sType) {
        this.setReferenceTrajectories(propagators);
        AbstractJacobiansMapper[] mappers = this.getMappers();
        for (int k = 0; k < propagators.length; ++k) {
            String equationName = KalmanEstimator.class.getName() + "-derivatives-" + k;
            TLEPartialDerivativesEquations pde = new TLEPartialDerivativesEquations(equationName, (TLEPropagator)this.getReferenceTrajectories()[k]);
            SpacecraftState rawState = this.getReferenceTrajectories()[k].getInitialState();
            SpacecraftState stateWithDerivatives = pde.setInitialJacobians(rawState);
            ((TLEPropagator)this.getReferenceTrajectories()[k]).resetInitialState(stateWithDerivatives);
            mappers[k] = pde.getMapper();
        }
        this.setMappers(mappers);
    }

    @Override
    @DefaultDataContext
    protected void analyticalDerivativeComputations(AbstractJacobiansMapper mapper, SpacecraftState state) {
        ((TLEJacobiansMapper)mapper).analyticalDerivatives(state);
    }
}

