/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.estimation.measurements.modifiers;

import java.util.Arrays;
import java.util.List;
import org.hipparchus.CalculusFieldElement;
import org.hipparchus.Field;
import org.hipparchus.analysis.differentiation.Gradient;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.orekit.attitudes.InertialProvider;
import org.orekit.estimation.measurements.EstimatedMeasurement;
import org.orekit.estimation.measurements.EstimationModifier;
import org.orekit.estimation.measurements.GroundStation;
import org.orekit.estimation.measurements.TurnAroundRange;
import org.orekit.estimation.measurements.modifiers.TroposphericGradientConverter;
import org.orekit.models.earth.troposphere.DiscreteTroposphericModel;
import org.orekit.propagation.FieldSpacecraftState;
import org.orekit.propagation.SpacecraftState;
import org.orekit.utils.Differentiation;
import org.orekit.utils.ParameterDriver;
import org.orekit.utils.ParameterFunction;

public class TurnAroundRangeTroposphericDelayModifier
implements EstimationModifier<TurnAroundRange> {
    private final DiscreteTroposphericModel tropoModel;

    public TurnAroundRangeTroposphericDelayModifier(DiscreteTroposphericModel model) {
        this.tropoModel = model;
    }

    private double rangeErrorTroposphericModel(GroundStation station, SpacecraftState state) {
        Vector3D position = state.getPVCoordinates().getPosition();
        double elevation = station.getBaseFrame().getElevation(position, state.getFrame(), state.getDate());
        if (elevation > 0.0) {
            double delay = this.tropoModel.pathDelay(elevation, station.getBaseFrame().getPoint(), this.tropoModel.getParameters(), state.getDate());
            return delay;
        }
        return 0.0;
    }

    private <T extends CalculusFieldElement<T>> T rangeErrorTroposphericModel(GroundStation station, FieldSpacecraftState<T> state, T[] parameters) {
        Field<T> field = state.getDate().getField();
        CalculusFieldElement zero = (CalculusFieldElement)field.getZero();
        FieldVector3D position = state.getPVCoordinates().getPosition();
        Object dsElevation = station.getBaseFrame().getElevation(position, state.getFrame(), state.getDate());
        if (dsElevation.getReal() > 0.0) {
            CalculusFieldElement delay = this.tropoModel.pathDelay((CalculusFieldElement)dsElevation, station.getBaseFrame().getPoint(field), (CalculusFieldElement[])parameters, state.getDate());
            return (T)delay;
        }
        return (T)zero;
    }

    private double[][] rangeErrorJacobianState(double[] derivatives) {
        double[][] finiteDifferencesJacobian = new double[1][6];
        System.arraycopy(derivatives, 0, finiteDifferencesJacobian[0], 0, 6);
        return finiteDifferencesJacobian;
    }

    private double rangeErrorParameterDerivative(final GroundStation station, ParameterDriver driver, final SpacecraftState state) {
        ParameterFunction rangeError = new ParameterFunction(){

            @Override
            public double value(ParameterDriver parameterDriver) {
                return TurnAroundRangeTroposphericDelayModifier.this.rangeErrorTroposphericModel(station, state);
            }
        };
        ParameterFunction rangeErrorDerivative = Differentiation.differentiate(rangeError, 3, 10.0 * driver.getScale());
        return rangeErrorDerivative.value(driver);
    }

    private double[] rangeErrorParameterDerivative(double[] derivatives, int freeStateParameters) {
        int dim = derivatives.length - freeStateParameters;
        double[] rangeError = new double[dim];
        for (int i = 0; i < dim; ++i) {
            rangeError[i] = derivatives[freeStateParameters + i];
        }
        return rangeError;
    }

    @Override
    public List<ParameterDriver> getParametersDrivers() {
        return this.tropoModel.getParametersDrivers();
    }

    @Override
    public void modify(EstimatedMeasurement<TurnAroundRange> estimated) {
        double parameterDerivative;
        TurnAroundRange measurement = estimated.getObservedMeasurement();
        GroundStation primaryStation = measurement.getPrimaryStation();
        GroundStation secondaryStation = measurement.getSecondaryStation();
        SpacecraftState state = estimated.getStates()[0];
        double[] oldValue = estimated.getEstimatedValue();
        TroposphericGradientConverter converter = new TroposphericGradientConverter(state, 6, new InertialProvider(state.getFrame()));
        FieldSpacecraftState<Gradient> gState = converter.getState(this.tropoModel);
        Gradient[] gParameters = converter.getParameters(gState, this.tropoModel);
        Gradient primaryGDelay = (Gradient)this.rangeErrorTroposphericModel(primaryStation, gState, (CalculusFieldElement[])gParameters);
        Gradient secondaryGDelay = (Gradient)this.rangeErrorTroposphericModel(secondaryStation, gState, (CalculusFieldElement[])gParameters);
        double[] primaryDerivatives = primaryGDelay.getGradient();
        double[] secondaryDerivatives = secondaryGDelay.getGradient();
        double[][] primaryDjac = this.rangeErrorJacobianState(primaryDerivatives);
        double[][] secondaryDjac = this.rangeErrorJacobianState(secondaryDerivatives);
        double[][] stateDerivatives = estimated.getStateDerivatives(0);
        for (int irow = 0; irow < stateDerivatives.length; ++irow) {
            for (int jcol = 0; jcol < stateDerivatives[0].length; ++jcol) {
                double[] dArray = stateDerivatives[irow];
                int n = jcol;
                dArray[n] = dArray[n] + (primaryDjac[irow][jcol] + secondaryDjac[irow][jcol]);
            }
        }
        estimated.setStateDerivatives(0, stateDerivatives);
        int indexPrimary = 0;
        for (ParameterDriver parameterDriver : this.getParametersDrivers()) {
            if (!parameterDriver.isSelected()) continue;
            double parameterDerivative2 = estimated.getParameterDerivatives(parameterDriver)[0];
            double[] derivatives = this.rangeErrorParameterDerivative(primaryDerivatives, converter.getFreeStateParameters());
            estimated.setParameterDerivatives(parameterDriver, parameterDerivative2 += derivatives[indexPrimary]);
            ++indexPrimary;
        }
        int indexSecondary = 0;
        for (ParameterDriver driver : this.getParametersDrivers()) {
            if (!driver.isSelected()) continue;
            parameterDerivative = estimated.getParameterDerivatives(driver)[0];
            double[] derivatives = this.rangeErrorParameterDerivative(secondaryDerivatives, converter.getFreeStateParameters());
            estimated.setParameterDerivatives(driver, parameterDerivative += derivatives[indexSecondary]);
            ++indexSecondary;
        }
        for (ParameterDriver driver : Arrays.asList(primaryStation.getClockOffsetDriver(), primaryStation.getEastOffsetDriver(), primaryStation.getNorthOffsetDriver(), primaryStation.getZenithOffsetDriver())) {
            if (!driver.isSelected()) continue;
            parameterDerivative = estimated.getParameterDerivatives(driver)[0];
            estimated.setParameterDerivatives(driver, parameterDerivative += this.rangeErrorParameterDerivative(primaryStation, driver, state));
        }
        for (ParameterDriver driver : Arrays.asList(secondaryStation.getEastOffsetDriver(), secondaryStation.getNorthOffsetDriver(), secondaryStation.getZenithOffsetDriver())) {
            if (!driver.isSelected()) continue;
            parameterDerivative = estimated.getParameterDerivatives(driver)[0];
            estimated.setParameterDerivatives(driver, parameterDerivative += this.rangeErrorParameterDerivative(secondaryStation, driver, state));
        }
        double[] dArray = (double[])oldValue.clone();
        dArray[0] = dArray[0] + primaryGDelay.getReal() + secondaryGDelay.getReal();
        estimated.setEstimatedValue(dArray);
    }
}

