/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.special.elliptic.carlson;

import org.hipparchus.CalculusFieldElement;
import org.hipparchus.FieldElement;
import org.hipparchus.complex.Complex;
import org.hipparchus.complex.FieldComplex;
import org.hipparchus.special.elliptic.carlson.RcFieldDuplication;
import org.hipparchus.special.elliptic.carlson.RcRealDuplication;
import org.hipparchus.special.elliptic.carlson.RdFieldDuplication;
import org.hipparchus.special.elliptic.carlson.RdRealDuplication;
import org.hipparchus.special.elliptic.carlson.RfFieldDuplication;
import org.hipparchus.special.elliptic.carlson.RfRealDuplication;
import org.hipparchus.special.elliptic.carlson.RjFieldDuplication;
import org.hipparchus.special.elliptic.carlson.RjRealDuplication;
import org.hipparchus.util.FastMath;

public class CarlsonEllipticIntegral {
    private CarlsonEllipticIntegral() {
    }

    public static double rC(double x, double y) {
        if (y < 0.0) {
            double xMy = x - y;
            return FastMath.sqrt(x / xMy) * new RcRealDuplication(xMy, -y).integral();
        }
        return new RcRealDuplication(x, y).integral();
    }

    public static <T extends CalculusFieldElement<T>> T rC(T x, T y) {
        if (y.getReal() < 0.0) {
            T xMy = x.subtract(y);
            return (T)((CalculusFieldElement)FastMath.sqrt(x.divide(xMy)).multiply(new RcFieldDuplication<CalculusFieldElement>(xMy, (CalculusFieldElement)y.negate()).integral()));
        }
        return new RcFieldDuplication<T>(x, y).integral();
    }

    public static Complex rC(Complex x, Complex y) {
        if (y.getImaginaryPart() == 0.0 && y.getRealPart() < 0.0) {
            Complex xMy = x.subtract(y);
            return FastMath.sqrt(x.divide(xMy)).multiply((Complex)new RcFieldDuplication<Complex>(xMy, y.negate()).integral());
        }
        return (Complex)new RcFieldDuplication<Complex>(x, y).integral();
    }

    public static <T extends CalculusFieldElement<T>> FieldComplex<T> rC(FieldComplex<T> x, FieldComplex<T> y) {
        if (y.getImaginaryPart().isZero() && y.getRealPart().getReal() < 0.0) {
            FieldComplex<FieldComplex<T>> xMy = x.subtract((FieldComplex<FieldComplex<FieldComplex<T>>>)y);
            return FastMath.sqrt(x.divide((FieldComplex<FieldComplex<FieldComplex<T>>>)xMy)).multiply((FieldComplex)new RcFieldDuplication<FieldElement>(xMy, y.negate()).integral());
        }
        return (FieldComplex)new RcFieldDuplication<FieldComplex<T>>(x, y).integral();
    }

    public static double rF(double x, double y, double z) {
        return new RfRealDuplication(x, y, z).integral();
    }

    public static <T extends CalculusFieldElement<T>> T rF(T x, T y, T z) {
        return new RfFieldDuplication<T>(x, y, z).integral();
    }

    public static Complex rF(Complex x, Complex y, Complex z) {
        return new RfFieldDuplication<Complex>(x, y, z).integral();
    }

    public static <T extends CalculusFieldElement<T>> FieldComplex<T> rF(FieldComplex<T> x, FieldComplex<T> y, FieldComplex<T> z) {
        return new RfFieldDuplication<FieldComplex<T>>(x, y, z).integral();
    }

    public static double rJ(double x, double y, double z, double p) {
        double delta = (p - x) * (p - y) * (p - z);
        return CarlsonEllipticIntegral.rJ(x, y, z, p, delta);
    }

    public static double rJ(double x, double y, double z, double p, double delta) {
        return new RjRealDuplication(x, y, z, p, delta).integral();
    }

    public static <T extends CalculusFieldElement<T>> T rJ(T x, T y, T z, T p) {
        T delta = p.subtract(x).multiply(p.subtract(y)).multiply(p.subtract(z));
        return new RjFieldDuplication<T>(x, y, z, p, delta).integral();
    }

    public static <T extends CalculusFieldElement<T>> T rJ(T x, T y, T z, T p, T delta) {
        return new RjFieldDuplication<T>(x, y, z, p, delta).integral();
    }

    public static Complex rJ(Complex x, Complex y, Complex z, Complex p) {
        Complex delta = p.subtract(x).multiply(p.subtract(y)).multiply(p.subtract(z));
        return (Complex)new RjFieldDuplication<Complex>(x, y, z, p, delta).integral();
    }

    public static Complex rJ(Complex x, Complex y, Complex z, Complex p, Complex delta) {
        return (Complex)new RjFieldDuplication<Complex>(x, y, z, p, delta).integral();
    }

    public static <T extends CalculusFieldElement<T>> FieldComplex<T> rJ(FieldComplex<T> x, FieldComplex<T> y, FieldComplex<T> z, FieldComplex<T> p) {
        FieldComplex<FieldComplex<FieldComplex<T>>> delta = p.subtract((FieldComplex<FieldComplex<FieldComplex<T>>>)x).multiply((FieldComplex<FieldComplex<FieldComplex<T>>>)p.subtract((FieldComplex<FieldComplex<FieldComplex<T>>>)y)).multiply((FieldComplex<FieldComplex<FieldComplex<FieldComplex<T>>>>)p.subtract((FieldComplex<FieldComplex<FieldComplex<T>>>)z));
        return (FieldComplex)new RjFieldDuplication<FieldComplex<FieldComplex<FieldComplex<T>>>>(x, y, z, p, delta).integral();
    }

    public static <T extends CalculusFieldElement<T>> FieldComplex<T> rJ(FieldComplex<T> x, FieldComplex<T> y, FieldComplex<T> z, FieldComplex<T> p, FieldComplex<T> delta) {
        return (FieldComplex)new RjFieldDuplication<FieldComplex<T>>(x, y, z, p, delta).integral();
    }

    public static double rD(double x, double y, double z) {
        return new RdRealDuplication(x, y, z).integral();
    }

    public static <T extends CalculusFieldElement<T>> T rD(T x, T y, T z) {
        return new RdFieldDuplication<T>(x, y, z).integral();
    }

    public static Complex rD(Complex x, Complex y, Complex z) {
        return (Complex)new RdFieldDuplication<Complex>(x, y, z).integral();
    }

    public static <T extends CalculusFieldElement<T>> FieldComplex<T> rD(FieldComplex<T> x, FieldComplex<T> y, FieldComplex<T> z) {
        return (FieldComplex)new RdFieldDuplication<FieldComplex<T>>(x, y, z).integral();
    }

    public static double rG(double x, double y, double z) {
        return CarlsonEllipticIntegral.generalComputeRg(x, y, z);
    }

    public static <T extends CalculusFieldElement<T>> T rG(T x, T y, T z) {
        return CarlsonEllipticIntegral.generalComputeRg(x, y, z);
    }

    public static Complex rG(Complex x, Complex y, Complex z) {
        return CarlsonEllipticIntegral.generalComputeRg(x, y, z);
    }

    public static <T extends CalculusFieldElement<T>> FieldComplex<T> rG(FieldComplex<T> x, FieldComplex<T> y, FieldComplex<T> z) {
        return CarlsonEllipticIntegral.generalComputeRg(x, y, z);
    }

    private static double generalComputeRg(double x, double y, double z) {
        if (x <= y) {
            if (y <= z) {
                return CarlsonEllipticIntegral.permutedComputeRg(x, z, y);
            }
            if (x <= z) {
                return CarlsonEllipticIntegral.permutedComputeRg(x, y, z);
            }
            return CarlsonEllipticIntegral.permutedComputeRg(z, y, x);
        }
        if (x <= z) {
            return CarlsonEllipticIntegral.permutedComputeRg(y, z, x);
        }
        if (y <= z) {
            return CarlsonEllipticIntegral.permutedComputeRg(y, x, z);
        }
        return CarlsonEllipticIntegral.permutedComputeRg(z, x, y);
    }

    private static <T extends CalculusFieldElement<T>> T generalComputeRg(T x, T y, T z) {
        double xR = x.getReal();
        double yR = y.getReal();
        double zR = z.getReal();
        if (xR <= yR) {
            if (yR <= zR) {
                return CarlsonEllipticIntegral.permutedComputeRg(x, z, y);
            }
            if (xR <= zR) {
                return CarlsonEllipticIntegral.permutedComputeRg(x, y, z);
            }
            return CarlsonEllipticIntegral.permutedComputeRg(z, y, x);
        }
        if (xR <= zR) {
            return CarlsonEllipticIntegral.permutedComputeRg(y, z, x);
        }
        if (yR <= zR) {
            return CarlsonEllipticIntegral.permutedComputeRg(y, x, z);
        }
        return CarlsonEllipticIntegral.permutedComputeRg(z, x, y);
    }

    private static double permutedComputeRg(double x, double y, double z) {
        if (z == 0.0) {
            return x == 0.0 ? CarlsonEllipticIntegral.safeComputeRg(z, x, y) : CarlsonEllipticIntegral.safeComputeRg(y, z, x);
        }
        return CarlsonEllipticIntegral.safeComputeRg(x, y, z);
    }

    private static <T extends CalculusFieldElement<T>> T permutedComputeRg(T x, T y, T z) {
        if (z.isZero()) {
            return x.isZero() ? CarlsonEllipticIntegral.safeComputeRg(z, x, y) : CarlsonEllipticIntegral.safeComputeRg(y, z, x);
        }
        return CarlsonEllipticIntegral.safeComputeRg(x, y, z);
    }

    private static double safeComputeRg(double x, double y, double z) {
        double termF = new RfRealDuplication(x, y, z).integral() * z;
        double termD = (x - z) * (y - z) * new RdRealDuplication(x, y, z).integral() / 3.0;
        double termS = FastMath.sqrt(x * y / z);
        return (termF - termD + termS) * 0.5;
    }

    private static <T extends CalculusFieldElement<T>> T safeComputeRg(T x, T y, T z) {
        CalculusFieldElement termF = new RfFieldDuplication<T>(x, y, z).integral().multiply(z);
        CalculusFieldElement termD = (CalculusFieldElement)((CalculusFieldElement)x.subtract(z).multiply(y.subtract(z)).multiply(new RdFieldDuplication<T>(x, y, z).integral())).divide(3.0);
        CalculusFieldElement termS = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)x.sqrt()).multiply(y.sqrt())).divide(z.sqrt());
        return (T)((CalculusFieldElement)termF.subtract((CalculusFieldElement)termD).add(termS).multiply(0.5));
    }
}

