/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.time;

import org.hipparchus.CalculusFieldElement;
import org.hipparchus.FieldElement;
import org.hipparchus.util.FastMath;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.time.TimeScale;
import org.orekit.time.UT1Scale;

public class GMSTScale
implements TimeScale {
    private static final long serialVersionUID = 20131209L;
    private static final double FULL_DAY = 86400.0;
    private static final double HALF_DAY = 43200.0;
    private static final double C0 = 24110.54841;
    private static final double C1 = 8640184.812866;
    private static final double C2 = 0.093104;
    private static final double C3 = -6.2E-6;
    private final UT1Scale ut1;
    private final AbsoluteDate referenceDate;

    GMSTScale(UT1Scale ut1) {
        this.ut1 = ut1;
        this.referenceDate = new AbsoluteDate(2000, 1, 1, 12, 0, 0.0, (TimeScale)ut1);
    }

    @Override
    public double offsetFromTAI(AbsoluteDate date) {
        double ts = date.durationFrom(this.referenceDate);
        double tc = ts / 3.15576E9;
        double gmst0h = 24110.54841 + tc * (8640184.812866 + tc * (0.093104 + tc * -6.2E-6));
        double offset = gmst0h + this.ut1.offsetFromTAI(date);
        return offset - 86400.0 * FastMath.floor((double)((offset + 43200.0) / 86400.0));
    }

    @Override
    public <T extends CalculusFieldElement<T>> T offsetFromTAI(FieldAbsoluteDate<T> date) {
        T ts = date.durationFrom(this.referenceDate);
        CalculusFieldElement tc = (CalculusFieldElement)ts.divide(3.15576E9);
        CalculusFieldElement gmst0h = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)tc.multiply(-6.2E-6)).add(0.093104)).multiply((FieldElement)tc)).add(8640184.812866)).multiply((FieldElement)tc)).add(24110.54841);
        CalculusFieldElement offset = (CalculusFieldElement)gmst0h.add(this.ut1.offsetFromTAI(date));
        return (T)((CalculusFieldElement)offset.subtract(86400.0 * FastMath.floor((double)((offset.getReal() + 43200.0) / 86400.0))));
    }

    @Override
    public String getName() {
        return "GMST";
    }

    public String toString() {
        return this.getName();
    }
}

