/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.files.general;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.orekit.annotation.DefaultDataContext;
import org.orekit.bodies.CelestialBody;
import org.orekit.data.DataContext;
import org.orekit.errors.OrekitIllegalArgumentException;
import org.orekit.errors.OrekitMessages;
import org.orekit.files.general.EphemerisFile;
import org.orekit.frames.Frame;
import org.orekit.propagation.SpacecraftState;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.TimeScale;
import org.orekit.utils.CartesianDerivativesFilter;
import org.orekit.utils.TimeStampedPVCoordinates;

public class OrekitEphemerisFile
implements EphemerisFile<TimeStampedPVCoordinates, OrekitEphemerisSegment> {
    private final Map<String, OrekitSatelliteEphemeris> satellites = new ConcurrentHashMap<String, OrekitSatelliteEphemeris>();

    @Override
    public Map<String, OrekitSatelliteEphemeris> getSatellites() {
        return Collections.unmodifiableMap(this.satellites);
    }

    public OrekitSatelliteEphemeris addSatellite(String id) {
        OrekitSatelliteEphemeris newSat = new OrekitSatelliteEphemeris(id);
        this.satellites.put(id, newSat);
        return newSat;
    }

    public static class OrekitEphemerisSegment
    implements EphemerisFile.EphemerisSegment<TimeStampedPVCoordinates> {
        private final List<TimeStampedPVCoordinates> coordinates;
        private final Frame frame;
        private final double mu;
        private final int interpolationSamples;

        public OrekitEphemerisSegment(List<TimeStampedPVCoordinates> coordinates, Frame frame, double mu, int interpolationSamples) {
            this.coordinates = coordinates;
            this.frame = frame;
            this.mu = mu;
            this.interpolationSamples = interpolationSamples;
        }

        @Override
        public double getMu() {
            return this.mu;
        }

        @Override
        public Frame getFrame() {
            return this.frame;
        }

        @Override
        public Frame getInertialFrame() {
            return this.frame;
        }

        @Override
        public int getInterpolationSamples() {
            return this.interpolationSamples;
        }

        @Override
        public CartesianDerivativesFilter getAvailableDerivatives() {
            return CartesianDerivativesFilter.USE_PV;
        }

        @Override
        public List<TimeStampedPVCoordinates> getCoordinates() {
            return Collections.unmodifiableList(this.coordinates);
        }

        @Override
        public AbsoluteDate getStart() {
            return this.coordinates.get(0).getDate();
        }

        @Override
        public AbsoluteDate getStop() {
            return this.coordinates.get(this.coordinates.size() - 1).getDate();
        }
    }

    public static class OrekitSatelliteEphemeris
    implements EphemerisFile.SatelliteEphemeris<TimeStampedPVCoordinates, OrekitEphemerisSegment> {
        public static final int DEFAULT_INTERPOLATION_SIZE = 2;
        private final String id;
        private AbsoluteDate startDate;
        private AbsoluteDate stopDate;
        private final List<OrekitEphemerisSegment> segments;

        public OrekitSatelliteEphemeris(String id) {
            this.id = id;
            this.segments = new ArrayList<OrekitEphemerisSegment>();
        }

        @Override
        public String getId() {
            return this.id;
        }

        @Override
        public double getMu() {
            if (this.segments.size() == 0) {
                return 0.0;
            }
            return this.segments.get(0).getMu();
        }

        @Override
        public List<OrekitEphemerisSegment> getSegments() {
            return Collections.unmodifiableList(this.segments);
        }

        @Override
        public AbsoluteDate getStart() {
            return this.startDate;
        }

        @Override
        public AbsoluteDate getStop() {
            return this.stopDate;
        }

        @DefaultDataContext
        public OrekitEphemerisSegment addNewSegment(List<SpacecraftState> states) {
            return this.addNewSegment(states, 2);
        }

        @DefaultDataContext
        public OrekitEphemerisSegment addNewSegment(List<SpacecraftState> states, int interpolationSampleSize) {
            return this.addNewSegment(states, DataContext.getDefault().getCelestialBodies().getEarth(), interpolationSampleSize);
        }

        @DefaultDataContext
        public OrekitEphemerisSegment addNewSegment(List<SpacecraftState> states, CelestialBody body, int interpolationSampleSize) {
            return this.addNewSegment(states, body, interpolationSampleSize, DataContext.getDefault().getTimeScales().getUTC());
        }

        public OrekitEphemerisSegment addNewSegment(List<SpacecraftState> states, CelestialBody body, int interpolationSampleSize, TimeScale timeScale) {
            int minimumSampleSize = 2;
            if (states == null || states.size() == 0) {
                throw new OrekitIllegalArgumentException(OrekitMessages.NULL_ARGUMENT, "states");
            }
            if (interpolationSampleSize < 2) {
                throw new OrekitIllegalArgumentException(OrekitMessages.NOT_ENOUGH_DATA_FOR_INTERPOLATION, interpolationSampleSize);
            }
            AbsoluteDate start = states.get(0).getDate();
            AbsoluteDate stop = states.get(states.size() - 1).getDate();
            if (this.startDate == null || start.compareTo(this.startDate) < 0) {
                this.startDate = start;
            }
            if (this.stopDate == null || stop.compareTo(this.stopDate) > 0) {
                this.stopDate = stop;
            }
            ArrayList<TimeStampedPVCoordinates> coordinates = new ArrayList<TimeStampedPVCoordinates>();
            for (SpacecraftState state : states) {
                coordinates.add(state.getPVCoordinates());
            }
            Frame frame = states.get(0).getFrame();
            OrekitEphemerisSegment newSeg = new OrekitEphemerisSegment(coordinates, frame, body.getGM(), interpolationSampleSize);
            this.segments.add(newSeg);
            return newSeg;
        }
    }
}

