/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.files.ccsds.ndm.adm.apm;

import java.io.IOException;
import org.orekit.files.ccsds.definitions.Units;
import org.orekit.files.ccsds.ndm.adm.apm.SpacecraftParameters;
import org.orekit.files.ccsds.ndm.adm.apm.SpacecraftParametersKey;
import org.orekit.files.ccsds.section.AbstractWriter;
import org.orekit.files.ccsds.utils.generation.Generator;

class SpacecraftParametersWriter
extends AbstractWriter {
    private final SpacecraftParameters spacecraftParameters;

    SpacecraftParametersWriter(String xmlTag, String kvnTag, SpacecraftParameters spacecraftParameters) {
        super(xmlTag, kvnTag);
        this.spacecraftParameters = spacecraftParameters;
    }

    @Override
    protected void writeContent(Generator generator) throws IOException {
        generator.writeComments(this.spacecraftParameters.getComments());
        if (this.spacecraftParameters.getInertiaReferenceFrame() != null) {
            generator.writeEntry(SpacecraftParametersKey.INERTIA_REF_FRAME.name(), this.spacecraftParameters.getInertiaReferenceFrame().getName(), null, false);
        }
        generator.writeEntry(SpacecraftParametersKey.I11.name(), this.spacecraftParameters.getI11(), Units.KG_M2, true);
        generator.writeEntry(SpacecraftParametersKey.I22.name(), this.spacecraftParameters.getI22(), Units.KG_M2, true);
        generator.writeEntry(SpacecraftParametersKey.I33.name(), this.spacecraftParameters.getI33(), Units.KG_M2, true);
        generator.writeEntry(SpacecraftParametersKey.I12.name(), this.spacecraftParameters.getI12(), Units.KG_M2, true);
        generator.writeEntry(SpacecraftParametersKey.I13.name(), this.spacecraftParameters.getI13(), Units.KG_M2, true);
        generator.writeEntry(SpacecraftParametersKey.I23.name(), this.spacecraftParameters.getI23(), Units.KG_M2, true);
    }
}

