/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.files.ccsds.ndm.adm.apm;

import java.io.IOException;
import org.hipparchus.complex.Quaternion;
import org.orekit.files.ccsds.definitions.TimeConverter;
import org.orekit.files.ccsds.ndm.adm.apm.ApmQuaternion;
import org.orekit.files.ccsds.ndm.adm.apm.ApmQuaternionKey;
import org.orekit.files.ccsds.section.AbstractWriter;
import org.orekit.files.ccsds.utils.generation.Generator;
import org.orekit.utils.units.Unit;

class ApmQuaternionWriter
extends AbstractWriter {
    private final ApmQuaternion quaternion;
    private final TimeConverter timeConverter;

    ApmQuaternionWriter(String xmlTag, String kvnTag, ApmQuaternion quaternion, TimeConverter timeConverter) {
        super(xmlTag, kvnTag);
        this.quaternion = quaternion;
        this.timeConverter = timeConverter;
    }

    @Override
    protected void writeContent(Generator generator) throws IOException {
        generator.writeEntry(ApmQuaternionKey.EPOCH.name(), this.timeConverter, this.quaternion.getEpoch(), true);
        generator.writeEntry(ApmQuaternionKey.Q_FRAME_A.name(), this.quaternion.getEndpoints().getFrameA().getName(), null, true);
        generator.writeEntry(ApmQuaternionKey.Q_FRAME_B.name(), this.quaternion.getEndpoints().getFrameB().getName(), null, true);
        generator.writeEntry(ApmQuaternionKey.Q_DIR.name(), this.quaternion.getEndpoints().isA2b() ? "A2B" : "B2A", null, true);
        Quaternion q = this.quaternion.getQuaternion();
        generator.writeEntry(ApmQuaternionKey.Q1.name(), q.getQ1(), Unit.ONE, true);
        generator.writeEntry(ApmQuaternionKey.Q2.name(), q.getQ2(), Unit.ONE, true);
        generator.writeEntry(ApmQuaternionKey.Q3.name(), q.getQ3(), Unit.ONE, true);
        generator.writeEntry(ApmQuaternionKey.QC.name(), q.getQ0(), Unit.ONE, true);
        if (this.quaternion.hasRates()) {
            Quaternion qDot = this.quaternion.getQuaternionDot();
            generator.writeEntry(ApmQuaternionKey.Q1_DOT.name(), qDot.getQ1(), Unit.ONE, true);
            generator.writeEntry(ApmQuaternionKey.Q2_DOT.name(), qDot.getQ2(), Unit.ONE, true);
            generator.writeEntry(ApmQuaternionKey.Q3_DOT.name(), qDot.getQ3(), Unit.ONE, true);
            generator.writeEntry(ApmQuaternionKey.QC_DOT.name(), qDot.getQ0(), Unit.ONE, true);
        }
    }
}

