/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.analysis.integration.gauss;

import org.hipparchus.analysis.integration.gauss.AbstractRuleFactory;
import org.hipparchus.exception.MathIllegalArgumentException;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.Pair;

public class HermiteRuleFactory
extends AbstractRuleFactory {
    private static final double SQRT_PI = 1.772453850905516;

    @Override
    protected Pair<double[], double[]> computeRule(int numberOfPoints) throws MathIllegalArgumentException {
        if (numberOfPoints == 1) {
            return new Pair<double[], double[]>(new double[]{0.0}, new double[]{1.772453850905516});
        }
        double[] points = this.findRoots(numberOfPoints, new Hermite(numberOfPoints)::ratio);
        this.enforceSymmetry(points);
        double[] weights = new double[numberOfPoints];
        Hermite hm1 = new Hermite(numberOfPoints - 1);
        for (int i = 0; i < numberOfPoints; ++i) {
            double y = hm1.hNhNm1(points[i])[0];
            weights[i] = 1.772453850905516 / ((double)numberOfPoints * y * y);
        }
        return new Pair<double[], double[]>(points, weights);
    }

    private static class Hermite {
        private static final double SQRT2 = FastMath.sqrt(2.0);
        private final int degree;

        Hermite(int degree) {
            this.degree = degree;
        }

        public double ratio(double x) {
            double[] h = this.hNhNm1(x);
            return h[0] / (h[1] * 2.0 * (double)this.degree);
        }

        private double[] hNhNm1(double x) {
            double[] h = new double[]{SQRT2 * x, 1.0};
            double sqrtN = 1.0;
            for (int n = 1; n < this.degree; ++n) {
                double sqrtNp = FastMath.sqrt(n + 1);
                double hp = (h[0] * x * SQRT2 - h[1] * sqrtN) / sqrtNp;
                h[1] = h[0];
                h[0] = hp;
                sqrtN = sqrtNp;
            }
            return h;
        }
    }
}

