/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.ode.sampling;

import org.hipparchus.exception.MathIllegalStateException;
import org.hipparchus.ode.EquationsMapper;
import org.hipparchus.ode.ODEStateAndDerivative;
import org.hipparchus.ode.sampling.ODEStateInterpolator;
import org.hipparchus.util.FastMath;

public abstract class AbstractODEStateInterpolator
implements ODEStateInterpolator {
    private static final long serialVersionUID = 20160328L;
    private final ODEStateAndDerivative globalPreviousState;
    private final ODEStateAndDerivative globalCurrentState;
    private final ODEStateAndDerivative softPreviousState;
    private final ODEStateAndDerivative softCurrentState;
    private final boolean forward;
    private EquationsMapper mapper;

    protected AbstractODEStateInterpolator(boolean isForward, ODEStateAndDerivative globalPreviousState, ODEStateAndDerivative globalCurrentState, ODEStateAndDerivative softPreviousState, ODEStateAndDerivative softCurrentState, EquationsMapper equationsMapper) {
        this.forward = isForward;
        this.globalPreviousState = globalPreviousState;
        this.globalCurrentState = globalCurrentState;
        this.softPreviousState = softPreviousState;
        this.softCurrentState = softCurrentState;
        this.mapper = equationsMapper;
    }

    public AbstractODEStateInterpolator restrictStep(ODEStateAndDerivative previousState, ODEStateAndDerivative currentState) {
        return this.create(this.forward, this.globalPreviousState, this.globalCurrentState, previousState, currentState, this.mapper);
    }

    protected abstract AbstractODEStateInterpolator create(boolean var1, ODEStateAndDerivative var2, ODEStateAndDerivative var3, ODEStateAndDerivative var4, ODEStateAndDerivative var5, EquationsMapper var6);

    public ODEStateAndDerivative getGlobalPreviousState() {
        return this.globalPreviousState;
    }

    public ODEStateAndDerivative getGlobalCurrentState() {
        return this.globalCurrentState;
    }

    @Override
    public ODEStateAndDerivative getPreviousState() {
        return this.softPreviousState;
    }

    @Override
    public boolean isPreviousStateInterpolated() {
        return this.softPreviousState != this.globalPreviousState;
    }

    @Override
    public ODEStateAndDerivative getCurrentState() {
        return this.softCurrentState;
    }

    @Override
    public boolean isCurrentStateInterpolated() {
        return this.softCurrentState != this.globalCurrentState;
    }

    @Override
    public ODEStateAndDerivative getInterpolatedState(double time) {
        if (FastMath.abs((double)(this.globalCurrentState.getTime() - this.globalPreviousState.getTime())) <= FastMath.ulp((double)this.globalCurrentState.getTime())) {
            return this.globalCurrentState;
        }
        double thetaH = time - this.globalPreviousState.getTime();
        double oneMinusThetaH = this.globalCurrentState.getTime() - time;
        double theta = thetaH / (this.globalCurrentState.getTime() - this.globalPreviousState.getTime());
        return this.computeInterpolatedStateAndDerivatives(this.mapper, time, theta, thetaH, oneMinusThetaH);
    }

    @Override
    public boolean isForward() {
        return this.forward;
    }

    protected EquationsMapper getMapper() {
        return this.mapper;
    }

    protected abstract ODEStateAndDerivative computeInterpolatedStateAndDerivatives(EquationsMapper var1, double var2, double var4, double var6, double var8) throws MathIllegalStateException;
}

