/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.ode.nonstiff;

import org.hipparchus.ode.EquationsMapper;
import org.hipparchus.ode.ODEStateAndDerivative;
import org.hipparchus.ode.nonstiff.RungeKuttaStateInterpolator;

class ClassicalRungeKuttaStateInterpolator
extends RungeKuttaStateInterpolator {
    private static final long serialVersionUID = 20160328L;

    ClassicalRungeKuttaStateInterpolator(boolean forward, double[][] yDotK, ODEStateAndDerivative globalPreviousState, ODEStateAndDerivative globalCurrentState, ODEStateAndDerivative softPreviousState, ODEStateAndDerivative softCurrentState, EquationsMapper mapper) {
        super(forward, yDotK, globalPreviousState, globalCurrentState, softPreviousState, softCurrentState, mapper);
    }

    @Override
    protected ClassicalRungeKuttaStateInterpolator create(boolean newForward, double[][] newYDotK, ODEStateAndDerivative newGlobalPreviousState, ODEStateAndDerivative newGlobalCurrentState, ODEStateAndDerivative newSoftPreviousState, ODEStateAndDerivative newSoftCurrentState, EquationsMapper newMapper) {
        return new ClassicalRungeKuttaStateInterpolator(newForward, newYDotK, newGlobalPreviousState, newGlobalCurrentState, newSoftPreviousState, newSoftCurrentState, newMapper);
    }

    @Override
    protected ODEStateAndDerivative computeInterpolatedStateAndDerivatives(EquationsMapper mapper, double time, double theta, double thetaH, double oneMinusThetaH) {
        double[] interpolatedDerivatives;
        double[] interpolatedState;
        double oneMinusTheta = 1.0 - theta;
        double oneMinus2Theta = 1.0 - theta * 2.0;
        double coeffDot1 = oneMinusTheta * oneMinus2Theta;
        double coeffDot23 = theta * oneMinusTheta * 2.0;
        double coeffDot4 = -theta * oneMinus2Theta;
        if (this.getGlobalPreviousState() != null && theta <= 0.5) {
            double fourTheta2 = theta * theta * 4.0;
            double s = thetaH / 6.0;
            double coeff1 = s * (fourTheta2 - theta * 9.0 + 6.0);
            double coeff23 = s * (theta * 6.0 - fourTheta2);
            double coeff4 = s * (fourTheta2 - theta * 3.0);
            interpolatedState = this.previousStateLinearCombination(coeff1, coeff23, coeff23, coeff4);
            interpolatedDerivatives = this.derivativeLinearCombination(coeffDot1, coeffDot23, coeffDot23, coeffDot4);
        } else {
            double fourTheta = theta * 4.0;
            double s = oneMinusThetaH / 6.0;
            double coeff1 = s * (theta * (-fourTheta + 5.0) - 1.0);
            double coeff23 = s * (theta * (fourTheta - 2.0) - 2.0);
            double coeff4 = s * (theta * (-fourTheta - 1.0) - 1.0);
            interpolatedState = this.currentStateLinearCombination(coeff1, coeff23, coeff23, coeff4);
            interpolatedDerivatives = this.derivativeLinearCombination(coeffDot1, coeffDot23, coeffDot23, coeffDot4);
        }
        return mapper.mapStateAndDerivative(time, interpolatedState, interpolatedDerivatives);
    }
}

