/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.utils;

import java.util.List;
import java.util.Map;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.integration.AdditionalEquations;
import org.orekit.propagation.numerical.EpochDerivativesEquations;
import org.orekit.propagation.numerical.NumericalPropagator;
import org.orekit.utils.AbstractMultipleShooting;

public class MultipleShooter
extends AbstractMultipleShooting {
    public MultipleShooter(List<SpacecraftState> initialGuessList, List<NumericalPropagator> propagatorList, List<AdditionalEquations> additionalEquations, double arcDuration, double tolerance) {
        super(initialGuessList, propagatorList, additionalEquations, arcDuration, tolerance, "derivatives");
    }

    @Override
    protected SpacecraftState getAugmentedInitialState(SpacecraftState initialState, AdditionalEquations additionalEquation) {
        return ((EpochDerivativesEquations)additionalEquation).setInitialJacobians(initialState);
    }

    @Override
    protected double[][] computeAdditionalJacobianMatrix(List<SpacecraftState> propagatedSP) {
        Map<Integer, Double> mapConstraints = this.getConstraintsMap();
        int n = mapConstraints.size();
        int ncolumns = this.getNumberOfFreeVariables() - 1;
        double[][] M = new double[n][ncolumns];
        int k = 0;
        for (int index : mapConstraints.keySet()) {
            M[k][index] = 1.0;
            ++k;
        }
        return M;
    }

    @Override
    protected double[] computeAdditionalConstraints(List<SpacecraftState> propagatedSP) {
        int n = this.getConstraintsMap().size();
        double[] fxAdditionnal = new double[n];
        this.updateAdditionalConstraints(0, fxAdditionnal);
        return fxAdditionnal;
    }
}

