/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.utils;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.function.Function;
import java.util.regex.Pattern;
import org.hipparchus.CalculusFieldElement;
import org.hipparchus.FieldElement;
import org.hipparchus.analysis.interpolation.FieldHermiteInterpolator;
import org.hipparchus.analysis.interpolation.HermiteInterpolator;
import org.hipparchus.exception.Localizable;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.FieldSinCos;
import org.hipparchus.util.MathArrays;
import org.hipparchus.util.SinCos;
import org.orekit.annotation.DefaultDataContext;
import org.orekit.data.BodiesElements;
import org.orekit.data.DataContext;
import org.orekit.data.DelaunayArguments;
import org.orekit.data.FieldBodiesElements;
import org.orekit.data.FieldDelaunayArguments;
import org.orekit.data.FundamentalNutationArguments;
import org.orekit.data.PoissonSeries;
import org.orekit.data.PoissonSeriesParser;
import org.orekit.data.PolynomialNutation;
import org.orekit.data.PolynomialParser;
import org.orekit.data.SimpleTimeStampedTableParser;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitInternalError;
import org.orekit.errors.OrekitMessages;
import org.orekit.errors.TimeStampedCacheException;
import org.orekit.frames.EOPHistory;
import org.orekit.frames.FieldPoleCorrection;
import org.orekit.frames.PoleCorrection;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.DateComponents;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.time.TimeComponents;
import org.orekit.time.TimeScalarFunction;
import org.orekit.time.TimeScale;
import org.orekit.time.TimeScales;
import org.orekit.time.TimeStamped;
import org.orekit.time.TimeVectorFunction;
import org.orekit.time.UTCScale;
import org.orekit.utils.ImmutableTimeStampedCache;
import org.orekit.utils.LoveNumbers;

public enum IERSConventions {
    IERS_1996{
        private static final String NUTATION_ARGUMENTS = "/assets/org/orekit/IERS-conventions/1996/nutation-arguments.txt";
        private static final String X_Y_SERIES = "/assets/org/orekit/IERS-conventions/1996/tab5.4.txt";
        private static final String PSI_EPSILON_SERIES = "/assets/org/orekit/IERS-conventions/1996/tab5.1.txt";
        private static final String TIDAL_CORRECTION_XP_YP_SERIES = "/assets/org/orekit/IERS-conventions/1996/tab8.4.txt";
        private static final String TIDAL_CORRECTION_UT1_SERIES = "/assets/org/orekit/IERS-conventions/1996/tab8.3.txt";
        private static final String LOVE_NUMBERS = "/assets/org/orekit/IERS-conventions/1996/tab6.1.txt";
        private static final String K20_FREQUENCY_DEPENDENCE = "/assets/org/orekit/IERS-conventions/1996/tab6.2b.txt";
        private static final String K21_FREQUENCY_DEPENDENCE = "/assets/org/orekit/IERS-conventions/1996/tab6.2a.txt";
        private static final String K22_FREQUENCY_DEPENDENCE = "/assets/org/orekit/IERS-conventions/1996/tab6.2c.txt";
        private static final String TIDAL_DISPLACEMENT_CORRECTION_DIURNAL = "/assets/org/orekit/IERS-conventions/1996/tab7.3a.txt";
        private static final String TIDAL_DISPLACEMENT_CORRECTION_ZONAL = "/assets/org/orekit/IERS-conventions/1996/tab7.3b.txt";

        @Override
        public FundamentalNutationArguments getNutationArguments(TimeScale timeScale, TimeScales timeScales) {
            return (FundamentalNutationArguments)IERSConventions.load(NUTATION_ARGUMENTS, in -> new FundamentalNutationArguments(this, timeScale, (InputStream)in, NUTATION_ARGUMENTS, timeScales));
        }

        @Override
        public TimeScalarFunction getMeanObliquityFunction(final TimeScales timeScales) {
            final PolynomialNutation epsilonA = new PolynomialNutation(0.40909280422232897, -2.2696552481142927E-4, -2.8604007185462624E-9, 8.789672038515888E-9);
            return new TimeScalarFunction(){

                @Override
                public double value(AbsoluteDate date) {
                    return epsilonA.value(this.evaluateTC(date, timeScales));
                }

                @Override
                public <T extends CalculusFieldElement<T>> T value(FieldAbsoluteDate<T> date) {
                    return epsilonA.value(this.evaluateTC(date, timeScales));
                }
            };
        }

        @Override
        public TimeVectorFunction getXYSpXY2Function(TimeScales timeScales) {
            final FundamentalNutationArguments arguments = this.getNutationArguments(timeScales);
            final PolynomialNutation xPolynomial = new PolynomialNutation(0.0, 0.00971717345516967, -2.068457570453835E-6, -9.631114663449597E-7, 6.787391535533504E-11);
            double fXCosOm = 2.908882086657216E-10;
            double fXSinOm = 9.890199094634534E-9;
            double fXSin2FDOm = 7.757018897752577E-10;
            final double sinEps0 = FastMath.sin((double)this.getMeanObliquityFunction(timeScales).value(this.getNutationReferenceEpoch(timeScales)));
            double deciMilliAS = 4.84813681109536E-10;
            PoissonSeriesParser baseParser = new PoissonSeriesParser(12).withFirstDelaunay(1);
            PoissonSeriesParser xParser = baseParser.withSinCos(0, 7, 4.84813681109536E-10, -1, 4.84813681109536E-10).withSinCos(1, 8, 4.84813681109536E-10, 9, 4.84813681109536E-10);
            PoissonSeries xSum = (PoissonSeries)IERSConventions.load(X_Y_SERIES, in -> xParser.parse((InputStream)in, X_Y_SERIES));
            final PolynomialNutation yPolynomial = new PolynomialNutation(-6.302577854423967E-10, 0.0, -1.0864635808570213E-4, 8.901179185171081E-9, 5.395976270749136E-9);
            double fYCosOm = -1.1199196033630281E-8;
            double fYCos2FDOm = -6.787391535533503E-10;
            PoissonSeriesParser yParser = baseParser.withSinCos(0, -1, 4.84813681109536E-10, 10, 4.84813681109536E-10).withSinCos(1, 12, 4.84813681109536E-10, 11, 4.84813681109536E-10);
            PoissonSeries ySum = (PoissonSeries)IERSConventions.load(X_Y_SERIES, in -> yParser.parse((InputStream)in, X_Y_SERIES));
            final PoissonSeries.CompiledSeries xySum = PoissonSeries.compile(xSum, ySum);
            double fST = 1.8665326722717134E-8;
            double fST3 = -3.5192625111741217E-7;
            double fSSinOm = -1.2799081181291749E-8;
            double fSSin2Om = -2.908882086657216E-10;
            double fST2SinOm = 3.587621240210566E-9;
            double fST2Sin2FDOm = 2.908882086657216E-10;
            return new TimeVectorFunction(){

                @Override
                public double[] value(AbsoluteDate date) {
                    BodiesElements elements = arguments.evaluateAll(date);
                    double[] xy = xySum.value(elements);
                    double omega = elements.getOmega();
                    double f = elements.getF();
                    double d = elements.getD();
                    double t = elements.getTC();
                    SinCos scOmega = FastMath.sinCos((double)omega);
                    SinCos sc2omega = SinCos.sum((SinCos)scOmega, (SinCos)scOmega);
                    SinCos sc2FD0m = FastMath.sinCos((double)(2.0 * (f - d + omega)));
                    double cosOmega = scOmega.cos();
                    double sinOmega = scOmega.sin();
                    double sin2Omega = sc2omega.sin();
                    double cos2FDOm = sc2FD0m.cos();
                    double sin2FDOm = sc2FD0m.sin();
                    double x = xPolynomial.value(t) + sinEps0 * xy[0] + t * t * (2.908882086657216E-10 * cosOmega + 9.890199094634534E-9 * sinOmega + 7.757018897752577E-10 * cos2FDOm);
                    double y = yPolynomial.value(t) + xy[1] + t * t * (-1.1199196033630281E-8 * cosOmega + -6.787391535533503E-10 * cos2FDOm);
                    double sPxy2 = -1.2799081181291749E-8 * sinOmega + -2.908882086657216E-10 * sin2Omega + t * (1.8665326722717134E-8 + t * (3.587621240210566E-9 * sinOmega + 2.908882086657216E-10 * sin2FDOm + t * -3.5192625111741217E-7));
                    return new double[]{x, y, sPxy2};
                }

                @Override
                public <T extends CalculusFieldElement<T>> T[] value(FieldAbsoluteDate<T> date) {
                    FieldBodiesElements<T> elements = arguments.evaluateAll(date);
                    CalculusFieldElement[] xy = xySum.value(elements);
                    Object omega = elements.getOmega();
                    Object f = elements.getF();
                    Object d = elements.getD();
                    Object t = elements.getTC();
                    CalculusFieldElement t2 = (CalculusFieldElement)t.multiply(t);
                    FieldSinCos scOmega = FastMath.sinCos(omega);
                    FieldSinCos sc2omega = FieldSinCos.sum((FieldSinCos)scOmega, (FieldSinCos)scOmega);
                    FieldSinCos sc2FD0m = FastMath.sinCos((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)f.subtract(d)).add(omega)).multiply(2)));
                    CalculusFieldElement cosOmega = (CalculusFieldElement)scOmega.cos();
                    CalculusFieldElement sinOmega = (CalculusFieldElement)scOmega.sin();
                    CalculusFieldElement sin2Omega = (CalculusFieldElement)sc2omega.sin();
                    CalculusFieldElement cos2FDOm = (CalculusFieldElement)sc2FD0m.cos();
                    CalculusFieldElement sin2FDOm = (CalculusFieldElement)sc2FD0m.sin();
                    CalculusFieldElement x = (CalculusFieldElement)((CalculusFieldElement)xPolynomial.value(t).add(xy[0].multiply(sinEps0))).add(t2.multiply(((CalculusFieldElement)((CalculusFieldElement)cosOmega.multiply(2.908882086657216E-10)).add(sinOmega.multiply(9.890199094634534E-9))).add(cos2FDOm.multiply(7.757018897752577E-10))));
                    CalculusFieldElement y = (CalculusFieldElement)((CalculusFieldElement)yPolynomial.value(t).add((FieldElement)xy[1])).add(t2.multiply(((CalculusFieldElement)cosOmega.multiply(-1.1199196033630281E-8)).add(cos2FDOm.multiply(-6.787391535533503E-10))));
                    CalculusFieldElement sPxy2 = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)sinOmega.multiply(-1.2799081181291749E-8)).add(sin2Omega.multiply(-2.908882086657216E-10))).add(((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)t.multiply(-3.5192625111741217E-7)).add(sinOmega.multiply(3.587621240210566E-9))).add(sin2FDOm.multiply(2.908882086657216E-10))).multiply(t)).add(1.8665326722717134E-8)).multiply(t));
                    CalculusFieldElement[] a = (CalculusFieldElement[])MathArrays.buildArray(date.getField(), (int)3);
                    a[0] = x;
                    a[1] = y;
                    a[2] = sPxy2;
                    return a;
                }
            };
        }

        @Override
        public TimeVectorFunction getPrecessionFunction(TimeScales timeScales) {
            PolynomialNutation psiA = new PolynomialNutation(0.0, 0.02442868704399218, -5.200063062212772E-6, -5.560812922326378E-9);
            PolynomialNutation omegaA = new PolynomialNutation(this.getMeanObliquityFunction(timeScales).value(this.getNutationReferenceEpoch(timeScales)), 0.0, 2.4856397430485914E-7, -3.745670500252275E-8);
            PolynomialNutation chiA = new PolynomialNutation(0.0, 5.1160448512764897E-5, -1.1541668417966057E-5, -5.454153912482279E-9);
            return new PrecessionFunction(psiA, omegaA, chiA, timeScales);
        }

        @Override
        public TimeVectorFunction getNutationFunction(final TimeScales timeScales) {
            final FundamentalNutationArguments arguments = this.getNutationArguments(timeScales);
            double deciMilliAS = 4.84813681109536E-10;
            PoissonSeriesParser baseParser = new PoissonSeriesParser(10).withFirstDelaunay(1);
            PoissonSeriesParser psiParser = baseParser.withSinCos(0, 7, 4.84813681109536E-10, -1, 4.84813681109536E-10).withSinCos(1, 8, 4.84813681109536E-10, -1, 4.84813681109536E-10);
            PoissonSeries psiSeries = (PoissonSeries)IERSConventions.load(PSI_EPSILON_SERIES, in -> psiParser.parse((InputStream)in, PSI_EPSILON_SERIES));
            PoissonSeriesParser epsilonParser = baseParser.withSinCos(0, -1, 4.84813681109536E-10, 9, 4.84813681109536E-10).withSinCos(1, -1, 4.84813681109536E-10, 10, 4.84813681109536E-10);
            PoissonSeries epsilonSeries = (PoissonSeries)IERSConventions.load(PSI_EPSILON_SERIES, in -> epsilonParser.parse((InputStream)in, PSI_EPSILON_SERIES));
            final PoissonSeries.CompiledSeries psiEpsilonSeries = PoissonSeries.compile(psiSeries, epsilonSeries);
            return new TimeVectorFunction(){

                @Override
                public double[] value(AbsoluteDate date) {
                    BodiesElements elements = arguments.evaluateAll(date);
                    double[] psiEpsilon = psiEpsilonSeries.value(elements);
                    return new double[]{psiEpsilon[0], psiEpsilon[1], IAU1994ResolutionC7.value(elements, (TimeScale)timeScales.getTAI())};
                }

                @Override
                public <T extends CalculusFieldElement<T>> T[] value(FieldAbsoluteDate<T> date) {
                    FieldBodiesElements<T> elements = arguments.evaluateAll(date);
                    CalculusFieldElement[] psiEpsilon = psiEpsilonSeries.value(elements);
                    CalculusFieldElement[] result = (CalculusFieldElement[])MathArrays.buildArray(date.getField(), (int)3);
                    result[0] = psiEpsilon[0];
                    result[1] = psiEpsilon[1];
                    result[2] = IAU1994ResolutionC7.value(elements, (TimeScale)timeScales.getTAI());
                    return result;
                }
            };
        }

        @Override
        public TimeScalarFunction getGMSTFunction(final TimeScale ut1, TimeScales timeScales) {
            double radiansPerSecond = 7.27220521664304E-5;
            final AbsoluteDate gmstReference = new AbsoluteDate(DateComponents.J2000_EPOCH, TimeComponents.H12, (TimeScale)timeScales.getTAI());
            double gmst0 = 24110.54841;
            double gmst1 = 8640184.812866;
            double gmst2 = 0.093104;
            double gmst3 = -6.2E-6;
            return new TimeScalarFunction(){

                @Override
                public double value(AbsoluteDate date) {
                    double dtai = date.durationFrom(gmstReference);
                    double tut1 = dtai + ut1.offsetFromTAI(date);
                    double tt = tut1 / 3.15576E9;
                    double sd = FastMath.IEEEremainder((double)(tut1 + 43200.0), (double)86400.0);
                    return (((tt * -6.2E-6 + 0.093104) * tt + 8640184.812866) * tt + 24110.54841 + sd) * 7.27220521664304E-5;
                }

                @Override
                public <T extends CalculusFieldElement<T>> T value(FieldAbsoluteDate<T> date) {
                    T dtai = date.durationFrom(gmstReference);
                    CalculusFieldElement tut1 = (CalculusFieldElement)dtai.add(ut1.offsetFromTAI(date.toAbsoluteDate()));
                    CalculusFieldElement tt = (CalculusFieldElement)tut1.divide(3.15576E9);
                    CalculusFieldElement sd = (CalculusFieldElement)((CalculusFieldElement)tut1.add(43200.0)).remainder(86400.0);
                    return (T)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)tt.multiply(-6.2E-6)).add(0.093104)).multiply((FieldElement)tt)).add(8640184.812866)).multiply((FieldElement)tt)).add(24110.54841)).add((FieldElement)sd)).multiply(7.27220521664304E-5));
                }
            };
        }

        @Override
        public TimeScalarFunction getGMSTRateFunction(final TimeScale ut1, TimeScales timeScales) {
            double radiansPerSecond = 7.27220521664304E-5;
            final AbsoluteDate gmstReference = new AbsoluteDate(DateComponents.J2000_EPOCH, TimeComponents.H12, (TimeScale)timeScales.getTAI());
            double gmst1 = 8640184.812866;
            double gmst2 = 0.093104;
            double gmst3 = -6.2E-6;
            return new TimeScalarFunction(){

                @Override
                public double value(AbsoluteDate date) {
                    double dtai = date.durationFrom(gmstReference);
                    double tut1 = dtai + ut1.offsetFromTAI(date);
                    double tt = tut1 / 3.15576E9;
                    return (((tt * 3.0 * -6.2E-6 + 0.186208) * tt + 8640184.812866) / 3.15576E9 + 1.0) * 7.27220521664304E-5;
                }

                @Override
                public <T extends CalculusFieldElement<T>> T value(FieldAbsoluteDate<T> date) {
                    T dtai = date.durationFrom(gmstReference);
                    CalculusFieldElement tut1 = (CalculusFieldElement)dtai.add(ut1.offsetFromTAI(date.toAbsoluteDate()));
                    CalculusFieldElement tt = (CalculusFieldElement)tut1.divide(3.15576E9);
                    return (T)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)tt.multiply(-1.8599999999999998E-5)).add(0.186208)).multiply((FieldElement)tt)).add(8640184.812866)).divide(3.15576E9)).add(1.0)).multiply(7.27220521664304E-5));
                }
            };
        }

        @Override
        public TimeScalarFunction getGASTFunction(TimeScale ut1, final EOPHistory eopHistory, TimeScales timeScales) {
            final TimeScalarFunction epsilonA = this.getMeanObliquityFunction(timeScales);
            final TimeScalarFunction gmst = this.getGMSTFunction(ut1, timeScales);
            final TimeVectorFunction nutation = this.getNutationFunction(timeScales);
            return new TimeScalarFunction(){

                @Override
                public double value(AbsoluteDate date) {
                    double[] angles = nutation.value(date);
                    double deltaPsi = angles[0];
                    if (eopHistory != null) {
                        deltaPsi += eopHistory.getEquinoxNutationCorrection(date)[0];
                    }
                    double eqe = deltaPsi * FastMath.cos((double)epsilonA.value(date)) + angles[2];
                    return gmst.value(date) + eqe;
                }

                @Override
                public <T extends CalculusFieldElement<T>> T value(FieldAbsoluteDate<T> date) {
                    CalculusFieldElement[] angles = nutation.value(date);
                    CalculusFieldElement deltaPsi = angles[0];
                    if (eopHistory != null) {
                        deltaPsi = (CalculusFieldElement)deltaPsi.add((FieldElement)eopHistory.getEquinoxNutationCorrection(date)[0]);
                    }
                    CalculusFieldElement eqe = (CalculusFieldElement)((CalculusFieldElement)deltaPsi.multiply(epsilonA.value(date).cos())).add((FieldElement)angles[2]);
                    return (T)((CalculusFieldElement)gmst.value(date).add((FieldElement)eqe));
                }
            };
        }

        @Override
        public TimeVectorFunction getEOPTidalCorrection(TimeScales timeScales) {
            FundamentalNutationArguments arguments = this.getNutationArguments(timeScales.getTT(), timeScales);
            double milliAS = 4.84813681109536E-9;
            PoissonSeriesParser xyParser = new PoissonSeriesParser(17).withOptionalColumn(1).withGamma(7).withFirstDelaunay(2);
            PoissonSeries xSeries = (PoissonSeries)IERSConventions.load(TIDAL_CORRECTION_XP_YP_SERIES, in -> xyParser.withSinCos(0, 14, 4.84813681109536E-9, 15, 4.84813681109536E-9).parse((InputStream)in, TIDAL_CORRECTION_XP_YP_SERIES));
            PoissonSeries ySeries = (PoissonSeries)IERSConventions.load(TIDAL_CORRECTION_XP_YP_SERIES, in -> xyParser.withSinCos(0, 16, 4.84813681109536E-9, 17, 4.84813681109536E-9).parse((InputStream)in, TIDAL_CORRECTION_XP_YP_SERIES));
            double deciMilliS = 1.0E-4;
            PoissonSeriesParser ut1Parser = new PoissonSeriesParser(17).withOptionalColumn(1).withGamma(7).withFirstDelaunay(2);
            PoissonSeries ut1Series = (PoissonSeries)IERSConventions.load(TIDAL_CORRECTION_UT1_SERIES, in -> ut1Parser.withSinCos(0, 16, 1.0E-4, 17, 1.0E-4).parse((InputStream)in, TIDAL_CORRECTION_UT1_SERIES));
            return new EOPTidalCorrection(arguments, xSeries, ySeries, ut1Series);
        }

        @Override
        public LoveNumbers getLoveNumbers() {
            return this.loadLoveNumbers(LOVE_NUMBERS);
        }

        @Override
        public TimeVectorFunction getTideFrequencyDependenceFunction(TimeScale ut1, TimeScales timeScales) {
            FundamentalNutationArguments arguments = this.getNutationArguments(ut1, timeScales);
            PoissonSeriesParser k20Parser = new PoissonSeriesParser(18).withOptionalColumn(1).withDoodson(4, 2).withFirstDelaunay(10);
            PoissonSeriesParser k21Parser = new PoissonSeriesParser(18).withOptionalColumn(1).withDoodson(4, 3).withFirstDelaunay(10);
            PoissonSeriesParser k22Parser = new PoissonSeriesParser(16).withOptionalColumn(1).withDoodson(4, 2).withFirstDelaunay(10);
            double pico = 1.0E-12;
            PoissonSeries c20Series = (PoissonSeries)IERSConventions.load(K20_FREQUENCY_DEPENDENCE, in -> k20Parser.withSinCos(0, 18, -1.0E-12, 16, 1.0E-12).parse((InputStream)in, K20_FREQUENCY_DEPENDENCE));
            PoissonSeries c21Series = (PoissonSeries)IERSConventions.load(K21_FREQUENCY_DEPENDENCE, in -> k21Parser.withSinCos(0, 17, 1.0E-12, 18, 1.0E-12).parse((InputStream)in, K21_FREQUENCY_DEPENDENCE));
            PoissonSeries s21Series = (PoissonSeries)IERSConventions.load(K21_FREQUENCY_DEPENDENCE, in -> k21Parser.withSinCos(0, 18, -1.0E-12, 17, 1.0E-12).parse((InputStream)in, K21_FREQUENCY_DEPENDENCE));
            PoissonSeries c22Series = (PoissonSeries)IERSConventions.load(K22_FREQUENCY_DEPENDENCE, in -> k22Parser.withSinCos(0, -1, 1.0E-12, 16, 1.0E-12).parse((InputStream)in, K22_FREQUENCY_DEPENDENCE));
            PoissonSeries s22Series = (PoissonSeries)IERSConventions.load(K22_FREQUENCY_DEPENDENCE, in -> k22Parser.withSinCos(0, 16, -1.0E-12, -1, 1.0E-12).parse((InputStream)in, K22_FREQUENCY_DEPENDENCE));
            return new TideFrequencyDependenceFunction(arguments, c20Series, c21Series, s21Series, c22Series, s22Series);
        }

        @Override
        public double getPermanentTide() {
            return -1.39141288E-8 * this.getLoveNumbers().getReal(2, 0);
        }

        @Override
        public TimeVectorFunction getSolidPoleTide(final EOPHistory eopHistory) {
            double globalFactor = -2.780449588210859E-4;
            double coupling = 0.0112;
            return new TimeVectorFunction(){

                @Override
                public double[] value(AbsoluteDate date) {
                    PoleCorrection pole = eopHistory.getPoleCorrection(date);
                    return new double[]{-2.780449588210859E-4 * (pole.getXp() + 0.0112 * pole.getYp()), -2.780449588210859E-4 * (0.0112 * pole.getXp() - pole.getYp())};
                }

                @Override
                public <T extends CalculusFieldElement<T>> T[] value(FieldAbsoluteDate<T> date) {
                    FieldPoleCorrection<T> pole = eopHistory.getPoleCorrection(date);
                    CalculusFieldElement[] a = (CalculusFieldElement[])MathArrays.buildArray(date.getField(), (int)2);
                    a[0] = (CalculusFieldElement)((CalculusFieldElement)pole.getXp().add(pole.getYp().multiply(0.0112))).multiply(-2.780449588210859E-4);
                    a[1] = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)pole.getXp().multiply(0.0112)).subtract(pole.getYp())).multiply(-2.780449588210859E-4);
                    return a;
                }
            };
        }

        @Override
        public TimeVectorFunction getOceanPoleTide(EOPHistory eopHistory) {
            return new TimeVectorFunction(){

                @Override
                public double[] value(AbsoluteDate date) {
                    return new double[]{0.0, 0.0};
                }

                @Override
                public <T extends CalculusFieldElement<T>> T[] value(FieldAbsoluteDate<T> date) {
                    return (CalculusFieldElement[])MathArrays.buildArray(date.getField(), (int)2);
                }
            };
        }

        @Override
        public double[] getNominalTidalDisplacement() {
            return new double[]{0.6078, -6.0E-4, 0.292, -0.0025, -0.0022, 0.0847, 0.0012, 0.0024, 2.0E-4, 0.015, -7.0E-4, -7.0E-4, -0.3146};
        }

        @Override
        public PoissonSeries.CompiledSeries getTidalDisplacementFrequencyCorrectionDiurnal() {
            return 1.getTidalDisplacementFrequencyCorrectionDiurnal(TIDAL_DISPLACEMENT_CORRECTION_DIURNAL, 18, 17, -1, 18, -1);
        }

        @Override
        public PoissonSeries.CompiledSeries getTidalDisplacementFrequencyCorrectionZonal() {
            return 1.getTidalDisplacementFrequencyCorrectionZonal(TIDAL_DISPLACEMENT_CORRECTION_ZONAL, 20, 17, 19, 18, 20);
        }
    }
    ,
    IERS_2003{
        private static final String NUTATION_ARGUMENTS = "/assets/org/orekit/IERS-conventions/2003/nutation-arguments.txt";
        private static final String X_SERIES = "/assets/org/orekit/IERS-conventions/2003/tab5.2a.txt";
        private static final String Y_SERIES = "/assets/org/orekit/IERS-conventions/2003/tab5.2b.txt";
        private static final String S_SERIES = "/assets/org/orekit/IERS-conventions/2003/tab5.2c.txt";
        private static final String LUNI_SOLAR_SERIES = "/assets/org/orekit/IERS-conventions/2003/tab5.3a-first-table.txt";
        private static final String PLANETARY_SERIES = "/assets/org/orekit/IERS-conventions/2003/tab5.3b.txt";
        private static final String GST_SERIES = "/assets/org/orekit/IERS-conventions/2003/tab5.4.txt";
        private static final String TIDAL_CORRECTION_XP_YP_SERIES = "/assets/org/orekit/IERS-conventions/2003/tab8.2ab.txt";
        private static final String TIDAL_CORRECTION_UT1_SERIES = "/assets/org/orekit/IERS-conventions/2003/tab8.3ab.txt";
        private static final String LOVE_NUMBERS = "/assets/org/orekit/IERS-conventions/2003/tab6.1.txt";
        private static final String K20_FREQUENCY_DEPENDENCE = "/assets/org/orekit/IERS-conventions/2003/tab6.3b.txt";
        private static final String K21_FREQUENCY_DEPENDENCE = "/assets/org/orekit/IERS-conventions/2003/tab6.3a.txt";
        private static final String K22_FREQUENCY_DEPENDENCE = "/assets/org/orekit/IERS-conventions/2003/tab6.3c.txt";
        private static final String ANNUAL_POLE = "/assets/org/orekit/IERS-conventions/2003/annual.pole";
        private static final String TIDAL_DISPLACEMENT_CORRECTION_DIURNAL = "/assets/org/orekit/IERS-conventions/2003/tab7.5a.txt";
        private static final String TIDAL_DISPLACEMENT_CORRECTION_ZONAL = "/assets/org/orekit/IERS-conventions/2003/tab7.5b.txt";

        @Override
        public FundamentalNutationArguments getNutationArguments(TimeScale timeScale, TimeScales timeScales) {
            return (FundamentalNutationArguments)IERSConventions.load(NUTATION_ARGUMENTS, in -> new FundamentalNutationArguments(this, timeScale, (InputStream)in, NUTATION_ARGUMENTS, timeScales));
        }

        @Override
        public TimeScalarFunction getMeanObliquityFunction(final TimeScales timeScales) {
            final PolynomialNutation epsilonA = new PolynomialNutation(0.40909280422232897, -2.2708789178454132E-4, -2.8604007185462624E-9, 8.789672038515888E-9);
            return new TimeScalarFunction(){

                @Override
                public double value(AbsoluteDate date) {
                    return epsilonA.value(this.evaluateTC(date, timeScales));
                }

                @Override
                public <T extends CalculusFieldElement<T>> T value(FieldAbsoluteDate<T> date) {
                    return epsilonA.value(this.evaluateTC(date, timeScales));
                }
            };
        }

        @Override
        public TimeVectorFunction getXYSpXY2Function(TimeScales timeScales) {
            final FundamentalNutationArguments arguments = this.getNutationArguments(timeScales);
            double microAS = 4.84813681109536E-12;
            PoissonSeriesParser parser = new PoissonSeriesParser(17).withPolynomialPart('t', PolynomialParser.Unit.MICRO_ARC_SECONDS).withFirstDelaunay(4).withFirstPlanetary(9).withSinCos(0, 2, 4.84813681109536E-12, 3, 4.84813681109536E-12);
            PoissonSeries xSeries = (PoissonSeries)IERSConventions.load(X_SERIES, in -> parser.parse((InputStream)in, X_SERIES));
            PoissonSeries ySeries = (PoissonSeries)IERSConventions.load(Y_SERIES, in -> parser.parse((InputStream)in, Y_SERIES));
            PoissonSeries sSeries = (PoissonSeries)IERSConventions.load(S_SERIES, in -> parser.parse((InputStream)in, S_SERIES));
            final PoissonSeries.CompiledSeries xys = PoissonSeries.compile(xSeries, ySeries, sSeries);
            return new TimeVectorFunction(){

                @Override
                public double[] value(AbsoluteDate date) {
                    return xys.value(arguments.evaluateAll(date));
                }

                @Override
                public <T extends CalculusFieldElement<T>> T[] value(FieldAbsoluteDate<T> date) {
                    return xys.value(arguments.evaluateAll(date));
                }
            };
        }

        @Override
        public TimeVectorFunction getPrecessionFunction(TimeScales timeScales) {
            PolynomialNutation psiA = new PolynomialNutation(0.0, 0.024427234299796735, -5.200063062212772E-6, -5.560812922326378E-9);
            PolynomialNutation omegaA = new PolynomialNutation(this.getMeanObliquityFunction(timeScales).value(this.getNutationReferenceEpoch(timeScales)), -1.2236697311204688E-7, 2.4856397430485914E-7, -3.745670500252275E-8);
            PolynomialNutation chiA = new PolynomialNutation(0.0, 5.1160448512764897E-5, -1.1541668417966057E-5, -5.454153912482279E-9);
            return new PrecessionFunction(psiA, omegaA, chiA, timeScales);
        }

        @Override
        public TimeVectorFunction getNutationFunction(final TimeScales timeScales) {
            final FundamentalNutationArguments arguments = this.getNutationArguments(timeScales);
            double milliAS = 4.84813681109536E-9;
            PoissonSeriesParser luniSolarParser = new PoissonSeriesParser(14).withFirstDelaunay(1);
            PoissonSeriesParser luniSolarPsiParser = luniSolarParser.withSinCos(0, 7, 4.84813681109536E-9, 11, 4.84813681109536E-9).withSinCos(1, 8, 4.84813681109536E-9, 12, 4.84813681109536E-9);
            PoissonSeries psiLuniSolarSeries = (PoissonSeries)IERSConventions.load(LUNI_SOLAR_SERIES, in -> luniSolarPsiParser.parse((InputStream)in, LUNI_SOLAR_SERIES));
            PoissonSeriesParser luniSolarEpsilonParser = luniSolarParser.withSinCos(0, 13, 4.84813681109536E-9, 9, 4.84813681109536E-9).withSinCos(1, 14, 4.84813681109536E-9, 10, 4.84813681109536E-9);
            PoissonSeries epsilonLuniSolarSeries = (PoissonSeries)IERSConventions.load(LUNI_SOLAR_SERIES, in -> luniSolarEpsilonParser.parse((InputStream)in, LUNI_SOLAR_SERIES));
            PoissonSeriesParser planetaryParser = new PoissonSeriesParser(21).withFirstDelaunay(2).withFirstPlanetary(7);
            PoissonSeriesParser planetaryPsiParser = planetaryParser.withSinCos(0, 17, 4.84813681109536E-9, 18, 4.84813681109536E-9);
            PoissonSeries psiPlanetarySeries = (PoissonSeries)IERSConventions.load(PLANETARY_SERIES, in -> planetaryPsiParser.parse((InputStream)in, PLANETARY_SERIES));
            PoissonSeriesParser planetaryEpsilonParser = planetaryParser.withSinCos(0, 19, 4.84813681109536E-9, 20, 4.84813681109536E-9);
            PoissonSeries epsilonPlanetarySeries = (PoissonSeries)IERSConventions.load(PLANETARY_SERIES, in -> planetaryEpsilonParser.parse((InputStream)in, PLANETARY_SERIES));
            final PoissonSeries.CompiledSeries luniSolarSeries = PoissonSeries.compile(psiLuniSolarSeries, epsilonLuniSolarSeries);
            final PoissonSeries.CompiledSeries planetarySeries = PoissonSeries.compile(psiPlanetarySeries, epsilonPlanetarySeries);
            return new TimeVectorFunction(){

                @Override
                public double[] value(AbsoluteDate date) {
                    BodiesElements elements = arguments.evaluateAll(date);
                    double[] luniSolar = luniSolarSeries.value(elements);
                    double[] planetary = planetarySeries.value(elements);
                    return new double[]{luniSolar[0] + planetary[0], luniSolar[1] + planetary[1], IAU1994ResolutionC7.value(elements, (TimeScale)timeScales.getTAI())};
                }

                @Override
                public <T extends CalculusFieldElement<T>> T[] value(FieldAbsoluteDate<T> date) {
                    FieldBodiesElements<T> elements = arguments.evaluateAll(date);
                    CalculusFieldElement[] luniSolar = luniSolarSeries.value(elements);
                    CalculusFieldElement[] planetary = planetarySeries.value(elements);
                    CalculusFieldElement[] result = (CalculusFieldElement[])MathArrays.buildArray(date.getField(), (int)3);
                    result[0] = (CalculusFieldElement)luniSolar[0].add((FieldElement)planetary[0]);
                    result[1] = (CalculusFieldElement)luniSolar[1].add((FieldElement)planetary[1]);
                    result[2] = IAU1994ResolutionC7.value(elements, (TimeScale)timeScales.getTAI());
                    return result;
                }
            };
        }

        @Override
        public TimeScalarFunction getGMSTFunction(TimeScale ut1, final TimeScales timeScales) {
            final StellarAngleCapitaine era = new StellarAngleCapitaine(ut1, timeScales.getTAI());
            double microAS = 4.84813681109536E-12;
            PoissonSeriesParser parser = new PoissonSeriesParser(17).withFirstDelaunay(4).withFirstPlanetary(9).withSinCos(0, 2, 4.84813681109536E-12, 3, 4.84813681109536E-12).withPolynomialPart('t', PolynomialParser.Unit.ARC_SECONDS);
            final PolynomialNutation minusEO = (PolynomialNutation)IERSConventions.load(GST_SERIES, in -> parser.parse((InputStream)in, GST_SERIES).getPolynomial());
            return new TimeScalarFunction(){

                @Override
                public double value(AbsoluteDate date) {
                    return era.value(date) + minusEO.value(this.evaluateTC(date, timeScales));
                }

                @Override
                public <T extends CalculusFieldElement<T>> T value(FieldAbsoluteDate<T> date) {
                    return (T)((CalculusFieldElement)era.value(date).add(minusEO.value(this.evaluateTC(date, timeScales))));
                }
            };
        }

        @Override
        public TimeScalarFunction getGMSTRateFunction(TimeScale ut1, final TimeScales timeScales) {
            final StellarAngleCapitaine era = new StellarAngleCapitaine(ut1, timeScales.getTAI());
            double microAS = 4.84813681109536E-12;
            PoissonSeriesParser parser = new PoissonSeriesParser(17).withFirstDelaunay(4).withFirstPlanetary(9).withSinCos(0, 2, 4.84813681109536E-12, 3, 4.84813681109536E-12).withPolynomialPart('t', PolynomialParser.Unit.ARC_SECONDS);
            final PolynomialNutation minusEO = (PolynomialNutation)IERSConventions.load(GST_SERIES, in -> parser.parse((InputStream)in, GST_SERIES).getPolynomial());
            return new TimeScalarFunction(){

                @Override
                public double value(AbsoluteDate date) {
                    return era.getRate() + minusEO.derivative(this.evaluateTC(date, timeScales));
                }

                @Override
                public <T extends CalculusFieldElement<T>> T value(FieldAbsoluteDate<T> date) {
                    return (T)((CalculusFieldElement)minusEO.derivative(this.evaluateTC(date, timeScales)).add(era.getRate()));
                }
            };
        }

        @Override
        public TimeScalarFunction getGASTFunction(TimeScale ut1, final EOPHistory eopHistory, TimeScales timeScales) {
            final FundamentalNutationArguments arguments = this.getNutationArguments(timeScales);
            final TimeScalarFunction epsilon = this.getMeanObliquityFunction(timeScales);
            double milliAS = 4.84813681109536E-9;
            PoissonSeriesParser luniSolarPsiParser = new PoissonSeriesParser(14).withFirstDelaunay(1).withSinCos(0, 7, 4.84813681109536E-9, 11, 4.84813681109536E-9).withSinCos(1, 8, 4.84813681109536E-9, 12, 4.84813681109536E-9);
            PoissonSeries psiLuniSolarSeries = (PoissonSeries)IERSConventions.load(LUNI_SOLAR_SERIES, in -> luniSolarPsiParser.parse((InputStream)in, LUNI_SOLAR_SERIES));
            PoissonSeriesParser planetaryPsiParser = new PoissonSeriesParser(21).withFirstDelaunay(2).withFirstPlanetary(7).withSinCos(0, 17, 4.84813681109536E-9, 18, 4.84813681109536E-9);
            PoissonSeries psiPlanetarySeries = (PoissonSeries)IERSConventions.load(PLANETARY_SERIES, in -> planetaryPsiParser.parse((InputStream)in, PLANETARY_SERIES));
            double microAS = 4.84813681109536E-12;
            PoissonSeriesParser gstParser = new PoissonSeriesParser(17).withFirstDelaunay(4).withFirstPlanetary(9).withSinCos(0, 2, 4.84813681109536E-12, 3, 4.84813681109536E-12).withPolynomialPart('t', PolynomialParser.Unit.ARC_SECONDS);
            PoissonSeries gstSeries = (PoissonSeries)IERSConventions.load(GST_SERIES, in -> gstParser.parse((InputStream)in, GST_SERIES));
            final PoissonSeries.CompiledSeries psiGstSeries = PoissonSeries.compile(psiLuniSolarSeries, psiPlanetarySeries, gstSeries);
            final TimeScalarFunction era = this.getEarthOrientationAngleFunction(ut1, timeScales.getTAI());
            return new TimeScalarFunction(){

                @Override
                public double value(AbsoluteDate date) {
                    BodiesElements elements = arguments.evaluateAll(date);
                    double[] angles = psiGstSeries.value(elements);
                    double ddPsi = eopHistory == null ? 0.0 : eopHistory.getEquinoxNutationCorrection(date)[0];
                    double deltaPsi = angles[0] + angles[1] + ddPsi;
                    double epsilonA = epsilon.value(date);
                    return era.value(date) + deltaPsi * FastMath.cos((double)epsilonA) + angles[2];
                }

                @Override
                public <T extends CalculusFieldElement<T>> T value(FieldAbsoluteDate<T> date) {
                    FieldBodiesElements<T> elements = arguments.evaluateAll(date);
                    CalculusFieldElement[] angles = psiGstSeries.value(elements);
                    CalculusFieldElement ddPsi = eopHistory == null ? (CalculusFieldElement)date.getField().getZero() : eopHistory.getEquinoxNutationCorrection(date)[0];
                    CalculusFieldElement deltaPsi = (CalculusFieldElement)((CalculusFieldElement)angles[0].add((FieldElement)angles[1])).add((FieldElement)ddPsi);
                    T epsilonA = epsilon.value(date);
                    return (T)((CalculusFieldElement)((CalculusFieldElement)era.value(date).add(deltaPsi.multiply(epsilonA.cos()))).add((FieldElement)angles[2]));
                }
            };
        }

        @Override
        public TimeVectorFunction getEOPTidalCorrection(TimeScales timeScales) {
            FundamentalNutationArguments arguments = this.getNutationArguments(timeScales.getTT(), timeScales);
            double microAS = 4.84813681109536E-12;
            PoissonSeriesParser xyParser = new PoissonSeriesParser(13).withOptionalColumn(1).withGamma(2).withFirstDelaunay(3);
            double microS = 1.0E-6;
            PoissonSeriesParser ut1Parser = new PoissonSeriesParser(11).withOptionalColumn(1).withGamma(2).withFirstDelaunay(3);
            PoissonSeries xSeries = (PoissonSeries)IERSConventions.load(TIDAL_CORRECTION_XP_YP_SERIES, in -> xyParser.withSinCos(0, 10, 4.84813681109536E-12, 11, 4.84813681109536E-12).parse((InputStream)in, TIDAL_CORRECTION_XP_YP_SERIES));
            PoissonSeries ySeries = (PoissonSeries)IERSConventions.load(TIDAL_CORRECTION_XP_YP_SERIES, in -> xyParser.withSinCos(0, 12, 4.84813681109536E-12, 13, 4.84813681109536E-12).parse((InputStream)in, TIDAL_CORRECTION_XP_YP_SERIES));
            PoissonSeries ut1Series = (PoissonSeries)IERSConventions.load(TIDAL_CORRECTION_UT1_SERIES, in -> ut1Parser.withSinCos(0, 10, 1.0E-6, 11, 1.0E-6).parse((InputStream)in, TIDAL_CORRECTION_UT1_SERIES));
            return new EOPTidalCorrection(arguments, xSeries, ySeries, ut1Series);
        }

        @Override
        public LoveNumbers getLoveNumbers() {
            return this.loadLoveNumbers(LOVE_NUMBERS);
        }

        @Override
        public TimeVectorFunction getTideFrequencyDependenceFunction(TimeScale ut1, TimeScales timeScales) {
            FundamentalNutationArguments arguments = this.getNutationArguments(ut1, timeScales);
            PoissonSeriesParser k20Parser = new PoissonSeriesParser(18).withOptionalColumn(1).withDoodson(4, 2).withFirstDelaunay(10);
            PoissonSeriesParser k21Parser = new PoissonSeriesParser(18).withOptionalColumn(1).withDoodson(4, 3).withFirstDelaunay(10);
            PoissonSeriesParser k22Parser = new PoissonSeriesParser(16).withOptionalColumn(1).withDoodson(4, 2).withFirstDelaunay(10);
            double pico = 1.0E-12;
            PoissonSeries c20Series = (PoissonSeries)IERSConventions.load(K20_FREQUENCY_DEPENDENCE, in -> k20Parser.withSinCos(0, 18, -1.0E-12, 16, 1.0E-12).parse((InputStream)in, K20_FREQUENCY_DEPENDENCE));
            PoissonSeries c21Series = (PoissonSeries)IERSConventions.load(K21_FREQUENCY_DEPENDENCE, in -> k21Parser.withSinCos(0, 17, 1.0E-12, 18, 1.0E-12).parse((InputStream)in, K21_FREQUENCY_DEPENDENCE));
            PoissonSeries s21Series = (PoissonSeries)IERSConventions.load(K21_FREQUENCY_DEPENDENCE, in -> k21Parser.withSinCos(0, 18, -1.0E-12, 17, 1.0E-12).parse((InputStream)in, K21_FREQUENCY_DEPENDENCE));
            PoissonSeries c22Series = (PoissonSeries)IERSConventions.load(K22_FREQUENCY_DEPENDENCE, in -> k22Parser.withSinCos(0, -1, 1.0E-12, 16, 1.0E-12).parse((InputStream)in, K22_FREQUENCY_DEPENDENCE));
            PoissonSeries s22Series = (PoissonSeries)IERSConventions.load(K22_FREQUENCY_DEPENDENCE, in -> k22Parser.withSinCos(0, 16, -1.0E-12, -1, 1.0E-12).parse((InputStream)in, K22_FREQUENCY_DEPENDENCE));
            return new TideFrequencyDependenceFunction(arguments, c20Series, c21Series, s21Series, c22Series, s22Series);
        }

        @Override
        public double getPermanentTide() {
            return -1.39141288E-8 * this.getLoveNumbers().getReal(2, 0);
        }

        @Override
        public TimeVectorFunction getSolidPoleTide(final EOPHistory eopHistory) {
            final UTCScale utc = eopHistory.getTimeScales().getUTC();
            SimpleTimeStampedTableParser.RowConverter<MeanPole> converter = new SimpleTimeStampedTableParser.RowConverter<MeanPole>(){

                @Override
                public MeanPole convert(double[] rawFields) {
                    return new MeanPole(new AbsoluteDate((int)rawFields[0], 1, 1, utc), rawFields[1] * 4.84813681109536E-6, rawFields[2] * 4.84813681109536E-6);
                }
            };
            SimpleTimeStampedTableParser<MeanPole> parser = new SimpleTimeStampedTableParser<MeanPole>(3, converter);
            List annualPoleList = (List)IERSConventions.load(ANNUAL_POLE, in -> parser.parse((InputStream)in, ANNUAL_POLE));
            final AbsoluteDate firstAnnualPoleDate = ((MeanPole)annualPoleList.get(0)).getDate();
            final AbsoluteDate lastAnnualPoleDate = ((MeanPole)annualPoleList.get(annualPoleList.size() - 1)).getDate();
            final ImmutableTimeStampedCache annualCache = new ImmutableTimeStampedCache(2, annualPoleList);
            double xp0 = 2.617993877991494E-7;
            double xp0Dot = 1.275113935536653E-16;
            double yp0 = 1.7307848415610435E-6;
            double yp0Dot = 6.068313307674435E-16;
            double globalFactor = -2.749509867273795E-4;
            double ratio = 0.0115;
            return new TimeVectorFunction(){

                @Override
                public double[] value(AbsoluteDate date) {
                    if (date.compareTo(firstAnnualPoleDate) <= 0) {
                        return new double[]{0.0, 0.0};
                    }
                    double meanPoleX = 0.0;
                    double meanPoleY = 0.0;
                    if (date.compareTo(lastAnnualPoleDate) <= 0) {
                        try {
                            HermiteInterpolator interpolator = new HermiteInterpolator();
                            annualCache.getNeighbors(date).forEach(neighbor -> interpolator.addSamplePoint(neighbor.getDate().durationFrom(date), (double[][])new double[][]{{neighbor.getX(), neighbor.getY()}}));
                            double[] interpolated = interpolator.value(0.0);
                            meanPoleX = interpolated[0];
                            meanPoleY = interpolated[1];
                        }
                        catch (TimeStampedCacheException tsce) {
                            throw new OrekitInternalError(tsce);
                        }
                    } else {
                        double t = date.durationFrom(eopHistory.getTimeScales().getJ2000Epoch());
                        meanPoleX = 2.617993877991494E-7 + t * 1.275113935536653E-16;
                        meanPoleY = 1.7307848415610435E-6 + t * 6.068313307674435E-16;
                    }
                    PoleCorrection correction = eopHistory.getPoleCorrection(date);
                    double m1 = correction.getXp() - meanPoleX;
                    double m2 = meanPoleY - correction.getYp();
                    return new double[]{-2.749509867273795E-4 * (m1 - 0.0115 * m2), -2.749509867273795E-4 * (m2 + 0.0115 * m1)};
                }

                @Override
                public <T extends CalculusFieldElement<T>> T[] value(FieldAbsoluteDate<T> date) {
                    AbsoluteDate aDate = date.toAbsoluteDate();
                    if (aDate.compareTo(firstAnnualPoleDate) <= 0) {
                        return (CalculusFieldElement[])MathArrays.buildArray(date.getField(), (int)2);
                    }
                    CalculusFieldElement meanPoleX = (CalculusFieldElement)date.getField().getZero();
                    CalculusFieldElement meanPoleY = (CalculusFieldElement)date.getField().getZero();
                    if (aDate.compareTo(lastAnnualPoleDate) <= 0) {
                        try {
                            FieldHermiteInterpolator interpolator = new FieldHermiteInterpolator();
                            CalculusFieldElement[] y = (CalculusFieldElement[])MathArrays.buildArray(date.getField(), (int)2);
                            CalculusFieldElement zero = (CalculusFieldElement)date.getField().getZero();
                            FieldAbsoluteDate<CalculusFieldElement> central = new FieldAbsoluteDate<CalculusFieldElement>(aDate, zero);
                            annualCache.getNeighbors(aDate).forEach(neighbor -> {
                                y[0] = (CalculusFieldElement)zero.add(neighbor.getX());
                                y[1] = (CalculusFieldElement)zero.add(neighbor.getY());
                                interpolator.addSamplePoint(central.durationFrom(neighbor.getDate()).negate(), (FieldElement[][])new CalculusFieldElement[][]{y});
                            });
                            CalculusFieldElement[] interpolated = (CalculusFieldElement[])interpolator.value((FieldElement)date.durationFrom(central));
                            meanPoleX = interpolated[0];
                            meanPoleY = interpolated[1];
                        }
                        catch (TimeStampedCacheException tsce) {
                            throw new OrekitInternalError(tsce);
                        }
                    } else {
                        T t = date.durationFrom(eopHistory.getTimeScales().getJ2000Epoch());
                        meanPoleX = (CalculusFieldElement)((CalculusFieldElement)t.multiply(1.275113935536653E-16)).add(2.617993877991494E-7);
                        meanPoleY = (CalculusFieldElement)((CalculusFieldElement)t.multiply(6.068313307674435E-16)).add(1.7307848415610435E-6);
                    }
                    FieldPoleCorrection<T> correction = eopHistory.getPoleCorrection(date);
                    CalculusFieldElement m1 = (CalculusFieldElement)correction.getXp().subtract((FieldElement)meanPoleX);
                    CalculusFieldElement m2 = (CalculusFieldElement)meanPoleY.subtract(correction.getYp());
                    CalculusFieldElement[] a = (CalculusFieldElement[])MathArrays.buildArray(date.getField(), (int)2);
                    a[0] = (CalculusFieldElement)((CalculusFieldElement)m1.add(m2.multiply(-0.0115))).multiply(-2.749509867273795E-4);
                    a[1] = (CalculusFieldElement)((CalculusFieldElement)m2.add(m1.multiply(0.0115))).multiply(-2.749509867273795E-4);
                    return a;
                }
            };
        }

        @Override
        public TimeVectorFunction getOceanPoleTide(EOPHistory eopHistory) {
            return new TimeVectorFunction(){

                @Override
                public double[] value(AbsoluteDate date) {
                    return new double[]{0.0, 0.0};
                }

                @Override
                public <T extends CalculusFieldElement<T>> T[] value(FieldAbsoluteDate<T> date) {
                    return (CalculusFieldElement[])MathArrays.buildArray(date.getField(), (int)2);
                }
            };
        }

        @Override
        public double[] getNominalTidalDisplacement() {
            return new double[]{0.6078, -6.0E-4, 0.292, -0.0025, -0.0022, 0.0847, 0.0012, 0.0024, 2.0E-4, 0.015, -7.0E-4, -7.0E-4, -0.3146};
        }

        @Override
        public PoissonSeries.CompiledSeries getTidalDisplacementFrequencyCorrectionDiurnal() {
            return 2.getTidalDisplacementFrequencyCorrectionDiurnal(TIDAL_DISPLACEMENT_CORRECTION_DIURNAL, 18, 15, 16, 17, 18);
        }

        @Override
        public PoissonSeries.CompiledSeries getTidalDisplacementFrequencyCorrectionZonal() {
            return 2.getTidalDisplacementFrequencyCorrectionZonal(TIDAL_DISPLACEMENT_CORRECTION_ZONAL, 18, 15, 16, 17, 18);
        }
    }
    ,
    IERS_2010{
        private static final String NUTATION_ARGUMENTS = "/assets/org/orekit/IERS-conventions/2010/nutation-arguments.txt";
        private static final String X_SERIES = "/assets/org/orekit/IERS-conventions/2010/tab5.2a.txt";
        private static final String Y_SERIES = "/assets/org/orekit/IERS-conventions/2010/tab5.2b.txt";
        private static final String S_SERIES = "/assets/org/orekit/IERS-conventions/2010/tab5.2d.txt";
        private static final String PSI_SERIES = "/assets/org/orekit/IERS-conventions/2010/tab5.3a.txt";
        private static final String EPSILON_SERIES = "/assets/org/orekit/IERS-conventions/2010/tab5.3b.txt";
        private static final String GST_SERIES = "/assets/org/orekit/IERS-conventions/2010/tab5.2e.txt";
        private static final String TIDAL_CORRECTION_XP_YP_SERIES = "/assets/org/orekit/IERS-conventions/2010/tab8.2ab.txt";
        private static final String TIDAL_CORRECTION_UT1_SERIES = "/assets/org/orekit/IERS-conventions/2010/tab8.3ab.txt";
        private static final String LOVE_NUMBERS = "/assets/org/orekit/IERS-conventions/2010/tab6.3.txt";
        private static final String K20_FREQUENCY_DEPENDENCE = "/assets/org/orekit/IERS-conventions/2010/tab6.5b.txt";
        private static final String K21_FREQUENCY_DEPENDENCE = "/assets/org/orekit/IERS-conventions/2010/tab6.5a.txt";
        private static final String K22_FREQUENCY_DEPENDENCE = "/assets/org/orekit/IERS-conventions/2010/tab6.5c.txt";
        private static final String TIDAL_DISPLACEMENT_CORRECTION_DIURNAL = "/assets/org/orekit/IERS-conventions/2010/tab7.3a.txt";
        private static final String TIDAL_DISPLACEMENT_CORRECTION_ZONAL = "/assets/org/orekit/IERS-conventions/2010/tab7.3b.txt";

        @Override
        public FundamentalNutationArguments getNutationArguments(TimeScale timeScale, TimeScales timeScales) {
            return (FundamentalNutationArguments)IERSConventions.load(NUTATION_ARGUMENTS, in -> new FundamentalNutationArguments(this, timeScale, (InputStream)in, NUTATION_ARGUMENTS, timeScales));
        }

        @Override
        public TimeScalarFunction getMeanObliquityFunction(final TimeScales timeScales) {
            final PolynomialNutation epsilonA = new PolynomialNutation(0.4090926006005829, -2.2707106390167E-4, -8.876938501115605E-10, 9.712757287348442E-9, -2.792526803190927E-12, -2.104091376015386E-13);
            return new TimeScalarFunction(){

                @Override
                public double value(AbsoluteDate date) {
                    return epsilonA.value(this.evaluateTC(date, timeScales));
                }

                @Override
                public <T extends CalculusFieldElement<T>> T value(FieldAbsoluteDate<T> date) {
                    return epsilonA.value(this.evaluateTC(date, timeScales));
                }
            };
        }

        @Override
        public TimeVectorFunction getXYSpXY2Function(TimeScales timeScales) {
            final FundamentalNutationArguments arguments = this.getNutationArguments(timeScales);
            double microAS = 4.84813681109536E-12;
            PoissonSeriesParser parser = new PoissonSeriesParser(17).withPolynomialPart('t', PolynomialParser.Unit.MICRO_ARC_SECONDS).withFirstDelaunay(4).withFirstPlanetary(9).withSinCos(0, 2, 4.84813681109536E-12, 3, 4.84813681109536E-12);
            PoissonSeries xSeries = (PoissonSeries)IERSConventions.load(X_SERIES, in -> parser.parse((InputStream)in, X_SERIES));
            PoissonSeries ySeries = (PoissonSeries)IERSConventions.load(Y_SERIES, in -> parser.parse((InputStream)in, Y_SERIES));
            PoissonSeries sSeries = (PoissonSeries)IERSConventions.load(S_SERIES, in -> parser.parse((InputStream)in, S_SERIES));
            final PoissonSeries.CompiledSeries xys = PoissonSeries.compile(xSeries, ySeries, sSeries);
            return new TimeVectorFunction(){

                @Override
                public double[] value(AbsoluteDate date) {
                    return xys.value(arguments.evaluateAll(date));
                }

                @Override
                public <T extends CalculusFieldElement<T>> T[] value(FieldAbsoluteDate<T> date) {
                    return xys.value(arguments.evaluateAll(date));
                }
            };
        }

        @Override
        public LoveNumbers getLoveNumbers() {
            return this.loadLoveNumbers(LOVE_NUMBERS);
        }

        @Override
        public TimeVectorFunction getTideFrequencyDependenceFunction(TimeScale ut1, TimeScales timeScales) {
            FundamentalNutationArguments arguments = this.getNutationArguments(ut1, timeScales);
            PoissonSeriesParser k20Parser = new PoissonSeriesParser(18).withOptionalColumn(1).withDoodson(4, 2).withFirstDelaunay(10);
            PoissonSeriesParser k21Parser = new PoissonSeriesParser(18).withOptionalColumn(1).withDoodson(4, 3).withFirstDelaunay(10);
            PoissonSeriesParser k22Parser = new PoissonSeriesParser(16).withOptionalColumn(1).withDoodson(4, 2).withFirstDelaunay(10);
            double pico = 1.0E-12;
            PoissonSeries c20Series = (PoissonSeries)IERSConventions.load(K20_FREQUENCY_DEPENDENCE, in -> k20Parser.withSinCos(0, 18, -1.0E-12, 16, 1.0E-12).parse((InputStream)in, K20_FREQUENCY_DEPENDENCE));
            PoissonSeries c21Series = (PoissonSeries)IERSConventions.load(K21_FREQUENCY_DEPENDENCE, in -> k21Parser.withSinCos(0, 17, 1.0E-12, 18, 1.0E-12).parse((InputStream)in, K21_FREQUENCY_DEPENDENCE));
            PoissonSeries s21Series = (PoissonSeries)IERSConventions.load(K21_FREQUENCY_DEPENDENCE, in -> k21Parser.withSinCos(0, 18, -1.0E-12, 17, 1.0E-12).parse((InputStream)in, K21_FREQUENCY_DEPENDENCE));
            PoissonSeries c22Series = (PoissonSeries)IERSConventions.load(K22_FREQUENCY_DEPENDENCE, in -> k22Parser.withSinCos(0, -1, 1.0E-12, 16, 1.0E-12).parse((InputStream)in, K22_FREQUENCY_DEPENDENCE));
            PoissonSeries s22Series = (PoissonSeries)IERSConventions.load(K22_FREQUENCY_DEPENDENCE, in -> k22Parser.withSinCos(0, 16, -1.0E-12, -1, 1.0E-12).parse((InputStream)in, K22_FREQUENCY_DEPENDENCE));
            return new TideFrequencyDependenceFunction(arguments, c20Series, c21Series, s21Series, c22Series, s22Series);
        }

        @Override
        public double getPermanentTide() {
            return -1.39141288E-8 * this.getLoveNumbers().getReal(2, 0);
        }

        private double[] computePoleWobble(AbsoluteDate date, EOPHistory eopHistory) {
            int i;
            double[] yPolynomial;
            double[] xPolynomial;
            double f0 = 4.84813681109536E-9;
            double f1 = 1.5362818500441607E-16;
            double f2 = 4.868183417129822E-24;
            double f3 = 1.5426342361680932E-31;
            AbsoluteDate changeDate = new AbsoluteDate(2010, 1, 1, (TimeScale)eopHistory.getTimeScales().getTT());
            if (date.compareTo(changeDate) <= 0) {
                xPolynomial = new double[]{2.713696098642517E-7, 2.802638979035562E-16, 8.96378612596114E-25, 1.0835462874844687E-33};
                yPolynomial = new double[]{1.6791327919756337E-6, 2.74932999883903E-16, -5.223073988238586E-25, -1.4007118864406287E-34};
            } else {
                xPolynomial = new double[]{1.1399424083928521E-7, 1.1697403634421242E-15};
                yPolynomial = new double[]{1.7399526682708251E-6, -9.658603991227639E-17};
            }
            double meanPoleX = 0.0;
            double meanPoleY = 0.0;
            double t = date.durationFrom(eopHistory.getTimeScales().getJ2000Epoch());
            for (i = xPolynomial.length - 1; i >= 0; --i) {
                meanPoleX = meanPoleX * t + xPolynomial[i];
            }
            for (i = yPolynomial.length - 1; i >= 0; --i) {
                meanPoleY = meanPoleY * t + yPolynomial[i];
            }
            PoleCorrection correction = eopHistory.getPoleCorrection(date);
            double m1 = correction.getXp() - meanPoleX;
            double m2 = meanPoleY - correction.getYp();
            return new double[]{m1, m2};
        }

        private <T extends CalculusFieldElement<T>> T[] computePoleWobble(FieldAbsoluteDate<T> date, EOPHistory eopHistory) {
            int i;
            double[] yPolynomial;
            double[] xPolynomial;
            double f0 = 4.84813681109536E-9;
            double f1 = 1.5362818500441607E-16;
            double f2 = 4.868183417129822E-24;
            double f3 = 1.5426342361680932E-31;
            AbsoluteDate changeDate = new AbsoluteDate(2010, 1, 1, (TimeScale)eopHistory.getTimeScales().getTT());
            if (date.toAbsoluteDate().compareTo(changeDate) <= 0) {
                xPolynomial = new double[]{2.713696098642517E-7, 2.802638979035562E-16, 8.96378612596114E-25, 1.0835462874844687E-33};
                yPolynomial = new double[]{1.6791327919756337E-6, 2.74932999883903E-16, -5.223073988238586E-25, -1.4007118864406287E-34};
            } else {
                xPolynomial = new double[]{1.1399424083928521E-7, 1.1697403634421242E-15};
                yPolynomial = new double[]{1.7399526682708251E-6, -9.658603991227639E-17};
            }
            CalculusFieldElement meanPoleX = (CalculusFieldElement)date.getField().getZero();
            CalculusFieldElement meanPoleY = (CalculusFieldElement)date.getField().getZero();
            T t = date.durationFrom(eopHistory.getTimeScales().getJ2000Epoch());
            for (i = xPolynomial.length - 1; i >= 0; --i) {
                meanPoleX = (CalculusFieldElement)((CalculusFieldElement)meanPoleX.multiply(t)).add(xPolynomial[i]);
            }
            for (i = yPolynomial.length - 1; i >= 0; --i) {
                meanPoleY = (CalculusFieldElement)((CalculusFieldElement)meanPoleY.multiply(t)).add(yPolynomial[i]);
            }
            FieldPoleCorrection<T> correction = eopHistory.getPoleCorrection(date);
            CalculusFieldElement[] m = (CalculusFieldElement[])MathArrays.buildArray(date.getField(), (int)2);
            m[0] = (CalculusFieldElement)correction.getXp().subtract((FieldElement)meanPoleX);
            m[1] = (CalculusFieldElement)meanPoleY.subtract(correction.getYp());
            return m;
        }

        @Override
        public TimeVectorFunction getSolidPoleTide(final EOPHistory eopHistory) {
            double globalFactor = -2.749509867273795E-4;
            double ratio = 0.0115;
            return new TimeVectorFunction(){

                @Override
                public double[] value(AbsoluteDate date) {
                    double[] wobbleM = this.computePoleWobble(date, eopHistory);
                    return new double[]{-2.749509867273795E-4 * (wobbleM[0] + 0.0115 * wobbleM[1]), -2.749509867273795E-4 * (wobbleM[1] - 0.0115 * wobbleM[0])};
                }

                @Override
                public <T extends CalculusFieldElement<T>> T[] value(FieldAbsoluteDate<T> date) {
                    CalculusFieldElement[] wobbleM = this.computePoleWobble(date, eopHistory);
                    CalculusFieldElement[] a = (CalculusFieldElement[])MathArrays.buildArray(date.getField(), (int)2);
                    a[0] = (CalculusFieldElement)((CalculusFieldElement)wobbleM[0].add(wobbleM[1].multiply(0.0115))).multiply(-2.749509867273795E-4);
                    a[1] = (CalculusFieldElement)((CalculusFieldElement)wobbleM[1].add(wobbleM[0].multiply(-0.0115))).multiply(-2.749509867273795E-4);
                    return a;
                }
            };
        }

        @Override
        public TimeVectorFunction getOceanPoleTide(final EOPHistory eopHistory) {
            return new TimeVectorFunction(){

                @Override
                public double[] value(AbsoluteDate date) {
                    double[] wobbleM = this.computePoleWobble(date, eopHistory);
                    return new double[]{-2.1778E-10 * (wobbleM[0] - 0.01724 * wobbleM[1]) / 4.84813681109536E-6, -1.7232E-10 * (wobbleM[1] - 0.03365 * wobbleM[0]) / 4.84813681109536E-6};
                }

                @Override
                public <T extends CalculusFieldElement<T>> T[] value(FieldAbsoluteDate<T> date) {
                    CalculusFieldElement[] v = (CalculusFieldElement[])MathArrays.buildArray(date.getField(), (int)2);
                    CalculusFieldElement[] wobbleM = this.computePoleWobble(date, eopHistory);
                    v[0] = (CalculusFieldElement)((CalculusFieldElement)wobbleM[0].subtract(wobbleM[1].multiply(0.01724))).multiply(-4.4920349504492645E-5);
                    v[1] = (CalculusFieldElement)((CalculusFieldElement)wobbleM[1].subtract(wobbleM[0].multiply(0.03365))).multiply(-3.554355141249965E-5);
                    return v;
                }
            };
        }

        @Override
        public TimeVectorFunction getPrecessionFunction(TimeScales timeScales) {
            PolynomialNutation psiA = new PolynomialNutation(0.0, 0.024427247666109923, -5.23117307131589E-6, -5.529057626213704E-9, 6.440798234908296E-10, -4.610578107351687E-13);
            PolynomialNutation omegaA = new PolynomialNutation(this.getMeanObliquityFunction(timeScales).value(this.getNutationReferenceEpoch(timeScales)), -1.2485891543294988E-7, 2.4852664365141367E-7, -3.745200230981599E-8, -2.264079890781533E-12, 1.6178232538625214E-12);
            PolynomialNutation chiA = new PolynomialNutation(0.0, 5.117888597705749E-5, -1.1545494567537374E-5, -5.875796370943243E-9, 8.273975725919673E-10, -2.7149566142134015E-13);
            return new PrecessionFunction(psiA, omegaA, chiA, timeScales);
        }

        @Override
        public TimeVectorFunction getNutationFunction(final TimeScales timeScales) {
            final FundamentalNutationArguments arguments = this.getNutationArguments(timeScales);
            double microAS = 4.84813681109536E-12;
            PoissonSeriesParser parser = new PoissonSeriesParser(17).withFirstDelaunay(4).withFirstPlanetary(9).withSinCos(0, 2, 4.84813681109536E-12, 3, 4.84813681109536E-12);
            PoissonSeries psiSeries = (PoissonSeries)IERSConventions.load(PSI_SERIES, in -> parser.parse((InputStream)in, PSI_SERIES));
            PoissonSeries epsilonSeries = (PoissonSeries)IERSConventions.load(EPSILON_SERIES, in -> parser.parse((InputStream)in, EPSILON_SERIES));
            final PoissonSeries.CompiledSeries psiEpsilonSeries = PoissonSeries.compile(psiSeries, epsilonSeries);
            return new TimeVectorFunction(){

                @Override
                public double[] value(AbsoluteDate date) {
                    BodiesElements elements = arguments.evaluateAll(date);
                    double[] psiEpsilon = psiEpsilonSeries.value(elements);
                    return new double[]{psiEpsilon[0], psiEpsilon[1], IAU1994ResolutionC7.value(elements, (TimeScale)timeScales.getTAI())};
                }

                @Override
                public <T extends CalculusFieldElement<T>> T[] value(FieldAbsoluteDate<T> date) {
                    FieldBodiesElements<T> elements = arguments.evaluateAll(date);
                    CalculusFieldElement[] psiEpsilon = psiEpsilonSeries.value(elements);
                    CalculusFieldElement[] result = (CalculusFieldElement[])MathArrays.buildArray(date.getField(), (int)3);
                    result[0] = psiEpsilon[0];
                    result[1] = psiEpsilon[1];
                    result[2] = IAU1994ResolutionC7.value(elements, (TimeScale)timeScales.getTAI());
                    return result;
                }
            };
        }

        @Override
        public TimeScalarFunction getGMSTFunction(TimeScale ut1, final TimeScales timeScales) {
            final StellarAngleCapitaine era = new StellarAngleCapitaine(ut1, timeScales.getTAI());
            double microAS = 4.84813681109536E-12;
            PoissonSeriesParser parser = new PoissonSeriesParser(17).withFirstDelaunay(4).withFirstPlanetary(9).withSinCos(0, 2, 4.84813681109536E-12, 3, 4.84813681109536E-12).withPolynomialPart('t', PolynomialParser.Unit.ARC_SECONDS);
            final PolynomialNutation minusEO = (PolynomialNutation)IERSConventions.load(GST_SERIES, in -> parser.parse((InputStream)in, GST_SERIES).getPolynomial());
            return new TimeScalarFunction(){

                @Override
                public double value(AbsoluteDate date) {
                    return era.value(date) + minusEO.value(this.evaluateTC(date, timeScales));
                }

                @Override
                public <T extends CalculusFieldElement<T>> T value(FieldAbsoluteDate<T> date) {
                    return (T)((CalculusFieldElement)era.value(date).add(minusEO.value(this.evaluateTC(date, timeScales))));
                }
            };
        }

        @Override
        public TimeScalarFunction getGMSTRateFunction(TimeScale ut1, final TimeScales timeScales) {
            final StellarAngleCapitaine era = new StellarAngleCapitaine(ut1, timeScales.getTAI());
            double microAS = 4.84813681109536E-12;
            PoissonSeriesParser parser = new PoissonSeriesParser(17).withFirstDelaunay(4).withFirstPlanetary(9).withSinCos(0, 2, 4.84813681109536E-12, 3, 4.84813681109536E-12).withPolynomialPart('t', PolynomialParser.Unit.ARC_SECONDS);
            final PolynomialNutation minusEO = (PolynomialNutation)IERSConventions.load(GST_SERIES, in -> parser.parse((InputStream)in, GST_SERIES).getPolynomial());
            return new TimeScalarFunction(){

                @Override
                public double value(AbsoluteDate date) {
                    return era.getRate() + minusEO.derivative(this.evaluateTC(date, timeScales));
                }

                @Override
                public <T extends CalculusFieldElement<T>> T value(FieldAbsoluteDate<T> date) {
                    return (T)((CalculusFieldElement)minusEO.derivative(this.evaluateTC(date, timeScales)).add(era.getRate()));
                }
            };
        }

        @Override
        public TimeScalarFunction getGASTFunction(TimeScale ut1, final EOPHistory eopHistory, TimeScales timeScales) {
            final FundamentalNutationArguments arguments = this.getNutationArguments(timeScales);
            final TimeScalarFunction epsilon = this.getMeanObliquityFunction(timeScales);
            double microAS = 4.84813681109536E-12;
            PoissonSeriesParser baseParser = new PoissonSeriesParser(17).withFirstDelaunay(4).withFirstPlanetary(9).withSinCos(0, 2, 4.84813681109536E-12, 3, 4.84813681109536E-12);
            PoissonSeriesParser gstParser = baseParser.withPolynomialPart('t', PolynomialParser.Unit.ARC_SECONDS);
            PoissonSeries psiSeries = (PoissonSeries)IERSConventions.load(PSI_SERIES, in -> baseParser.parse((InputStream)in, PSI_SERIES));
            PoissonSeries gstSeries = (PoissonSeries)IERSConventions.load(GST_SERIES, in -> gstParser.parse((InputStream)in, GST_SERIES));
            final PoissonSeries.CompiledSeries psiGstSeries = PoissonSeries.compile(psiSeries, gstSeries);
            final TimeScalarFunction era = this.getEarthOrientationAngleFunction(ut1, timeScales.getTAI());
            return new TimeScalarFunction(){

                @Override
                public double value(AbsoluteDate date) {
                    BodiesElements elements = arguments.evaluateAll(date);
                    double[] angles = psiGstSeries.value(elements);
                    double ddPsi = eopHistory == null ? 0.0 : eopHistory.getEquinoxNutationCorrection(date)[0];
                    double deltaPsi = angles[0] + ddPsi;
                    double epsilonA = epsilon.value(date);
                    return era.value(date) + deltaPsi * FastMath.cos((double)epsilonA) + angles[1];
                }

                @Override
                public <T extends CalculusFieldElement<T>> T value(FieldAbsoluteDate<T> date) {
                    FieldBodiesElements<T> elements = arguments.evaluateAll(date);
                    CalculusFieldElement[] angles = psiGstSeries.value(elements);
                    CalculusFieldElement ddPsi = eopHistory == null ? (CalculusFieldElement)date.getField().getZero() : eopHistory.getEquinoxNutationCorrection(date)[0];
                    CalculusFieldElement deltaPsi = (CalculusFieldElement)angles[0].add((FieldElement)ddPsi);
                    T epsilonA = epsilon.value(date);
                    return (T)((CalculusFieldElement)((CalculusFieldElement)era.value(date).add(deltaPsi.multiply(epsilonA.cos()))).add((FieldElement)angles[1]));
                }
            };
        }

        @Override
        public TimeVectorFunction getEOPTidalCorrection(TimeScales timeScales) {
            FundamentalNutationArguments arguments = this.getNutationArguments(timeScales.getTT(), timeScales);
            double microAS = 4.84813681109536E-12;
            PoissonSeriesParser xyParser = new PoissonSeriesParser(13).withOptionalColumn(1).withGamma(2).withFirstDelaunay(3);
            double microS = 1.0E-6;
            PoissonSeriesParser ut1Parser = new PoissonSeriesParser(11).withOptionalColumn(1).withGamma(2).withFirstDelaunay(3);
            PoissonSeries xSeries = (PoissonSeries)IERSConventions.load(TIDAL_CORRECTION_XP_YP_SERIES, xpIn -> xyParser.withSinCos(0, 10, 4.84813681109536E-12, 11, 4.84813681109536E-12).parse((InputStream)xpIn, TIDAL_CORRECTION_XP_YP_SERIES));
            PoissonSeries ySeries = (PoissonSeries)IERSConventions.load(TIDAL_CORRECTION_XP_YP_SERIES, ypIn -> xyParser.withSinCos(0, 12, 4.84813681109536E-12, 13, 4.84813681109536E-12).parse((InputStream)ypIn, TIDAL_CORRECTION_XP_YP_SERIES));
            PoissonSeries ut1Series = (PoissonSeries)IERSConventions.load(TIDAL_CORRECTION_UT1_SERIES, ut1In -> ut1Parser.withSinCos(0, 10, 1.0E-6, 11, 1.0E-6).parse((InputStream)ut1In, TIDAL_CORRECTION_UT1_SERIES));
            return new EOPTidalCorrection(arguments, xSeries, ySeries, ut1Series);
        }

        @Override
        public double[] getNominalTidalDisplacement() {
            return new double[]{0.6078, -6.0E-4, 0.292, -0.0025, -0.0022, 0.0847, 0.0012, 0.0024, 2.0E-4, 0.015, -7.0E-4, -7.0E-4, -0.3146};
        }

        @Override
        public PoissonSeries.CompiledSeries getTidalDisplacementFrequencyCorrectionDiurnal() {
            return 3.getTidalDisplacementFrequencyCorrectionDiurnal(TIDAL_DISPLACEMENT_CORRECTION_DIURNAL, 18, 15, 16, 17, 18);
        }

        @Override
        public PoissonSeries.CompiledSeries getTidalDisplacementFrequencyCorrectionZonal() {
            return 3.getTidalDisplacementFrequencyCorrectionZonal(TIDAL_DISPLACEMENT_CORRECTION_ZONAL, 18, 15, 16, 17, 18);
        }
    };

    private static final Pattern SEPARATOR;
    private static final String IERS_BASE = "/assets/org/orekit/IERS-conventions/";

    @DefaultDataContext
    public AbsoluteDate getNutationReferenceEpoch() {
        return this.getNutationReferenceEpoch(DataContext.getDefault().getTimeScales());
    }

    public AbsoluteDate getNutationReferenceEpoch(TimeScales timeScales) {
        return timeScales.getJ2000Epoch();
    }

    @DefaultDataContext
    public double evaluateTC(AbsoluteDate date) {
        return this.evaluateTC(date, (TimeScales)DataContext.getDefault().getTimeScales());
    }

    public double evaluateTC(AbsoluteDate date, TimeScales timeScales) {
        return date.durationFrom(this.getNutationReferenceEpoch(timeScales)) / 3.15576E9;
    }

    @DefaultDataContext
    public <T extends CalculusFieldElement<T>> T evaluateTC(FieldAbsoluteDate<T> date) {
        return this.evaluateTC(date, (TimeScales)DataContext.getDefault().getTimeScales());
    }

    public <T extends CalculusFieldElement<T>> T evaluateTC(FieldAbsoluteDate<T> date, TimeScales timeScales) {
        return (T)((CalculusFieldElement)date.durationFrom(this.getNutationReferenceEpoch(timeScales)).divide(3.15576E9));
    }

    protected FundamentalNutationArguments getNutationArguments(TimeScales timeScales) {
        return this.getNutationArguments(null, timeScales);
    }

    @DefaultDataContext
    public FundamentalNutationArguments getNutationArguments(TimeScale timeScale) {
        return this.getNutationArguments(timeScale, DataContext.getDefault().getTimeScales());
    }

    public abstract FundamentalNutationArguments getNutationArguments(TimeScale var1, TimeScales var2);

    @DefaultDataContext
    public TimeScalarFunction getMeanObliquityFunction() {
        return this.getMeanObliquityFunction(DataContext.getDefault().getTimeScales());
    }

    public abstract TimeScalarFunction getMeanObliquityFunction(TimeScales var1);

    @DefaultDataContext
    public TimeVectorFunction getXYSpXY2Function() {
        return this.getXYSpXY2Function(DataContext.getDefault().getTimeScales());
    }

    public abstract TimeVectorFunction getXYSpXY2Function(TimeScales var1);

    @DefaultDataContext
    public TimeScalarFunction getEarthOrientationAngleFunction(TimeScale ut1) {
        return this.getEarthOrientationAngleFunction(ut1, DataContext.getDefault().getTimeScales().getTAI());
    }

    public TimeScalarFunction getEarthOrientationAngleFunction(TimeScale ut1, TimeScale tai) {
        return new StellarAngleCapitaine(ut1, tai);
    }

    @DefaultDataContext
    public TimeVectorFunction getPrecessionFunction() {
        return this.getPrecessionFunction(DataContext.getDefault().getTimeScales());
    }

    public abstract TimeVectorFunction getPrecessionFunction(TimeScales var1);

    @DefaultDataContext
    public TimeVectorFunction getNutationFunction() {
        return this.getNutationFunction(DataContext.getDefault().getTimeScales());
    }

    public abstract TimeVectorFunction getNutationFunction(TimeScales var1);

    @DefaultDataContext
    public TimeScalarFunction getGMSTFunction(TimeScale ut1) {
        return this.getGMSTFunction(ut1, DataContext.getDefault().getTimeScales());
    }

    public abstract TimeScalarFunction getGMSTFunction(TimeScale var1, TimeScales var2);

    @DefaultDataContext
    public TimeScalarFunction getGMSTRateFunction(TimeScale ut1) {
        return this.getGMSTRateFunction(ut1, DataContext.getDefault().getTimeScales());
    }

    public abstract TimeScalarFunction getGMSTRateFunction(TimeScale var1, TimeScales var2);

    @DefaultDataContext
    public TimeScalarFunction getGASTFunction(TimeScale ut1, EOPHistory eopHistory) {
        TimeScales timeScales = eopHistory != null ? eopHistory.getTimeScales() : DataContext.getDefault().getTimeScales();
        return this.getGASTFunction(ut1, eopHistory, timeScales);
    }

    public abstract TimeScalarFunction getGASTFunction(TimeScale var1, EOPHistory var2, TimeScales var3);

    @DefaultDataContext
    public TimeVectorFunction getEOPTidalCorrection() {
        return this.getEOPTidalCorrection(DataContext.getDefault().getTimeScales());
    }

    public abstract TimeVectorFunction getEOPTidalCorrection(TimeScales var1);

    public abstract LoveNumbers getLoveNumbers();

    @DefaultDataContext
    public TimeVectorFunction getTideFrequencyDependenceFunction(TimeScale ut1) {
        return this.getTideFrequencyDependenceFunction(ut1, DataContext.getDefault().getTimeScales());
    }

    public abstract TimeVectorFunction getTideFrequencyDependenceFunction(TimeScale var1, TimeScales var2);

    public abstract double getPermanentTide();

    public abstract TimeVectorFunction getSolidPoleTide(EOPHistory var1);

    public abstract TimeVectorFunction getOceanPoleTide(EOPHistory var1);

    public abstract double[] getNominalTidalDisplacement();

    public abstract PoissonSeries.CompiledSeries getTidalDisplacementFrequencyCorrectionDiurnal();

    protected static PoissonSeries.CompiledSeries getTidalDisplacementFrequencyCorrectionDiurnal(String tableName, int cols, int rIp, int rOp, int tIp, int tOp) {
        PoissonSeries drCos = IERSConventions.load(tableName, in -> new PoissonSeriesParser(cols).withOptionalColumn(1).withDoodson(4, 3).withFirstDelaunay(10).withSinCos(0, rIp, 0.001, rOp, 0.001).parse((InputStream)in, tableName));
        PoissonSeries drSin = IERSConventions.load(tableName, in -> new PoissonSeriesParser(cols).withOptionalColumn(1).withDoodson(4, 3).withFirstDelaunay(10).withSinCos(0, rOp, -0.001, rIp, 0.001).parse((InputStream)in, tableName));
        PoissonSeries dnCos = IERSConventions.load(tableName, in -> new PoissonSeriesParser(cols).withOptionalColumn(1).withDoodson(4, 3).withFirstDelaunay(10).withSinCos(0, tIp, 0.001, tOp, 0.001).parse((InputStream)in, tableName));
        PoissonSeries dnSin = IERSConventions.load(tableName, in -> new PoissonSeriesParser(cols).withOptionalColumn(1).withDoodson(4, 3).withFirstDelaunay(10).withSinCos(0, tOp, -0.001, tIp, 0.001).parse((InputStream)in, tableName));
        PoissonSeries deCos = IERSConventions.load(tableName, in -> new PoissonSeriesParser(cols).withOptionalColumn(1).withDoodson(4, 3).withFirstDelaunay(10).withSinCos(0, tOp, -0.001, tIp, 0.001).parse((InputStream)in, tableName));
        PoissonSeries deSin = IERSConventions.load(tableName, in -> new PoissonSeriesParser(cols).withOptionalColumn(1).withDoodson(4, 3).withFirstDelaunay(10).withSinCos(0, tIp, -0.001, tOp, -0.001).parse((InputStream)in, tableName));
        return PoissonSeries.compile(drCos, drSin, dnCos, dnSin, deCos, deSin);
    }

    public abstract PoissonSeries.CompiledSeries getTidalDisplacementFrequencyCorrectionZonal();

    protected static PoissonSeries.CompiledSeries getTidalDisplacementFrequencyCorrectionZonal(String tableName, int cols, int rIp, int rOp, int tIp, int tOp) {
        PoissonSeries dr = IERSConventions.load(tableName, in -> new PoissonSeriesParser(cols).withOptionalColumn(1).withDoodson(4, 3).withFirstDelaunay(10).withSinCos(0, rOp, 0.001, rIp, 0.001).parse((InputStream)in, tableName));
        PoissonSeries dn = IERSConventions.load(tableName, in -> new PoissonSeriesParser(cols).withOptionalColumn(1).withDoodson(4, 3).withFirstDelaunay(10).withSinCos(0, tOp, 0.001, tIp, 0.001).parse((InputStream)in, tableName));
        return PoissonSeries.compile(dr, dn);
    }

    @DefaultDataContext
    public NutationCorrectionConverter getNutationCorrectionConverter() {
        return this.getNutationCorrectionConverter(DataContext.getDefault().getTimeScales());
    }

    public NutationCorrectionConverter getNutationCorrectionConverter(TimeScales timeScales) {
        final TimeVectorFunction precessionFunction = this.getPrecessionFunction(timeScales);
        final TimeScalarFunction epsilonAFunction = this.getMeanObliquityFunction(timeScales);
        AbsoluteDate date0 = this.getNutationReferenceEpoch(timeScales);
        final double cosE0 = FastMath.cos((double)epsilonAFunction.value(date0));
        return new NutationCorrectionConverter(){

            @Override
            public double[] toNonRotating(AbsoluteDate date, double ddPsi, double ddEpsilon) {
                double[] angles = precessionFunction.value(date);
                double sinEA = FastMath.sin((double)epsilonAFunction.value(date));
                double c = angles[0] * cosE0 - angles[2];
                return new double[]{sinEA * ddPsi + c * ddEpsilon, ddEpsilon - c * sinEA * ddPsi};
            }

            @Override
            public double[] toEquinox(AbsoluteDate date, double dX, double dY) {
                double[] angles = precessionFunction.value(date);
                double sinEA = FastMath.sin((double)epsilonAFunction.value(date));
                double c = angles[0] * cosE0 - angles[2];
                double opC2 = 1.0 + c * c;
                return new double[]{(dX - c * dY) / (sinEA * opC2), (dY + c * dX) / opC2};
            }
        };
    }

    protected LoveNumbers loadLoveNumbers(String nameLove) {
        try {
            double[][] real = new double[4][];
            double[][] imaginary = new double[4][];
            double[][] plus = new double[4][];
            for (int i = 0; i < real.length; ++i) {
                real[i] = new double[i + 1];
                imaginary[i] = new double[i + 1];
                plus[i] = new double[i + 1];
            }
            try (InputStream stream = IERSConventions.class.getResourceAsStream(nameLove);){
                if (stream == null) {
                    throw new OrekitException((Localizable)OrekitMessages.UNABLE_TO_FIND_FILE, nameLove);
                }
                int lineNumber = 1;
                String line = null;
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(stream, StandardCharsets.UTF_8));){
                    line = reader.readLine();
                    while (line != null) {
                        if (!(line = line.trim()).isEmpty() && !line.startsWith("#")) {
                            String[] fields = SEPARATOR.split(line);
                            if (fields.length != 5) {
                                throw new OrekitException((Localizable)OrekitMessages.UNABLE_TO_PARSE_LINE_IN_FILE, lineNumber, nameLove, line);
                            }
                            int n = Integer.parseInt(fields[0]);
                            int m = Integer.parseInt(fields[1]);
                            if (n < 2 || n > 3 || m < 0 || m > n) {
                                throw new OrekitException((Localizable)OrekitMessages.UNABLE_TO_PARSE_LINE_IN_FILE, lineNumber, nameLove, line);
                            }
                            real[n][m] = Double.parseDouble(fields[2]);
                            imaginary[n][m] = Double.parseDouble(fields[3]);
                            plus[n][m] = Double.parseDouble(fields[4]);
                        }
                        ++lineNumber;
                        line = reader.readLine();
                    }
                }
                catch (NumberFormatException nfe) {
                    throw new OrekitException((Localizable)OrekitMessages.UNABLE_TO_PARSE_LINE_IN_FILE, lineNumber, nameLove, line);
                }
            }
            return new LoveNumbers(real, imaginary, plus);
        }
        catch (IOException ioe) {
            throw new OrekitException((Localizable)OrekitMessages.NOT_A_SUPPORTED_IERS_DATA_FILE, nameLove);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static <T> T load(String name, Function<InputStream, T> loader) {
        try (InputStream is = IERSConventions.class.getResourceAsStream(name);){
            InputStream inputStream = loader.apply(is);
            return (T)inputStream;
        }
        catch (IOException ioe) {
            throw new OrekitException((Localizable)OrekitMessages.INTERNAL_ERROR, (Throwable)ioe);
        }
    }

    static {
        SEPARATOR = Pattern.compile("\\p{Space}+");
    }

    private static class EOPTidalCorrection
    implements TimeVectorFunction {
        private final FundamentalNutationArguments arguments;
        private final PoissonSeries.CompiledSeries correctionSeries;

        EOPTidalCorrection(FundamentalNutationArguments arguments, PoissonSeries xSeries, PoissonSeries ySeries, PoissonSeries ut1Series) {
            this.arguments = arguments;
            this.correctionSeries = PoissonSeries.compile(xSeries, ySeries, ut1Series);
        }

        @Override
        public double[] value(AbsoluteDate date) {
            BodiesElements elements = this.arguments.evaluateAll(date);
            double[] correction = this.correctionSeries.value(elements);
            double[] correctionDot = this.correctionSeries.derivative(elements);
            return new double[]{correction[0], correction[1], correction[2], correctionDot[2] * -86400.0};
        }

        @Override
        public <T extends CalculusFieldElement<T>> T[] value(FieldAbsoluteDate<T> date) {
            FieldBodiesElements<T> elements = this.arguments.evaluateAll(date);
            CalculusFieldElement[] correction = this.correctionSeries.value(elements);
            CalculusFieldElement[] correctionDot = this.correctionSeries.derivative(elements);
            CalculusFieldElement[] a = (CalculusFieldElement[])MathArrays.buildArray(date.getField(), (int)4);
            a[0] = correction[0];
            a[1] = correction[1];
            a[2] = correction[2];
            a[3] = (CalculusFieldElement)correctionDot[2].multiply(-86400.0);
            return a;
        }
    }

    private static class TideFrequencyDependenceFunction
    implements TimeVectorFunction {
        private final FundamentalNutationArguments arguments;
        private final PoissonSeries.CompiledSeries kSeries;

        TideFrequencyDependenceFunction(FundamentalNutationArguments arguments, PoissonSeries c20Series, PoissonSeries c21Series, PoissonSeries s21Series, PoissonSeries c22Series, PoissonSeries s22Series) {
            this.arguments = arguments;
            this.kSeries = PoissonSeries.compile(c20Series, c21Series, s21Series, c22Series, s22Series);
        }

        @Override
        public double[] value(AbsoluteDate date) {
            return this.kSeries.value(this.arguments.evaluateAll(date));
        }

        @Override
        public <T extends CalculusFieldElement<T>> T[] value(FieldAbsoluteDate<T> date) {
            return this.kSeries.value(this.arguments.evaluateAll(date));
        }
    }

    private class PrecessionFunction
    implements TimeVectorFunction {
        private final PolynomialNutation psiA;
        private final PolynomialNutation omegaA;
        private final PolynomialNutation chiA;
        private final TimeScales timeScales;

        PrecessionFunction(PolynomialNutation psiA, PolynomialNutation omegaA, PolynomialNutation chiA, TimeScales timeScales) {
            this.psiA = psiA;
            this.omegaA = omegaA;
            this.chiA = chiA;
            this.timeScales = timeScales;
        }

        @Override
        public double[] value(AbsoluteDate date) {
            double tc = IERSConventions.this.evaluateTC(date, this.timeScales);
            return new double[]{this.psiA.value(tc), this.omegaA.value(tc), this.chiA.value(tc)};
        }

        @Override
        public <T extends CalculusFieldElement<T>> T[] value(FieldAbsoluteDate<T> date) {
            CalculusFieldElement[] a = (CalculusFieldElement[])MathArrays.buildArray(date.getField(), (int)3);
            T tc = IERSConventions.this.evaluateTC(date, this.timeScales);
            a[0] = this.psiA.value(tc);
            a[1] = this.omegaA.value(tc);
            a[2] = this.chiA.value(tc);
            return a;
        }
    }

    private static class MeanPole
    implements TimeStamped,
    Serializable {
        private static final long serialVersionUID = 20131028L;
        private final AbsoluteDate date;
        private double x;
        private double y;

        MeanPole(AbsoluteDate date, double x, double y) {
            this.date = date;
            this.x = x;
            this.y = y;
        }

        @Override
        public AbsoluteDate getDate() {
            return this.date;
        }

        public double getX() {
            return this.x;
        }

        public double getY() {
            return this.y;
        }
    }

    private static class StellarAngleCapitaine
    implements TimeScalarFunction {
        private static final double ERA_0 = 4.894961212823756;
        private static final double ERA_1A = 7.27220521664304E-5;
        private static final double ERA_1B = 1.99099300639395E-7;
        private final TimeScale ut1;
        private final AbsoluteDate referenceDate;

        StellarAngleCapitaine(TimeScale ut1, TimeScale tai) {
            this.ut1 = ut1;
            this.referenceDate = new AbsoluteDate(DateComponents.J2000_EPOCH, TimeComponents.H12, tai);
        }

        public double getRate() {
            return 7.292115146706979E-5;
        }

        @Override
        public double value(AbsoluteDate date) {
            int secondsInDay = 86400;
            double dt = date.durationFrom(this.referenceDate);
            long days = (long)dt / 86400L;
            double dtA = 86400L * days;
            double dtB = dt - dtA + this.ut1.offsetFromTAI(date);
            return 4.894961212823756 + 7.27220521664304E-5 * dtB + 1.99099300639395E-7 * (dtA + dtB);
        }

        @Override
        public <T extends CalculusFieldElement<T>> T value(FieldAbsoluteDate<T> date) {
            int secondsInDay = 86400;
            T dt = date.durationFrom(this.referenceDate);
            long days = (long)dt.getReal() / 86400L;
            double dtA = 86400L * days;
            CalculusFieldElement dtB = (CalculusFieldElement)((CalculusFieldElement)dt.subtract(dtA)).add(this.ut1.offsetFromTAI(date.toAbsoluteDate()));
            return (T)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)dtB.add(dtA)).multiply(1.99099300639395E-7)).add(dtB.multiply(7.27220521664304E-5))).add(4.894961212823756));
        }
    }

    private static class IAU1994ResolutionC7 {
        private static final double EQE1 = 1.2799081181291749E-8;
        private static final double EQE2 = 3.0543261909900767E-10;

        private IAU1994ResolutionC7() {
        }

        public static double value(DelaunayArguments arguments, TimeScale tai) {
            AbsoluteDate modelStart = new AbsoluteDate(1997, 2, 27, 0, 0, 30.0, tai);
            if (arguments.getDate().compareTo(modelStart) >= 0) {
                double om = arguments.getOmega();
                return 1.2799081181291749E-8 * FastMath.sin((double)om) + 3.0543261909900767E-10 * FastMath.sin((double)(om + om));
            }
            return 0.0;
        }

        public static <T extends CalculusFieldElement<T>> T value(FieldDelaunayArguments<T> arguments, TimeScale tai) {
            AbsoluteDate modelStart = new AbsoluteDate(1997, 2, 27, 0, 0, 30.0, tai);
            if (arguments.getDate().toAbsoluteDate().compareTo(modelStart) >= 0) {
                T om = arguments.getOmega();
                return (T)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)om.sin()).multiply(1.2799081181291749E-8)).add(((CalculusFieldElement)((CalculusFieldElement)om.add(om)).sin()).multiply(3.0543261909900767E-10)));
            }
            return (T)((CalculusFieldElement)arguments.getDate().getField().getZero());
        }
    }

    public static interface NutationCorrectionConverter {
        public double[] toNonRotating(AbsoluteDate var1, double var2, double var4);

        public double[] toEquinox(AbsoluteDate var1, double var2, double var4);
    }
}

