/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.integration;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hipparchus.exception.Localizable;
import org.hipparchus.exception.MathRuntimeException;
import org.hipparchus.ode.DenseOutputModel;
import org.hipparchus.ode.EquationsMapper;
import org.hipparchus.ode.ExpandableODE;
import org.hipparchus.ode.ODEIntegrator;
import org.hipparchus.ode.ODEState;
import org.hipparchus.ode.ODEStateAndDerivative;
import org.hipparchus.ode.OrdinaryDifferentialEquation;
import org.hipparchus.ode.SecondaryODE;
import org.hipparchus.ode.events.Action;
import org.hipparchus.ode.events.EventHandlerConfiguration;
import org.hipparchus.ode.events.ODEEventHandler;
import org.hipparchus.ode.sampling.AbstractODEStateInterpolator;
import org.hipparchus.ode.sampling.ODEStateInterpolator;
import org.hipparchus.ode.sampling.ODEStepHandler;
import org.hipparchus.util.Precision;
import org.orekit.attitudes.AttitudeProvider;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitInternalError;
import org.orekit.errors.OrekitMessages;
import org.orekit.frames.Frame;
import org.orekit.orbits.OrbitType;
import org.orekit.orbits.PositionAngle;
import org.orekit.propagation.AbstractPropagator;
import org.orekit.propagation.BoundedPropagator;
import org.orekit.propagation.EphemerisGenerator;
import org.orekit.propagation.PropagationType;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.events.EventDetector;
import org.orekit.propagation.integration.AdditionalEquations;
import org.orekit.propagation.integration.IntegratedEphemeris;
import org.orekit.propagation.integration.StateMapper;
import org.orekit.propagation.sampling.OrekitStepHandler;
import org.orekit.propagation.sampling.OrekitStepInterpolator;
import org.orekit.time.AbsoluteDate;

public abstract class AbstractIntegratedPropagator
extends AbstractPropagator {
    private final List<EventDetector> detectors = new ArrayList<EventDetector>();
    private final List<StoringStepHandler> generators = new ArrayList<StoringStepHandler>();
    private final ODEIntegrator integrator;
    private List<AdditionalEquations> additionalEquations = new ArrayList<AdditionalEquations>();
    private int calls;
    private StateMapper stateMapper;
    private EquationsMapper equationsMapper;
    private boolean resetAtEnd;
    private PropagationType propagationType;

    protected AbstractIntegratedPropagator(ODEIntegrator integrator, PropagationType propagationType) {
        this.integrator = integrator;
        this.propagationType = propagationType;
        this.resetAtEnd = true;
    }

    public void setResetAtEnd(boolean resetAtEnd) {
        this.resetAtEnd = resetAtEnd;
    }

    protected void initMapper() {
        this.stateMapper = this.createMapper(null, Double.NaN, null, null, null, null);
    }

    @Override
    public void setAttitudeProvider(AttitudeProvider attitudeProvider) {
        super.setAttitudeProvider(attitudeProvider);
        this.stateMapper = this.createMapper(this.stateMapper.getReferenceDate(), this.stateMapper.getMu(), this.stateMapper.getOrbitType(), this.stateMapper.getPositionAngleType(), attitudeProvider, this.stateMapper.getFrame());
    }

    protected void setOrbitType(OrbitType orbitType) {
        this.stateMapper = this.createMapper(this.stateMapper.getReferenceDate(), this.stateMapper.getMu(), orbitType, this.stateMapper.getPositionAngleType(), this.stateMapper.getAttitudeProvider(), this.stateMapper.getFrame());
    }

    protected OrbitType getOrbitType() {
        return this.stateMapper.getOrbitType();
    }

    protected PropagationType isMeanOrbit() {
        return this.propagationType;
    }

    protected void setPositionAngleType(PositionAngle positionAngleType) {
        this.stateMapper = this.createMapper(this.stateMapper.getReferenceDate(), this.stateMapper.getMu(), this.stateMapper.getOrbitType(), positionAngleType, this.stateMapper.getAttitudeProvider(), this.stateMapper.getFrame());
    }

    protected PositionAngle getPositionAngleType() {
        return this.stateMapper.getPositionAngleType();
    }

    public void setMu(double mu) {
        this.stateMapper = this.createMapper(this.stateMapper.getReferenceDate(), mu, this.stateMapper.getOrbitType(), this.stateMapper.getPositionAngleType(), this.stateMapper.getAttitudeProvider(), this.stateMapper.getFrame());
    }

    public double getMu() {
        return this.stateMapper.getMu();
    }

    public int getCalls() {
        return this.calls;
    }

    @Override
    public boolean isAdditionalStateManaged(String name) {
        if (super.isAdditionalStateManaged(name)) {
            return true;
        }
        for (AdditionalEquations equation : this.additionalEquations) {
            if (!equation.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String[] getManagedAdditionalStates() {
        String[] alreadyIntegrated = super.getManagedAdditionalStates();
        String[] managed = new String[alreadyIntegrated.length + this.additionalEquations.size()];
        System.arraycopy(alreadyIntegrated, 0, managed, 0, alreadyIntegrated.length);
        for (int i = 0; i < this.additionalEquations.size(); ++i) {
            managed[i + alreadyIntegrated.length] = this.additionalEquations.get(i).getName();
        }
        return managed;
    }

    public void addAdditionalEquations(AdditionalEquations additional) {
        if (this.isAdditionalStateManaged(additional.getName())) {
            throw new OrekitException((Localizable)OrekitMessages.ADDITIONAL_STATE_NAME_ALREADY_IN_USE, additional.getName());
        }
        this.additionalEquations.add(additional);
    }

    public void addEventDetector(EventDetector detector) {
        this.detectors.add(detector);
    }

    @Override
    public Collection<EventDetector> getEventsDetectors() {
        return Collections.unmodifiableCollection(this.detectors);
    }

    @Override
    public void clearEventsDetectors() {
        this.detectors.clear();
    }

    protected void setUpUserEventDetectors() {
        for (EventDetector detector : this.detectors) {
            this.setUpEventDetector(this.integrator, detector);
        }
    }

    protected void setUpEventDetector(ODEIntegrator integ, EventDetector detector) {
        integ.addEventHandler((ODEEventHandler)new AdaptedEventDetector(detector), detector.getMaxCheckInterval(), detector.getThreshold(), detector.getMaxIterationCount());
    }

    @Override
    public EphemerisGenerator getEphemerisGenerator() {
        StoringStepHandler storingHandler = new StoringStepHandler();
        this.generators.add(storingHandler);
        return storingHandler;
    }

    protected abstract StateMapper createMapper(AbsoluteDate var1, double var2, OrbitType var4, PositionAngle var5, AttitudeProvider var6, Frame var7);

    protected abstract MainStateEquations getMainStateEquations(ODEIntegrator var1);

    @Override
    public SpacecraftState propagate(AbsoluteDate target) {
        if (this.getStartDate() == null) {
            if (this.getInitialState() == null) {
                throw new OrekitException((Localizable)OrekitMessages.INITIAL_STATE_NOT_SPECIFIED_FOR_ORBIT_PROPAGATION, new Object[0]);
            }
            this.setStartDate(this.getInitialState().getDate());
        }
        return this.propagate(this.getStartDate(), target);
    }

    @Override
    public SpacecraftState propagate(AbsoluteDate tStart, AbsoluteDate tEnd) {
        if (this.getInitialState() == null) {
            throw new OrekitException((Localizable)OrekitMessages.INITIAL_STATE_NOT_SPECIFIED_FOR_ORBIT_PROPAGATION, new Object[0]);
        }
        try (IntegratorResetter resetter = new IntegratorResetter(this.integrator);){
            if (!tStart.equals(this.getInitialState().getDate())) {
                this.integrateDynamics(tStart);
            }
            this.setUpUserEventDetectors();
            for (OrekitStepHandler handler : this.getMultiplexer().getHandlers()) {
                this.integrator.addStepHandler((ODEStepHandler)new AdaptedStepHandler(handler));
            }
            for (StoringStepHandler generator : this.generators) {
                generator.setEndDate(tEnd);
                this.integrator.addStepHandler((ODEStepHandler)generator);
            }
            SpacecraftState spacecraftState = this.integrateDynamics(tEnd);
            return spacecraftState;
        }
    }

    private SpacecraftState integrateDynamics(AbsoluteDate tEnd) {
        try {
            this.initializePropagation();
            if (this.getInitialState().getDate().equals(tEnd)) {
                return this.getInitialState();
            }
            this.stateMapper = this.createMapper(this.getInitialState().getDate(), this.stateMapper.getMu(), this.stateMapper.getOrbitType(), this.stateMapper.getPositionAngleType(), this.stateMapper.getAttitudeProvider(), this.getInitialState().getFrame());
            if (Double.isNaN(this.getMu())) {
                this.setMu(this.getInitialState().getMu());
            }
            if (this.getInitialState().getMass() <= 0.0) {
                throw new OrekitException((Localizable)OrekitMessages.SPACECRAFT_MASS_BECOMES_NEGATIVE, this.getInitialState().getMass());
            }
            SpacecraftState initialIntegrationState = this.getInitialIntegrationState();
            ODEState mathInitialState = this.createInitialState(initialIntegrationState);
            ExpandableODE mathODE = this.createODE(this.integrator, mathInitialState);
            this.equationsMapper = mathODE.getMapper();
            this.beforeIntegration(initialIntegrationState, tEnd);
            ODEStateAndDerivative mathFinalState = this.integrator.integrate(mathODE, mathInitialState, tEnd.durationFrom(this.getInitialState().getDate()));
            this.afterIntegration();
            SpacecraftState finalState = this.stateMapper.mapArrayToState(this.stateMapper.mapDoubleToDate(mathFinalState.getTime(), tEnd), mathFinalState.getPrimaryState(), mathFinalState.getPrimaryDerivative(), this.propagationType);
            finalState = this.updateAdditionalStates(finalState);
            for (int i = 0; i < this.additionalEquations.size(); ++i) {
                double[] secondary = mathFinalState.getSecondaryState(i + 1);
                finalState = finalState.addAdditionalState(this.additionalEquations.get(i).getName(), secondary);
            }
            if (this.resetAtEnd) {
                this.resetInitialState(finalState);
                this.setStartDate(finalState.getDate());
            }
            return finalState;
        }
        catch (MathRuntimeException mre) {
            throw OrekitException.unwrap(mre);
        }
    }

    protected SpacecraftState getInitialIntegrationState() {
        return this.getInitialState();
    }

    private ODEState createInitialState(SpacecraftState initialState) {
        double[] primary = new double[this.getBasicDimension()];
        this.stateMapper.mapStateToArray(initialState, primary, null);
        double[][] secondary = new double[this.additionalEquations.size()][];
        for (int i = 0; i < this.additionalEquations.size(); ++i) {
            AdditionalEquations additional = this.additionalEquations.get(i);
            secondary[i] = initialState.getAdditionalState(additional.getName());
        }
        return new ODEState(0.0, primary, (double[][])secondary);
    }

    private ExpandableODE createODE(ODEIntegrator integ, ODEState mathInitialState) {
        ExpandableODE ode = new ExpandableODE((OrdinaryDifferentialEquation)new ConvertedMainStateEquations(this.getMainStateEquations(integ)));
        for (int i = 0; i < this.additionalEquations.size(); ++i) {
            AdditionalEquations additional = this.additionalEquations.get(i);
            ConvertedSecondaryStateEquations secondary = new ConvertedSecondaryStateEquations(additional, mathInitialState.getSecondaryStateDimension(i + 1));
            ode.addSecondaryEquations((SecondaryODE)secondary);
        }
        return ode;
    }

    protected void beforeIntegration(SpacecraftState initialState, AbsoluteDate tEnd) {
    }

    protected void afterIntegration() {
    }

    public int getBasicDimension() {
        return 7;
    }

    protected ODEIntegrator getIntegrator() {
        return this.integrator;
    }

    private SpacecraftState getCompleteState(double t, double[] y, double[] yDot) {
        SpacecraftState state = this.stateMapper.mapArrayToState(t, y, yDot, this.propagationType);
        state = this.updateAdditionalStates(state);
        if (!this.additionalEquations.isEmpty()) {
            for (int i = 0; i < this.additionalEquations.size(); ++i) {
                state = state.addAdditionalState(this.additionalEquations.get(i).getName(), this.equationsMapper.extractEquationData(i + 1, y));
            }
        }
        return state;
    }

    private SpacecraftState convert(ODEStateAndDerivative os) {
        SpacecraftState s = this.stateMapper.mapArrayToState(os.getTime(), os.getPrimaryState(), os.getPrimaryDerivative(), this.propagationType);
        s = this.updateAdditionalStates(s);
        for (int i = 0; i < this.additionalEquations.size(); ++i) {
            double[] secondary = os.getSecondaryState(i + 1);
            s = s.addAdditionalState(this.additionalEquations.get(i).getName(), secondary);
        }
        return s;
    }

    private ODEStateAndDerivative convert(SpacecraftState state) {
        double[] primary = new double[this.getBasicDimension()];
        double[] primaryDot = new double[this.getBasicDimension()];
        this.stateMapper.mapStateToArray(state, primary, primaryDot);
        double[][] secondary = new double[this.additionalEquations.size()][];
        for (int i = 0; i < this.additionalEquations.size(); ++i) {
            AdditionalEquations additional = this.additionalEquations.get(i);
            secondary[i] = state.getAdditionalState(additional.getName());
        }
        return new ODEStateAndDerivative(this.stateMapper.mapDateToDouble(state.getDate()), primary, primaryDot, (double[][])secondary, (double[][])null);
    }

    private static class IntegratorResetter
    implements AutoCloseable {
        private final ODEIntegrator integrator;
        private final List<EventHandlerConfiguration> eventHandlersConfigurations;
        private final List<ODEStepHandler> stepHandlers;

        IntegratorResetter(ODEIntegrator integrator) {
            this.integrator = integrator;
            this.eventHandlersConfigurations = new ArrayList<EventHandlerConfiguration>(integrator.getEventHandlersConfigurations());
            this.stepHandlers = new ArrayList<ODEStepHandler>(integrator.getStepHandlers());
        }

        @Override
        public void close() {
            this.integrator.clearEventHandlers();
            this.eventHandlersConfigurations.forEach(c -> this.integrator.addEventHandler(c.getEventHandler(), c.getMaxCheckInterval(), c.getConvergence(), c.getMaxIterationCount(), c.getSolver()));
            this.integrator.clearStepHandlers();
            this.stepHandlers.forEach(stepHandler -> this.integrator.addStepHandler(stepHandler));
        }
    }

    private class StoringStepHandler
    implements ODEStepHandler,
    EphemerisGenerator {
        private DenseOutputModel model;
        private AbsoluteDate endDate;
        private BoundedPropagator ephemeris;

        private StoringStepHandler() {
        }

        public void setEndDate(AbsoluteDate endDate) {
            this.endDate = endDate;
        }

        public void init(ODEStateAndDerivative s0, double t) {
            this.model = new DenseOutputModel();
            this.model.init(s0, t);
            this.ephemeris = null;
        }

        @Override
        public BoundedPropagator getGeneratedEphemeris() {
            return this.ephemeris;
        }

        public void handleStep(ODEStateInterpolator interpolator) {
            this.model.handleStep(interpolator);
        }

        public void finish(ODEStateAndDerivative finalState) {
            AbsoluteDate maxDate;
            AbsoluteDate minDate;
            double tI = this.model.getInitialTime();
            double tF = this.model.getFinalTime();
            AbsoluteDate startDate = AbstractIntegratedPropagator.this.stateMapper.mapDoubleToDate(tI);
            AbsoluteDate finalDate = AbstractIntegratedPropagator.this.stateMapper.mapDoubleToDate(tF, this.endDate);
            if (tF < tI) {
                minDate = finalDate;
                maxDate = startDate;
            } else {
                minDate = startDate;
                maxDate = finalDate;
            }
            HashMap<String, double[]> unmanaged = new HashMap<String, double[]>();
            for (Map.Entry<String, double[]> initial : AbstractIntegratedPropagator.this.getInitialState().getAdditionalStates().entrySet()) {
                if (AbstractIntegratedPropagator.this.isAdditionalStateManaged(initial.getKey())) continue;
                unmanaged.put(initial.getKey(), initial.getValue());
            }
            String[] names = new String[AbstractIntegratedPropagator.this.additionalEquations.size()];
            for (int i = 0; i < names.length; ++i) {
                names[i] = ((AdditionalEquations)AbstractIntegratedPropagator.this.additionalEquations.get(i)).getName();
            }
            this.ephemeris = new IntegratedEphemeris(startDate, minDate, maxDate, AbstractIntegratedPropagator.this.stateMapper, AbstractIntegratedPropagator.this.propagationType, this.model, unmanaged, AbstractIntegratedPropagator.this.getAdditionalStateProviders(), names);
        }
    }

    private class AdaptedStepInterpolator
    implements OrekitStepInterpolator {
        private final ODEStateInterpolator mathInterpolator;

        AdaptedStepInterpolator(ODEStateInterpolator mathInterpolator) {
            this.mathInterpolator = mathInterpolator;
        }

        @Override
        public SpacecraftState getPreviousState() {
            return AbstractIntegratedPropagator.this.convert(this.mathInterpolator.getPreviousState());
        }

        @Override
        public boolean isPreviousStateInterpolated() {
            return this.mathInterpolator.isPreviousStateInterpolated();
        }

        @Override
        public SpacecraftState getCurrentState() {
            return AbstractIntegratedPropagator.this.convert(this.mathInterpolator.getCurrentState());
        }

        @Override
        public boolean isCurrentStateInterpolated() {
            return this.mathInterpolator.isCurrentStateInterpolated();
        }

        @Override
        public SpacecraftState getInterpolatedState(AbsoluteDate date) {
            return AbstractIntegratedPropagator.this.convert(this.mathInterpolator.getInterpolatedState(date.durationFrom(AbstractIntegratedPropagator.this.stateMapper.getReferenceDate())));
        }

        @Override
        public boolean isForward() {
            return this.mathInterpolator.isForward();
        }

        @Override
        public AdaptedStepInterpolator restrictStep(SpacecraftState newPreviousState, SpacecraftState newCurrentState) {
            try {
                AbstractODEStateInterpolator aosi = (AbstractODEStateInterpolator)this.mathInterpolator;
                return new AdaptedStepInterpolator((ODEStateInterpolator)aosi.restrictStep(AbstractIntegratedPropagator.this.convert(newPreviousState), AbstractIntegratedPropagator.this.convert(newCurrentState)));
            }
            catch (ClassCastException cce) {
                throw new OrekitInternalError(cce);
            }
        }
    }

    private class AdaptedStepHandler
    implements ODEStepHandler {
        private final OrekitStepHandler handler;

        AdaptedStepHandler(OrekitStepHandler handler) {
            this.handler = handler;
        }

        public void init(ODEStateAndDerivative s0, double t) {
            this.handler.init(AbstractIntegratedPropagator.this.getCompleteState(s0.getTime(), s0.getCompleteState(), s0.getCompleteDerivative()), AbstractIntegratedPropagator.this.stateMapper.mapDoubleToDate(t));
        }

        public void handleStep(ODEStateInterpolator interpolator) {
            this.handler.handleStep(new AdaptedStepInterpolator(interpolator));
        }

        public void finish(ODEStateAndDerivative finalState) {
            this.handler.finish(AbstractIntegratedPropagator.this.convert(finalState));
        }
    }

    private class AdaptedEventDetector
    implements ODEEventHandler {
        private final EventDetector detector;
        private double lastT;
        private double lastG;

        AdaptedEventDetector(EventDetector detector) {
            this.detector = detector;
            this.lastT = Double.NaN;
            this.lastG = Double.NaN;
        }

        public void init(ODEStateAndDerivative s0, double t) {
            this.detector.init(AbstractIntegratedPropagator.this.getCompleteState(s0.getTime(), s0.getCompleteState(), s0.getCompleteDerivative()), AbstractIntegratedPropagator.this.stateMapper.mapDoubleToDate(t));
            this.lastT = Double.NaN;
            this.lastG = Double.NaN;
        }

        public double g(ODEStateAndDerivative s) {
            if (!Precision.equals((double)this.lastT, (double)s.getTime(), (int)0)) {
                this.lastT = s.getTime();
                this.lastG = this.detector.g(AbstractIntegratedPropagator.this.getCompleteState(s.getTime(), s.getCompleteState(), s.getCompleteDerivative()));
            }
            return this.lastG;
        }

        public Action eventOccurred(ODEStateAndDerivative s, boolean increasing) {
            return this.detector.eventOccurred(AbstractIntegratedPropagator.this.getCompleteState(s.getTime(), s.getCompleteState(), s.getCompleteDerivative()), increasing);
        }

        public ODEState resetState(ODEStateAndDerivative s) {
            SpacecraftState oldState = AbstractIntegratedPropagator.this.getCompleteState(s.getTime(), s.getCompleteState(), s.getCompleteDerivative());
            SpacecraftState newState = this.detector.resetState(oldState);
            AbstractIntegratedPropagator.this.stateChanged(newState);
            double[] primary = new double[s.getPrimaryStateDimension()];
            AbstractIntegratedPropagator.this.stateMapper.mapStateToArray(newState, primary, null);
            double[][] secondary = new double[AbstractIntegratedPropagator.this.additionalEquations.size()][];
            for (int i = 0; i < AbstractIntegratedPropagator.this.additionalEquations.size(); ++i) {
                secondary[i] = newState.getAdditionalState(((AdditionalEquations)AbstractIntegratedPropagator.this.additionalEquations.get(i)).getName());
            }
            return new ODEState(newState.getDate().durationFrom(AbstractIntegratedPropagator.this.getStartDate()), primary, (double[][])secondary);
        }
    }

    private class ConvertedSecondaryStateEquations
    implements SecondaryODE {
        private final AdditionalEquations equations;
        private final int dimension;

        ConvertedSecondaryStateEquations(AdditionalEquations equations, int dimension) {
            this.equations = equations;
            this.dimension = dimension;
        }

        public int getDimension() {
            return this.dimension;
        }

        public void init(double t0, double[] primary0, double[] secondary0, double finalTime) {
            SpacecraftState initialState = AbstractIntegratedPropagator.this.stateMapper.mapArrayToState(t0, primary0, null, PropagationType.MEAN);
            initialState = AbstractIntegratedPropagator.this.updateAdditionalStates(initialState);
            initialState = initialState.addAdditionalState(this.equations.getName(), secondary0);
            AbsoluteDate target = AbstractIntegratedPropagator.this.stateMapper.mapDoubleToDate(finalTime);
            this.equations.init(initialState, target);
        }

        public double[] computeDerivatives(double t, double[] primary, double[] primaryDot, double[] secondary) {
            double[] secondaryDot;
            SpacecraftState currentState = AbstractIntegratedPropagator.this.stateMapper.mapArrayToState(t, primary, primaryDot, PropagationType.MEAN);
            currentState = AbstractIntegratedPropagator.this.updateAdditionalStates(currentState);
            double[] additionalMainDot = this.equations.computeDerivatives(currentState = currentState.addAdditionalState(this.equations.getName(), secondary), secondaryDot = new double[secondary.length]);
            if (additionalMainDot != null) {
                for (int i = 0; i < additionalMainDot.length; ++i) {
                    int n = i;
                    primaryDot[n] = primaryDot[n] + additionalMainDot[i];
                }
            }
            return secondaryDot;
        }
    }

    private class ConvertedMainStateEquations
    implements OrdinaryDifferentialEquation {
        private final MainStateEquations main;

        ConvertedMainStateEquations(MainStateEquations main) {
            this.main = main;
            AbstractIntegratedPropagator.this.calls = 0;
        }

        public int getDimension() {
            return AbstractIntegratedPropagator.this.getBasicDimension();
        }

        public void init(double t0, double[] y0, double finalTime) {
            SpacecraftState initialState = AbstractIntegratedPropagator.this.stateMapper.mapArrayToState(t0, y0, null, PropagationType.MEAN);
            initialState = AbstractIntegratedPropagator.this.updateAdditionalStates(initialState);
            AbsoluteDate target = AbstractIntegratedPropagator.this.stateMapper.mapDoubleToDate(finalTime);
            this.main.init(initialState, target);
        }

        public double[] computeDerivatives(double t, double[] y) {
            ++AbstractIntegratedPropagator.this.calls;
            SpacecraftState currentState = AbstractIntegratedPropagator.this.stateMapper.mapArrayToState(t, y, null, PropagationType.MEAN);
            currentState = AbstractIntegratedPropagator.this.updateAdditionalStates(currentState);
            return this.main.computeDerivatives(currentState);
        }
    }

    public static interface MainStateEquations {
        default public void init(SpacecraftState initialState, AbsoluteDate target) {
        }

        public double[] computeDerivatives(SpacecraftState var1);
    }
}

