/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.events;

import org.hipparchus.CalculusFieldElement;
import org.hipparchus.Field;
import org.hipparchus.geometry.Vector;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.hipparchus.util.FastMath;
import org.orekit.propagation.FieldSpacecraftState;
import org.orekit.propagation.events.FieldAbstractDetector;
import org.orekit.propagation.events.handlers.FieldEventHandler;
import org.orekit.propagation.events.handlers.FieldStopOnIncreasing;
import org.orekit.utils.PVCoordinatesProvider;

public class FieldEclipseDetector<T extends CalculusFieldElement<T>>
extends FieldAbstractDetector<FieldEclipseDetector<T>, T> {
    private final PVCoordinatesProvider occulting;
    private final double occultingRadius;
    private final PVCoordinatesProvider occulted;
    private final double occultedRadius;
    private boolean totalEclipse;

    public FieldEclipseDetector(PVCoordinatesProvider occulted, double occultedRadius, PVCoordinatesProvider occulting, double occultingRadius, Field<T> field) {
        this((CalculusFieldElement)((CalculusFieldElement)field.getZero()).add(600.0), (CalculusFieldElement)((CalculusFieldElement)field.getZero()).add(1.0E-6), occulted, occultedRadius, occulting, occultingRadius);
    }

    public FieldEclipseDetector(T maxCheck, PVCoordinatesProvider occulted, double occultedRadius, PVCoordinatesProvider occulting, double occultingRadius) {
        this((CalculusFieldElement)maxCheck, (CalculusFieldElement)((CalculusFieldElement)maxCheck.getField().getZero()).add(1.0E-6), occulted, occultedRadius, occulting, occultingRadius);
    }

    public FieldEclipseDetector(T maxCheck, T threshold, PVCoordinatesProvider occulted, double occultedRadius, PVCoordinatesProvider occulting, double occultingRadius) {
        this(maxCheck, threshold, 100, new FieldStopOnIncreasing(), occulted, occultedRadius, occulting, occultingRadius, true);
    }

    private FieldEclipseDetector(T maxCheck, T threshold, int maxIter, FieldEventHandler<? super FieldEclipseDetector<T>, T> handler, PVCoordinatesProvider occulted, double occultedRadius, PVCoordinatesProvider occulting, double occultingRadius, boolean totalEclipse) {
        super(maxCheck, threshold, maxIter, handler);
        this.occulted = occulted;
        this.occultedRadius = FastMath.abs((double)occultedRadius);
        this.occulting = occulting;
        this.occultingRadius = FastMath.abs((double)occultingRadius);
        this.totalEclipse = totalEclipse;
    }

    @Override
    protected FieldEclipseDetector<T> create(T newMaxCheck, T newThreshold, int nawMaxIter, FieldEventHandler<? super FieldEclipseDetector<T>, T> newHandler) {
        return new FieldEclipseDetector<T>(newMaxCheck, newThreshold, nawMaxIter, newHandler, this.occulted, this.occultedRadius, this.occulting, this.occultingRadius, this.totalEclipse);
    }

    public FieldEclipseDetector<T> withUmbra() {
        return new FieldEclipseDetector(this.getMaxCheckInterval(), this.getThreshold(), this.getMaxIterationCount(), this.getHandler(), this.occulted, this.occultedRadius, this.occulting, this.occultingRadius, true);
    }

    public FieldEclipseDetector<T> withPenumbra() {
        return new FieldEclipseDetector(this.getMaxCheckInterval(), this.getThreshold(), this.getMaxIterationCount(), this.getHandler(), this.occulted, this.occultedRadius, this.occulting, this.occultingRadius, false);
    }

    public PVCoordinatesProvider getOcculting() {
        return this.occulting;
    }

    public double getOccultingRadius() {
        return this.occultingRadius;
    }

    public PVCoordinatesProvider getOcculted() {
        return this.occulted;
    }

    public double getOccultedRadius() {
        return this.occultedRadius;
    }

    public boolean getTotalEclipse() {
        return this.totalEclipse;
    }

    @Override
    public T g(FieldSpacecraftState<T> s) {
        CalculusFieldElement zero = (CalculusFieldElement)s.getOrbit().getA().getField().getZero();
        Vector3D pted = this.occulted.getPVCoordinates(s.getDate().toAbsoluteDate(), s.getFrame()).getPosition();
        Vector3D ping = this.occulting.getPVCoordinates(s.getDate().toAbsoluteDate(), s.getFrame()).getPosition();
        Vector3D psat = s.toSpacecraftState().getPVCoordinates().getPosition();
        Vector3D ps = pted.subtract((Vector)psat);
        Vector3D po = ping.subtract((Vector)psat);
        double angle = Vector3D.angle((Vector3D)ps, (Vector3D)po);
        double rs = FastMath.asin((double)(this.occultedRadius / ps.getNorm()));
        if (Double.isNaN(rs)) {
            return (T)((CalculusFieldElement)zero.getPi());
        }
        double ro = FastMath.asin((double)(this.occultingRadius / po.getNorm()));
        if (Double.isNaN(ro)) {
            return (T)((CalculusFieldElement)((CalculusFieldElement)zero.getPi()).negate());
        }
        return (T)(this.totalEclipse ? (CalculusFieldElement)zero.add(angle - ro + rs) : (CalculusFieldElement)zero.add(angle - ro - rs));
    }
}

