/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.conversion;

import java.util.List;
import org.orekit.annotation.DefaultDataContext;
import org.orekit.attitudes.InertialProvider;
import org.orekit.data.DataContext;
import org.orekit.estimation.leastsquares.AbstractBatchLSModel;
import org.orekit.estimation.leastsquares.ModelObserver;
import org.orekit.estimation.leastsquares.TLEBatchLSModel;
import org.orekit.estimation.measurements.ObservedMeasurement;
import org.orekit.estimation.sequential.AbstractKalmanModel;
import org.orekit.estimation.sequential.CovarianceMatrixProvider;
import org.orekit.estimation.sequential.TLEKalmanModel;
import org.orekit.frames.FactoryManagedFrame;
import org.orekit.orbits.Orbit;
import org.orekit.orbits.PositionAngle;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.analytical.tle.TLE;
import org.orekit.propagation.analytical.tle.TLEPropagator;
import org.orekit.propagation.conversion.AbstractPropagatorBuilder;
import org.orekit.propagation.conversion.OrbitDeterminationPropagatorBuilder;
import org.orekit.time.UTCScale;
import org.orekit.utils.ParameterDriver;
import org.orekit.utils.ParameterDriversList;

public class TLEPropagatorBuilder
extends AbstractPropagatorBuilder
implements OrbitDeterminationPropagatorBuilder {
    private final DataContext dataContext;
    private final TLE templateTLE;

    @DefaultDataContext
    public TLEPropagatorBuilder(TLE templateTLE, PositionAngle positionAngle, double positionScale) {
        this(templateTLE, positionAngle, positionScale, DataContext.getDefault());
    }

    public TLEPropagatorBuilder(TLE templateTLE, PositionAngle positionAngle, double positionScale, DataContext dataContext) {
        super(TLEPropagator.selectExtrapolator(templateTLE, dataContext.getFrames()).getInitialState().getOrbit(), positionAngle, positionScale, false, InertialProvider.of(dataContext.getFrames().getTEME()));
        for (ParameterDriver driver : templateTLE.getParametersDrivers()) {
            this.addSupportedParameter(driver);
        }
        this.templateTLE = templateTLE;
        this.dataContext = dataContext;
    }

    @Override
    public TLEPropagator buildPropagator(double[] normalizedParameters) {
        this.setParameters(normalizedParameters);
        Orbit orbit = this.createInitialOrbit();
        SpacecraftState state = new SpacecraftState(orbit);
        FactoryManagedFrame teme = this.dataContext.getFrames().getTEME();
        UTCScale utc = this.dataContext.getTimeScales().getUTC();
        TLE tle = TLE.stateToTLE(state, this.templateTLE, utc, teme);
        List<ParameterDriver> drivers = this.templateTLE.getParametersDrivers();
        for (int index = 0; index < drivers.size(); ++index) {
            if (!drivers.get(index).isSelected()) continue;
            tle.getParametersDrivers().get(index).setSelected(true);
        }
        return TLEPropagator.selectExtrapolator(tle, this.getAttitudeProvider(), 1000.0, teme);
    }

    public TLE getTemplateTLE() {
        return this.templateTLE;
    }

    @Override
    public AbstractBatchLSModel buildLSModel(OrbitDeterminationPropagatorBuilder[] builders, List<ObservedMeasurement<?>> measurements, ParameterDriversList estimatedMeasurementsParameters, ModelObserver observer) {
        return new TLEBatchLSModel(builders, measurements, estimatedMeasurementsParameters, observer);
    }

    @Override
    public AbstractKalmanModel buildKalmanModel(List<OrbitDeterminationPropagatorBuilder> propagatorBuilders, List<CovarianceMatrixProvider> covarianceMatricesProviders, ParameterDriversList estimatedMeasurementsParameters, CovarianceMatrixProvider measurementProcessNoiseMatrix) {
        return new TLEKalmanModel(propagatorBuilders, covarianceMatricesProviders, estimatedMeasurementsParameters, measurementProcessNoiseMatrix);
    }
}

