/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.analytical.tle;

import org.hipparchus.exception.Localizable;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.analytical.tle.TLEJacobiansMapper;
import org.orekit.propagation.analytical.tle.TLEPropagator;
import org.orekit.utils.ParameterDriver;
import org.orekit.utils.ParameterDriversList;

public class TLEPartialDerivativesEquations {
    private final TLEPropagator propagator;
    private ParameterDriversList selected;
    private final String name;
    private boolean initialized;

    public TLEPartialDerivativesEquations(String name, TLEPropagator propagator) {
        this.name = name;
        this.selected = null;
        this.propagator = propagator;
        this.initialized = false;
    }

    public String getName() {
        return this.name;
    }

    private void freezeParametersSelection() {
        if (this.selected == null) {
            this.selected = new ParameterDriversList();
            for (ParameterDriver driver : this.propagator.getTLE().getParametersDrivers()) {
                if (!driver.isSelected()) continue;
                this.selected.add(driver);
            }
        }
    }

    public SpacecraftState setInitialJacobians(SpacecraftState s0) {
        this.freezeParametersSelection();
        int stateDimension = 6;
        double[][] dYdY0 = new double[6][6];
        double[][] dYdP = new double[6][this.selected.getNbParams()];
        for (int i = 0; i < 6; ++i) {
            dYdY0[i][i] = 1.0;
        }
        return this.setInitialJacobians(s0, dYdY0, dYdP);
    }

    public SpacecraftState setInitialJacobians(SpacecraftState s1, double[][] dY1dY0, double[][] dY1dP) {
        this.freezeParametersSelection();
        int stateDim = dY1dY0.length;
        if (stateDim != 6 || stateDim != dY1dY0[0].length) {
            throw new OrekitException((Localizable)OrekitMessages.STATE_JACOBIAN_NOT_6X6, stateDim, dY1dY0[0].length);
        }
        if (dY1dP != null && stateDim != dY1dP.length) {
            throw new OrekitException((Localizable)OrekitMessages.STATE_AND_PARAMETERS_JACOBIANS_ROWS_MISMATCH, stateDim, dY1dP.length);
        }
        if (dY1dP == null && this.selected.getNbParams() != 0 || dY1dP != null && this.selected.getNbParams() != dY1dP[0].length) {
            throw new OrekitException(new OrekitException((Localizable)OrekitMessages.INITIAL_MATRIX_AND_PARAMETERS_NUMBER_MISMATCH, dY1dP == null ? 0 : dY1dP[0].length, this.selected.getNbParams()));
        }
        this.initialized = true;
        TLEJacobiansMapper mapper = this.getMapper();
        double[] p = new double[mapper.getAdditionalStateDimension()];
        mapper.setInitialJacobians(s1, dY1dY0, dY1dP, p);
        return s1.addAdditionalState(this.name, p);
    }

    public TLEJacobiansMapper getMapper() {
        if (!this.initialized) {
            throw new OrekitException((Localizable)OrekitMessages.STATE_JACOBIAN_NOT_INITIALIZED, new Object[0]);
        }
        return new TLEJacobiansMapper(this.name, this.selected, this.propagator);
    }
}

