/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.analytical.tle;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hipparchus.exception.Localizable;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;

class ParseUtils {
    private static final int MAX_NUMERIC_SATNUM = 99999;
    private static final Map<Character, Integer> ALPHA5_NUMBERS;
    private static final Map<Integer, Character> ALPHA5_LETTERS;
    private static final int ALPHA5_SCALING = 10000;

    private ParseUtils() {
    }

    public static String buildSatelliteNumber(int satelliteNumber, String name) {
        if (satelliteNumber > 99999) {
            int highDigits = satelliteNumber / 10000;
            int lowDigits = satelliteNumber - highDigits * 10000;
            Character alpha = ALPHA5_LETTERS.get(highDigits);
            if (alpha == null) {
                throw new OrekitException((Localizable)OrekitMessages.TLE_INVALID_PARAMETER, satelliteNumber, name, "null");
            }
            return alpha + ParseUtils.addPadding(name, lowDigits, '0', 4, true, satelliteNumber);
        }
        return ParseUtils.addPadding(name, satelliteNumber, '0', 5, true, satelliteNumber);
    }

    public static String addPadding(String name, int k, char c, int size, boolean rightJustified, int satelliteNumber) {
        return ParseUtils.addPadding(name, Integer.toString(k), c, size, rightJustified, satelliteNumber);
    }

    public static String addPadding(String name, String string, char c, int size, boolean rightJustified, int satelliteNumber) {
        if (string.length() > size) {
            throw new OrekitException((Localizable)OrekitMessages.TLE_INVALID_PARAMETER, satelliteNumber, name, string);
        }
        StringBuffer padding = new StringBuffer();
        for (int i = 0; i < size; ++i) {
            padding.append(c);
        }
        if (rightJustified) {
            String concatenated = padding + string;
            int l = concatenated.length();
            return concatenated.substring(l - size, l);
        }
        return (string + padding).substring(0, size);
    }

    public static double parseDouble(String line, int start, int length) {
        String string = line.substring(start, start + length).trim();
        return string.length() > 0 ? Double.parseDouble(string.replace(' ', '0')) : 0.0;
    }

    public static int parseInteger(String line, int start, int length) {
        String field = line.substring(start, start + length).trim();
        return field.length() > 0 ? Integer.parseInt(field.replace(' ', '0')) : 0;
    }

    public static int parseSatelliteNumber(String line, int start, int length) {
        int satelliteNumber;
        String field = line.substring(start, start + length);
        Integer alpha = ALPHA5_NUMBERS.get(Character.valueOf(field.charAt(0)));
        if (alpha != null) {
            satelliteNumber = Integer.parseInt(field.substring(1));
            satelliteNumber += alpha * 10000;
        } else {
            satelliteNumber = (field = field.trim()).length() > 0 ? Integer.parseInt(field.replace(' ', '0')) : 0;
        }
        return satelliteNumber;
    }

    public static int parseYear(String line, int start) {
        int year = 2000 + ParseUtils.parseInteger(line, start, 2);
        return year > 2056 ? year - 100 : year;
    }

    static {
        List<Character> alpha5Letters = Arrays.asList(Character.valueOf('A'), Character.valueOf('B'), Character.valueOf('C'), Character.valueOf('D'), Character.valueOf('E'), Character.valueOf('F'), Character.valueOf('G'), Character.valueOf('H'), Character.valueOf('J'), Character.valueOf('K'), Character.valueOf('L'), Character.valueOf('M'), Character.valueOf('N'), Character.valueOf('P'), Character.valueOf('Q'), Character.valueOf('R'), Character.valueOf('S'), Character.valueOf('T'), Character.valueOf('U'), Character.valueOf('V'), Character.valueOf('W'), Character.valueOf('X'), Character.valueOf('Y'), Character.valueOf('Z'));
        ALPHA5_NUMBERS = new HashMap<Character, Integer>(alpha5Letters.size());
        ALPHA5_LETTERS = new HashMap<Integer, Character>(alpha5Letters.size());
        for (int i = 0; i < alpha5Letters.size(); ++i) {
            ALPHA5_NUMBERS.put(alpha5Letters.get(i), i + 10);
            ALPHA5_LETTERS.put(i + 10, alpha5Letters.get(i));
        }
    }
}

