/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.analytical.gnss.data;

import org.hipparchus.util.FastMath;
import org.orekit.propagation.analytical.gnss.data.CommonGnssData;
import org.orekit.time.AbsoluteDate;

public abstract class AbstractNavigationMessage
extends CommonGnssData {
    private double deltaN;
    private double iDot;
    private double af2;
    private AbsoluteDate epochToc;
    private double cuc;
    private double cus;
    private double crc;
    private double crs;
    private double cic;
    private double cis;

    public AbstractNavigationMessage(double mu, double angularVelocity, int weekNumber) {
        super(mu, angularVelocity, weekNumber);
    }

    public void setSqrtA(double sqrtA) {
        super.setSma(sqrtA * sqrtA);
    }

    public double getMeanMotion() {
        double absA = FastMath.abs((double)this.getSma());
        return FastMath.sqrt((double)(this.getMu() / absA)) / absA + this.deltaN;
    }

    public void setDeltaN(double deltaN) {
        this.deltaN = deltaN;
    }

    public double getIDot() {
        return this.iDot;
    }

    public void setIDot(double iRate) {
        this.iDot = iRate;
    }

    public double getAf2() {
        return this.af2;
    }

    public void setAf2(double af2) {
        this.af2 = af2;
    }

    public AbsoluteDate getEpochToc() {
        return this.epochToc;
    }

    public void setEpochToc(AbsoluteDate epochToc) {
        this.epochToc = epochToc;
    }

    public double getCuc() {
        return this.cuc;
    }

    public void setCuc(double cuc) {
        this.cuc = cuc;
    }

    public double getCus() {
        return this.cus;
    }

    public void setCus(double cus) {
        this.cus = cus;
    }

    public double getCrc() {
        return this.crc;
    }

    public void setCrc(double crc) {
        this.crc = crc;
    }

    public double getCrs() {
        return this.crs;
    }

    public void setCrs(double crs) {
        this.crs = crs;
    }

    public double getCic() {
        return this.cic;
    }

    public void setCic(double cic) {
        this.cic = cic;
    }

    public double getCis() {
        return this.cis;
    }

    public void setCis(double cis) {
        this.cis = cis;
    }
}

