/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.analytical;

import org.hipparchus.util.FastMath;
import org.hipparchus.util.SinCos;
import org.orekit.forces.gravity.potential.UnnormalizedSphericalHarmonicsProvider;
import org.orekit.orbits.EquinoctialOrbit;
import org.orekit.orbits.Orbit;
import org.orekit.orbits.OrbitType;
import org.orekit.orbits.PositionAngle;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.analytical.AdapterPropagator;
import org.orekit.time.AbsoluteDate;

public class J2DifferentialEffect
implements AdapterPropagator.DifferentialEffect {
    private final AbsoluteDate referenceDate;
    private final double dPaDot;
    private final double dRaanDot;
    private final boolean applyBefore;

    public J2DifferentialEffect(SpacecraftState original, AdapterPropagator.DifferentialEffect directEffect, boolean applyBefore, UnnormalizedSphericalHarmonicsProvider gravityField) {
        this(original, directEffect, applyBefore, gravityField.getAe(), gravityField.getMu(), -gravityField.onDate(original.getDate()).getUnnormalizedCnm(2, 0));
    }

    public J2DifferentialEffect(Orbit orbit0, Orbit orbit1, boolean applyBefore, UnnormalizedSphericalHarmonicsProvider gravityField) {
        this(orbit0, orbit1, applyBefore, gravityField.getAe(), gravityField.getMu(), -gravityField.onDate(orbit0.getDate()).getUnnormalizedCnm(2, 0));
    }

    public J2DifferentialEffect(SpacecraftState original, AdapterPropagator.DifferentialEffect directEffect, boolean applyBefore, double referenceRadius, double mu, double j2) {
        this(original.getOrbit(), directEffect.apply(original.shiftedBy(0.001)).getOrbit().shiftedBy(-0.001), applyBefore, referenceRadius, mu, j2);
    }

    public J2DifferentialEffect(Orbit orbit0, Orbit orbit1, boolean applyBefore, double referenceRadius, double mu, double j2) {
        this.referenceDate = orbit0.getDate();
        this.applyBefore = applyBefore;
        double a0 = orbit0.getA();
        double e0 = orbit0.getE();
        double i0 = orbit0.getI();
        double a1 = orbit1.getA();
        double e1 = orbit1.getE();
        double i1 = orbit1.getI();
        double oMe2 = 1.0 - e0 * e0;
        double ratio = referenceRadius / (a0 * oMe2);
        SinCos scI = FastMath.sinCos((double)i0);
        double n = FastMath.sqrt((double)(mu / a0)) / a0;
        double c = ratio * ratio * n * j2;
        double refPaDot = 0.75 * c * (4.0 - 5.0 * scI.sin() * scI.sin());
        double refRaanDot = -1.5 * c * scI.cos();
        double dPaDotDa = -3.5 * refPaDot / a0;
        double dPaDotDe = 4.0 * refPaDot * e0 / oMe2;
        double dPaDotDi = -7.5 * c * scI.sin() * scI.cos();
        this.dPaDot = dPaDotDa * (a1 - a0) + dPaDotDe * (e1 - e0) + dPaDotDi * (i1 - i0);
        double dRaanDotDa = -3.5 * refRaanDot / a0;
        double dRaanDotDe = 4.0 * refRaanDot * e0 / oMe2;
        double dRaanDotDi = -refRaanDot * FastMath.tan((double)i0);
        this.dRaanDot = dRaanDotDa * (a1 - a0) + dRaanDotDe * (e1 - e0) + dRaanDotDi * (i1 - i0);
    }

    public Orbit apply(Orbit orbit1) {
        if (orbit1.getDate().compareTo(this.referenceDate) <= 0 && !this.applyBefore) {
            return orbit1;
        }
        return this.updateOrbit(orbit1);
    }

    @Override
    public SpacecraftState apply(SpacecraftState state1) {
        if (state1.getDate().compareTo(this.referenceDate) <= 0 && !this.applyBefore) {
            return state1;
        }
        return new SpacecraftState(this.updateOrbit(state1.getOrbit()), state1.getAttitude(), state1.getMass());
    }

    private Orbit updateOrbit(Orbit orbit1) {
        EquinoctialOrbit original = (EquinoctialOrbit)OrbitType.EQUINOCTIAL.convertType(orbit1);
        AbsoluteDate date = original.getDate();
        double dt = date.durationFrom(this.referenceDate);
        double dPaRaan = (this.dPaDot + this.dRaanDot) * dt;
        SinCos scPaRaan = FastMath.sinCos((double)dPaRaan);
        double dRaan = this.dRaanDot * dt;
        SinCos scRaan = FastMath.sinCos((double)dRaan);
        double ex = original.getEquinoctialEx() * scPaRaan.cos() - original.getEquinoctialEy() * scPaRaan.sin();
        double ey = original.getEquinoctialEx() * scPaRaan.sin() + original.getEquinoctialEy() * scPaRaan.cos();
        double hx = original.getHx() * scRaan.cos() - original.getHy() * scRaan.sin();
        double hy = original.getHx() * scRaan.sin() + original.getHy() * scRaan.cos();
        double lambda = original.getLv() + dPaRaan;
        EquinoctialOrbit updated = new EquinoctialOrbit(original.getA(), ex, ey, hx, hy, lambda, PositionAngle.TRUE, original.getFrame(), date, original.getMu());
        return orbit1.getType().convertType(updated);
    }
}

