/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.analytical;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.hipparchus.CalculusFieldElement;
import org.hipparchus.Field;
import org.hipparchus.util.MathArrays;
import org.orekit.attitudes.AttitudeProvider;
import org.orekit.attitudes.FieldAttitude;
import org.orekit.attitudes.InertialProvider;
import org.orekit.orbits.FieldOrbit;
import org.orekit.orbits.OrbitType;
import org.orekit.orbits.PositionAngle;
import org.orekit.propagation.FieldSpacecraftState;
import org.orekit.propagation.analytical.FieldAbstractAnalyticalPropagator;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.time.FieldTimeInterpolable;
import org.orekit.utils.FieldTimeSpanMap;
import org.orekit.utils.ParameterDriver;

public class FieldKeplerianPropagator<T extends CalculusFieldElement<T>>
extends FieldAbstractAnalyticalPropagator<T> {
    private transient FieldTimeSpanMap<FieldSpacecraftState<T>, T> states;

    public FieldKeplerianPropagator(FieldOrbit<T> initialFieldOrbit) {
        this((FieldOrbit<CalculusFieldElement>)initialFieldOrbit, InertialProvider.of(initialFieldOrbit.getFrame()), (CalculusFieldElement)initialFieldOrbit.getMu(), (CalculusFieldElement)((CalculusFieldElement)initialFieldOrbit.getA().getField().getZero()).add(1000.0));
    }

    public FieldKeplerianPropagator(FieldOrbit<T> initialFieldOrbit, T mu) {
        this((FieldOrbit<CalculusFieldElement>)initialFieldOrbit, InertialProvider.of(initialFieldOrbit.getFrame()), (CalculusFieldElement)mu, (CalculusFieldElement)((CalculusFieldElement)initialFieldOrbit.getA().getField().getZero()).add(1000.0));
    }

    public FieldKeplerianPropagator(FieldOrbit<T> initialFieldOrbit, AttitudeProvider attitudeProv) {
        this((FieldOrbit<CalculusFieldElement>)initialFieldOrbit, attitudeProv, (CalculusFieldElement)initialFieldOrbit.getMu(), (CalculusFieldElement)((CalculusFieldElement)initialFieldOrbit.getA().getField().getZero()).add(1000.0));
    }

    public FieldKeplerianPropagator(FieldOrbit<T> initialFieldOrbit, AttitudeProvider attitudeProv, T mu) {
        this((FieldOrbit<CalculusFieldElement>)initialFieldOrbit, attitudeProv, (CalculusFieldElement)mu, (CalculusFieldElement)((CalculusFieldElement)initialFieldOrbit.getA().getField().getZero()).add(1000.0));
    }

    public FieldKeplerianPropagator(FieldOrbit<T> initialOrbit, AttitudeProvider attitudeProv, T mu, T mass) {
        super(initialOrbit.getA().getField(), attitudeProv);
        FieldSpacecraftState<T> initial = this.fixState(initialOrbit, this.getAttitudeProvider().getAttitude(initialOrbit, initialOrbit.getDate(), initialOrbit.getFrame()), mass, mu, Collections.emptyMap());
        this.states = new FieldTimeSpanMap(initial, initialOrbit.getA().getField());
        super.resetInitialState(initial);
    }

    private FieldSpacecraftState<T> fixState(FieldOrbit<T> orbit, FieldAttitude<T> attitude, T mass, T mu, Map<String, T[]> additionalStates) {
        OrbitType type = orbit.getType();
        CalculusFieldElement[] stateVector = (CalculusFieldElement[])MathArrays.buildArray((Field)mass.getField(), (int)6);
        type.mapOrbitToArray(orbit, PositionAngle.TRUE, stateVector, null);
        FieldOrbit fixedOrbit = type.mapArrayToOrbit(stateVector, null, PositionAngle.TRUE, orbit.getDate(), (CalculusFieldElement)mu, orbit.getFrame());
        FieldSpacecraftState fixedState = new FieldSpacecraftState(fixedOrbit, attitude, mass);
        for (Map.Entry<String, T[]> entry : additionalStates.entrySet()) {
            fixedState = fixedState.addAdditionalState(entry.getKey(), (CalculusFieldElement[])entry.getValue());
        }
        return fixedState;
    }

    @Override
    public void resetInitialState(FieldSpacecraftState<T> state) {
        FieldSpacecraftState formerInitial = this.getInitialState();
        T mu = formerInitial == null ? state.getMu() : formerInitial.getMu();
        FieldSpacecraftState<T> fixedState = this.fixState(state.getOrbit(), state.getAttitude(), state.getMass(), mu, state.getAdditionalStates());
        this.states = new FieldTimeSpanMap<FieldSpacecraftState<FieldSpacecraftState<T>>, FieldSpacecraftState<T>>(fixedState, state.getDate().getField());
        super.resetInitialState(fixedState);
    }

    @Override
    protected void resetIntermediateState(FieldSpacecraftState<T> state, boolean forward) {
        if (forward) {
            this.states.addValidAfter(state, state.getDate());
        } else {
            this.states.addValidBefore(state, state.getDate());
        }
        this.stateChanged(state);
    }

    @Override
    protected FieldOrbit<T> propagateOrbit(FieldAbsoluteDate<T> date, T[] parameters) {
        FieldTimeInterpolable orbit = this.states.get(date).getOrbit();
        while (!date.equals(((FieldOrbit)(orbit = ((FieldOrbit)orbit).shiftedBy((CalculusFieldElement)date.durationFrom(((FieldOrbit)orbit).getDate())))).getDate())) {
        }
        return orbit;
    }

    @Override
    protected T getMass(FieldAbsoluteDate<T> date) {
        return this.states.get(date).getMass();
    }

    @Override
    protected List<ParameterDriver> getParametersDrivers() {
        return Collections.emptyList();
    }
}

