/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.models.earth.troposphere;

import java.util.Collections;
import java.util.List;
import org.hipparchus.CalculusFieldElement;
import org.hipparchus.FieldElement;
import org.hipparchus.analysis.interpolation.PiecewiseBicubicSplineInterpolatingFunction;
import org.hipparchus.analysis.interpolation.PiecewiseBicubicSplineInterpolator;
import org.hipparchus.exception.Localizable;
import org.hipparchus.util.FastMath;
import org.orekit.annotation.DefaultDataContext;
import org.orekit.bodies.FieldGeodeticPoint;
import org.orekit.bodies.GeodeticPoint;
import org.orekit.data.DataContext;
import org.orekit.data.DataProvidersManager;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.models.earth.troposphere.DiscreteTroposphericModel;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.utils.InterpolationTableLoader;
import org.orekit.utils.ParameterDriver;

public class FixedTroposphericDelay
implements DiscreteTroposphericModel {
    private static FixedTroposphericDelay defaultModel;
    private final double[] xArr;
    private final double[] yArr;
    private final double[][] fArr;
    private PiecewiseBicubicSplineInterpolatingFunction delayFunction;

    public FixedTroposphericDelay(double[] xArr, double[] yArr, double[][] fArr) {
        this.xArr = (double[])xArr.clone();
        this.yArr = (double[])yArr.clone();
        this.fArr = (double[][])fArr.clone();
        this.delayFunction = new PiecewiseBicubicSplineInterpolator().interpolate(xArr, yArr, fArr);
    }

    @DefaultDataContext
    public FixedTroposphericDelay(String supportedName) {
        this(supportedName, DataContext.getDefault().getDataProvidersManager());
    }

    public FixedTroposphericDelay(String supportedName, DataProvidersManager dataProvidersManager) {
        InterpolationTableLoader loader = new InterpolationTableLoader();
        dataProvidersManager.feed(supportedName, loader);
        if (!loader.stillAcceptsData()) {
            this.xArr = loader.getAbscissaGrid();
            this.yArr = loader.getOrdinateGrid();
            for (int i = 0; i < this.yArr.length; ++i) {
                this.yArr[i] = FastMath.toRadians((double)this.yArr[i]);
            }
        } else {
            throw new OrekitException((Localizable)OrekitMessages.UNABLE_TO_FIND_RESOURCE, supportedName);
        }
        this.fArr = loader.getValuesSamples();
        this.delayFunction = new PiecewiseBicubicSplineInterpolator().interpolate(this.xArr, this.yArr, this.fArr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @DefaultDataContext
    public static FixedTroposphericDelay getDefaultModel() {
        Class<FixedTroposphericDelay> clazz = FixedTroposphericDelay.class;
        synchronized (FixedTroposphericDelay.class) {
            if (defaultModel == null) {
                defaultModel = new FixedTroposphericDelay("^tropospheric-delay\\.txt$");
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return defaultModel;
        }
    }

    @Override
    public double pathDelay(double elevation, GeodeticPoint point, double[] parameters, AbsoluteDate date) {
        double h = FastMath.min((double)FastMath.max((double)0.0, (double)point.getAltitude()), (double)5000.0);
        double ele = FastMath.min((double)Math.PI, (double)FastMath.max((double)0.0, (double)elevation));
        double e = ele > 1.5707963267948966 ? Math.PI - ele : ele;
        return this.delayFunction.value(h, e);
    }

    @Override
    public <T extends CalculusFieldElement<T>> T pathDelay(T elevation, FieldGeodeticPoint<T> point, T[] parameters, FieldAbsoluteDate<T> date) {
        CalculusFieldElement zero = (CalculusFieldElement)date.getField().getZero();
        CalculusFieldElement pi = (CalculusFieldElement)zero.getPi();
        CalculusFieldElement h = FastMath.min((CalculusFieldElement)FastMath.max((CalculusFieldElement)zero, point.getAltitude()), (CalculusFieldElement)((CalculusFieldElement)zero.add(5000.0)));
        CalculusFieldElement ele = FastMath.min((CalculusFieldElement)pi, (CalculusFieldElement)FastMath.max((CalculusFieldElement)zero, elevation));
        CalculusFieldElement e = ele.getReal() > ((CalculusFieldElement)pi.multiply(0.5)).getReal() ? (CalculusFieldElement)((CalculusFieldElement)ele.negate()).add((FieldElement)pi) : ele;
        return (T)this.delayFunction.value(h, e);
    }

    @Override
    public List<ParameterDriver> getParametersDrivers() {
        return Collections.emptyList();
    }
}

