/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.models.earth.ionosphere;

import java.util.Collections;
import java.util.List;
import org.hipparchus.CalculusFieldElement;
import org.hipparchus.Field;
import org.hipparchus.FieldElement;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.FieldSinCos;
import org.hipparchus.util.MathUtils;
import org.hipparchus.util.SinCos;
import org.orekit.bodies.FieldGeodeticPoint;
import org.orekit.bodies.GeodeticPoint;
import org.orekit.frames.TopocentricFrame;
import org.orekit.gnss.metric.messages.ssr.subtype.SsrIm201;
import org.orekit.gnss.metric.messages.ssr.subtype.SsrIm201Data;
import org.orekit.gnss.metric.messages.ssr.subtype.SsrIm201Header;
import org.orekit.models.earth.ionosphere.IonosphericModel;
import org.orekit.propagation.FieldSpacecraftState;
import org.orekit.propagation.SpacecraftState;
import org.orekit.utils.FieldLegendrePolynomials;
import org.orekit.utils.LegendrePolynomials;
import org.orekit.utils.ParameterDriver;

public class SsrVtecIonosphericModel
implements IonosphericModel {
    private static final long serialVersionUID = 20210322L;
    private static final double EARTH_RADIUS = 6370000.0;
    private static final double FACTOR = 4.03E17;
    private final transient SsrIm201 vtecMessage;

    public SsrVtecIonosphericModel(SsrIm201 vtecMessage) {
        this.vtecMessage = vtecMessage;
    }

    @Override
    public double pathDelay(SpacecraftState state, TopocentricFrame baseFrame, double frequency, double[] parameters) {
        Vector3D position = state.getPVCoordinates(baseFrame).getPosition();
        double elevation = position.getDelta();
        if (elevation > 0.0) {
            double azimuth = FastMath.atan2((double)position.getX(), (double)position.getY());
            if (azimuth < 0.0) {
                azimuth += Math.PI * 2;
            }
            double stec = 0.0;
            SsrIm201Header header = (SsrIm201Header)this.vtecMessage.getHeader();
            for (SsrIm201Data data : this.vtecMessage.getData()) {
                stec += SsrVtecIonosphericModel.stecIonosphericLayer(data, header, elevation, azimuth, baseFrame.getPoint());
            }
            return 4.03E17 * stec / (frequency * frequency);
        }
        return 0.0;
    }

    @Override
    public <T extends CalculusFieldElement<T>> T pathDelay(FieldSpacecraftState<T> state, TopocentricFrame baseFrame, double frequency, T[] parameters) {
        Field<T> field = state.getDate().getField();
        FieldVector3D position = state.getPVCoordinates(baseFrame).getPosition();
        CalculusFieldElement elevation = position.getDelta();
        if (elevation.getReal() > 0.0) {
            CalculusFieldElement azimuth = FastMath.atan2((CalculusFieldElement)position.getX(), (CalculusFieldElement)position.getY());
            if (azimuth.getReal() < 0.0) {
                azimuth = (CalculusFieldElement)azimuth.add(Math.PI * 2);
            }
            CalculusFieldElement stec = (CalculusFieldElement)field.getZero();
            SsrIm201Header header = (SsrIm201Header)this.vtecMessage.getHeader();
            for (SsrIm201Data data : this.vtecMessage.getData()) {
                stec = (CalculusFieldElement)stec.add((FieldElement)SsrVtecIonosphericModel.stecIonosphericLayer(data, header, elevation, azimuth, baseFrame.getPoint(field)));
            }
            return (T)((CalculusFieldElement)((CalculusFieldElement)stec.multiply(4.03E17)).divide(frequency * frequency));
        }
        return (T)((CalculusFieldElement)field.getZero());
    }

    @Override
    public List<ParameterDriver> getParametersDrivers() {
        return Collections.emptyList();
    }

    private static double stecIonosphericLayer(SsrIm201Data im201Data, SsrIm201Header im201Header, double elevation, double azimuth, GeodeticPoint point) {
        double phiR = point.getLatitude();
        double lambdaR = point.getLongitude();
        double hR = point.getAltitude();
        double hI = im201Data.getHeightIonosphericLayer();
        int degree = im201Data.getSphericalHarmonicsDegree();
        int order = im201Data.getSphericalHarmonicsOrder();
        double[][] cnm = im201Data.getCnm();
        double[][] snm = im201Data.getSnm();
        double psiPP = SsrVtecIonosphericModel.calculatePsi(hR, hI, elevation);
        SinCos scA = FastMath.sinCos((double)azimuth);
        SinCos scPhiR = FastMath.sinCos((double)phiR);
        SinCos scPsi = FastMath.sinCos((double)psiPP);
        double phiPP = SsrVtecIonosphericModel.calculatePiercePointLatitude(scPhiR, scPsi, scA);
        double lambdaPP = SsrVtecIonosphericModel.calculatePiercePointLongitude(scA, phiPP, psiPP, phiR, lambdaR);
        double lambdaS = SsrVtecIonosphericModel.calculateSunLongitude(im201Header, lambdaPP);
        double vtec = FastMath.max((double)0.0, (double)SsrVtecIonosphericModel.calculateVTEC(degree, order, cnm, snm, phiPP, lambdaS));
        return vtec / FastMath.sin((double)(elevation + psiPP));
    }

    private static <T extends CalculusFieldElement<T>> T stecIonosphericLayer(SsrIm201Data im201Data, SsrIm201Header im201Header, T elevation, T azimuth, FieldGeodeticPoint<T> point) {
        T phiR = point.getLatitude();
        T lambdaR = point.getLongitude();
        T hR = point.getAltitude();
        double hI = im201Data.getHeightIonosphericLayer();
        int degree = im201Data.getSphericalHarmonicsDegree();
        int order = im201Data.getSphericalHarmonicsOrder();
        double[][] cnm = im201Data.getCnm();
        double[][] snm = im201Data.getSnm();
        T psiPP = SsrVtecIonosphericModel.calculatePsi(hR, hI, elevation);
        FieldSinCos scA = FastMath.sinCos(azimuth);
        FieldSinCos scPhiR = FastMath.sinCos(phiR);
        FieldSinCos scPsi = FastMath.sinCos(psiPP);
        T phiPP = SsrVtecIonosphericModel.calculatePiercePointLatitude(scPhiR, scPsi, scA);
        T lambdaPP = SsrVtecIonosphericModel.calculatePiercePointLongitude(scA, phiPP, psiPP, phiR, lambdaR);
        T lambdaS = SsrVtecIonosphericModel.calculateSunLongitude(im201Header, lambdaPP);
        CalculusFieldElement vtec = FastMath.max((CalculusFieldElement)((CalculusFieldElement)phiR.getField().getZero()), SsrVtecIonosphericModel.calculateVTEC(degree, order, cnm, snm, phiPP, lambdaS));
        return (T)((CalculusFieldElement)vtec.divide((FieldElement)FastMath.sin((CalculusFieldElement)((CalculusFieldElement)elevation.add(psiPP)))));
    }

    private static double calculatePsi(double hR, double hI, double elevation) {
        double ratio = (6370000.0 + hR) / (6370000.0 + hI);
        return 1.5707963267948966 - elevation - FastMath.asin((double)(ratio * FastMath.cos((double)elevation)));
    }

    private static <T extends CalculusFieldElement<T>> T calculatePsi(T hR, double hI, T elevation) {
        CalculusFieldElement ratio = (CalculusFieldElement)((CalculusFieldElement)hR.add(6370000.0)).divide(6370000.0 + hI);
        return (T)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)hR.getPi()).multiply(0.5)).subtract(elevation)).subtract((FieldElement)FastMath.asin((CalculusFieldElement)((CalculusFieldElement)ratio.multiply((FieldElement)FastMath.cos(elevation))))));
    }

    private static double calculatePiercePointLatitude(SinCos scPhiR, SinCos scPsi, SinCos scA) {
        return FastMath.asin((double)(scPhiR.sin() * scPsi.cos() + scPhiR.cos() * scPsi.sin() * scA.cos()));
    }

    private static <T extends CalculusFieldElement<T>> T calculatePiercePointLatitude(FieldSinCos<T> scPhiR, FieldSinCos<T> scPsi, FieldSinCos<T> scA) {
        return (T)FastMath.asin((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)scPhiR.sin()).multiply((FieldElement)scPsi.cos())).add(((CalculusFieldElement)((CalculusFieldElement)scPhiR.cos()).multiply((FieldElement)scPsi.sin())).multiply((FieldElement)scA.cos()))));
    }

    private static double calculatePiercePointLongitude(SinCos scA, double phiPP, double psiPP, double phiR, double lambdaR) {
        double arcSin = FastMath.asin((double)(FastMath.sin((double)psiPP) * scA.sin() / FastMath.cos((double)phiPP)));
        return SsrVtecIonosphericModel.verifyCondition(scA.cos(), psiPP, phiR) ? lambdaR + Math.PI - arcSin : lambdaR + arcSin;
    }

    private static <T extends CalculusFieldElement<T>> T calculatePiercePointLongitude(FieldSinCos<T> scA, T phiPP, T psiPP, T phiR, T lambdaR) {
        CalculusFieldElement arcSin = FastMath.asin((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)FastMath.sin(psiPP).multiply((FieldElement)scA.sin())).divide((FieldElement)FastMath.cos(phiPP))));
        return (T)(SsrVtecIonosphericModel.verifyCondition(((CalculusFieldElement)scA.cos()).getReal(), psiPP.getReal(), phiR.getReal()) ? (CalculusFieldElement)((CalculusFieldElement)lambdaR.add(arcSin.getPi())).subtract((FieldElement)arcSin) : (CalculusFieldElement)lambdaR.add((FieldElement)arcSin));
    }

    private static double calculateSunLongitude(SsrIm201Header im201Header, double lambdaPP) {
        double t = SsrVtecIonosphericModel.getTime(im201Header);
        return MathUtils.normalizeAngle((double)(lambdaPP + (t - 50400.0) * Math.PI / 43200.0), (double)Math.PI);
    }

    private static <T extends CalculusFieldElement<T>> T calculateSunLongitude(SsrIm201Header im201Header, T lambdaPP) {
        double t = SsrVtecIonosphericModel.getTime(im201Header);
        return (T)MathUtils.normalizeAngle((CalculusFieldElement)((CalculusFieldElement)lambdaPP.add(((CalculusFieldElement)((CalculusFieldElement)lambdaPP.getPi()).multiply(t - 50400.0)).divide(43200.0))), (CalculusFieldElement)((CalculusFieldElement)lambdaPP.getPi()));
    }

    private static double calculateVTEC(int degree, int order, double[][] cnm, double[][] snm, double phiPP, double lambdaS) {
        double vtec = 0.0;
        LegendrePolynomials p = new LegendrePolynomials(degree, order, FastMath.sin((double)phiPP));
        for (int n = 0; n <= degree; ++n) {
            for (int m = 0; m <= FastMath.min((int)n, (int)order); ++m) {
                SinCos sc = FastMath.sinCos((double)((double)m * lambdaS));
                double pCosmLambda = p.getPnm(n, m) * sc.cos();
                double pSinmLambda = p.getPnm(n, m) * sc.sin();
                vtec += cnm[n][m] * pCosmLambda + snm[n][m] * pSinmLambda;
            }
        }
        return vtec;
    }

    private static <T extends CalculusFieldElement<T>> T calculateVTEC(int degree, int order, double[][] cnm, double[][] snm, T phiPP, T lambdaS) {
        CalculusFieldElement vtec = (CalculusFieldElement)phiPP.getField().getZero();
        FieldLegendrePolynomials<CalculusFieldElement> p = new FieldLegendrePolynomials<CalculusFieldElement>(degree, order, FastMath.sin(phiPP));
        for (int n = 0; n <= degree; ++n) {
            for (int m = 0; m <= FastMath.min((int)n, (int)order); ++m) {
                FieldSinCos sc = FastMath.sinCos((CalculusFieldElement)((CalculusFieldElement)lambdaS.multiply(m)));
                CalculusFieldElement pCosmLambda = (CalculusFieldElement)p.getPnm(n, m).multiply((FieldElement)sc.cos());
                CalculusFieldElement pSinmLambda = (CalculusFieldElement)p.getPnm(n, m).multiply((FieldElement)sc.sin());
                vtec = (CalculusFieldElement)vtec.add(((CalculusFieldElement)pCosmLambda.multiply(cnm[n][m])).add(pSinmLambda.multiply(snm[n][m])));
            }
        }
        return (T)vtec;
    }

    private static double getTime(SsrIm201Header im201Header) {
        double ssrEpochTime = im201Header.getSsrEpoch1s();
        return ssrEpochTime - FastMath.floor((double)(ssrEpochTime / 86400.0)) * 86400.0;
    }

    private static boolean verifyCondition(double scACos, double psiPP, double phiR) {
        double tanPsiCosA = FastMath.tan((double)psiPP) * scACos;
        return phiR >= 0.0 && tanPsiCosA > FastMath.tan((double)(1.5707963267948966 - phiR)) || phiR < 0.0 && -tanPsiCosA > FastMath.tan((double)(1.5707963267948966 + phiR));
    }
}

