/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.models.earth.ionosphere;

import org.hipparchus.CalculusFieldElement;
import org.hipparchus.Field;
import org.hipparchus.FieldElement;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.FieldSinCos;
import org.hipparchus.util.MathArrays;
import org.hipparchus.util.SinCos;
import org.orekit.time.DateComponents;
import org.orekit.time.DateTimeComponents;
import org.orekit.time.TimeComponents;

class FieldNeQuickParameters<T extends CalculusFieldElement<T>> {
    private static final double X0 = 86.23292796211615;
    private final T nmF2;
    private final T hmF2;
    private final T hmF1;
    private final T hmE;
    private final T b2Bot;
    private final T b1Top;
    private final T b1Bot;
    private final T beTop;
    private final T beBot;
    private final T h0;
    private final T[] amplitudes;

    FieldNeQuickParameters(Field<T> field, DateTimeComponents dateTime, double[][][] f2, double[][][] fm3, T latitude, T longitude, double[] alpha, double[][] modipGrip) {
        CalculusFieldElement nmF1;
        CalculusFieldElement zero = (CalculusFieldElement)field.getZero();
        T modip = this.computeMODIP(latitude, longitude, modipGrip);
        T az = this.computeAz(modip, alpha);
        CalculusFieldElement azr = (CalculusFieldElement)FastMath.sqrt((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)az.subtract(63.7)).multiply(1123.6)).add(167273.0))).subtract(408.99);
        DateComponents date = dateTime.getDate();
        TimeComponents time = dateTime.getTime();
        double hours = time.getSecondsInUTCDay() / 3600.0;
        T xeff = this.computeEffectiveSolarAngle(date.getMonth(), hours, latitude, longitude);
        CalculusFieldElement[][] af2 = (CalculusFieldElement[][])MathArrays.buildArray(field, (int)76, (int)13);
        for (int j = 0; j < 76; ++j) {
            for (int k = 0; k < 13; ++k) {
                af2[j][k] = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)azr.multiply(0.01)).negate()).add(1.0)).multiply(f2[0][j][k])).add(((CalculusFieldElement)azr.multiply(0.01)).multiply(f2[1][j][k]));
            }
        }
        CalculusFieldElement[][] am3 = (CalculusFieldElement[][])MathArrays.buildArray(field, (int)49, (int)9);
        for (int j = 0; j < 49; ++j) {
            for (int k = 0; k < 9; ++k) {
                am3[j][k] = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)azr.multiply(0.01)).negate()).add(1.0)).multiply(fm3[0][j][k])).add(((CalculusFieldElement)azr.multiply(0.01)).multiply(fm3[1][j][k]));
            }
        }
        this.hmE = (CalculusFieldElement)((CalculusFieldElement)field.getZero()).add(120.0);
        T foE = this.computefoE(date.getMonth(), az, xeff, latitude);
        CalculusFieldElement nmE = (CalculusFieldElement)((CalculusFieldElement)foE.multiply(foE)).multiply(0.124);
        double t = FastMath.toRadians((double)(15.0 * hours)) - Math.PI;
        CalculusFieldElement[] cf2 = this.computeCF2(field, af2, t);
        CalculusFieldElement[] cm3 = this.computeCm3(field, am3, t);
        CalculusFieldElement foF2 = this.computefoF2((Field)field, (CalculusFieldElement)modip, cf2, (CalculusFieldElement)latitude, (CalculusFieldElement)longitude);
        CalculusFieldElement mF2 = this.computeMF2((Field)field, (CalculusFieldElement)modip, cm3, (CalculusFieldElement)latitude, (CalculusFieldElement)longitude);
        this.nmF2 = (CalculusFieldElement)((CalculusFieldElement)foF2.multiply((FieldElement)foF2)).multiply(0.124);
        this.hmF2 = this.computehmF2(field, foE, foF2, mF2);
        CalculusFieldElement foF1 = this.computefoF1(field, foE, foF2);
        if (foF1.getReal() <= 0.0 && foE.getReal() > 2.0) {
            CalculusFieldElement foEpopf = (CalculusFieldElement)foE.add(0.5);
            nmF1 = (CalculusFieldElement)((CalculusFieldElement)foEpopf.multiply((FieldElement)foEpopf)).multiply(0.124);
        } else {
            nmF1 = (CalculusFieldElement)((CalculusFieldElement)foF1.multiply((FieldElement)foF1)).multiply(0.124);
        }
        this.hmF1 = (CalculusFieldElement)((CalculusFieldElement)this.hmF2.add(this.hmE)).multiply(0.5);
        CalculusFieldElement a = (CalculusFieldElement)this.clipExp((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)FastMath.log((CalculusFieldElement)((CalculusFieldElement)foF2.multiply((FieldElement)foF2))).multiply(0.857)).add(FastMath.log((CalculusFieldElement)mF2).multiply(2.02))).add(-3.467)).multiply(0.01);
        this.b2Bot = (CalculusFieldElement)((CalculusFieldElement)this.nmF2.divide((FieldElement)a)).multiply(0.385);
        this.b1Top = (CalculusFieldElement)((CalculusFieldElement)this.hmF2.subtract(this.hmF1)).multiply(0.3);
        this.b1Bot = (CalculusFieldElement)((CalculusFieldElement)this.hmF1.subtract(this.hmE)).multiply(0.5);
        this.beTop = FastMath.max(this.b1Bot, (CalculusFieldElement)((CalculusFieldElement)zero.add(7.0)));
        this.beBot = (CalculusFieldElement)zero.add(5.0);
        this.amplitudes = this.computeLayerAmplitudes(field, nmE, nmF1, foF1);
        this.h0 = this.computeH0(field, date.getMonth(), azr);
    }

    public T getNmF2() {
        return this.nmF2;
    }

    public T getHmF2() {
        return this.hmF2;
    }

    public T getHmF1() {
        return this.hmF1;
    }

    public T getHmE() {
        return this.hmE;
    }

    public T getB2Bot() {
        return this.b2Bot;
    }

    public T getB1Top() {
        return this.b1Top;
    }

    public T getB1Bot() {
        return this.b1Bot;
    }

    public T getBEBot() {
        return this.beBot;
    }

    public T getBETop() {
        return this.beTop;
    }

    public T[] getLayerAmplitudes() {
        return (CalculusFieldElement[])this.amplitudes.clone();
    }

    public T getH0() {
        return this.h0;
    }

    private T computeMODIP(T lat, T lon, double[][] stModip) {
        CalculusFieldElement zero = (CalculusFieldElement)lat.getField().getZero();
        CalculusFieldElement latitude = FastMath.toDegrees(lat);
        CalculusFieldElement longitude = FastMath.toDegrees(lon);
        if (latitude.getReal() == 90.0 || latitude.getReal() == -90.0) {
            return (T)latitude;
        }
        int lF = (int)((longitude.getReal() + 180.0) * 0.1);
        int l = lF - 2;
        if (l < 0) {
            l += 36;
        } else if (l > 33) {
            l -= 36;
        }
        CalculusFieldElement a = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)latitude.add(90.0)).multiply(0.2)).add(1.0);
        CalculusFieldElement aF = FastMath.floor((CalculusFieldElement)a);
        CalculusFieldElement x = (CalculusFieldElement)a.subtract((FieldElement)aF);
        int i = (int)aF.getReal() - 2;
        CalculusFieldElement z1 = this.interpolate((CalculusFieldElement)zero.add(stModip[i + 1][l + 2]), (CalculusFieldElement)zero.add(stModip[i + 2][l + 2]), (CalculusFieldElement)zero.add(stModip[i + 3][l + 2]), (CalculusFieldElement)zero.add(stModip[i + 4][l + 2]), x);
        CalculusFieldElement z2 = this.interpolate((CalculusFieldElement)zero.add(stModip[i + 1][l + 3]), (CalculusFieldElement)zero.add(stModip[i + 2][l + 3]), (CalculusFieldElement)zero.add(stModip[i + 3][l + 3]), (CalculusFieldElement)zero.add(stModip[i + 4][l + 3]), x);
        CalculusFieldElement z3 = this.interpolate((CalculusFieldElement)zero.add(stModip[i + 1][l + 4]), (CalculusFieldElement)zero.add(stModip[i + 2][l + 4]), (CalculusFieldElement)zero.add(stModip[i + 3][l + 4]), (CalculusFieldElement)zero.add(stModip[i + 4][l + 4]), x);
        CalculusFieldElement z4 = this.interpolate((CalculusFieldElement)zero.add(stModip[i + 1][l + 5]), (CalculusFieldElement)zero.add(stModip[i + 2][l + 5]), (CalculusFieldElement)zero.add(stModip[i + 3][l + 5]), (CalculusFieldElement)zero.add(stModip[i + 4][l + 5]), x);
        CalculusFieldElement b = (CalculusFieldElement)((CalculusFieldElement)longitude.add(180.0)).multiply(0.1);
        CalculusFieldElement bF = FastMath.floor((CalculusFieldElement)b);
        CalculusFieldElement y = (CalculusFieldElement)b.subtract((FieldElement)bF);
        CalculusFieldElement modip = this.interpolate(z1, z2, z3, z4, y);
        return (T)modip;
    }

    private T computeAz(T modip, double[] alpha) {
        Field field = modip.getField();
        CalculusFieldElement zero = (CalculusFieldElement)field.getZero();
        if (alpha[0] == 0.0 && alpha[1] == 0.0 && alpha[2] == 0.0) {
            return (T)((CalculusFieldElement)zero.add(63.7));
        }
        CalculusFieldElement az = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)modip.multiply(alpha[2])).add(alpha[1])).multiply(modip)).add(alpha[0]);
        az = FastMath.max((CalculusFieldElement)zero, (CalculusFieldElement)az);
        az = FastMath.min((CalculusFieldElement)((CalculusFieldElement)zero.add(400.0)), (CalculusFieldElement)az);
        return (T)az;
    }

    private T computeEffectiveSolarAngle(int month, double hours, T latitude, T longitude) {
        CalculusFieldElement zero = (CalculusFieldElement)latitude.getField().getZero();
        CalculusFieldElement lt = (CalculusFieldElement)((CalculusFieldElement)longitude.divide(FastMath.toRadians((double)15.0))).add(hours);
        double dy = 30.5 * (double)month - 15.0;
        double t = dy + (18.0 - hours) / 24.0;
        double am = FastMath.toRadians((double)(0.9856 * t - 3.289));
        double al = am + FastMath.toRadians((double)(1.916 * FastMath.sin((double)am) + 0.02 * FastMath.sin((double)(2.0 * am)) + 282.634));
        double sDec = 0.39782 * FastMath.sin((double)al);
        double cDec = FastMath.sqrt((double)(1.0 - sDec * sDec));
        FieldSinCos scLat = FastMath.sinCos(latitude);
        CalculusFieldElement coef = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)lt.negate()).add(12.0)).multiply(0.2617993877991494);
        CalculusFieldElement cZenith = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)scLat.sin()).multiply(sDec)).add(((CalculusFieldElement)((CalculusFieldElement)scLat.cos()).multiply(cDec)).multiply((FieldElement)FastMath.cos((CalculusFieldElement)coef)));
        CalculusFieldElement angle = FastMath.atan2((CalculusFieldElement)FastMath.sqrt((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)cZenith.multiply((FieldElement)cZenith)).negate()).add(1.0))), (CalculusFieldElement)cZenith);
        CalculusFieldElement x = FastMath.toDegrees((CalculusFieldElement)angle);
        CalculusFieldElement xeff = this.join((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)this.clipExp((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)x.multiply(0.2)).negate()).add(20.0)).multiply(0.24)).negate()).add(90.0), x, (CalculusFieldElement)zero.add(12.0), (CalculusFieldElement)x.subtract(86.23292796211615));
        return (T)FastMath.toRadians((CalculusFieldElement)xeff);
    }

    private T computefoE(int month, T az, T xeff, T latitude) {
        CalculusFieldElement lat = FastMath.toDegrees(latitude);
        CalculusFieldElement sqAz = FastMath.sqrt(az);
        int seas = month == 1 || month == 2 || month == 11 || month == 12 ? -1 : (month == 3 || month == 4 || month == 9 || month == 10 ? 0 : 1);
        CalculusFieldElement ee = this.clipExp((CalculusFieldElement)lat.multiply(0.3));
        CalculusFieldElement seasp = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)ee.subtract(1.0)).divide(ee.add(1.0))).multiply(seas);
        CalculusFieldElement coef = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)seasp.multiply(0.019)).negate()).add(1.112);
        CalculusFieldElement foE = FastMath.sqrt((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)coef.multiply((FieldElement)coef)).multiply((FieldElement)sqAz)).multiply(FastMath.cos(xeff).pow(0.6))).add(0.49)));
        return (T)foE;
    }

    private T computehmF2(Field<T> field, T foE, T foF2, T mF2) {
        CalculusFieldElement zero = (CalculusFieldElement)field.getZero();
        CalculusFieldElement fo = (CalculusFieldElement)foF2.divide(foE);
        CalculusFieldElement ratio = this.join(fo, (CalculusFieldElement)zero.add(1.75), (CalculusFieldElement)zero.add(20.0), (CalculusFieldElement)fo.subtract(1.75));
        CalculusFieldElement deltaM = (CalculusFieldElement)zero.subtract(0.012);
        if (foE.getReal() >= 1.0E-30) {
            deltaM = (CalculusFieldElement)deltaM.add(((CalculusFieldElement)((CalculusFieldElement)ratio.subtract(1.215)).divide(0.253)).reciprocal());
        }
        CalculusFieldElement mF2Sq = (CalculusFieldElement)mF2.multiply(mF2);
        CalculusFieldElement temp = FastMath.sqrt((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)mF2Sq.multiply(0.0196)).add(1.0)).divide(((CalculusFieldElement)mF2Sq.multiply(1.2967)).subtract(1.0))));
        CalculusFieldElement height = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)mF2.multiply(1490.0)).multiply((FieldElement)temp)).divide(mF2.add((FieldElement)deltaM))).subtract(176.0);
        return (T)height;
    }

    private T[] computeCF2(Field<T> field, T[][] af2, double t) {
        CalculusFieldElement[] cf2 = (CalculusFieldElement[])MathArrays.buildArray(field, (int)76);
        for (int i = 0; i < cf2.length; ++i) {
            CalculusFieldElement sum = (CalculusFieldElement)field.getZero();
            for (int k = 0; k < 6; ++k) {
                SinCos sc = FastMath.sinCos((double)((double)(k + 1) * t));
                sum = (CalculusFieldElement)sum.add(((CalculusFieldElement)af2[i][2 * k + 1].multiply(sc.sin())).add(af2[i][2 * (k + 1)].multiply(sc.cos())));
            }
            cf2[i] = (CalculusFieldElement)af2[i][0].add((FieldElement)sum);
        }
        return cf2;
    }

    private T[] computeCm3(Field<T> field, T[][] am3, double t) {
        CalculusFieldElement[] cm3 = (CalculusFieldElement[])MathArrays.buildArray(field, (int)49);
        for (int i = 0; i < cm3.length; ++i) {
            CalculusFieldElement sum = (CalculusFieldElement)field.getZero();
            for (int k = 0; k < 4; ++k) {
                SinCos sc = FastMath.sinCos((double)((double)(k + 1) * t));
                sum = (CalculusFieldElement)sum.add(((CalculusFieldElement)am3[i][2 * k + 1].multiply(sc.sin())).add(am3[i][2 * (k + 1)].multiply(sc.cos())));
            }
            cm3[i] = (CalculusFieldElement)am3[i][0].add((FieldElement)sum);
        }
        return cm3;
    }

    private T computefoF2(Field<T> field, T modip, T[] cf2, T latitude, T longitude) {
        CalculusFieldElement one = (CalculusFieldElement)field.getOne();
        int[] q = new int[]{12, 12, 9, 5, 2, 1, 1, 1, 1};
        CalculusFieldElement[] g = (CalculusFieldElement[])MathArrays.buildArray(field, (int)cf2.length);
        g[0] = one;
        CalculusFieldElement sinMODIP = FastMath.sin((CalculusFieldElement)FastMath.toRadians(modip));
        CalculusFieldElement[] m = (CalculusFieldElement[])MathArrays.buildArray(field, (int)12);
        m[0] = one;
        for (int i = 1; i < q[0]; ++i) {
            m[i] = (CalculusFieldElement)sinMODIP.multiply((FieldElement)m[i - 1]);
            g[i] = m[i];
        }
        CalculusFieldElement cosLat = FastMath.cos(latitude);
        CalculusFieldElement[] p = (CalculusFieldElement[])MathArrays.buildArray(field, (int)8);
        p[0] = cosLat;
        for (int n = 2; n < 9; ++n) {
            p[n - 1] = (CalculusFieldElement)cosLat.multiply((FieldElement)p[n - 2]);
        }
        int index = 12;
        for (int i = 1; i < q.length; ++i) {
            FieldSinCos sc = FastMath.sinCos((CalculusFieldElement)((CalculusFieldElement)longitude.multiply(i)));
            for (int j = 0; j < q[i]; ++j) {
                g[index++] = (CalculusFieldElement)((CalculusFieldElement)m[j].multiply((FieldElement)p[i - 1])).multiply((FieldElement)sc.cos());
                g[index++] = (CalculusFieldElement)((CalculusFieldElement)m[j].multiply((FieldElement)p[i - 1])).multiply((FieldElement)sc.sin());
            }
        }
        CalculusFieldElement frequency = (CalculusFieldElement)one.linearCombination((FieldElement[])g, cf2);
        return (T)frequency;
    }

    private T computeMF2(Field<T> field, T modip, T[] cm3, T latitude, T longitude) {
        CalculusFieldElement one = (CalculusFieldElement)field.getOne();
        int[] r = new int[]{7, 8, 6, 3, 2, 1, 1};
        CalculusFieldElement[] g = (CalculusFieldElement[])MathArrays.buildArray(field, (int)cm3.length);
        g[0] = one;
        CalculusFieldElement sinMODIP = FastMath.sin((CalculusFieldElement)FastMath.toRadians(modip));
        CalculusFieldElement[] m = (CalculusFieldElement[])MathArrays.buildArray(field, (int)12);
        m[0] = one;
        for (int i = 1; i < 12; ++i) {
            m[i] = (CalculusFieldElement)sinMODIP.multiply((FieldElement)m[i - 1]);
            if (i >= 7) continue;
            g[i] = m[i];
        }
        CalculusFieldElement cosLat = FastMath.cos(latitude);
        CalculusFieldElement[] p = (CalculusFieldElement[])MathArrays.buildArray(field, (int)8);
        p[0] = cosLat;
        for (int n = 2; n < 9; ++n) {
            p[n - 1] = (CalculusFieldElement)cosLat.multiply((FieldElement)p[n - 2]);
        }
        int index = 7;
        for (int i = 1; i < r.length; ++i) {
            FieldSinCos sc = FastMath.sinCos((CalculusFieldElement)((CalculusFieldElement)longitude.multiply(i)));
            for (int j = 0; j < r[i]; ++j) {
                g[index++] = (CalculusFieldElement)((CalculusFieldElement)m[j].multiply((FieldElement)p[i - 1])).multiply((FieldElement)sc.cos());
                g[index++] = (CalculusFieldElement)((CalculusFieldElement)m[j].multiply((FieldElement)p[i - 1])).multiply((FieldElement)sc.sin());
            }
        }
        CalculusFieldElement m3000 = (CalculusFieldElement)one.linearCombination((FieldElement[])g, cm3);
        return (T)m3000;
    }

    private T computefoF1(Field<T> field, T foE, T foF2) {
        CalculusFieldElement temp;
        CalculusFieldElement zero = (CalculusFieldElement)field.getZero();
        CalculusFieldElement temp2 = this.join(zero, temp = this.join((CalculusFieldElement)foE.multiply(1.4), zero, (CalculusFieldElement)zero.add(1000.0), (CalculusFieldElement)foE.subtract(2.0)), (CalculusFieldElement)zero.add(1000.0), (CalculusFieldElement)foE.subtract((FieldElement)temp));
        CalculusFieldElement value = this.join(temp2, (CalculusFieldElement)temp2.multiply(0.85), (CalculusFieldElement)zero.add(60.0), (CalculusFieldElement)((CalculusFieldElement)foF2.multiply(0.85)).subtract((FieldElement)temp2));
        if (value.getReal() < 1.0E-6) {
            return (T)zero;
        }
        return (T)value;
    }

    private T[] computeLayerAmplitudes(Field<T> field, T nmE, T nmF1, T foF1) {
        CalculusFieldElement a1;
        CalculusFieldElement zero = (CalculusFieldElement)field.getZero();
        CalculusFieldElement[] amplitude = (CalculusFieldElement[])MathArrays.buildArray(field, (int)3);
        amplitude[0] = a1 = (CalculusFieldElement)this.nmF2.multiply(4.0);
        if (foF1.getReal() < 0.5) {
            amplitude[1] = zero;
            amplitude[2] = (CalculusFieldElement)((CalculusFieldElement)nmE.subtract((FieldElement)this.epst(a1, this.hmF2, this.b2Bot, this.hmE))).multiply(4.0);
        } else {
            CalculusFieldElement a2a = zero;
            CalculusFieldElement a3a = (CalculusFieldElement)nmE.multiply(4.0);
            for (int i = 0; i < 5; ++i) {
                a2a = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)nmF1.subtract((FieldElement)this.epst(a1, this.hmF2, this.b2Bot, this.hmF1))).subtract((FieldElement)this.epst(a3a, this.hmE, this.beTop, this.hmF1))).multiply(4.0);
                a2a = this.join(a2a, (CalculusFieldElement)nmF1.multiply(0.8), (CalculusFieldElement)field.getOne(), (CalculusFieldElement)a2a.subtract(nmF1.multiply(0.8)));
                a3a = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)nmE.subtract((FieldElement)this.epst(a2a, this.hmF1, this.b1Bot, this.hmE))).subtract((FieldElement)this.epst(a1, this.hmF2, this.b2Bot, this.hmE))).multiply(4.0);
            }
            amplitude[1] = a2a;
            amplitude[2] = this.join(a3a, (CalculusFieldElement)zero.add(0.05), (CalculusFieldElement)zero.add(60.0), (CalculusFieldElement)a3a.subtract(0.005));
        }
        return amplitude;
    }

    private T computeH0(Field<T> field, int month, T azr) {
        CalculusFieldElement ka;
        CalculusFieldElement one = (CalculusFieldElement)field.getOne();
        if (month > 3 && month < 10) {
            ka = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)azr.multiply(0.014)).add(this.hmF2.multiply(0.008))).negate()).add(6.705);
        } else {
            CalculusFieldElement ratio = (CalculusFieldElement)this.hmF2.divide(this.b2Bot);
            ka = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)ratio.multiply((FieldElement)ratio)).multiply(0.097)).add(this.nmF2.multiply(0.153))).add(-7.77);
        }
        CalculusFieldElement kb = this.join(ka, (CalculusFieldElement)one.multiply(2.0), one, (CalculusFieldElement)ka.subtract(2.0));
        kb = this.join((CalculusFieldElement)one.multiply(8.0), kb, one, (CalculusFieldElement)kb.subtract(8.0));
        CalculusFieldElement hA = (CalculusFieldElement)kb.multiply(this.b2Bot);
        CalculusFieldElement x = (CalculusFieldElement)((CalculusFieldElement)hA.subtract(150.0)).multiply(0.01);
        CalculusFieldElement v = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)x.multiply(0.041163)).subtract(0.183981)).multiply((FieldElement)x)).add(1.424472);
        CalculusFieldElement h = (CalculusFieldElement)hA.divide((FieldElement)v);
        return (T)h;
    }

    private T clipExp(T power) {
        CalculusFieldElement zero = (CalculusFieldElement)power.getField().getZero();
        if (power.getReal() > 80.0) {
            return (T)((CalculusFieldElement)zero.add(5.5406E34));
        }
        if (power.getReal() < -80.0) {
            return (T)((CalculusFieldElement)zero.add(1.8049E-35));
        }
        return (T)FastMath.exp(power);
    }

    private T interpolate(T z1, T z2, T z3, T z4, T x) {
        if (FastMath.abs((double)(2.0 * x.getReal())) < 1.0E-10) {
            return z2;
        }
        CalculusFieldElement delta = (CalculusFieldElement)((CalculusFieldElement)x.multiply(2.0)).subtract(1.0);
        CalculusFieldElement g1 = (CalculusFieldElement)z3.add(z2);
        CalculusFieldElement g2 = (CalculusFieldElement)z3.subtract(z2);
        CalculusFieldElement g3 = (CalculusFieldElement)z4.add(z1);
        CalculusFieldElement g4 = (CalculusFieldElement)((CalculusFieldElement)z4.subtract(z1)).divide(3.0);
        CalculusFieldElement a0 = (CalculusFieldElement)((CalculusFieldElement)g1.multiply(9.0)).subtract((FieldElement)g3);
        CalculusFieldElement a1 = (CalculusFieldElement)((CalculusFieldElement)g2.multiply(9.0)).subtract((FieldElement)g4);
        CalculusFieldElement a2 = (CalculusFieldElement)g3.subtract((FieldElement)g1);
        CalculusFieldElement a3 = (CalculusFieldElement)g4.subtract((FieldElement)g2);
        CalculusFieldElement zx = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)delta.multiply((FieldElement)a3)).add((FieldElement)a2)).multiply((FieldElement)delta)).add((FieldElement)a1)).multiply((FieldElement)delta)).add((FieldElement)a0)).multiply(0.0625);
        return (T)zx;
    }

    private T join(T dF1, T dF2, T dA, T dX) {
        CalculusFieldElement ee = this.clipExp((CalculusFieldElement)dA.multiply(dX));
        return (T)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)dF1.multiply((FieldElement)ee)).add(dF2)).divide(ee.add(1.0)));
    }

    private T epst(T x, T y, T z, T w) {
        CalculusFieldElement ex = this.clipExp((CalculusFieldElement)((CalculusFieldElement)w.subtract(y)).divide(z));
        CalculusFieldElement opex = (CalculusFieldElement)ex.add(1.0);
        CalculusFieldElement epst = (CalculusFieldElement)((CalculusFieldElement)x.multiply((FieldElement)ex)).divide(opex.multiply((FieldElement)opex));
        return (T)epst;
    }
}

