/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.models.earth;

import org.hipparchus.CalculusFieldElement;
import org.hipparchus.Field;
import org.hipparchus.analysis.CalculusFieldUnivariateFunction;
import org.hipparchus.analysis.UnivariateFunction;
import org.hipparchus.analysis.solvers.AllowedSolution;
import org.hipparchus.analysis.solvers.BracketingNthOrderBrentSolver;
import org.hipparchus.analysis.solvers.FieldBracketingNthOrderBrentSolver;
import org.hipparchus.exception.MathRuntimeException;
import org.hipparchus.geometry.euclidean.threed.FieldLine;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.hipparchus.geometry.euclidean.threed.Line;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.hipparchus.util.FastMath;
import org.orekit.bodies.FieldGeodeticPoint;
import org.orekit.bodies.GeodeticPoint;
import org.orekit.errors.OrekitException;
import org.orekit.forces.gravity.HolmesFeatherstoneAttractionModel;
import org.orekit.forces.gravity.potential.NormalizedSphericalHarmonicsProvider;
import org.orekit.forces.gravity.potential.TideSystem;
import org.orekit.frames.FieldTransform;
import org.orekit.frames.Frame;
import org.orekit.frames.Transform;
import org.orekit.models.earth.EarthShape;
import org.orekit.models.earth.ReferenceEllipsoid;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.utils.TimeStampedPVCoordinates;

public class Geoid
implements EarthShape {
    private static final long serialVersionUID = 20150312L;
    private static final double MAX_UNDULATION = 100.0;
    private static final double MIN_UNDULATION = -150.0;
    private static final int MAX_EVALUATIONS = 100;
    private final AbsoluteDate defaultDate;
    private final ReferenceEllipsoid referenceEllipsoid;
    private final transient HolmesFeatherstoneAttractionModel harmonics;

    public Geoid(NormalizedSphericalHarmonicsProvider geopotential, ReferenceEllipsoid referenceEllipsoid) {
        if (geopotential == null || referenceEllipsoid == null) {
            throw new NullPointerException();
        }
        SubtractEllipsoid potential = new SubtractEllipsoid(geopotential, referenceEllipsoid);
        this.referenceEllipsoid = referenceEllipsoid;
        this.harmonics = new HolmesFeatherstoneAttractionModel(referenceEllipsoid.getBodyFrame(), potential);
        this.defaultDate = geopotential.getReferenceDate();
    }

    @Override
    public Frame getBodyFrame() {
        return this.getEllipsoid().getBodyFrame();
    }

    public double getUndulation(double geodeticLatitude, double longitude, AbsoluteDate date) {
        ReferenceEllipsoid ellipsoid = this.getEllipsoid();
        GeodeticPoint gp = new GeodeticPoint(geodeticLatitude, longitude, 0.0);
        Vector3D position = ellipsoid.transform(gp);
        double normalGravity = ellipsoid.getNormalGravity(geodeticLatitude);
        double mu = this.harmonics.getMu();
        double T = this.harmonics.nonCentralPart(date, position, mu);
        return T / normalGravity;
    }

    @Override
    public ReferenceEllipsoid getEllipsoid() {
        return this.referenceEllipsoid;
    }

    @Override
    public GeodeticPoint getIntersectionPoint(Line lineInFrame, Vector3D closeInFrame, Frame frame, final AbsoluteDate date) {
        final Frame bodyFrame = this.getBodyFrame();
        Transform frameToBody = frame.getTransformTo(bodyFrame, date);
        Vector3D close = frameToBody.transformPosition(closeInFrame);
        Line lineInBodyFrame = frameToBody.transformLine(lineInFrame);
        final Line line = lineInBodyFrame.getAbscissa(close) < 0.0 ? lineInBodyFrame.revert() : lineInBodyFrame;
        ReferenceEllipsoid ellipsoid = this.getEllipsoid();
        double d2 = line.pointAt(0.0).getNormSq();
        double n = ellipsoid.getPolarRadius() + -150.0;
        double minAbscissa2 = n * n - d2;
        double lowPoint = FastMath.sqrt((double)FastMath.max((double)minAbscissa2, (double)0.0));
        double x = ellipsoid.getEquatorialRadius() + 100.0;
        double maxAbscissa2 = x * x - d2;
        double highPoint = FastMath.sqrt((double)maxAbscissa2);
        UnivariateFunction heightFunction = new UnivariateFunction(){

            public double value(double x) {
                try {
                    GeodeticPoint geodetic = Geoid.this.transform(line.pointAt(x), bodyFrame, date);
                    return geodetic.getAltitude();
                }
                catch (OrekitException e) {
                    throw new RuntimeException(e);
                }
            }
        };
        if (maxAbscissa2 < 0.0) {
            return null;
        }
        BracketingNthOrderBrentSolver solver = new BracketingNthOrderBrentSolver();
        try {
            double abscissa = solver.solve(100, heightFunction, lowPoint, highPoint);
            return this.transform(line.pointAt(abscissa), bodyFrame, date);
        }
        catch (MathRuntimeException e) {
            return null;
        }
    }

    @Override
    public Vector3D projectToGround(Vector3D point, AbsoluteDate date, Frame frame) {
        GeodeticPoint gp = this.transform(point, frame, date);
        GeodeticPoint gpZero = new GeodeticPoint(gp.getLatitude(), gp.getLongitude(), 0.0);
        Transform bodyToFrame = this.getBodyFrame().getTransformTo(frame, date);
        return bodyToFrame.transformPosition(this.transform(gpZero));
    }

    @Override
    public <T extends CalculusFieldElement<T>> FieldGeodeticPoint<T> getIntersectionPoint(FieldLine<T> lineInFrame, FieldVector3D<T> closeInFrame, Frame frame, FieldAbsoluteDate<T> date) {
        Field<T> field = date.getField();
        Frame bodyFrame = this.getBodyFrame();
        FieldTransform<T> frameToBody = frame.getTransformTo(bodyFrame, date);
        FieldVector3D<T> close = frameToBody.transformPosition(closeInFrame);
        FieldLine lineInBodyFrame = frameToBody.transformLine(lineInFrame);
        FieldLine line = lineInBodyFrame.getAbscissa(close).getReal() < 0.0 ? lineInBodyFrame.revert() : lineInBodyFrame;
        ReferenceEllipsoid ellipsoid = this.getEllipsoid();
        CalculusFieldElement d2 = line.pointAt(0.0).getNormSq();
        double n = ellipsoid.getPolarRadius() + -150.0;
        CalculusFieldElement minAbscissa2 = (CalculusFieldElement)((CalculusFieldElement)d2.negate()).add(n * n);
        CalculusFieldElement lowPoint = minAbscissa2.getReal() < 0.0 ? (CalculusFieldElement)field.getZero() : (CalculusFieldElement)minAbscissa2.sqrt();
        double x = ellipsoid.getEquatorialRadius() + 100.0;
        CalculusFieldElement maxAbscissa2 = (CalculusFieldElement)((CalculusFieldElement)d2.negate()).add(x * x);
        CalculusFieldElement highPoint = (CalculusFieldElement)maxAbscissa2.sqrt();
        CalculusFieldUnivariateFunction heightFunction = z -> {
            try {
                FieldGeodeticPoint geodetic = this.transform(line.pointAt(z), bodyFrame, date);
                return geodetic.getAltitude();
            }
            catch (OrekitException e) {
                throw new RuntimeException(e);
            }
        };
        if (maxAbscissa2.getReal() < 0.0) {
            return null;
        }
        FieldBracketingNthOrderBrentSolver solver = new FieldBracketingNthOrderBrentSolver((CalculusFieldElement)((CalculusFieldElement)field.getZero()).add(1.0E-14), (CalculusFieldElement)((CalculusFieldElement)field.getZero()).add(1.0E-6), (CalculusFieldElement)((CalculusFieldElement)field.getZero()).add(1.0E-15), 5);
        try {
            CalculusFieldElement abscissa = solver.solve(100, heightFunction, lowPoint, highPoint, AllowedSolution.ANY_SIDE);
            return this.transform(line.pointAt(abscissa), bodyFrame, date);
        }
        catch (MathRuntimeException e) {
            return null;
        }
    }

    @Override
    public TimeStampedPVCoordinates projectToGround(TimeStampedPVCoordinates pv, Frame frame) {
        throw new UnsupportedOperationException();
    }

    @Override
    public GeodeticPoint transform(Vector3D point, Frame frame, AbsoluteDate date) {
        GeodeticPoint ellipsoidal = this.getEllipsoid().transform(point, frame, date);
        double undulation = this.getUndulation(ellipsoidal.getLatitude(), ellipsoidal.getLongitude(), date);
        return new GeodeticPoint(ellipsoidal.getLatitude(), ellipsoidal.getLongitude(), ellipsoidal.getAltitude() - undulation);
    }

    @Override
    public <T extends CalculusFieldElement<T>> FieldGeodeticPoint<T> transform(FieldVector3D<T> point, Frame frame, FieldAbsoluteDate<T> date) {
        FieldGeodeticPoint<T> ellipsoidal = this.getEllipsoid().transform(point, frame, date);
        double undulation = this.getUndulation(ellipsoidal.getLatitude().getReal(), ellipsoidal.getLongitude().getReal(), date.toAbsoluteDate());
        return new FieldGeodeticPoint<CalculusFieldElement>((CalculusFieldElement)ellipsoidal.getLatitude(), (CalculusFieldElement)ellipsoidal.getLongitude(), (CalculusFieldElement)ellipsoidal.getAltitude().subtract(undulation));
    }

    @Override
    public Vector3D transform(GeodeticPoint point) {
        try {
            double undulation = this.getUndulation(point.getLatitude(), point.getLongitude(), this.defaultDate);
            GeodeticPoint ellipsoidal = new GeodeticPoint(point.getLatitude(), point.getLongitude(), point.getAltitude() + undulation);
            return this.getEllipsoid().transform(ellipsoidal);
        }
        catch (OrekitException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public <T extends CalculusFieldElement<T>> FieldVector3D<T> transform(FieldGeodeticPoint<T> point) {
        try {
            double undulation = this.getUndulation(point.getLatitude().getReal(), point.getLongitude().getReal(), this.defaultDate);
            FieldGeodeticPoint<CalculusFieldElement> ellipsoidal = new FieldGeodeticPoint<CalculusFieldElement>((CalculusFieldElement)point.getLatitude(), (CalculusFieldElement)point.getLongitude(), (CalculusFieldElement)point.getAltitude().add(undulation));
            return this.getEllipsoid().transform(ellipsoidal);
        }
        catch (OrekitException e) {
            throw new RuntimeException(e);
        }
    }

    private static final class SubtractEllipsoid
    implements NormalizedSphericalHarmonicsProvider {
        private final NormalizedSphericalHarmonicsProvider provider;
        private final ReferenceEllipsoid ellipsoid;

        private SubtractEllipsoid(NormalizedSphericalHarmonicsProvider provider, ReferenceEllipsoid ellipsoid) {
            this.provider = provider;
            this.ellipsoid = ellipsoid;
        }

        @Override
        public int getMaxDegree() {
            return this.provider.getMaxDegree();
        }

        @Override
        public int getMaxOrder() {
            return this.provider.getMaxOrder();
        }

        @Override
        public double getMu() {
            return this.provider.getMu();
        }

        @Override
        public double getAe() {
            return this.provider.getAe();
        }

        @Override
        public AbsoluteDate getReferenceDate() {
            return this.provider.getReferenceDate();
        }

        @Override
        public double getOffset(AbsoluteDate date) {
            return this.provider.getOffset(date);
        }

        @Override
        public NormalizedSphericalHarmonicsProvider.NormalizedSphericalHarmonics onDate(final AbsoluteDate date) {
            return new NormalizedSphericalHarmonicsProvider.NormalizedSphericalHarmonics(){
                private final NormalizedSphericalHarmonicsProvider.NormalizedSphericalHarmonics delegate;
                {
                    this.delegate = provider.onDate(date);
                }

                @Override
                public double getNormalizedCnm(int n, int m) {
                    return this.getCorrectedCnm(n, m, this.delegate.getNormalizedCnm(n, m));
                }

                @Override
                public double getNormalizedSnm(int n, int m) {
                    return this.delegate.getNormalizedSnm(n, m);
                }

                @Override
                public AbsoluteDate getDate() {
                    return date;
                }
            };
        }

        private double getCorrectedCnm(int n, int m, double uncorrectedCnm) {
            double Cnm = uncorrectedCnm;
            if (m == 0 && n <= 10 && n % 2 == 0 && n > 0) {
                double gmRatio = this.ellipsoid.getGM() / this.getMu();
                double aRatio = this.ellipsoid.getEquatorialRadius() / this.getAe();
                int halfN = n / 2;
                Cnm -= gmRatio * FastMath.pow((double)aRatio, (int)halfN) * this.ellipsoid.getC2n0(halfN);
            }
            return Cnm;
        }

        @Override
        public TideSystem getTideSystem() {
            return this.provider.getTideSystem();
        }
    }
}

