/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.gnss.navigation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.orekit.gnss.SatelliteSystem;
import org.orekit.propagation.analytical.gnss.data.BeidouNavigationMessage;
import org.orekit.propagation.analytical.gnss.data.GLONASSNavigationMessage;
import org.orekit.propagation.analytical.gnss.data.GPSNavigationMessage;
import org.orekit.propagation.analytical.gnss.data.GalileoNavigationMessage;
import org.orekit.propagation.analytical.gnss.data.IRNSSNavigationMessage;
import org.orekit.propagation.analytical.gnss.data.QZSSNavigationMessage;
import org.orekit.propagation.analytical.gnss.data.SBASNavigationMessage;
import org.orekit.time.AbsoluteDate;

public class RinexNavigation {
    private double formatVersion;
    private String fileType;
    private SatelliteSystem satelliteSystem;
    private String programName;
    private String agencyName;
    private String creationDateString;
    private String creationTimeString;
    private String creationTimeZoneString;
    private AbsoluteDate creationDate;
    private String comments = "";
    private String ionosphericCorrectionType;
    private double[] klobucharAlpha;
    private double[] klobucharBeta;
    private double[] neQuickAlpha;
    private List<TimeSystemCorrection> timeSystemCorrections = new ArrayList<TimeSystemCorrection>();
    private int numberOfLeapSeconds;
    private Map<String, List<GPSNavigationMessage>> gpsData = new HashMap<String, List<GPSNavigationMessage>>();
    private Map<String, List<GalileoNavigationMessage>> galileoData = new HashMap<String, List<GalileoNavigationMessage>>();
    private Map<String, List<BeidouNavigationMessage>> beidouData = new HashMap<String, List<BeidouNavigationMessage>>();
    private Map<String, List<QZSSNavigationMessage>> qzssData = new HashMap<String, List<QZSSNavigationMessage>>();
    private Map<String, List<IRNSSNavigationMessage>> irnssData = new HashMap<String, List<IRNSSNavigationMessage>>();
    private Map<String, List<GLONASSNavigationMessage>> glonassData = new HashMap<String, List<GLONASSNavigationMessage>>();
    private Map<String, List<SBASNavigationMessage>> sbasData = new HashMap<String, List<SBASNavigationMessage>>();

    public double getFormatVersion() {
        return this.formatVersion;
    }

    public void setFormatVersion(double formatVersion) {
        this.formatVersion = formatVersion;
    }

    public String getFileType() {
        return this.fileType;
    }

    public void setFileType(String fileType) {
        this.fileType = fileType;
    }

    public SatelliteSystem getSatelliteSystem() {
        return this.satelliteSystem;
    }

    public void setSatelliteSystem(SatelliteSystem satelliteSystem) {
        this.satelliteSystem = satelliteSystem;
    }

    public String getProgramName() {
        return this.programName;
    }

    public void setProgramName(String programName) {
        this.programName = programName;
    }

    public String getAgencyName() {
        return this.agencyName;
    }

    public void setAgencyName(String agencyName) {
        this.agencyName = agencyName;
    }

    public String getCreationDateString() {
        return this.creationDateString;
    }

    public void setCreationDateString(String creationDateString) {
        this.creationDateString = creationDateString;
    }

    public String getCreationTimeString() {
        return this.creationTimeString;
    }

    public void setCreationTimeString(String creationTimeString) {
        this.creationTimeString = creationTimeString;
    }

    public String getCreationTimeZoneString() {
        return this.creationTimeZoneString;
    }

    public void setCreationTimeZoneString(String creationTimeZoneString) {
        this.creationTimeZoneString = creationTimeZoneString;
    }

    public AbsoluteDate getCreationDate() {
        return this.creationDate;
    }

    public void setCreationDate(AbsoluteDate creationDate) {
        this.creationDate = creationDate;
    }

    public String getComments() {
        return this.comments;
    }

    public void addComment(String comment) {
        this.comments = this.comments.concat(comment);
    }

    public String getIonosphericCorrectionType() {
        return this.ionosphericCorrectionType;
    }

    public void setIonosphericCorrectionType(String ionosphericCorrectionType) {
        this.ionosphericCorrectionType = ionosphericCorrectionType;
    }

    public double[] getKlobucharAlpha() {
        return (double[])this.klobucharAlpha.clone();
    }

    public void setKlobucharAlpha(double[] klobucharAlpha) {
        this.klobucharAlpha = (double[])klobucharAlpha.clone();
    }

    public double[] getKlobucharBeta() {
        return (double[])this.klobucharBeta.clone();
    }

    public void setKlobucharBeta(double[] klobucharBeta) {
        this.klobucharBeta = (double[])klobucharBeta.clone();
    }

    public double[] getNeQuickAlpha() {
        return (double[])this.neQuickAlpha.clone();
    }

    public void setNeQuickAlpha(double[] neQuickAlpha) {
        this.neQuickAlpha = (double[])neQuickAlpha.clone();
    }

    public List<TimeSystemCorrection> getTimeSystemCorrections() {
        return this.timeSystemCorrections;
    }

    public void addTimeSystemCorrections(TimeSystemCorrection timeSystemCorrection) {
        this.timeSystemCorrections.add(timeSystemCorrection);
    }

    public int getNumberOfLeapSeconds() {
        return this.numberOfLeapSeconds;
    }

    public void setNumberOfLeapSeconds(int numberOfLeapSeconds) {
        this.numberOfLeapSeconds = numberOfLeapSeconds;
    }

    public Map<String, List<GPSNavigationMessage>> getGPSNavigationMessages() {
        return Collections.unmodifiableMap(this.gpsData);
    }

    public List<GPSNavigationMessage> getGPSNavigationMessages(String satId) {
        return Collections.unmodifiableList(this.gpsData.get(satId));
    }

    public void addGPSNavigationMessage(GPSNavigationMessage message) {
        int gpsPRN = message.getPRN();
        String prnString = gpsPRN < 10 ? "0" + String.valueOf(gpsPRN) : String.valueOf(gpsPRN);
        String satId = SatelliteSystem.GPS.getKey() + prnString;
        this.gpsData.putIfAbsent(satId, new ArrayList());
        this.gpsData.get(satId).add(message);
    }

    public Map<String, List<GalileoNavigationMessage>> getGalileoNavigationMessages() {
        return Collections.unmodifiableMap(this.galileoData);
    }

    public List<GalileoNavigationMessage> getGalileoNavigationMessages(String satId) {
        return Collections.unmodifiableList(this.galileoData.get(satId));
    }

    public void addGalileoNavigationMessage(GalileoNavigationMessage message) {
        int galPRN = message.getPRN();
        String prnString = galPRN < 10 ? "0" + String.valueOf(galPRN) : String.valueOf(galPRN);
        String satId = SatelliteSystem.GALILEO.getKey() + prnString;
        this.galileoData.putIfAbsent(satId, new ArrayList());
        this.galileoData.get(satId).add(message);
    }

    public Map<String, List<BeidouNavigationMessage>> getBeidouNavigationMessages() {
        return Collections.unmodifiableMap(this.beidouData);
    }

    public List<BeidouNavigationMessage> getBeidouNavigationMessages(String satId) {
        return Collections.unmodifiableList(this.beidouData.get(satId));
    }

    public void addBeidouNavigationMessage(BeidouNavigationMessage message) {
        int bdtPRN = message.getPRN();
        String prnString = bdtPRN < 10 ? "0" + String.valueOf(bdtPRN) : String.valueOf(bdtPRN);
        String satId = SatelliteSystem.BEIDOU.getKey() + prnString;
        this.beidouData.putIfAbsent(satId, new ArrayList());
        this.beidouData.get(satId).add(message);
    }

    public Map<String, List<QZSSNavigationMessage>> getQZSSNavigationMessages() {
        return Collections.unmodifiableMap(this.qzssData);
    }

    public List<QZSSNavigationMessage> getQZSSNavigationMessages(String satId) {
        return Collections.unmodifiableList(this.qzssData.get(satId));
    }

    public void addQZSSNavigationMessage(QZSSNavigationMessage message) {
        int qzsPRN = message.getPRN();
        String prnString = qzsPRN < 10 ? "0" + String.valueOf(qzsPRN) : String.valueOf(qzsPRN);
        String satId = SatelliteSystem.QZSS.getKey() + prnString;
        this.qzssData.putIfAbsent(satId, new ArrayList());
        this.qzssData.get(satId).add(message);
    }

    public Map<String, List<IRNSSNavigationMessage>> getIRNSSNavigationMessages() {
        return Collections.unmodifiableMap(this.irnssData);
    }

    public List<IRNSSNavigationMessage> getIRNSSNavigationMessages(String satId) {
        return Collections.unmodifiableList(this.irnssData.get(satId));
    }

    public void addIRNSSNavigationMessage(IRNSSNavigationMessage message) {
        int irsPRN = message.getPRN();
        String prnString = irsPRN < 10 ? "0" + String.valueOf(irsPRN) : String.valueOf(irsPRN);
        String satId = SatelliteSystem.IRNSS.getKey() + prnString;
        this.irnssData.putIfAbsent(satId, new ArrayList());
        this.irnssData.get(satId).add(message);
    }

    public Map<String, List<GLONASSNavigationMessage>> getGlonassNavigationMessages() {
        return Collections.unmodifiableMap(this.glonassData);
    }

    public List<GLONASSNavigationMessage> getGlonassNavigationMessages(String satId) {
        return Collections.unmodifiableList(this.glonassData.get(satId));
    }

    public void addGlonassNavigationMessage(GLONASSNavigationMessage message) {
        int gloPRN = message.getPRN();
        String prnString = gloPRN < 10 ? "0" + String.valueOf(gloPRN) : String.valueOf(gloPRN);
        String satId = SatelliteSystem.GLONASS.getKey() + prnString;
        this.glonassData.putIfAbsent(satId, new ArrayList());
        this.glonassData.get(satId).add(message);
    }

    public Map<String, List<SBASNavigationMessage>> getSBASNavigationMessages() {
        return Collections.unmodifiableMap(this.sbasData);
    }

    public List<SBASNavigationMessage> getSBASNavigationMessages(String satId) {
        return Collections.unmodifiableList(this.sbasData.get(satId));
    }

    public void addSBASNavigationMessage(SBASNavigationMessage message) {
        int sbsPRN = message.getPRN();
        String prnString = sbsPRN < 10 ? "0" + String.valueOf(sbsPRN) : String.valueOf(sbsPRN);
        String satId = SatelliteSystem.SBAS.getKey() + prnString;
        this.sbasData.putIfAbsent(satId, new ArrayList());
        this.sbasData.get(satId).add(message);
    }

    public static class TimeSystemCorrection {
        private String timeSystemCorrectionType;
        private double timeSystemCorrectionA0;
        private double timeSystemCorrectionA1;
        private int timeSystemCorrectionSecOfWeek;
        private int timeSystemCorrectionWeekNumber;

        public TimeSystemCorrection(String timeSystemCorrectionType, double timeSystemCorrectionA0, double timeSystemCorrectionA1, int timeSystemCorrectionSecOfWeek, int timeSystemCorrectionWeekNumber) {
            this.timeSystemCorrectionType = timeSystemCorrectionType;
            this.timeSystemCorrectionA0 = timeSystemCorrectionA0;
            this.timeSystemCorrectionA1 = timeSystemCorrectionA1;
            this.timeSystemCorrectionSecOfWeek = timeSystemCorrectionSecOfWeek;
            this.timeSystemCorrectionWeekNumber = timeSystemCorrectionWeekNumber;
        }

        public String getTimeSystemCorrectionType() {
            return this.timeSystemCorrectionType;
        }

        public double getTimeSystemCorrectionA0() {
            return this.timeSystemCorrectionA0;
        }

        public double getTimeSystemCorrectionA1() {
            return this.timeSystemCorrectionA1;
        }

        public int getTimeSystemCorrectionSecOfWeek() {
            return this.timeSystemCorrectionSecOfWeek;
        }

        public int getTimeSystemCorrectionWeekNumber() {
            return this.timeSystemCorrectionWeekNumber;
        }
    }
}

