/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.gnss.metric.parser;

import java.util.function.Function;
import org.orekit.gnss.metric.parser.EncodedMessage;

enum DataType {
    BIT_1(m -> m.extractBits(1)),
    BIT_2(m -> m.extractBits(2)),
    BIT_3(m -> m.extractBits(3)),
    BIT_4(m -> m.extractBits(4)),
    BIT_6(m -> m.extractBits(6)),
    BIT_7(m -> m.extractBits(7)),
    BIT_8(m -> m.extractBits(8)),
    BIT_10(m -> m.extractBits(10)),
    BIT_12(m -> m.extractBits(12)),
    BIT_24(m -> m.extractBits(24)),
    BIT_32(m -> m.extractBits(32)),
    INT_6(m -> {
        long msb = 32L;
        long signed = (m.extractBits(6) ^ 0x20L) - 32L;
        return signed == -32L ? null : Long.valueOf(signed);
    }),
    INT_8(m -> {
        long msb = 128L;
        long signed = (m.extractBits(8) ^ 0x80L) - 128L;
        return signed == -128L ? null : Long.valueOf(signed);
    }),
    INT_9(m -> {
        long msb = 256L;
        long signed = (m.extractBits(9) ^ 0x100L) - 256L;
        return signed == -256L ? null : Long.valueOf(signed);
    }),
    INT_10(m -> {
        long msb = 512L;
        long signed = (m.extractBits(10) ^ 0x200L) - 512L;
        return signed == -512L ? null : Long.valueOf(signed);
    }),
    INT_11(m -> {
        long msb = 1024L;
        long signed = (m.extractBits(11) ^ 0x400L) - 1024L;
        return signed == -1024L ? null : Long.valueOf(signed);
    }),
    INT_14(m -> {
        long msb = 8192L;
        long signed = (m.extractBits(14) ^ 0x2000L) - 8192L;
        return signed == -8192L ? null : Long.valueOf(signed);
    }),
    INT_15(m -> {
        long msb = 16384L;
        long signed = (m.extractBits(15) ^ 0x4000L) - 16384L;
        return signed == -16384L ? null : Long.valueOf(signed);
    }),
    INT_16(m -> {
        long msb = 32768L;
        long signed = (m.extractBits(16) ^ 0x8000L) - 32768L;
        return signed == -32768L ? null : Long.valueOf(signed);
    }),
    INT_17(m -> {
        long msb = 65536L;
        long signed = (m.extractBits(17) ^ 0x10000L) - 65536L;
        return signed == -65536L ? null : Long.valueOf(signed);
    }),
    INT_18(m -> {
        long msb = 131072L;
        long signed = (m.extractBits(18) ^ 0x20000L) - 131072L;
        return signed == -131072L ? null : Long.valueOf(signed);
    }),
    INT_19(m -> {
        long msb = 262144L;
        long signed = (m.extractBits(19) ^ 0x40000L) - 262144L;
        return signed == -262144L ? null : Long.valueOf(signed);
    }),
    INT_20(m -> {
        long msb = 524288L;
        long signed = (m.extractBits(20) ^ 0x80000L) - 524288L;
        return signed == -524288L ? null : Long.valueOf(signed);
    }),
    INT_21(m -> {
        long msb = 0x100000L;
        long signed = (m.extractBits(21) ^ 0x100000L) - 0x100000L;
        return signed == -1048576L ? null : Long.valueOf(signed);
    }),
    INT_22(m -> {
        long msb = 0x200000L;
        long signed = (m.extractBits(22) ^ 0x200000L) - 0x200000L;
        return signed == -2097152L ? null : Long.valueOf(signed);
    }),
    INT_23(m -> {
        long msb = 0x400000L;
        long signed = (m.extractBits(23) ^ 0x400000L) - 0x400000L;
        return signed == -4194304L ? null : Long.valueOf(signed);
    }),
    INT_24(m -> {
        long msb = 0x800000L;
        long signed = (m.extractBits(24) ^ 0x800000L) - 0x800000L;
        return signed == -8388608L ? null : Long.valueOf(signed);
    }),
    INT_25(m -> {
        long msb = 0x1000000L;
        long signed = (m.extractBits(25) ^ 0x1000000L) - 0x1000000L;
        return signed == -16777216L ? null : Long.valueOf(signed);
    }),
    INT_26(m -> {
        long msb = 0x2000000L;
        long signed = (m.extractBits(26) ^ 0x2000000L) - 0x2000000L;
        return signed == -33554432L ? null : Long.valueOf(signed);
    }),
    INT_27(m -> {
        long msb = 0x4000000L;
        long signed = (m.extractBits(27) ^ 0x4000000L) - 0x4000000L;
        return signed == -67108864L ? null : Long.valueOf(signed);
    }),
    INT_30(m -> {
        long msb = 0x20000000L;
        long signed = (m.extractBits(30) ^ 0x20000000L) - 0x20000000L;
        return signed == -536870912L ? null : Long.valueOf(signed);
    }),
    INT_31(m -> {
        long msb = 0x40000000L;
        long signed = (m.extractBits(31) ^ 0x40000000L) - 0x40000000L;
        return signed == -1073741824L ? null : Long.valueOf(signed);
    }),
    INT_32(m -> {
        long msb = 0x80000000L;
        long signed = (m.extractBits(32) ^ 0x80000000L) - 0x80000000L;
        return signed == Integer.MIN_VALUE ? null : Long.valueOf(signed);
    }),
    INT_34(m -> {
        long msb = 0x200000000L;
        long signed = (m.extractBits(34) ^ 0x200000000L) - 0x200000000L;
        return signed == -8589934592L ? null : Long.valueOf(signed);
    }),
    INT_35(m -> {
        long msb = 0x400000000L;
        long signed = (m.extractBits(35) ^ 0x400000000L) - 0x400000000L;
        return signed == -17179869184L ? null : Long.valueOf(signed);
    }),
    INT_38(m -> {
        long msb = 0x2000000000L;
        long signed = (m.extractBits(38) ^ 0x2000000000L) - 0x2000000000L;
        return signed == -137438953472L ? null : Long.valueOf(signed);
    }),
    U_INT_2(m -> m.extractBits(2)),
    U_INT_3(m -> m.extractBits(3)),
    U_INT_4(m -> m.extractBits(4)),
    U_INT_5(m -> m.extractBits(5)),
    U_INT_6(m -> m.extractBits(6)),
    U_INT_7(m -> m.extractBits(7)),
    U_INT_8(m -> m.extractBits(8)),
    U_INT_9(m -> m.extractBits(9)),
    U_INT_10(m -> m.extractBits(10)),
    U_INT_11(m -> m.extractBits(11)),
    U_INT_12(m -> m.extractBits(12)),
    U_INT_13(m -> m.extractBits(13)),
    U_INT_14(m -> m.extractBits(14)),
    U_INT_16(m -> m.extractBits(16)),
    U_INT_17(m -> m.extractBits(17)),
    U_INT_18(m -> m.extractBits(18)),
    U_INT_20(m -> m.extractBits(20)),
    U_INT_23(m -> m.extractBits(23)),
    U_INT_24(m -> m.extractBits(24)),
    U_INT_25(m -> m.extractBits(25)),
    U_INT_26(m -> m.extractBits(26)),
    U_INT_27(m -> m.extractBits(27)),
    U_INT_30(m -> m.extractBits(30)),
    U_INT_32(m -> m.extractBits(32)),
    U_INT_35(m -> m.extractBits(35)),
    U_INT_36(m -> m.extractBits(36)),
    INT_S_5(m -> {
        long data = m.extractBits(5);
        long mask = -(data >>> 4);
        return (mask ^ 0xFFFFFFFFFFFFFFFFL) & data | mask & 16L - data;
    }),
    INT_S_11(m -> {
        long data = m.extractBits(11);
        long mask = -(data >>> 10);
        return (mask ^ 0xFFFFFFFFFFFFFFFFL) & data | mask & 1024L - data;
    }),
    INT_S_22(m -> {
        long data = m.extractBits(22);
        long mask = -(data >>> 21);
        return (mask ^ 0xFFFFFFFFFFFFFFFFL) & data | mask & 0x200000L - data;
    }),
    INT_S_24(m -> {
        long data = m.extractBits(24);
        long mask = -(data >>> 23);
        return (mask ^ 0xFFFFFFFFFFFFFFFFL) & data | mask & 0x800000L - data;
    }),
    INT_S_27(m -> {
        long data = m.extractBits(27);
        long mask = -(data >>> 26);
        return (mask ^ 0xFFFFFFFFFFFFFFFFL) & data | mask & 0x4000000L - data;
    }),
    INT_S_32(m -> {
        long data = m.extractBits(32);
        long mask = -(data >>> 31);
        return (mask ^ 0xFFFFFFFFFFFFFFFFL) & data | mask & 0x80000000L - data;
    });

    private final Function<EncodedMessage, Long> decoder;

    private DataType(Function<EncodedMessage, Long> decoder) {
        this.decoder = decoder;
    }

    Long decode(EncodedMessage message) {
        return this.decoder.apply(message);
    }
}

