/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.gnss.metric.messages.rtcm.ephemeris;

import org.orekit.annotation.DefaultDataContext;
import org.orekit.data.DataContext;
import org.orekit.gnss.SatelliteSystem;
import org.orekit.gnss.metric.messages.rtcm.ephemeris.RtcmEphemerisData;
import org.orekit.propagation.analytical.gnss.data.BeidouNavigationMessage;
import org.orekit.time.GNSSDate;
import org.orekit.time.TimeScales;

public class Rtcm1042Data
extends RtcmEphemerisData {
    private BeidouNavigationMessage beidouNavigationMessage;
    private double beidouToc;
    private double svHealth;

    @DefaultDataContext
    public BeidouNavigationMessage getBeidouNavigationMessage() {
        return this.getBeidouNavigationMessage(DataContext.getDefault().getTimeScales());
    }

    public BeidouNavigationMessage getBeidouNavigationMessage(TimeScales timeScales) {
        SatelliteSystem system = SatelliteSystem.BEIDOU;
        int week = this.beidouNavigationMessage.getWeek();
        double toe = this.beidouNavigationMessage.getTime();
        this.beidouNavigationMessage.setDate(new GNSSDate(week, 1000.0 * toe, system, timeScales).getDate());
        this.beidouNavigationMessage.setEpochToc(new GNSSDate(week, 1000.0 * this.beidouToc, system, timeScales).getDate());
        return this.beidouNavigationMessage;
    }

    public void setBeidouNavigationMessage(BeidouNavigationMessage beidouNavigationMessage) {
        this.beidouNavigationMessage = beidouNavigationMessage;
    }

    public double getBeidouToc() {
        return this.beidouToc;
    }

    public void setBeidouToc(double toc) {
        this.beidouToc = toc;
    }

    public double getSvHealth() {
        return this.svHealth;
    }

    public void setSvHealth(double svHealth) {
        this.svHealth = svHealth;
    }
}

