/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.gnss.antenna;

import org.hipparchus.util.FastMath;
import org.orekit.gnss.antenna.PhaseCenterVariationFunction;

class OneDVariation
implements PhaseCenterVariationFunction {
    private final double polarStart;
    private final double polarStep;
    private final double[] variations;

    OneDVariation(double polarStart, double polarStep, double[] variations) {
        this.polarStart = polarStart;
        this.polarStep = polarStep;
        this.variations = (double[])variations.clone();
    }

    @Override
    public double value(double polarAngle, double azimuthAngle) {
        int jBase = (int)FastMath.floor((double)((polarAngle - this.polarStart) / this.polarStep));
        int j = FastMath.max((int)0, (int)FastMath.min((int)(this.variations.length - 2), (int)jBase));
        double pInf = this.polarStart + (double)j * this.polarStep;
        double pSup = pInf + this.polarStep;
        double vInf = this.variations[j];
        double vSup = this.variations[j + 1];
        return ((polarAngle - pInf) * vSup + (pSup - polarAngle) * vInf) / this.polarStep;
    }
}

