/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.gnss;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.regex.Pattern;
import org.hipparchus.exception.Localizable;
import org.hipparchus.util.Pair;
import org.orekit.annotation.DefaultDataContext;
import org.orekit.data.AbstractSelfFeedingLoader;
import org.orekit.data.DataContext;
import org.orekit.data.DataLoader;
import org.orekit.data.DataProvidersManager;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.gnss.SatelliteSystem;
import org.orekit.propagation.analytical.gnss.data.GPSAlmanac;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.GNSSDate;
import org.orekit.time.TimeScales;

public class YUMAParser
extends AbstractSelfFeedingLoader
implements DataLoader {
    private static final String SOURCE = "YUMA";
    private static final String[] KEY = new String[]{"id", "health", "eccentricity", "time", "orbital", "rate", "sqrt", "right", "argument", "mean", "af0", "af1", "week"};
    private static final String DEFAULT_SUPPORTED_NAMES = ".*\\.alm$";
    private static final Pattern SEPARATOR = Pattern.compile(":");
    private final List<GPSAlmanac> almanacs = new ArrayList<GPSAlmanac>();
    private final List<Integer> prnList = new ArrayList<Integer>();
    private final TimeScales timeScales;

    @DefaultDataContext
    public YUMAParser(String supportedNames) {
        this(supportedNames, DataContext.getDefault().getDataProvidersManager(), DataContext.getDefault().getTimeScales());
    }

    public YUMAParser(String supportedNames, DataProvidersManager dataProvidersManager, TimeScales timeScales) {
        super(supportedNames == null ? DEFAULT_SUPPORTED_NAMES : supportedNames, dataProvidersManager);
        this.timeScales = timeScales;
    }

    public void loadData() {
        this.feed(this);
        if (this.almanacs.isEmpty()) {
            throw new OrekitException((Localizable)OrekitMessages.NO_YUMA_ALMANAC_AVAILABLE, new Object[0]);
        }
    }

    @Override
    public void loadData(InputStream input, String name) throws IOException, ParseException, OrekitException {
        this.almanacs.clear();
        this.prnList.clear();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(input, StandardCharsets.UTF_8));){
            ArrayList<Pair<String, String>> entries = new ArrayList<Pair<String, String>>(KEY.length);
            String line = reader.readLine();
            while (line != null) {
                String[] token = SEPARATOR.split(line.trim());
                if (token.length == 2) {
                    entries.add((Pair<String, String>)new Pair((Object)token[0].trim(), (Object)token[1].trim()));
                }
                if (entries.size() == KEY.length) {
                    GPSAlmanac almanac = this.getAlmanac(entries, name);
                    this.almanacs.add(almanac);
                    this.prnList.add(almanac.getPRN());
                    entries.clear();
                }
                line = reader.readLine();
            }
        }
        catch (IOException ioe) {
            throw new OrekitException(ioe, OrekitMessages.NOT_A_SUPPORTED_YUMA_ALMANAC_FILE, name);
        }
    }

    @Override
    public boolean stillAcceptsData() {
        return this.almanacs.isEmpty();
    }

    @Override
    public String getSupportedNames() {
        return super.getSupportedNames();
    }

    public List<GPSAlmanac> getAlmanacs() {
        return this.almanacs;
    }

    public List<Integer> getPRNNumbers() {
        return this.prnList;
    }

    private GPSAlmanac getAlmanac(List<Pair<String, String>> entries, String name) {
        try {
            GPSAlmanac almanac = new GPSAlmanac();
            almanac.setSource(SOURCE);
            boolean[] checks = new boolean[KEY.length];
            for (Pair<String, String> entry : entries) {
                String lowerCaseKey = ((String)entry.getKey()).toLowerCase(Locale.US);
                if (lowerCaseKey.startsWith(KEY[0])) {
                    almanac.setPRN(Integer.parseInt((String)entry.getValue()));
                    checks[0] = true;
                    continue;
                }
                if (lowerCaseKey.startsWith(KEY[1])) {
                    almanac.setHealth(Integer.parseInt((String)entry.getValue()));
                    checks[1] = true;
                    continue;
                }
                if (lowerCaseKey.startsWith(KEY[2])) {
                    almanac.setE(Double.parseDouble((String)entry.getValue()));
                    checks[2] = true;
                    continue;
                }
                if (lowerCaseKey.startsWith(KEY[3])) {
                    almanac.setTime(Double.parseDouble((String)entry.getValue()));
                    checks[3] = true;
                    continue;
                }
                if (lowerCaseKey.startsWith(KEY[4])) {
                    almanac.setI0(Double.parseDouble((String)entry.getValue()));
                    checks[4] = true;
                    continue;
                }
                if (lowerCaseKey.startsWith(KEY[5])) {
                    almanac.setOmegaDot(Double.parseDouble((String)entry.getValue()));
                    checks[5] = true;
                    continue;
                }
                if (lowerCaseKey.startsWith(KEY[6])) {
                    almanac.setSqrtA(Double.parseDouble((String)entry.getValue()));
                    checks[6] = true;
                    continue;
                }
                if (lowerCaseKey.startsWith(KEY[7])) {
                    almanac.setOmega0(Double.parseDouble((String)entry.getValue()));
                    checks[7] = true;
                    continue;
                }
                if (lowerCaseKey.startsWith(KEY[8])) {
                    almanac.setPa(Double.parseDouble((String)entry.getValue()));
                    checks[8] = true;
                    continue;
                }
                if (lowerCaseKey.startsWith(KEY[9])) {
                    almanac.setM0(Double.parseDouble((String)entry.getValue()));
                    checks[9] = true;
                    continue;
                }
                if (lowerCaseKey.startsWith(KEY[10])) {
                    almanac.setAf0(Double.parseDouble((String)entry.getValue()));
                    checks[10] = true;
                    continue;
                }
                if (lowerCaseKey.startsWith(KEY[11])) {
                    almanac.setAf1(Double.parseDouble((String)entry.getValue()));
                    checks[11] = true;
                    continue;
                }
                if (lowerCaseKey.startsWith(KEY[12])) {
                    almanac.setWeek(Integer.parseInt((String)entry.getValue()));
                    checks[12] = true;
                    continue;
                }
                throw new OrekitException((Localizable)OrekitMessages.NOT_A_SUPPORTED_YUMA_ALMANAC_FILE, name);
            }
            if (this.readOK(checks)) {
                AbsoluteDate date = new GNSSDate(almanac.getWeek(), almanac.getTime() * 1000.0, SatelliteSystem.GPS, this.timeScales).getDate();
                almanac.setDate(date);
                almanac.setSVN(-1);
                almanac.setURA(-1);
                almanac.setSatConfiguration(-1);
                return almanac;
            }
            throw new OrekitException((Localizable)OrekitMessages.NOT_A_SUPPORTED_YUMA_ALMANAC_FILE, name);
        }
        catch (NumberFormatException nfe) {
            throw new OrekitException(nfe, OrekitMessages.NOT_A_SUPPORTED_YUMA_ALMANAC_FILE, name);
        }
    }

    private boolean readOK(boolean[] checks) {
        for (boolean check : checks) {
            if (check) continue;
            return false;
        }
        return true;
    }
}

