/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.forces.radiation;

import java.lang.reflect.Array;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;
import org.hipparchus.CalculusFieldElement;
import org.hipparchus.Field;
import org.hipparchus.FieldElement;
import org.hipparchus.exception.Localizable;
import org.hipparchus.geometry.Vector;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.hipparchus.ode.events.Action;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.MathArrays;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.forces.AbstractForceModel;
import org.orekit.propagation.FieldSpacecraftState;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.events.AbstractDetector;
import org.orekit.propagation.events.EventDetector;
import org.orekit.propagation.events.FieldAbstractDetector;
import org.orekit.propagation.events.FieldEventDetector;
import org.orekit.propagation.events.handlers.EventHandler;
import org.orekit.propagation.events.handlers.FieldEventHandler;
import org.orekit.utils.ExtendedPVCoordinatesProvider;

public abstract class AbstractRadiationForceModel
extends AbstractForceModel {
    private static final double ANGULAR_MARGIN = 1.0E-10;
    private final double equatorialRadius;
    private final ExtendedPVCoordinatesProvider sun;
    private final Map<ExtendedPVCoordinatesProvider, Double> otherOccultingBodies;

    protected AbstractRadiationForceModel(ExtendedPVCoordinatesProvider sun, double equatorialRadius) {
        this.sun = sun;
        this.equatorialRadius = equatorialRadius;
        this.otherOccultingBodies = new HashMap<ExtendedPVCoordinatesProvider, Double>();
    }

    @Override
    public boolean dependsOnPositionOnly() {
        return false;
    }

    @Override
    public Stream<EventDetector> getEventsDetectors() {
        EventDetector[] detectors = new EventDetector[2 + 2 * this.otherOccultingBodies.size()];
        detectors[0] = new UmbraDetector();
        detectors[1] = new PenumbraDetector();
        int i = 2;
        for (Map.Entry<ExtendedPVCoordinatesProvider, Double> entry : this.otherOccultingBodies.entrySet()) {
            detectors[i] = new GeneralUmbraDetector(entry.getKey(), entry.getValue());
            detectors[i + 1] = new GeneralPenumbraDetector(entry.getKey(), entry.getValue());
            i += 2;
        }
        return Stream.of(detectors);
    }

    @Override
    public <T extends CalculusFieldElement<T>> Stream<FieldEventDetector<T>> getFieldEventsDetectors(Field<T> field) {
        CalculusFieldElement zero = (CalculusFieldElement)field.getZero();
        FieldEventDetector[] detectors = (FieldEventDetector[])Array.newInstance(FieldEventDetector.class, 2 + 2 * this.otherOccultingBodies.size());
        detectors[0] = new FieldUmbraDetector<T>(field);
        detectors[1] = new FieldPenumbraDetector<T>(field);
        int i = 2;
        for (Map.Entry<ExtendedPVCoordinatesProvider, Double> entry : this.otherOccultingBodies.entrySet()) {
            detectors[i] = new FieldGeneralUmbraDetector(this, field, entry.getKey(), (CalculusFieldElement)zero.newInstance(entry.getValue().doubleValue()));
            detectors[i + 1] = new FieldGeneralPenumbraDetector(this, field, entry.getKey(), (CalculusFieldElement)zero.newInstance(entry.getValue().doubleValue()));
            i += 2;
        }
        return Stream.of(detectors);
    }

    protected double[] getEclipseAngles(Vector3D sunPosition, Vector3D position) {
        double[] angle = new double[3];
        Vector3D satSunVector = sunPosition.subtract((Vector)position);
        angle[0] = Vector3D.angle((Vector3D)satSunVector, (Vector3D)position.negate());
        double r = position.getNorm();
        if (r <= this.equatorialRadius) {
            throw new OrekitException((Localizable)OrekitMessages.TRAJECTORY_INSIDE_BRILLOUIN_SPHERE, r);
        }
        angle[1] = FastMath.asin((double)(this.equatorialRadius / r));
        angle[2] = FastMath.asin((double)(6.955E8 / satSunVector.getNorm()));
        return angle;
    }

    protected double[] getGeneralEclipseAngles(Vector3D position, Vector3D occultingPosition, double occultingRadius, Vector3D occultedPosition, double occultedRadius) {
        double[] angle = new double[3];
        Vector3D satOccultedVector = occultedPosition.subtract((Vector)position);
        Vector3D satOccultingVector = occultingPosition.subtract((Vector)position);
        angle[0] = Vector3D.angle((Vector3D)satOccultedVector, (Vector3D)satOccultingVector);
        angle[1] = FastMath.asin((double)(occultingRadius / satOccultingVector.getNorm()));
        angle[2] = FastMath.asin((double)(occultedRadius / satOccultedVector.getNorm()));
        return angle;
    }

    protected <T extends CalculusFieldElement<T>> T[] getEclipseAngles(FieldVector3D<T> sunPosition, FieldVector3D<T> position) {
        CalculusFieldElement[] angle = (CalculusFieldElement[])MathArrays.buildArray((Field)position.getX().getField(), (int)3);
        FieldVector3D mP = position.negate();
        FieldVector3D satSunVector = mP.add(sunPosition);
        angle[0] = FieldVector3D.angle((FieldVector3D)satSunVector, (FieldVector3D)mP);
        CalculusFieldElement r = position.getNorm();
        if (r.getReal() <= this.equatorialRadius) {
            throw new OrekitException((Localizable)OrekitMessages.TRAJECTORY_INSIDE_BRILLOUIN_SPHERE, r);
        }
        angle[1] = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)r.reciprocal()).multiply(this.equatorialRadius)).asin();
        angle[2] = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)satSunVector.getNorm().reciprocal()).multiply(6.955E8)).asin();
        return angle;
    }

    protected <T extends CalculusFieldElement<T>> T[] getGeneralEclipseAngles(FieldVector3D<T> position, FieldVector3D<T> occultingPosition, T occultingRadius, FieldVector3D<T> occultedPosition, T occultedRadius) {
        CalculusFieldElement[] angle = (CalculusFieldElement[])MathArrays.buildArray((Field)position.getX().getField(), (int)3);
        FieldVector3D satOccultedVector = occultedPosition.subtract(position);
        FieldVector3D satOccultingVector = occultingPosition.subtract(position);
        angle[0] = FieldVector3D.angle((FieldVector3D)satOccultedVector, (FieldVector3D)satOccultingVector);
        angle[1] = (CalculusFieldElement)((CalculusFieldElement)occultingRadius.divide((FieldElement)satOccultingVector.getNorm())).asin();
        angle[2] = (CalculusFieldElement)((CalculusFieldElement)occultedRadius.divide((FieldElement)satOccultedVector.getNorm())).asin();
        return angle;
    }

    public void addOccultingBody(ExtendedPVCoordinatesProvider provider, double radius) {
        this.otherOccultingBodies.put(provider, radius);
    }

    public Map<ExtendedPVCoordinatesProvider, Double> getOtherOccultingBodies() {
        return this.otherOccultingBodies;
    }

    public double getEquatorialRadius() {
        return this.equatorialRadius;
    }

    private static class FieldGeneralPenumbraDetector<T extends CalculusFieldElement<T>>
    extends FieldAbstractDetector<FieldGeneralPenumbraDetector<T>, T> {
        private ExtendedPVCoordinatesProvider provider;
        private T radius;
        final /* synthetic */ AbstractRadiationForceModel this$0;

        FieldGeneralPenumbraDetector(Field<T> field, ExtendedPVCoordinatesProvider provider, T radius) {
            this.this$0 = var1_1;
            super((CalculusFieldElement)((CalculusFieldElement)field.getZero()).add(60.0), (CalculusFieldElement)((CalculusFieldElement)field.getZero()).add(0.001), 100, new FieldEventHandler<FieldGeneralPenumbraDetector<T>, T>(){

                @Override
                public Action eventOccurred(FieldSpacecraftState<T> s, FieldGeneralPenumbraDetector<T> detector, boolean increasing) {
                    return Action.RESET_DERIVATIVES;
                }
            });
            this.provider = provider;
            this.radius = radius;
        }

        private FieldGeneralPenumbraDetector(T maxCheck, T threshold, int maxIter, FieldEventHandler<? super FieldGeneralPenumbraDetector<T>, T> handler) {
            this.this$0 = var1_1;
            super(maxCheck, threshold, maxIter, handler);
        }

        @Override
        protected FieldGeneralPenumbraDetector<T> create(T newMaxCheck, T newThreshold, int newMaxIter, FieldEventHandler<? super FieldGeneralPenumbraDetector<T>, T> newHandler) {
            return new FieldGeneralPenumbraDetector(this.this$0, newMaxCheck, newThreshold, newMaxIter, newHandler);
        }

        @Override
        public T g(FieldSpacecraftState<T> s) {
            CalculusFieldElement[] angle = this.this$0.getGeneralEclipseAngles(s.getPVCoordinates().getPosition(), this.provider.getPVCoordinates(s.getDate(), s.getFrame()).getPosition(), (CalculusFieldElement)this.radius, this.this$0.sun.getPVCoordinates(s.getDate(), s.getFrame()).getPosition(), (CalculusFieldElement)((CalculusFieldElement)s.getA().getField().getZero()).add(6.955E8));
            return (T)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)angle[0].subtract((FieldElement)angle[1])).subtract((FieldElement)angle[2])).add(1.0E-10));
        }
    }

    private static class FieldGeneralUmbraDetector<T extends CalculusFieldElement<T>>
    extends FieldAbstractDetector<FieldGeneralUmbraDetector<T>, T> {
        private ExtendedPVCoordinatesProvider provider;
        private T radius;
        final /* synthetic */ AbstractRadiationForceModel this$0;

        FieldGeneralUmbraDetector(Field<T> field, ExtendedPVCoordinatesProvider provider, T radius) {
            this.this$0 = var1_1;
            super((CalculusFieldElement)((CalculusFieldElement)field.getZero()).add(60.0), (CalculusFieldElement)((CalculusFieldElement)field.getZero()).add(0.001), 100, new FieldEventHandler<FieldGeneralUmbraDetector<T>, T>(){

                @Override
                public Action eventOccurred(FieldSpacecraftState<T> s, FieldGeneralUmbraDetector<T> detector, boolean increasing) {
                    return Action.RESET_DERIVATIVES;
                }
            });
            this.provider = provider;
            this.radius = radius;
        }

        private FieldGeneralUmbraDetector(T maxCheck, T threshold, int maxIter, FieldEventHandler<? super FieldGeneralUmbraDetector<T>, T> handler) {
            this.this$0 = var1_1;
            super(maxCheck, threshold, maxIter, handler);
        }

        @Override
        protected FieldGeneralUmbraDetector<T> create(T newMaxCheck, T newThreshold, int newMaxIter, FieldEventHandler<? super FieldGeneralUmbraDetector<T>, T> newHandler) {
            return new FieldGeneralUmbraDetector(this.this$0, newMaxCheck, newThreshold, newMaxIter, newHandler);
        }

        @Override
        public T g(FieldSpacecraftState<T> s) {
            CalculusFieldElement[] angle = this.this$0.getGeneralEclipseAngles(s.getPVCoordinates().getPosition(), this.provider.getPVCoordinates(s.getDate(), s.getFrame()).getPosition(), (CalculusFieldElement)this.radius, this.this$0.sun.getPVCoordinates(s.getDate(), s.getFrame()).getPosition(), (CalculusFieldElement)((CalculusFieldElement)s.getA().getField().getZero()).add(6.955E8));
            return (T)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)angle[0].subtract((FieldElement)angle[1])).add((FieldElement)angle[2])).subtract(1.0E-10));
        }
    }

    private class GeneralPenumbraDetector
    extends AbstractDetector<GeneralPenumbraDetector> {
        private ExtendedPVCoordinatesProvider provider;
        private double radius;

        GeneralPenumbraDetector(ExtendedPVCoordinatesProvider provider, double radius) {
            super(60.0, 0.001, 100, new EventHandler<GeneralPenumbraDetector>(){

                @Override
                public Action eventOccurred(SpacecraftState s, GeneralPenumbraDetector detector, boolean increasing) {
                    return Action.RESET_DERIVATIVES;
                }
            });
            this.provider = provider;
            this.radius = radius;
        }

        private GeneralPenumbraDetector(double maxCheck, double threshold, int maxIter, EventHandler<? super GeneralPenumbraDetector> handler) {
            super(maxCheck, threshold, maxIter, handler);
        }

        @Override
        protected GeneralPenumbraDetector create(double newMaxCheck, double newThreshold, int newMaxIter, EventHandler<? super GeneralPenumbraDetector> newHandler) {
            return new GeneralPenumbraDetector(newMaxCheck, newThreshold, newMaxIter, newHandler);
        }

        @Override
        public double g(SpacecraftState s) {
            double[] angle = AbstractRadiationForceModel.this.getGeneralEclipseAngles(s.getPVCoordinates().getPosition(), this.provider.getPVCoordinates(s.getDate(), s.getFrame()).getPosition(), this.radius, AbstractRadiationForceModel.this.sun.getPVCoordinates(s.getDate(), s.getFrame()).getPosition(), 6.955E8);
            return angle[0] - angle[1] - angle[2] + 1.0E-10;
        }
    }

    private class GeneralUmbraDetector
    extends AbstractDetector<GeneralUmbraDetector> {
        private ExtendedPVCoordinatesProvider provider;
        private double radius;

        GeneralUmbraDetector(ExtendedPVCoordinatesProvider provider, double radius) {
            super(60.0, 0.001, 100, new EventHandler<GeneralUmbraDetector>(){

                @Override
                public Action eventOccurred(SpacecraftState s, GeneralUmbraDetector detector, boolean increasing) {
                    return Action.RESET_DERIVATIVES;
                }
            });
            this.provider = provider;
            this.radius = radius;
        }

        private GeneralUmbraDetector(double maxCheck, double threshold, int maxIter, EventHandler<? super GeneralUmbraDetector> handler) {
            super(maxCheck, threshold, maxIter, handler);
        }

        @Override
        protected GeneralUmbraDetector create(double newMaxCheck, double newThreshold, int newMaxIter, EventHandler<? super GeneralUmbraDetector> newHandler) {
            return new GeneralUmbraDetector(newMaxCheck, newThreshold, newMaxIter, newHandler);
        }

        @Override
        public double g(SpacecraftState s) {
            double[] angle = AbstractRadiationForceModel.this.getGeneralEclipseAngles(s.getPVCoordinates().getPosition(), this.provider.getPVCoordinates(s.getDate(), s.getFrame()).getPosition(), this.radius, AbstractRadiationForceModel.this.sun.getPVCoordinates(s.getDate(), s.getFrame()).getPosition(), 6.955E8);
            return angle[0] - angle[1] + angle[2] - 1.0E-10;
        }
    }

    private class FieldPenumbraDetector<T extends CalculusFieldElement<T>>
    extends FieldAbstractDetector<FieldPenumbraDetector<T>, T> {
        FieldPenumbraDetector(Field<T> field) {
            super((CalculusFieldElement)((CalculusFieldElement)field.getZero()).add(60.0), (CalculusFieldElement)((CalculusFieldElement)field.getZero()).add(0.001), 100, new FieldEventHandler<FieldPenumbraDetector<T>, T>(){

                @Override
                public Action eventOccurred(FieldSpacecraftState<T> s, FieldPenumbraDetector<T> detector, boolean increasing) {
                    return Action.RESET_DERIVATIVES;
                }
            });
        }

        private FieldPenumbraDetector(T maxCheck, T threshold, int maxIter, FieldEventHandler<? super FieldPenumbraDetector<T>, T> handler) {
            super(maxCheck, threshold, maxIter, handler);
        }

        @Override
        protected FieldPenumbraDetector<T> create(T newMaxCheck, T newThreshold, int newMaxIter, FieldEventHandler<? super FieldPenumbraDetector<T>, T> newHandler) {
            return new FieldPenumbraDetector(AbstractRadiationForceModel.this, newMaxCheck, newThreshold, newMaxIter, newHandler);
        }

        @Override
        public T g(FieldSpacecraftState<T> s) {
            CalculusFieldElement[] angle = AbstractRadiationForceModel.this.getEclipseAngles(AbstractRadiationForceModel.this.sun.getPVCoordinates(s.getDate(), s.getFrame()).getPosition(), s.getPVCoordinates().getPosition());
            return (T)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)angle[0].subtract((FieldElement)angle[1])).subtract((FieldElement)angle[2])).add(1.0E-10));
        }
    }

    private class FieldUmbraDetector<T extends CalculusFieldElement<T>>
    extends FieldAbstractDetector<FieldUmbraDetector<T>, T> {
        FieldUmbraDetector(Field<T> field) {
            super((CalculusFieldElement)((CalculusFieldElement)field.getZero()).add(60.0), (CalculusFieldElement)((CalculusFieldElement)field.getZero()).add(0.001), 100, new FieldEventHandler<FieldUmbraDetector<T>, T>(){

                @Override
                public Action eventOccurred(FieldSpacecraftState<T> s, FieldUmbraDetector<T> detector, boolean increasing) {
                    return Action.RESET_DERIVATIVES;
                }
            });
        }

        private FieldUmbraDetector(T maxCheck, T threshold, int maxIter, FieldEventHandler<? super FieldUmbraDetector<T>, T> handler) {
            super(maxCheck, threshold, maxIter, handler);
        }

        @Override
        protected FieldUmbraDetector<T> create(T newMaxCheck, T newThreshold, int newMaxIter, FieldEventHandler<? super FieldUmbraDetector<T>, T> newHandler) {
            return new FieldUmbraDetector(AbstractRadiationForceModel.this, newMaxCheck, newThreshold, newMaxIter, newHandler);
        }

        @Override
        public T g(FieldSpacecraftState<T> s) {
            CalculusFieldElement[] angle = AbstractRadiationForceModel.this.getEclipseAngles(AbstractRadiationForceModel.this.sun.getPVCoordinates(s.getDate(), s.getFrame()).getPosition(), s.getPVCoordinates().getPosition());
            return (T)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)angle[0].subtract((FieldElement)angle[1])).add((FieldElement)angle[2])).subtract(1.0E-10));
        }
    }

    private class PenumbraDetector
    extends AbstractDetector<PenumbraDetector> {
        PenumbraDetector() {
            super(60.0, 0.001, 100, new EventHandler<PenumbraDetector>(){

                @Override
                public Action eventOccurred(SpacecraftState s, PenumbraDetector detector, boolean increasing) {
                    return Action.RESET_DERIVATIVES;
                }
            });
        }

        private PenumbraDetector(double maxCheck, double threshold, int maxIter, EventHandler<? super PenumbraDetector> handler) {
            super(maxCheck, threshold, maxIter, handler);
        }

        @Override
        protected PenumbraDetector create(double newMaxCheck, double newThreshold, int newMaxIter, EventHandler<? super PenumbraDetector> newHandler) {
            return new PenumbraDetector(newMaxCheck, newThreshold, newMaxIter, newHandler);
        }

        @Override
        public double g(SpacecraftState s) {
            double[] angle = AbstractRadiationForceModel.this.getEclipseAngles(AbstractRadiationForceModel.this.sun.getPVCoordinates(s.getDate(), s.getFrame()).getPosition(), s.getPVCoordinates().getPosition());
            return angle[0] - angle[1] - angle[2] + 1.0E-10;
        }
    }

    private class UmbraDetector
    extends AbstractDetector<UmbraDetector> {
        UmbraDetector() {
            super(60.0, 0.001, 100, new EventHandler<UmbraDetector>(){

                @Override
                public Action eventOccurred(SpacecraftState s, UmbraDetector detector, boolean increasing) {
                    return Action.RESET_DERIVATIVES;
                }
            });
        }

        private UmbraDetector(double maxCheck, double threshold, int maxIter, EventHandler<? super UmbraDetector> handler) {
            super(maxCheck, threshold, maxIter, handler);
        }

        @Override
        protected UmbraDetector create(double newMaxCheck, double newThreshold, int newMaxIter, EventHandler<? super UmbraDetector> newHandler) {
            return new UmbraDetector(newMaxCheck, newThreshold, newMaxIter, newHandler);
        }

        @Override
        public double g(SpacecraftState s) {
            double[] angle = AbstractRadiationForceModel.this.getEclipseAngles(AbstractRadiationForceModel.this.sun.getPVCoordinates(s.getDate(), s.getFrame()).getPosition(), s.getPVCoordinates().getPosition());
            return angle[0] - angle[1] + angle[2] - 1.0E-10;
        }
    }
}

