/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.forces.gravity.potential;

import org.orekit.forces.gravity.potential.RawSphericalHarmonicsProvider;
import org.orekit.forces.gravity.potential.TideSystem;
import org.orekit.time.AbsoluteDate;

class SecularTrendSphericalHarmonics
implements RawSphericalHarmonicsProvider {
    private final RawSphericalHarmonicsProvider provider;
    private final AbsoluteDate referenceDate;
    private final double[][] cTrend;
    private final double[][] sTrend;

    SecularTrendSphericalHarmonics(RawSphericalHarmonicsProvider provider, AbsoluteDate referenceDate, double[][] cTrend, double[][] sTrend) {
        this.provider = provider;
        this.referenceDate = referenceDate;
        this.cTrend = cTrend;
        this.sTrend = sTrend;
    }

    @Override
    public int getMaxDegree() {
        return this.provider.getMaxDegree();
    }

    @Override
    public int getMaxOrder() {
        return this.provider.getMaxOrder();
    }

    @Override
    public double getMu() {
        return this.provider.getMu();
    }

    @Override
    public double getAe() {
        return this.provider.getAe();
    }

    @Override
    public AbsoluteDate getReferenceDate() {
        return this.referenceDate;
    }

    @Override
    public double getOffset(AbsoluteDate date) {
        return date.durationFrom(this.referenceDate);
    }

    @Override
    public TideSystem getTideSystem() {
        return this.provider.getTideSystem();
    }

    @Override
    public RawSphericalHarmonicsProvider.RawSphericalHarmonics onDate(final AbsoluteDate date) {
        final RawSphericalHarmonicsProvider.RawSphericalHarmonics harmonics = this.provider.onDate(date);
        final double dateOffset = this.getOffset(date);
        return new RawSphericalHarmonicsProvider.RawSphericalHarmonics(){

            @Override
            public AbsoluteDate getDate() {
                return date;
            }

            @Override
            public double getRawCnm(int n, int m) {
                double cnm = harmonics.getRawCnm(n, m);
                if (n < SecularTrendSphericalHarmonics.this.cTrend.length && m < SecularTrendSphericalHarmonics.this.cTrend[n].length) {
                    cnm += dateOffset * SecularTrendSphericalHarmonics.this.cTrend[n][m];
                }
                return cnm;
            }

            @Override
            public double getRawSnm(int n, int m) {
                double snm = harmonics.getRawSnm(n, m);
                if (n < SecularTrendSphericalHarmonics.this.sTrend.length && m < SecularTrendSphericalHarmonics.this.sTrend[n].length) {
                    snm += dateOffset * SecularTrendSphericalHarmonics.this.sTrend[n][m];
                }
                return snm;
            }
        };
    }
}

