/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.forces.gravity;

import org.hipparchus.CalculusFieldElement;
import org.hipparchus.analysis.differentiation.Gradient;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.orekit.bodies.CelestialBody;
import org.orekit.forces.gravity.ThirdBodyAttraction;
import org.orekit.propagation.SpacecraftState;

public class ThirdBodyAttractionEpoch
extends ThirdBodyAttraction {
    private final CelestialBody body;

    public ThirdBodyAttractionEpoch(CelestialBody body) {
        super(body);
        this.body = body;
    }

    private FieldVector3D<Gradient> accelerationToEpoch(SpacecraftState s, double[] parameters) {
        double gm = parameters[0];
        Vector3D centralToBody = this.body.getPVCoordinates(s.getDate(), s.getFrame()).getPosition();
        double rx = centralToBody.getX();
        double ry = centralToBody.getY();
        double rz = centralToBody.getZ();
        int freeParameters = 3;
        Gradient fpx = Gradient.variable((int)3, (int)0, (double)rx);
        Gradient fpy = Gradient.variable((int)3, (int)1, (double)ry);
        Gradient fpz = Gradient.variable((int)3, (int)2, (double)rz);
        FieldVector3D centralToBodyFV = new FieldVector3D((CalculusFieldElement[])new Gradient[]{fpx, fpy, fpz});
        Gradient r2Central = (Gradient)centralToBodyFV.getNormSq();
        FieldVector3D satToBody = centralToBodyFV.subtract(s.getPVCoordinates().getPosition());
        Gradient r2Sat = (Gradient)satToBody.getNormSq();
        return new FieldVector3D(gm, satToBody.scalarMultiply((CalculusFieldElement)r2Sat.multiply(r2Sat.sqrt()).reciprocal()), -gm, centralToBodyFV.scalarMultiply((CalculusFieldElement)r2Central.multiply(r2Central.sqrt()).reciprocal()));
    }

    public double[] getDerivativesToEpoch(SpacecraftState s, double[] parameters) {
        FieldVector3D<Gradient> acc = this.accelerationToEpoch(s, parameters);
        Vector3D centralToBodyVelocity = this.body.getPVCoordinates(s.getDate(), s.getFrame()).getVelocity();
        double[] dAccxdR1i = ((Gradient)acc.getX()).getGradient();
        double[] dAccydR1i = ((Gradient)acc.getY()).getGradient();
        double[] dAcczdR1i = ((Gradient)acc.getZ()).getGradient();
        double[] v = centralToBodyVelocity.toArray();
        return new double[]{dAccxdR1i[0] * v[0] + dAccxdR1i[0] * v[1] + dAccxdR1i[0] * v[2], dAccydR1i[0] * v[0] + dAccydR1i[0] * v[1] + dAccydR1i[0] * v[2], dAcczdR1i[0] * v[0] + dAcczdR1i[0] * v[1] + dAcczdR1i[0] * v[2]};
    }
}

