/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.forces.gravity;

import java.util.List;
import java.util.stream.Stream;
import org.hipparchus.CalculusFieldElement;
import org.hipparchus.Field;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.orekit.annotation.DefaultDataContext;
import org.orekit.data.DataContext;
import org.orekit.forces.AbstractForceModel;
import org.orekit.forces.ForceModel;
import org.orekit.forces.gravity.HolmesFeatherstoneAttractionModel;
import org.orekit.forces.gravity.OceanTidesField;
import org.orekit.forces.gravity.potential.CachedNormalizedSphericalHarmonicsProvider;
import org.orekit.forces.gravity.potential.GravityFields;
import org.orekit.forces.gravity.potential.NormalizedSphericalHarmonicsProvider;
import org.orekit.forces.gravity.potential.OceanTidesWave;
import org.orekit.frames.Frame;
import org.orekit.propagation.FieldSpacecraftState;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.events.EventDetector;
import org.orekit.propagation.events.FieldEventDetector;
import org.orekit.time.TimeScales;
import org.orekit.time.UT1Scale;
import org.orekit.utils.IERSConventions;
import org.orekit.utils.OrekitConfiguration;
import org.orekit.utils.ParameterDriver;

public class OceanTides
extends AbstractForceModel {
    public static final double DEFAULT_STEP = 600.0;
    public static final int DEFAULT_POINTS = 12;
    private final ForceModel attractionModel;

    @DefaultDataContext
    public OceanTides(Frame centralBodyFrame, double ae, double mu, int degree, int order, IERSConventions conventions, UT1Scale ut1) {
        this(centralBodyFrame, ae, mu, true, 600.0, 12, degree, order, conventions, ut1);
    }

    @DefaultDataContext
    public OceanTides(Frame centralBodyFrame, double ae, double mu, boolean poleTide, double step, int nbPoints, int degree, int order, IERSConventions conventions, UT1Scale ut1) {
        this(centralBodyFrame, ae, mu, poleTide, step, nbPoints, degree, order, conventions, ut1, DataContext.getDefault().getGravityFields());
    }

    public OceanTides(Frame centralBodyFrame, double ae, double mu, boolean poleTide, double step, int nbPoints, int degree, int order, IERSConventions conventions, UT1Scale ut1, GravityFields gravityFields) {
        List<OceanTidesWave> waves = gravityFields.getOceanTidesWaves(degree, order);
        TimeScales timeScales = ut1.getEOPHistory().getTimeScales();
        OceanTidesField raw = new OceanTidesField(ae, mu, waves, conventions.getNutationArguments(ut1, timeScales), poleTide ? conventions.getOceanPoleTide(ut1.getEOPHistory()) : null);
        NormalizedSphericalHarmonicsProvider provider = nbPoints < 2 ? raw : new CachedNormalizedSphericalHarmonicsProvider(raw, step, nbPoints, OrekitConfiguration.getCacheSlotsNumber(), 604800.0, 43200.0);
        this.attractionModel = new HolmesFeatherstoneAttractionModel(centralBodyFrame, provider);
    }

    @Override
    public boolean dependsOnPositionOnly() {
        return this.attractionModel.dependsOnPositionOnly();
    }

    @Override
    public Vector3D acceleration(SpacecraftState s, double[] parameters) {
        return this.attractionModel.acceleration(s, parameters);
    }

    @Override
    public <T extends CalculusFieldElement<T>> FieldVector3D<T> acceleration(FieldSpacecraftState<T> s, T[] parameters) {
        return this.attractionModel.acceleration(s, (CalculusFieldElement[])parameters);
    }

    @Override
    public Stream<EventDetector> getEventsDetectors() {
        return this.attractionModel.getEventsDetectors();
    }

    @Override
    public <T extends CalculusFieldElement<T>> Stream<FieldEventDetector<T>> getFieldEventsDetectors(Field<T> field) {
        return this.attractionModel.getFieldEventsDetectors(field);
    }

    @Override
    public List<ParameterDriver> getParametersDrivers() {
        return this.attractionModel.getParametersDrivers();
    }
}

