/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.forces.empirical;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.NavigableSet;
import java.util.stream.Stream;
import org.hipparchus.CalculusFieldElement;
import org.hipparchus.Field;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.hipparchus.util.MathArrays;
import org.orekit.attitudes.Attitude;
import org.orekit.attitudes.AttitudeProvider;
import org.orekit.attitudes.FieldAttitude;
import org.orekit.forces.AbstractForceModel;
import org.orekit.forces.empirical.AccelerationModel;
import org.orekit.propagation.FieldSpacecraftState;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.events.EventDetector;
import org.orekit.propagation.events.FieldEventDetector;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.utils.ParameterDriver;
import org.orekit.utils.TimeSpanMap;

public class TimeSpanParametricAcceleration
extends AbstractForceModel {
    public static final String DATE_BEFORE = " - Before ";
    public static final String DATE_AFTER = " - After ";
    private final Vector3D direction;
    private final boolean isInertial;
    private final AttitudeProvider attitudeOverride;
    private final TimeSpanMap<AccelerationModel> accelerationModelTimeSpanMap;

    public TimeSpanParametricAcceleration(Vector3D direction, boolean isInertial, AccelerationModel accelerationModel) {
        this(direction, isInertial, null, accelerationModel);
    }

    public TimeSpanParametricAcceleration(Vector3D direction, AttitudeProvider attitudeOverride, AccelerationModel accelerationModel) {
        this(direction, false, attitudeOverride, accelerationModel);
    }

    private TimeSpanParametricAcceleration(Vector3D direction, boolean isInertial, AttitudeProvider attitudeOverride, AccelerationModel accelerationModel) {
        this.direction = direction;
        this.isInertial = isInertial;
        this.attitudeOverride = attitudeOverride;
        this.accelerationModelTimeSpanMap = new TimeSpanMap<AccelerationModel>(accelerationModel);
    }

    @Override
    public void init(SpacecraftState initialState, AbsoluteDate target) {
        this.accelerationModelTimeSpanMap.forEach(accelerationModel -> accelerationModel.init(initialState, target));
    }

    public void addAccelerationModelValidBefore(AccelerationModel accelerationModel, AbsoluteDate latestValidityDate) {
        this.accelerationModelTimeSpanMap.addValidBefore(accelerationModel, latestValidityDate);
    }

    public void addAccelerationModelValidAfter(AccelerationModel accelerationModel, AbsoluteDate earliestValidityDate) {
        this.accelerationModelTimeSpanMap.addValidAfter(accelerationModel, earliestValidityDate);
    }

    public AccelerationModel getAccelerationModel(AbsoluteDate date) {
        return this.accelerationModelTimeSpanMap.get(date);
    }

    public TimeSpanMap.Span<AccelerationModel> getAccelerationModelSpan(AbsoluteDate date) {
        return this.accelerationModelTimeSpanMap.getSpan(date);
    }

    public TimeSpanMap<AccelerationModel> extractAccelerationModelRange(AbsoluteDate start, AbsoluteDate end) {
        return this.accelerationModelTimeSpanMap.extractRange(start, end);
    }

    public NavigableSet<TimeSpanMap.Transition<AccelerationModel>> getTransitions() {
        return this.accelerationModelTimeSpanMap.getTransitions();
    }

    @Override
    public boolean dependsOnPositionOnly() {
        return this.isInertial;
    }

    @Override
    public Vector3D acceleration(SpacecraftState state, double[] parameters) {
        Vector3D inertialDirection;
        AbsoluteDate date = state.getDate();
        if (this.isInertial) {
            inertialDirection = this.direction;
        } else {
            Attitude attitude = this.attitudeOverride == null ? state.getAttitude() : this.attitudeOverride.getAttitude(state.getOrbit(), date, state.getFrame());
            inertialDirection = attitude.getRotation().applyInverseTo(this.direction);
        }
        double[] extractedParameters = this.extractParameters(parameters, date);
        return new Vector3D(this.getAccelerationModel(date).signedAmplitude(state, extractedParameters), inertialDirection);
    }

    @Override
    public <T extends CalculusFieldElement<T>> FieldVector3D<T> acceleration(FieldSpacecraftState<T> state, T[] parameters) {
        FieldVector3D inertialDirection;
        FieldAbsoluteDate<T> date = state.getDate();
        if (this.isInertial) {
            inertialDirection = new FieldVector3D(state.getDate().getField(), this.direction);
        } else {
            FieldAttitude<T> attitude = this.attitudeOverride == null ? state.getAttitude() : this.attitudeOverride.getAttitude(state.getOrbit(), date, state.getFrame());
            inertialDirection = attitude.getRotation().applyInverseTo(this.direction);
        }
        CalculusFieldElement[] extractedParameters = this.extractParameters((CalculusFieldElement[])parameters, date);
        return new FieldVector3D(this.getAccelerationModel(date.toAbsoluteDate()).signedAmplitude(state, extractedParameters), inertialDirection);
    }

    @Override
    public Stream<EventDetector> getEventsDetectors() {
        return Stream.empty();
    }

    @Override
    public <T extends CalculusFieldElement<T>> Stream<FieldEventDetector<T>> getFieldEventsDetectors(Field<T> field) {
        return Stream.empty();
    }

    @Override
    public List<ParameterDriver> getParametersDrivers() {
        ArrayList<ParameterDriver> listParameterDrivers = new ArrayList<ParameterDriver>();
        NavigableSet<TimeSpanMap.Transition<AccelerationModel>> accelerationModelTransitions = this.getTransitions();
        for (TimeSpanMap.Transition<AccelerationModel> transition : accelerationModelTransitions) {
            for (ParameterDriver driver : transition.getBefore().getParametersDrivers()) {
                if (this.findByName(listParameterDrivers, driver.getName())) continue;
                listParameterDrivers.add(driver);
            }
        }
        for (ParameterDriver driver : ((AccelerationModel)((TimeSpanMap.Transition)accelerationModelTransitions.last()).getAfter()).getParametersDrivers()) {
            if (this.findByName(listParameterDrivers, driver.getName())) continue;
            listParameterDrivers.add(driver);
        }
        return Collections.unmodifiableList(listParameterDrivers);
    }

    public double[] extractParameters(double[] parameters, AbsoluteDate date) {
        List<ParameterDriver> empiricalParameterDriver = this.getAccelerationModel(date).getParametersDrivers();
        List<ParameterDriver> allParameters = this.getParametersDrivers();
        double[] outParameters = new double[empiricalParameterDriver.size()];
        int index = 0;
        for (int i = 0; i < allParameters.size(); ++i) {
            String driverName = allParameters.get(i).getName();
            for (ParameterDriver accDriver : empiricalParameterDriver) {
                if (!accDriver.getName().equals(driverName)) continue;
                outParameters[index++] = parameters[i];
            }
        }
        return outParameters;
    }

    public <T extends CalculusFieldElement<T>> T[] extractParameters(T[] parameters, FieldAbsoluteDate<T> date) {
        List<ParameterDriver> empiricalParameterDriver = this.getAccelerationModel(date.toAbsoluteDate()).getParametersDrivers();
        List<ParameterDriver> allParameters = this.getParametersDrivers();
        CalculusFieldElement[] outParameters = (CalculusFieldElement[])MathArrays.buildArray(date.getField(), (int)empiricalParameterDriver.size());
        int index = 0;
        for (int i = 0; i < allParameters.size(); ++i) {
            String driverName = allParameters.get(i).getName();
            for (ParameterDriver accDriver : empiricalParameterDriver) {
                if (!accDriver.getName().equals(driverName)) continue;
                outParameters[index++] = parameters[i];
            }
        }
        return outParameters;
    }

    private boolean findByName(List<ParameterDriver> driversList, String name) {
        for (ParameterDriver d : driversList) {
            if (!d.getName().equals(name)) continue;
            return true;
        }
        return false;
    }
}

