/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.forces.drag;

import java.util.List;
import java.util.stream.Stream;
import org.hipparchus.CalculusFieldElement;
import org.hipparchus.Field;
import org.hipparchus.geometry.Vector;
import org.hipparchus.geometry.euclidean.threed.FieldRotation;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.orekit.forces.drag.AbstractDragForceModel;
import org.orekit.forces.drag.DragSensitive;
import org.orekit.frames.Frame;
import org.orekit.models.earth.atmosphere.Atmosphere;
import org.orekit.propagation.FieldSpacecraftState;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.events.EventDetector;
import org.orekit.propagation.events.FieldEventDetector;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.utils.ParameterDriver;

public class DragForce
extends AbstractDragForceModel {
    private final Atmosphere atmosphere;
    private final DragSensitive spacecraft;

    public DragForce(Atmosphere atmosphere, DragSensitive spacecraft) {
        super(atmosphere);
        this.atmosphere = atmosphere;
        this.spacecraft = spacecraft;
    }

    @Override
    public Vector3D acceleration(SpacecraftState s, double[] parameters) {
        AbsoluteDate date = s.getDate();
        Frame frame = s.getFrame();
        Vector3D position = s.getPVCoordinates().getPosition();
        double rho = this.atmosphere.getDensity(date, position, frame);
        Vector3D vAtm = this.atmosphere.getVelocity(date, position, frame);
        Vector3D relativeVelocity = vAtm.subtract((Vector)s.getPVCoordinates().getVelocity());
        return this.spacecraft.dragAcceleration(date, frame, position, s.getAttitude().getRotation(), s.getMass(), rho, relativeVelocity, parameters);
    }

    @Override
    public <T extends CalculusFieldElement<T>> FieldVector3D<T> acceleration(FieldSpacecraftState<T> s, T[] parameters) {
        FieldAbsoluteDate<T> date = s.getDate();
        Frame frame = s.getFrame();
        FieldVector3D position = s.getPVCoordinates().getPosition();
        Object rho = this.isGradientStateDerivative(s) ? this.getGradientDensityWrtStateUsingFiniteDifferences(date.toAbsoluteDate(), frame, position) : (this.isDSStateDerivative(s) ? this.getDSDensityWrtStateUsingFiniteDifferences(date.toAbsoluteDate(), frame, position) : this.atmosphere.getDensity(date, position, frame));
        FieldVector3D<T> vAtm = this.atmosphere.getVelocity(date, position, frame);
        FieldVector3D relativeVelocity = vAtm.subtract(s.getPVCoordinates().getVelocity());
        return this.spacecraft.dragAcceleration(date, frame, position, (FieldRotation)s.getAttitude().getRotation(), (CalculusFieldElement)s.getMass(), (CalculusFieldElement)rho, relativeVelocity, (CalculusFieldElement[])parameters);
    }

    @Override
    public List<ParameterDriver> getParametersDrivers() {
        return this.spacecraft.getDragParametersDrivers();
    }

    @Override
    public Stream<EventDetector> getEventsDetectors() {
        return Stream.empty();
    }

    @Override
    public <T extends CalculusFieldElement<T>> Stream<FieldEventDetector<T>> getFieldEventsDetectors(Field<T> field) {
        return Stream.empty();
    }

    public Atmosphere getAtmosphere() {
        return this.atmosphere;
    }

    public DragSensitive getSpacecraft() {
        return this.spacecraft;
    }
}

