/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.files.sinex;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.hipparchus.exception.DummyLocalizable;
import org.hipparchus.exception.Localizable;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.hipparchus.util.FastMath;
import org.orekit.annotation.DefaultDataContext;
import org.orekit.data.DataContext;
import org.orekit.data.DataLoader;
import org.orekit.data.DataProvidersManager;
import org.orekit.data.DataSource;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.files.sinex.Station;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.DateComponents;
import org.orekit.time.TimeScale;

public class SinexLoader {
    private static final Pattern SEPARATOR = Pattern.compile(":");
    private final Map<String, Station> stations;
    private final TimeScale utc;

    @DefaultDataContext
    public SinexLoader(String supportedNames) {
        this(supportedNames, DataContext.getDefault().getDataProvidersManager(), DataContext.getDefault().getTimeScales().getUTC());
    }

    public SinexLoader(String supportedNames, DataProvidersManager dataProvidersManager, TimeScale utc) {
        this.utc = utc;
        this.stations = new HashMap<String, Station>();
        dataProvidersManager.feed(supportedNames, new Parser());
    }

    @DefaultDataContext
    public SinexLoader(DataSource source) {
        this(source, DataContext.getDefault().getTimeScales().getUTC());
    }

    public SinexLoader(DataSource source, TimeScale utc) {
        try {
            this.utc = utc;
            this.stations = new HashMap<String, Station>();
            try (InputStream is = source.getOpener().openStreamOnce();
                 BufferedInputStream bis = new BufferedInputStream(is);){
                new Parser().loadData(bis, source.getName());
            }
        }
        catch (IOException | ParseException ioe) {
            throw new OrekitException(ioe, (Localizable)new DummyLocalizable(ioe.getMessage()), new Object[0]);
        }
    }

    public Map<String, Station> getStations() {
        return Collections.unmodifiableMap(this.stations);
    }

    public Station getStation(String siteCode) {
        return this.stations.get(siteCode);
    }

    private void addStation(Station station) {
        if (this.stations.get(station.getSiteCode()) == null) {
            this.stations.put(station.getSiteCode(), station);
        }
    }

    private AbsoluteDate stringEpochToAbsoluteDate(String stringDate) {
        String[] fields = SEPARATOR.split(stringDate);
        int twoDigitsYear = Integer.parseInt(fields[0]);
        int day = Integer.parseInt(fields[1]);
        int secInDay = Integer.parseInt(fields[2]);
        int year = twoDigitsYear > 50 ? 1900 + twoDigitsYear : 2000 + twoDigitsYear;
        return new AbsoluteDate(new DateComponents(year, 1, 1), this.utc).shiftedBy(86400.0 * (double)(day - 1)).shiftedBy(secInDay);
    }

    private class Parser
    implements DataLoader {
        private static final String COMMENT = "*";

        private Parser() {
        }

        @Override
        public boolean stillAcceptsData() {
            return true;
        }

        @Override
        public void loadData(InputStream input, String name) throws IOException, ParseException {
            int lineNumber = 0;
            String line = null;
            boolean inId = false;
            boolean inEcc = false;
            boolean inEpoch = false;
            boolean inEstimate = false;
            Vector3D position = Vector3D.ZERO;
            Vector3D velocity = Vector3D.ZERO;
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(input, StandardCharsets.UTF_8));){
                line = reader.readLine();
                while (line != null) {
                    ++lineNumber;
                    block15 : switch (line.trim()) {
                        case "+SITE/ID": {
                            inId = true;
                            break;
                        }
                        case "-SITE/ID": {
                            inId = false;
                            break;
                        }
                        case "+SITE/ECCENTRICITY": {
                            inEcc = true;
                            break;
                        }
                        case "-SITE/ECCENTRICITY": {
                            inEcc = false;
                            break;
                        }
                        case "+SOLUTION/EPOCHS": {
                            inEpoch = true;
                            break;
                        }
                        case "-SOLUTION/EPOCHS": {
                            inEpoch = false;
                            break;
                        }
                        case "+SOLUTION/ESTIMATE": {
                            inEstimate = true;
                            break;
                        }
                        case "-SOLUTION/ESTIMATE": {
                            inEstimate = false;
                            break;
                        }
                        default: {
                            Station station;
                            if (line.startsWith(COMMENT)) break;
                            if (inId) {
                                station = new Station();
                                station.setSiteCode(this.parseString(line, 1, 4));
                                station.setDomes(this.parseString(line, 9, 9));
                                SinexLoader.this.addStation(station);
                                break;
                            }
                            if (inEcc) {
                                station = SinexLoader.this.getStation(this.parseString(line, 1, 4));
                                if (station.getValidFrom() == null) {
                                    station.setValidFrom(SinexLoader.this.stringEpochToAbsoluteDate(this.parseString(line, 16, 12)));
                                    station.setValidUntil(SinexLoader.this.stringEpochToAbsoluteDate(this.parseString(line, 29, 12)));
                                }
                                station.setEccRefSystem(Station.ReferenceSystem.getEccRefSystem(this.parseString(line, 42, 3)));
                                station.setEccentricities(new Vector3D(this.parseDouble(line, 46, 8), this.parseDouble(line, 55, 8), this.parseDouble(line, 64, 8)));
                                break;
                            }
                            if (inEpoch) {
                                station = SinexLoader.this.getStation(this.parseString(line, 1, 4));
                                station.setValidFrom(SinexLoader.this.stringEpochToAbsoluteDate(this.parseString(line, 16, 12)));
                                station.setValidUntil(SinexLoader.this.stringEpochToAbsoluteDate(this.parseString(line, 29, 12)));
                                break;
                            }
                            if (!inEstimate || (station = SinexLoader.this.getStation(this.parseString(line, 14, 4))) == null) break;
                            switch (this.parseString(line, 7, 6)) {
                                case "STAX": {
                                    double x = this.parseDouble(line, 47, 22);
                                    position = new Vector3D(x, position.getY(), position.getZ());
                                    station.setPosition(position);
                                    break block15;
                                }
                                case "STAY": {
                                    double y = this.parseDouble(line, 47, 22);
                                    position = new Vector3D(position.getX(), y, position.getZ());
                                    station.setPosition(position);
                                    break block15;
                                }
                                case "STAZ": {
                                    double z = this.parseDouble(line, 47, 22);
                                    position = new Vector3D(position.getX(), position.getY(), z);
                                    station.setPosition(position);
                                    station.setEpoch(SinexLoader.this.stringEpochToAbsoluteDate(this.parseString(line, 27, 12)));
                                    position = Vector3D.ZERO;
                                    break block15;
                                }
                                case "VELX": {
                                    double vx = this.parseDouble(line, 47, 22) / 3.15576E7;
                                    velocity = new Vector3D(vx, velocity.getY(), velocity.getZ());
                                    station.setVelocity(velocity);
                                    break block15;
                                }
                                case "VELY": {
                                    double vy = this.parseDouble(line, 47, 22) / 3.15576E7;
                                    velocity = new Vector3D(velocity.getX(), vy, velocity.getZ());
                                    station.setVelocity(velocity);
                                    break block15;
                                }
                                case "VELZ": {
                                    double vz = this.parseDouble(line, 47, 22) / 3.15576E7;
                                    velocity = new Vector3D(velocity.getX(), velocity.getY(), vz);
                                    station.setVelocity(velocity);
                                    velocity = Vector3D.ZERO;
                                    break block15;
                                }
                            }
                        }
                    }
                    line = reader.readLine();
                }
            }
            catch (NumberFormatException nfe) {
                throw new OrekitException((Localizable)OrekitMessages.UNABLE_TO_PARSE_LINE_IN_FILE, lineNumber, name, line);
            }
        }

        private String parseString(String line, int start, int length) {
            return line.substring(start, FastMath.min((int)line.length(), (int)(start + length))).trim();
        }

        private double parseDouble(String line, int start, int length) {
            return Double.parseDouble(this.parseString(line, start, length));
        }
    }
}

