/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.files.ccsds.utils.generation;

import java.io.IOException;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hipparchus.exception.Localizable;
import org.hipparchus.fraction.Fraction;
import org.hipparchus.util.FastMath;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitInternalError;
import org.orekit.errors.OrekitMessages;
import org.orekit.files.ccsds.definitions.TimeConverter;
import org.orekit.files.ccsds.utils.generation.Generator;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.DateTimeComponents;
import org.orekit.utils.AccurateFormatter;
import org.orekit.utils.units.Parser;
import org.orekit.utils.units.PowerTerm;
import org.orekit.utils.units.Unit;

public abstract class AbstractGenerator
implements Generator {
    private static final char NEW_LINE = '\n';
    private final Appendable output;
    private final String outputName;
    private final boolean writeUnits;
    private final Deque<String> sections;
    private final Map<String, String> siToCcsds;

    public AbstractGenerator(Appendable output, String outputName, boolean writeUnits) {
        this.output = output;
        this.outputName = outputName;
        this.writeUnits = writeUnits;
        this.sections = new ArrayDeque<String>();
        this.siToCcsds = new HashMap<String, String>();
    }

    @Override
    public String getOutputName() {
        return this.outputName;
    }

    public boolean writeUnits(Unit unit) {
        return this.writeUnits && unit != null && !unit.getName().equals(Unit.NONE.getName()) && !unit.getName().equals(Unit.ONE.getName());
    }

    @Override
    public void close() throws IOException {
        while (!this.sections.isEmpty()) {
            this.exitSection();
        }
    }

    @Override
    public void newLine() throws IOException {
        this.output.append('\n');
    }

    @Override
    public void writeEntry(String key, List<String> value, boolean mandatory) throws IOException {
        if (value == null || value.isEmpty()) {
            this.complain(key, mandatory);
        } else {
            StringBuilder builder = new StringBuilder();
            boolean first = true;
            for (String v : value) {
                if (!first) {
                    builder.append(',');
                }
                builder.append(v);
                first = false;
            }
            this.writeEntry(key, builder.toString(), null, mandatory);
        }
    }

    @Override
    public void writeEntry(String key, Enum<?> value, boolean mandatory) throws IOException {
        this.writeEntry(key, value == null ? null : value.name(), null, mandatory);
    }

    @Override
    public void writeEntry(String key, TimeConverter converter, AbsoluteDate date, boolean mandatory) throws IOException {
        this.writeEntry(key, date == null ? (String)null : this.dateToString(converter, date), null, mandatory);
    }

    @Override
    public void writeEntry(String key, double value, Unit unit, boolean mandatory) throws IOException {
        this.writeEntry(key, this.doubleToString(unit.fromSI(value)), unit, mandatory);
    }

    @Override
    public void writeEntry(String key, Double value, Unit unit, boolean mandatory) throws IOException {
        this.writeEntry(key, value == null ? (String)null : this.doubleToString(unit.fromSI((double)value)), unit, mandatory);
    }

    @Override
    public void writeEntry(String key, char value, boolean mandatory) throws IOException {
        this.writeEntry(key, Character.toString(value), null, mandatory);
    }

    @Override
    public void writeEntry(String key, int value, boolean mandatory) throws IOException {
        this.writeEntry(key, Integer.toString(value), null, mandatory);
    }

    @Override
    public void writeRawData(char data) throws IOException {
        this.output.append(data);
    }

    @Override
    public void writeRawData(CharSequence data) throws IOException {
        this.output.append(data);
    }

    @Override
    public void enterSection(String name) throws IOException {
        this.sections.offerLast(name);
    }

    @Override
    public String exitSection() throws IOException {
        return this.sections.pollLast();
    }

    protected void complain(String key, boolean mandatory) {
        if (mandatory) {
            throw new OrekitException((Localizable)OrekitMessages.CCSDS_MISSING_KEYWORD, key, this.outputName);
        }
    }

    @Override
    public String doubleToString(double value) {
        return Double.isNaN(value) ? null : AccurateFormatter.format(value);
    }

    @Override
    public String dateToString(TimeConverter converter, AbsoluteDate date) {
        DateTimeComponents dt = converter.components(date);
        return this.dateToString(dt.getDate().getYear(), dt.getDate().getMonth(), dt.getDate().getDay(), dt.getTime().getHour(), dt.getTime().getMinute(), dt.getTime().getSecond());
    }

    @Override
    public String dateToString(int year, int month, int day, int hour, int minute, double seconds) {
        return AccurateFormatter.format(year, month, day, hour, minute, seconds);
    }

    @Override
    public String unitsListToString(List<Unit> units) {
        if (units == null || units.isEmpty()) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        builder.append('[');
        boolean first = true;
        for (Unit unit : units) {
            if (!first) {
                builder.append(',');
            }
            builder.append(this.siToCcsdsName(unit.getName()));
            first = false;
        }
        builder.append(']');
        return builder.toString();
    }

    @Override
    public String siToCcsdsName(String siName) {
        if (!this.siToCcsds.containsKey(siName)) {
            StringBuilder builder = new StringBuilder();
            List<PowerTerm> terms = Parser.buildTermsList(siName);
            if (terms == null) {
                builder.append("n/a");
            } else {
                boolean first = true;
                for (PowerTerm term : terms) {
                    if (term.getExponent().getNumerator() < 0) continue;
                    if (!first) {
                        builder.append('*');
                    }
                    this.appendScale(builder, term.getScale());
                    this.appendBase(builder, term.getBase());
                    this.appendExponent(builder, term.getExponent());
                    first = false;
                }
                if (first) {
                    builder.append('1');
                }
                for (PowerTerm term : terms) {
                    if (term.getExponent().getNumerator() >= 0) continue;
                    builder.append('/');
                    this.appendScale(builder, term.getScale());
                    this.appendBase(builder, term.getBase());
                    this.appendExponent(builder, term.getExponent().negate());
                }
            }
            this.siToCcsds.put(siName, builder.toString());
        }
        return this.siToCcsds.get(siName);
    }

    private void appendScale(StringBuilder builder, double scale) {
        int factor = (int)FastMath.rint((double)scale);
        if (FastMath.abs((double)(scale - (double)factor)) > 1.0E-12) {
            throw new OrekitInternalError(null);
        }
        if (factor != 1) {
            builder.append(factor);
        }
    }

    private void appendBase(StringBuilder builder, CharSequence base) {
        if ("\u00b0".equals(base) || "\u25e6".equals(base)) {
            builder.append("deg");
        } else {
            builder.append(base);
        }
    }

    private void appendExponent(StringBuilder builder, Fraction exponent) {
        if (!exponent.equals((Object)Fraction.ONE)) {
            builder.append("**");
            builder.append((Object)(exponent.equals((Object)Fraction.ONE_HALF) ? "0.5" : exponent));
        }
    }
}

