/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.files.ccsds.ndm.odm.oem;

import java.util.Collections;
import java.util.List;
import org.orekit.files.ccsds.ndm.odm.oem.OemSegment;
import org.orekit.files.general.EphemerisFile;
import org.orekit.time.AbsoluteDate;
import org.orekit.utils.TimeStampedPVCoordinates;

public class OemSatelliteEphemeris
implements EphemerisFile.SatelliteEphemeris<TimeStampedPVCoordinates, OemSegment> {
    private final String id;
    private final double mu;
    private final List<OemSegment> blocks;

    public OemSatelliteEphemeris(String id, double mu, List<OemSegment> blocks) {
        this.id = id;
        this.mu = mu;
        this.blocks = blocks;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public double getMu() {
        return this.mu;
    }

    @Override
    public List<OemSegment> getSegments() {
        return Collections.unmodifiableList(this.blocks);
    }

    @Override
    public AbsoluteDate getStart() {
        return this.blocks.get(0).getStart();
    }

    @Override
    public AbsoluteDate getStop() {
        return this.blocks.get(this.blocks.size() - 1).getStop();
    }
}

