/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.files.ccsds.ndm.odm.oem;

import org.orekit.files.ccsds.ndm.odm.CommonMetadata;
import org.orekit.files.ccsds.ndm.odm.oem.InterpolationMethod;
import org.orekit.files.ccsds.ndm.odm.oem.OemMetadataKey;
import org.orekit.time.AbsoluteDate;

public class OemMetadata
extends CommonMetadata {
    private AbsoluteDate startTime;
    private AbsoluteDate stopTime;
    private AbsoluteDate useableStartTime;
    private AbsoluteDate useableStopTime;
    private InterpolationMethod interpolationMethod;
    private int interpolationDegree;

    public OemMetadata(int defaultInterpolationDegree) {
        this.interpolationDegree = defaultInterpolationDegree;
    }

    @Override
    public void validate(double version) {
        this.checkMandatoryEntriesExceptDates(version);
        this.checkNotNull(this.startTime, OemMetadataKey.START_TIME);
        this.checkNotNull(this.stopTime, OemMetadataKey.STOP_TIME);
    }

    void checkMandatoryEntriesExceptDates(double version) {
        super.validate(version);
    }

    public AbsoluteDate getStartTime() {
        return this.startTime;
    }

    public void setStartTime(AbsoluteDate startTime) {
        this.refuseFurtherComments();
        this.startTime = startTime;
    }

    public AbsoluteDate getStopTime() {
        return this.stopTime;
    }

    public void setStopTime(AbsoluteDate stopTime) {
        this.refuseFurtherComments();
        this.stopTime = stopTime;
    }

    public AbsoluteDate getUseableStartTime() {
        return this.useableStartTime;
    }

    public void setUseableStartTime(AbsoluteDate useableStartTime) {
        this.refuseFurtherComments();
        this.useableStartTime = useableStartTime;
    }

    public AbsoluteDate getUseableStopTime() {
        return this.useableStopTime;
    }

    public void setUseableStopTime(AbsoluteDate useableStopTime) {
        this.refuseFurtherComments();
        this.useableStopTime = useableStopTime;
    }

    public InterpolationMethod getInterpolationMethod() {
        return this.interpolationMethod;
    }

    public void setInterpolationMethod(InterpolationMethod interpolationMethod) {
        this.refuseFurtherComments();
        this.interpolationMethod = interpolationMethod;
    }

    public int getInterpolationDegree() {
        return this.interpolationDegree;
    }

    public void setInterpolationDegree(int interpolationDegree) {
        this.refuseFurtherComments();
        this.interpolationDegree = interpolationDegree;
    }

    OemMetadata copy(double version) {
        this.checkMandatoryEntriesExceptDates(version);
        OemMetadata copy = new OemMetadata(this.getInterpolationDegree());
        for (String comment : this.getComments()) {
            copy.addComment(comment);
        }
        copy.setObjectName(this.getObjectName());
        copy.setObjectID(this.getObjectID());
        copy.setCenter(this.getCenter());
        copy.setFrameEpoch(this.getFrameEpoch());
        copy.setReferenceFrame(this.getReferenceFrame());
        copy.setTimeSystem(this.getTimeSystem());
        if (this.getInterpolationMethod() != null) {
            copy.setInterpolationMethod(this.getInterpolationMethod());
        }
        return copy;
    }
}

