/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.files.ccsds.ndm.odm.ocm;

import java.io.IOException;
import org.hipparchus.linear.RealMatrix;
import org.orekit.files.ccsds.definitions.TimeConverter;
import org.orekit.files.ccsds.definitions.Units;
import org.orekit.files.ccsds.ndm.odm.ocm.OcmDataSubStructureKey;
import org.orekit.files.ccsds.ndm.odm.ocm.PhysicalProperties;
import org.orekit.files.ccsds.ndm.odm.ocm.PhysicalPropertiesKey;
import org.orekit.files.ccsds.section.AbstractWriter;
import org.orekit.files.ccsds.utils.generation.Generator;
import org.orekit.utils.units.Unit;

class PhysicalPropertiesWriter
extends AbstractWriter {
    private final PhysicalProperties phys;
    private final TimeConverter timeConverter;

    PhysicalPropertiesWriter(PhysicalProperties phys, TimeConverter timeConverter) {
        super(OcmDataSubStructureKey.phys.name(), OcmDataSubStructureKey.PHYS.name());
        this.phys = phys;
        this.timeConverter = timeConverter;
    }

    @Override
    protected void writeContent(Generator generator) throws IOException {
        generator.writeComments(this.phys.getComments());
        generator.writeEntry(PhysicalPropertiesKey.MANUFACTURER.name(), this.phys.getManufacturer(), null, false);
        generator.writeEntry(PhysicalPropertiesKey.BUS_MODEL.name(), this.phys.getBusModel(), null, false);
        generator.writeEntry(PhysicalPropertiesKey.DOCKED_WITH.name(), this.phys.getDockedWith(), false);
        generator.writeEntry(PhysicalPropertiesKey.DRAG_CONST_AREA.name(), this.phys.getDragConstantArea(), Units.M2, false);
        generator.writeEntry(PhysicalPropertiesKey.DRAG_COEFF_NOM.name(), this.phys.getDragCoefficient(), Unit.ONE, false);
        generator.writeEntry(PhysicalPropertiesKey.DRAG_UNCERTAINTY.name(), this.phys.getDragUncertainty(), Unit.PERCENT, false);
        generator.writeEntry(PhysicalPropertiesKey.INITIAL_WET_MASS.name(), this.phys.getInitialWetMass(), Unit.KILOGRAM, false);
        generator.writeEntry(PhysicalPropertiesKey.WET_MASS.name(), this.phys.getWetMass(), Unit.KILOGRAM, false);
        generator.writeEntry(PhysicalPropertiesKey.DRY_MASS.name(), this.phys.getDryMass(), Unit.KILOGRAM, false);
        generator.writeEntry(PhysicalPropertiesKey.OEB_PARENT_FRAME.name(), this.phys.getOebParentFrame().getName(), null, false);
        generator.writeEntry(PhysicalPropertiesKey.OEB_PARENT_FRAME_EPOCH.name(), this.timeConverter, this.phys.getOebParentFrameEpoch(), false);
        generator.writeEntry(PhysicalPropertiesKey.OEB_Q1.name(), this.phys.getOebQ().getQ1(), Unit.ONE, false);
        generator.writeEntry(PhysicalPropertiesKey.OEB_Q2.name(), this.phys.getOebQ().getQ2(), Unit.ONE, false);
        generator.writeEntry(PhysicalPropertiesKey.OEB_Q3.name(), this.phys.getOebQ().getQ3(), Unit.ONE, false);
        generator.writeEntry(PhysicalPropertiesKey.OEB_QC.name(), this.phys.getOebQ().getQ0(), Unit.ONE, false);
        generator.writeEntry(PhysicalPropertiesKey.OEB_MAX.name(), this.phys.getOebMax(), Unit.METRE, false);
        generator.writeEntry(PhysicalPropertiesKey.OEB_INT.name(), this.phys.getOebIntermediate(), Unit.METRE, false);
        generator.writeEntry(PhysicalPropertiesKey.OEB_MIN.name(), this.phys.getOebMin(), Unit.METRE, false);
        generator.writeEntry(PhysicalPropertiesKey.AREA_ALONG_OEB_MAX.name(), this.phys.getOebAreaAlongMax(), Units.M2, false);
        generator.writeEntry(PhysicalPropertiesKey.AREA_ALONG_OEB_INT.name(), this.phys.getOebAreaAlongIntermediate(), Units.M2, false);
        generator.writeEntry(PhysicalPropertiesKey.AREA_ALONG_OEB_MIN.name(), this.phys.getOebAreaAlongMin(), Units.M2, false);
        generator.writeEntry(PhysicalPropertiesKey.AREA_MIN_FOR_PC.name(), this.phys.getMinAreaForCollisionProbability(), Units.M2, false);
        generator.writeEntry(PhysicalPropertiesKey.AREA_MAX_FOR_PC.name(), this.phys.getMaxAreaForCollisionProbability(), Units.M2, false);
        generator.writeEntry(PhysicalPropertiesKey.AREA_TYP_FOR_PC.name(), this.phys.getTypAreaForCollisionProbability(), Units.M2, false);
        generator.writeEntry(PhysicalPropertiesKey.RCS.name(), this.phys.getRcs(), Units.M2, false);
        generator.writeEntry(PhysicalPropertiesKey.RCS_MIN.name(), this.phys.getMinRcs(), Units.M2, false);
        generator.writeEntry(PhysicalPropertiesKey.RCS_MAX.name(), this.phys.getMaxRcs(), Units.M2, false);
        generator.writeEntry(PhysicalPropertiesKey.SRP_CONST_AREA.name(), this.phys.getSrpConstantArea(), Units.M2, false);
        generator.writeEntry(PhysicalPropertiesKey.SOLAR_RAD_COEFF.name(), this.phys.getSrpCoefficient(), Unit.ONE, false);
        generator.writeEntry(PhysicalPropertiesKey.SOLAR_RAD_UNCERTAINTY.name(), this.phys.getSrpUncertainty(), Unit.PERCENT, false);
        generator.writeEntry(PhysicalPropertiesKey.VM_ABSOLUTE.name(), this.phys.getVmAbsolute(), Unit.ONE, false);
        generator.writeEntry(PhysicalPropertiesKey.VM_APPARENT_MIN.name(), this.phys.getVmApparentMin(), Unit.ONE, false);
        generator.writeEntry(PhysicalPropertiesKey.VM_APPARENT.name(), this.phys.getVmApparent(), Unit.ONE, false);
        generator.writeEntry(PhysicalPropertiesKey.VM_APPARENT_MAX.name(), this.phys.getVmApparentMax(), Unit.ONE, false);
        generator.writeEntry(PhysicalPropertiesKey.REFLECTIVITY.name(), this.phys.getReflectivity(), Unit.ONE, false);
        generator.writeEntry(PhysicalPropertiesKey.ATT_CONTROL_MODE.name(), this.phys.getAttitudeControlMode(), null, false);
        generator.writeEntry(PhysicalPropertiesKey.ATT_ACTUATOR_TYPE.name(), this.phys.getAttitudeActuatorType(), null, false);
        generator.writeEntry(PhysicalPropertiesKey.ATT_KNOWLEDGE.name(), this.phys.getAttitudeKnowledgeAccuracy(), Unit.DEGREE, false);
        generator.writeEntry(PhysicalPropertiesKey.ATT_CONTROL.name(), this.phys.getAttitudeControlAccuracy(), Unit.DEGREE, false);
        generator.writeEntry(PhysicalPropertiesKey.ATT_POINTING.name(), this.phys.getAttitudePointingAccuracy(), Unit.DEGREE, false);
        generator.writeEntry(PhysicalPropertiesKey.AVG_MANEUVER_FREQ.name(), this.phys.getManeuversFrequency(), Units.NB_PER_Y, false);
        generator.writeEntry(PhysicalPropertiesKey.MAX_THRUST.name(), this.phys.getMaxThrust(), Unit.NEWTON, false);
        generator.writeEntry(PhysicalPropertiesKey.DV_BOL.name(), this.phys.getBolDv(), Units.KM_PER_S, false);
        generator.writeEntry(PhysicalPropertiesKey.DV_REMAINING.name(), this.phys.getRemainingDv(), Units.KM_PER_S, false);
        RealMatrix inertia = this.phys.getInertiaMatrix();
        if (inertia != null) {
            generator.writeEntry(PhysicalPropertiesKey.IXX.name(), inertia.getEntry(0, 0), Units.KG_M2, true);
            generator.writeEntry(PhysicalPropertiesKey.IYY.name(), inertia.getEntry(1, 1), Units.KG_M2, true);
            generator.writeEntry(PhysicalPropertiesKey.IZZ.name(), inertia.getEntry(2, 2), Units.KG_M2, true);
            generator.writeEntry(PhysicalPropertiesKey.IXY.name(), inertia.getEntry(0, 1), Units.KG_M2, true);
            generator.writeEntry(PhysicalPropertiesKey.IXZ.name(), inertia.getEntry(0, 2), Units.KG_M2, true);
            generator.writeEntry(PhysicalPropertiesKey.IYZ.name(), inertia.getEntry(1, 2), Units.KG_M2, true);
        }
    }
}

