/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.files.ccsds.ndm.odm.ocm;

import java.util.ArrayList;
import java.util.List;
import org.hipparchus.complex.Quaternion;
import org.hipparchus.linear.MatrixUtils;
import org.hipparchus.linear.RealMatrix;
import org.orekit.files.ccsds.definitions.FrameFacade;
import org.orekit.files.ccsds.definitions.OrbitRelativeFrame;
import org.orekit.files.ccsds.section.CommentsContainer;
import org.orekit.time.AbsoluteDate;

public class PhysicalProperties
extends CommentsContainer {
    private String manufacturer;
    private String busModel;
    private List<String> dockedWith = new ArrayList<String>();
    private double dragConstantArea = Double.NaN;
    private double dragCoefficient = Double.NaN;
    private double dragUncertainty = 0.0;
    private double initialWetMass = Double.NaN;
    private double wetMass = Double.NaN;
    private double dryMass = Double.NaN;
    private FrameFacade oebParentFrame = new FrameFacade(null, null, OrbitRelativeFrame.RIC, null, OrbitRelativeFrame.RIC.name());
    private AbsoluteDate oebParentFrameEpoch;
    private final double[] oebQ;
    private double oebMax;
    private double oebIntermediate;
    private double oebMin;
    private double oebAreaAlongMax;
    private double oebAreaAlongIntermediate;
    private double oebAreaAlongMin;
    private double minAreaForCollisionProbability;
    private double maxAreaForCollisionProbability;
    private double typAreaForCollisionProbability;
    private double rcs;
    private double minRcs;
    private double maxRcs;
    private double srpConstantArea;
    private double srpCoefficient;
    private double srpUncertainty;
    private double vmAbsolute;
    private double vmApparentMin;
    private double vmApparent;
    private double vmApparentMax;
    private double reflectivity;
    private String attitudeControlMode;
    private String attitudeActuatorType;
    private double attitudeKnowledgeAccuracy;
    private double attitudeControlAccuracy;
    private double attitudePointingAccuracy;
    private double maneuversFrequency;
    private double maxThrust;
    private double bolDv;
    private double remainingDv;
    private RealMatrix inertiaMatrix;

    PhysicalProperties(AbsoluteDate epochT0) {
        this.oebParentFrameEpoch = epochT0;
        this.oebQ = new double[4];
        this.oebMax = Double.NaN;
        this.oebIntermediate = Double.NaN;
        this.oebMin = Double.NaN;
        this.oebAreaAlongMax = Double.NaN;
        this.oebAreaAlongIntermediate = Double.NaN;
        this.oebAreaAlongMin = Double.NaN;
        this.minAreaForCollisionProbability = Double.NaN;
        this.maxAreaForCollisionProbability = Double.NaN;
        this.typAreaForCollisionProbability = Double.NaN;
        this.rcs = Double.NaN;
        this.minRcs = Double.NaN;
        this.maxRcs = Double.NaN;
        this.srpConstantArea = Double.NaN;
        this.srpCoefficient = Double.NaN;
        this.srpUncertainty = Double.NaN;
        this.vmAbsolute = Double.NaN;
        this.vmApparentMin = Double.NaN;
        this.vmApparent = Double.NaN;
        this.vmApparentMax = Double.NaN;
        this.reflectivity = Double.NaN;
        this.attitudeKnowledgeAccuracy = Double.NaN;
        this.attitudeControlAccuracy = Double.NaN;
        this.attitudePointingAccuracy = Double.NaN;
        this.maneuversFrequency = Double.NaN;
        this.maxThrust = Double.NaN;
        this.bolDv = Double.NaN;
        this.remainingDv = Double.NaN;
        this.inertiaMatrix = MatrixUtils.createRealMatrix((int)3, (int)3);
    }

    public String getManufacturer() {
        return this.manufacturer;
    }

    public void setManufacturer(String manufacturer) {
        this.refuseFurtherComments();
        this.manufacturer = manufacturer;
    }

    public String getBusModel() {
        return this.busModel;
    }

    public void setBusModel(String busModel) {
        this.refuseFurtherComments();
        this.busModel = busModel;
    }

    public List<String> getDockedWith() {
        return this.dockedWith;
    }

    public void setDockedWith(List<String> dockedWith) {
        this.refuseFurtherComments();
        this.dockedWith = dockedWith;
    }

    public double getDragConstantArea() {
        return this.dragConstantArea;
    }

    public void setDragConstantArea(double dragConstantArea) {
        this.refuseFurtherComments();
        this.dragConstantArea = dragConstantArea;
    }

    public double getDragCoefficient() {
        return this.dragCoefficient;
    }

    public void setDragCoefficient(double dragCoefficient) {
        this.refuseFurtherComments();
        this.dragCoefficient = dragCoefficient;
    }

    public double getDragUncertainty() {
        return this.dragUncertainty;
    }

    public void setDragUncertainty(double dragUncertainty) {
        this.refuseFurtherComments();
        this.dragUncertainty = dragUncertainty;
    }

    public double getInitialWetMass() {
        return this.initialWetMass;
    }

    public void setInitialWetMass(double initialWetMass) {
        this.refuseFurtherComments();
        this.initialWetMass = initialWetMass;
    }

    public double getWetMass() {
        return this.wetMass;
    }

    public void setWetMass(double wetMass) {
        this.refuseFurtherComments();
        this.wetMass = wetMass;
    }

    public double getDryMass() {
        return this.dryMass;
    }

    public void setDryMass(double dryMass) {
        this.refuseFurtherComments();
        this.dryMass = dryMass;
    }

    public FrameFacade getOebParentFrame() {
        return this.oebParentFrame;
    }

    public void setOebParentFrame(FrameFacade oebParentFrame) {
        this.refuseFurtherComments();
        this.oebParentFrame = oebParentFrame;
    }

    public AbsoluteDate getOebParentFrameEpoch() {
        return this.oebParentFrameEpoch;
    }

    public void setOebParentFrameEpoch(AbsoluteDate oebParentFrameEpoch) {
        this.refuseFurtherComments();
        this.oebParentFrameEpoch = oebParentFrameEpoch;
    }

    public Quaternion getOebQ() {
        return new Quaternion(this.oebQ[0], this.oebQ[1], this.oebQ[2], this.oebQ[3]);
    }

    public void setOebQ(int i, double qI) {
        this.refuseFurtherComments();
        this.oebQ[i] = qI;
    }

    public double getOebMax() {
        return this.oebMax;
    }

    public void setOebMax(double oebMax) {
        this.refuseFurtherComments();
        this.oebMax = oebMax;
    }

    public double getOebIntermediate() {
        return this.oebIntermediate;
    }

    public void setOebIntermediate(double oebIntermediate) {
        this.refuseFurtherComments();
        this.oebIntermediate = oebIntermediate;
    }

    public double getOebMin() {
        return this.oebMin;
    }

    public void setOebMin(double oebMin) {
        this.refuseFurtherComments();
        this.oebMin = oebMin;
    }

    public double getOebAreaAlongMax() {
        return this.oebAreaAlongMax;
    }

    public void setOebAreaAlongMax(double oebAreaAlongMax) {
        this.refuseFurtherComments();
        this.oebAreaAlongMax = oebAreaAlongMax;
    }

    public double getOebAreaAlongIntermediate() {
        return this.oebAreaAlongIntermediate;
    }

    public void setOebAreaAlongIntermediate(double oebAreaAlongIntermediate) {
        this.refuseFurtherComments();
        this.oebAreaAlongIntermediate = oebAreaAlongIntermediate;
    }

    public double getOebAreaAlongMin() {
        return this.oebAreaAlongMin;
    }

    public void setOebAreaAlongMin(double oebAreaAlongMin) {
        this.refuseFurtherComments();
        this.oebAreaAlongMin = oebAreaAlongMin;
    }

    public double getMinAreaForCollisionProbability() {
        return this.minAreaForCollisionProbability;
    }

    public void setMinAreaForCollisionProbability(double minAreaForCollisionProbability) {
        this.refuseFurtherComments();
        this.minAreaForCollisionProbability = minAreaForCollisionProbability;
    }

    public double getMaxAreaForCollisionProbability() {
        return this.maxAreaForCollisionProbability;
    }

    public void setMaxAreaForCollisionProbability(double maxAreaForCollisionProbability) {
        this.refuseFurtherComments();
        this.maxAreaForCollisionProbability = maxAreaForCollisionProbability;
    }

    public double getTypAreaForCollisionProbability() {
        return this.typAreaForCollisionProbability;
    }

    public void setTypAreaForCollisionProbability(double typAreaForCollisionProbability) {
        this.refuseFurtherComments();
        this.typAreaForCollisionProbability = typAreaForCollisionProbability;
    }

    public double getRcs() {
        return this.rcs;
    }

    public void setRcs(double rcs) {
        this.refuseFurtherComments();
        this.rcs = rcs;
    }

    public double getMinRcs() {
        return this.minRcs;
    }

    public void setMinRcs(double minRcs) {
        this.refuseFurtherComments();
        this.minRcs = minRcs;
    }

    public double getMaxRcs() {
        return this.maxRcs;
    }

    public void setMaxRcs(double maxRcs) {
        this.refuseFurtherComments();
        this.maxRcs = maxRcs;
    }

    public double getSrpConstantArea() {
        return this.srpConstantArea;
    }

    public void setSrpConstantArea(double srpConstantArea) {
        this.refuseFurtherComments();
        this.srpConstantArea = srpConstantArea;
    }

    public double getSrpCoefficient() {
        return this.srpCoefficient;
    }

    public void setSrpCoefficient(double srpCoefficient) {
        this.refuseFurtherComments();
        this.srpCoefficient = srpCoefficient;
    }

    public double getSrpUncertainty() {
        return this.srpUncertainty;
    }

    public void setSrpUncertainty(double srpUncertainty) {
        this.refuseFurtherComments();
        this.srpUncertainty = srpUncertainty;
    }

    public double getVmAbsolute() {
        return this.vmAbsolute;
    }

    public void setVmAbsolute(double vmAbsolute) {
        this.refuseFurtherComments();
        this.vmAbsolute = vmAbsolute;
    }

    public double getVmApparentMin() {
        return this.vmApparentMin;
    }

    public void setVmApparentMin(double vmApparentMin) {
        this.refuseFurtherComments();
        this.vmApparentMin = vmApparentMin;
    }

    public double getVmApparent() {
        return this.vmApparent;
    }

    public void setVmApparent(double vmApparent) {
        this.refuseFurtherComments();
        this.vmApparent = vmApparent;
    }

    public double getVmApparentMax() {
        return this.vmApparentMax;
    }

    public void setVmApparentMax(double vmApparentMax) {
        this.refuseFurtherComments();
        this.vmApparentMax = vmApparentMax;
    }

    public double getReflectivity() {
        return this.reflectivity;
    }

    public void setReflectivity(double reflectivity) {
        this.refuseFurtherComments();
        this.reflectivity = reflectivity;
    }

    public String getAttitudeControlMode() {
        return this.attitudeControlMode;
    }

    public void setAttitudeControlMode(String attitudeControlMode) {
        this.refuseFurtherComments();
        this.attitudeControlMode = attitudeControlMode;
    }

    public String getAttitudeActuatorType() {
        return this.attitudeActuatorType;
    }

    public void setAttitudeActuatorType(String attitudeActuatorType) {
        this.refuseFurtherComments();
        this.attitudeActuatorType = attitudeActuatorType;
    }

    public double getAttitudeKnowledgeAccuracy() {
        return this.attitudeKnowledgeAccuracy;
    }

    public void setAttitudeKnowledgeAccuracy(double attitudeKnowledgeAccuracy) {
        this.refuseFurtherComments();
        this.attitudeKnowledgeAccuracy = attitudeKnowledgeAccuracy;
    }

    public double getAttitudeControlAccuracy() {
        return this.attitudeControlAccuracy;
    }

    public void setAttitudeControlAccuracy(double attitudeControlAccuracy) {
        this.refuseFurtherComments();
        this.attitudeControlAccuracy = attitudeControlAccuracy;
    }

    public double getAttitudePointingAccuracy() {
        return this.attitudePointingAccuracy;
    }

    public void setAttitudePointingAccuracy(double attitudePointingAccuracy) {
        this.refuseFurtherComments();
        this.attitudePointingAccuracy = attitudePointingAccuracy;
    }

    public double getManeuversPerYear() {
        return this.maneuversFrequency * 3.15576E7;
    }

    public double getManeuversFrequency() {
        return this.maneuversFrequency;
    }

    public void setManeuversFrequency(double maneuversFrequency) {
        this.refuseFurtherComments();
        this.maneuversFrequency = maneuversFrequency;
    }

    public double getMaxThrust() {
        return this.maxThrust;
    }

    public void setMaxThrust(double maxThrust) {
        this.refuseFurtherComments();
        this.maxThrust = maxThrust;
    }

    public double getBolDv() {
        return this.bolDv;
    }

    public void setBolDv(double bolDv) {
        this.refuseFurtherComments();
        this.bolDv = bolDv;
    }

    public double getRemainingDv() {
        return this.remainingDv;
    }

    public void setRemainingDv(double remainingDv) {
        this.refuseFurtherComments();
        this.remainingDv = remainingDv;
    }

    public RealMatrix getInertiaMatrix() {
        return this.inertiaMatrix;
    }

    public void setInertiaMatrixEntry(int j, int k, double entry) {
        this.refuseFurtherComments();
        this.inertiaMatrix.setEntry(j, k, entry);
        this.inertiaMatrix.setEntry(k, j, entry);
    }
}

