/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.files.ccsds.ndm.adm.apm;

import java.io.IOException;
import org.orekit.data.DataContext;
import org.orekit.files.ccsds.definitions.TimeSystem;
import org.orekit.files.ccsds.ndm.ParsedUnitsBehavior;
import org.orekit.files.ccsds.ndm.adm.AdmMetadata;
import org.orekit.files.ccsds.ndm.adm.AdmMetadataWriter;
import org.orekit.files.ccsds.ndm.adm.apm.Apm;
import org.orekit.files.ccsds.ndm.adm.apm.ApmData;
import org.orekit.files.ccsds.ndm.adm.apm.ApmQuaternionWriter;
import org.orekit.files.ccsds.ndm.adm.apm.EulerWriter;
import org.orekit.files.ccsds.ndm.adm.apm.Maneuver;
import org.orekit.files.ccsds.ndm.adm.apm.ManeuverWriter;
import org.orekit.files.ccsds.ndm.adm.apm.SpacecraftParametersWriter;
import org.orekit.files.ccsds.ndm.adm.apm.SpinStabilizedWriter;
import org.orekit.files.ccsds.ndm.adm.apm.XmlSubStructureKey;
import org.orekit.files.ccsds.section.Header;
import org.orekit.files.ccsds.section.Segment;
import org.orekit.files.ccsds.section.XmlStructureKey;
import org.orekit.files.ccsds.utils.ContextBinding;
import org.orekit.files.ccsds.utils.FileFormat;
import org.orekit.files.ccsds.utils.generation.AbstractMessageWriter;
import org.orekit.files.ccsds.utils.generation.Generator;
import org.orekit.time.AbsoluteDate;
import org.orekit.utils.IERSConventions;

public class ApmWriter
extends AbstractMessageWriter<Header, Segment<AdmMetadata, ApmData>, Apm> {
    public static final double CCSDS_APM_VERS = 1.0;
    public static final int KVN_PADDING_WIDTH = 17;

    public ApmWriter(IERSConventions conventions, DataContext dataContext, AbsoluteDate missionReferenceDate) {
        super("apm", "CCSDS_APM_VERS", 1.0, new ContextBinding(() -> conventions, () -> false, () -> dataContext, () -> ParsedUnitsBehavior.STRICT_COMPLIANCE, () -> missionReferenceDate, () -> TimeSystem.UTC, () -> 0.0, () -> 1.0));
    }

    @Override
    public void writeSegmentContent(Generator generator, double formatVersion, Segment<AdmMetadata, ApmData> segment) throws IOException {
        ContextBinding oldContext = this.getContext();
        AdmMetadata metadata = segment.getMetadata();
        this.setContext(new ContextBinding(oldContext::getConventions, oldContext::isSimpleEOP, oldContext::getDataContext, oldContext::getParsedUnitsBehavior, oldContext::getReferenceDate, metadata::getTimeSystem, oldContext::getClockCount, oldContext::getClockRate));
        new AdmMetadataWriter(metadata).write(generator);
        if (generator.getFormat() == FileFormat.XML) {
            generator.enterSection(XmlStructureKey.data.name());
        }
        generator.writeComments(segment.getData().getComments());
        new ApmQuaternionWriter(XmlSubStructureKey.quaternionState.name(), null, segment.getData().getQuaternionBlock(), this.getTimeConverter()).write(generator);
        if (segment.getData().getEulerBlock() != null) {
            new EulerWriter(XmlSubStructureKey.eulerElementsThree.name(), null, segment.getData().getEulerBlock()).write(generator);
        }
        if (segment.getData().getSpinStabilizedBlock() != null) {
            new SpinStabilizedWriter(XmlSubStructureKey.eulerElementsSpin.name(), null, segment.getData().getSpinStabilizedBlock()).write(generator);
        }
        if (segment.getData().getSpacecraftParametersBlock() != null) {
            new SpacecraftParametersWriter(XmlSubStructureKey.spacecraftParameters.name(), null, segment.getData().getSpacecraftParametersBlock()).write(generator);
        }
        if (!segment.getData().getManeuvers().isEmpty()) {
            for (Maneuver maneuver : segment.getData().getManeuvers()) {
                new ManeuverWriter(XmlSubStructureKey.maneuverParameters.name(), null, maneuver, this.getTimeConverter()).write(generator);
            }
        }
        if (generator.getFormat() == FileFormat.XML) {
            generator.exitSection();
        }
    }
}

