/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.files.ccsds.ndm.adm.aem;

import java.io.IOException;
import org.hipparchus.exception.Localizable;
import org.hipparchus.geometry.euclidean.threed.RotationOrder;
import org.orekit.data.DataContext;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitInternalError;
import org.orekit.errors.OrekitMessages;
import org.orekit.files.ccsds.definitions.TimeSystem;
import org.orekit.files.ccsds.definitions.Units;
import org.orekit.files.ccsds.ndm.ParsedUnitsBehavior;
import org.orekit.files.ccsds.ndm.adm.AdmMetadataKey;
import org.orekit.files.ccsds.ndm.adm.AttitudeType;
import org.orekit.files.ccsds.ndm.adm.aem.Aem;
import org.orekit.files.ccsds.ndm.adm.aem.AemData;
import org.orekit.files.ccsds.ndm.adm.aem.AemMetadata;
import org.orekit.files.ccsds.ndm.adm.aem.AemMetadataKey;
import org.orekit.files.ccsds.ndm.adm.aem.AemSegment;
import org.orekit.files.ccsds.ndm.adm.aem.AttitudeEntryKey;
import org.orekit.files.ccsds.ndm.adm.aem.XmlSubStructureKey;
import org.orekit.files.ccsds.section.Header;
import org.orekit.files.ccsds.section.KvnStructureKey;
import org.orekit.files.ccsds.section.MetadataKey;
import org.orekit.files.ccsds.section.XmlStructureKey;
import org.orekit.files.ccsds.utils.ContextBinding;
import org.orekit.files.ccsds.utils.FileFormat;
import org.orekit.files.ccsds.utils.generation.AbstractMessageWriter;
import org.orekit.files.ccsds.utils.generation.Generator;
import org.orekit.files.ccsds.utils.generation.XmlGenerator;
import org.orekit.time.AbsoluteDate;
import org.orekit.utils.IERSConventions;
import org.orekit.utils.TimeStampedAngularCoordinates;
import org.orekit.utils.units.Unit;

public class AemWriter
extends AbstractMessageWriter<Header, AemSegment, Aem> {
    public static final double CCSDS_AEM_VERS = 1.0;
    public static final int KVN_PADDING_WIDTH = 20;
    private static final String A_TO_B = "A2B";
    private static final String B_TO_A = "B2A";
    private static final String FIRST = "FIRST";
    private static final String LAST = "LAST";
    private static final String REF_FRAME_A = "REF_FRAME_A";
    private static final String REF_FRAME_B = "REF_FRAME_B";
    private static final String ROTATION = "rotation";
    private static final String ANGLE_ATTRIBUTE = "angle";
    private static final String ANGLE_SUFFIX = "_ANGLE";
    private static final String RATE_ATTRIBUTE = "rate";
    private static final String RATE_SUFFIX = "_RATE";

    public AemWriter(IERSConventions conventions, DataContext dataContext, AbsoluteDate missionReferenceDate) {
        super("aem", "CCSDS_AEM_VERS", 1.0, new ContextBinding(() -> conventions, () -> true, () -> dataContext, () -> ParsedUnitsBehavior.STRICT_COMPLIANCE, () -> missionReferenceDate, () -> TimeSystem.UTC, () -> 0.0, () -> 1.0));
    }

    @Override
    public void writeSegmentContent(Generator generator, double formatVersion, AemSegment segment) throws IOException {
        AemMetadata metadata = (AemMetadata)segment.getMetadata();
        this.writeMetadata(generator, metadata);
        this.startAttitudeBlock(generator);
        generator.writeComments(((AemData)segment.getData()).getComments());
        for (TimeStampedAngularCoordinates coordinates : segment.getAngularCoordinates()) {
            this.writeAttitudeEphemerisLine(generator, metadata, coordinates);
        }
        this.endAttitudeBlock(generator);
    }

    void writeMetadata(Generator generator, AemMetadata metadata) throws IOException {
        ContextBinding oldContext = this.getContext();
        this.setContext(new ContextBinding(oldContext::getConventions, oldContext::isSimpleEOP, oldContext::getDataContext, oldContext::getParsedUnitsBehavior, oldContext::getReferenceDate, metadata::getTimeSystem, oldContext::getClockCount, oldContext::getClockRate));
        generator.enterSection(generator.getFormat() == FileFormat.KVN ? KvnStructureKey.META.name() : XmlStructureKey.metadata.name());
        generator.writeComments(metadata.getComments());
        generator.writeEntry(AdmMetadataKey.OBJECT_NAME.name(), metadata.getObjectName(), null, true);
        generator.writeEntry(AdmMetadataKey.OBJECT_ID.name(), metadata.getObjectID(), null, true);
        if (metadata.getCenter() != null) {
            generator.writeEntry(AdmMetadataKey.CENTER_NAME.name(), metadata.getCenter().getName(), null, false);
        }
        generator.writeEntry(AemMetadataKey.REF_FRAME_A.name(), metadata.getEndpoints().getFrameA().getName(), null, true);
        generator.writeEntry(AemMetadataKey.REF_FRAME_B.name(), metadata.getEndpoints().getFrameB().getName(), null, true);
        generator.writeEntry(AemMetadataKey.ATTITUDE_DIR.name(), metadata.getEndpoints().isA2b() ? A_TO_B : B_TO_A, null, true);
        generator.writeEntry(MetadataKey.TIME_SYSTEM.name(), metadata.getTimeSystem(), true);
        generator.writeEntry(AemMetadataKey.START_TIME.name(), this.getTimeConverter(), metadata.getStartTime(), true);
        if (metadata.getUseableStartTime() != null) {
            generator.writeEntry(AemMetadataKey.USEABLE_START_TIME.name(), this.getTimeConverter(), metadata.getUseableStartTime(), false);
        }
        if (metadata.getUseableStopTime() != null) {
            generator.writeEntry(AemMetadataKey.USEABLE_STOP_TIME.name(), this.getTimeConverter(), metadata.getUseableStopTime(), false);
        }
        generator.writeEntry(AemMetadataKey.STOP_TIME.name(), this.getTimeConverter(), metadata.getStopTime(), true);
        AttitudeType attitudeType = metadata.getAttitudeType();
        generator.writeEntry(AemMetadataKey.ATTITUDE_TYPE.name(), attitudeType.toString(), null, true);
        if (attitudeType == AttitudeType.QUATERNION || attitudeType == AttitudeType.QUATERNION_DERIVATIVE || attitudeType == AttitudeType.QUATERNION_RATE) {
            generator.writeEntry(AemMetadataKey.QUATERNION_TYPE.name(), metadata.isFirst() != false ? FIRST : LAST, null, false);
        }
        if (attitudeType == AttitudeType.QUATERNION_RATE || attitudeType == AttitudeType.EULER_ANGLE || attitudeType == AttitudeType.EULER_ANGLE_RATE) {
            if (metadata.getEulerRotSeq() == null) {
                throw new OrekitException((Localizable)OrekitMessages.CCSDS_MISSING_KEYWORD, AemMetadataKey.EULER_ROT_SEQ.name(), generator.getOutputName());
            }
            generator.writeEntry(AemMetadataKey.EULER_ROT_SEQ.name(), metadata.getEulerRotSeq().name().replace('X', '1').replace('Y', '2').replace('Z', '3'), null, false);
        }
        if (attitudeType == AttitudeType.QUATERNION_RATE || attitudeType == AttitudeType.EULER_ANGLE_RATE) {
            generator.writeEntry(AemMetadataKey.RATE_FRAME.name(), metadata.rateFrameIsA() ? REF_FRAME_A : REF_FRAME_B, null, false);
        }
        generator.writeEntry(AemMetadataKey.INTERPOLATION_METHOD.name(), metadata.getInterpolationMethod(), null, false);
        generator.writeEntry(AemMetadataKey.INTERPOLATION_DEGREE.name(), Integer.toString(metadata.getInterpolationDegree()), null, false);
        generator.exitSection();
    }

    void writeAttitudeEphemerisLine(Generator generator, AemMetadata metadata, TimeStampedAngularCoordinates attitude) throws IOException {
        String[] data = metadata.getAttitudeType().createDataFields(metadata.isFirst(), metadata.getEndpoints().isExternal2SpacecraftBody(), metadata.getEulerRotSeq(), metadata.isSpacecraftBodyRate(), attitude);
        if (generator.getFormat() == FileFormat.KVN) {
            generator.writeRawData(generator.dateToString(this.getTimeConverter(), attitude.getDate()));
            int size = data.length;
            for (int index = 0; index < size; ++index) {
                generator.writeRawData(' ');
                generator.writeRawData(data[index]);
            }
            generator.newLine();
        } else {
            XmlGenerator xmlGenerator = (XmlGenerator)generator;
            xmlGenerator.enterSection(XmlSubStructureKey.attitudeState.name());
            switch (metadata.getAttitudeType()) {
                case QUATERNION: {
                    this.writeQuaternion(xmlGenerator, metadata.isFirst(), attitude.getDate(), data);
                    break;
                }
                case QUATERNION_DERIVATIVE: {
                    this.writeQuaternionDerivative(xmlGenerator, metadata.isFirst(), attitude.getDate(), data);
                    break;
                }
                case QUATERNION_RATE: {
                    this.writeQuaternionRate(xmlGenerator, metadata.isFirst(), metadata.getEulerRotSeq(), attitude.getDate(), data);
                    break;
                }
                case EULER_ANGLE: {
                    this.writeEulerAngle(xmlGenerator, metadata.getEulerRotSeq(), attitude.getDate(), data);
                    break;
                }
                case EULER_ANGLE_RATE: {
                    this.writeEulerAngleRate(xmlGenerator, metadata.getEulerRotSeq(), attitude.getDate(), data);
                    break;
                }
                case SPIN: {
                    this.writeSpin(xmlGenerator, attitude.getDate(), data);
                    break;
                }
                default: {
                    throw new OrekitInternalError(null);
                }
            }
            generator.exitSection();
        }
    }

    void writeQuaternion(XmlGenerator xmlGenerator, boolean first, AbsoluteDate epoch, String[] data) throws IOException {
        xmlGenerator.enterSection(AttitudeEntryKey.quaternion.name());
        xmlGenerator.writeEntry(AttitudeEntryKey.EPOCH.name(), this.getTimeConverter(), epoch, true);
        int i = 0;
        if (first) {
            xmlGenerator.writeEntry(AttitudeEntryKey.QC.name(), data[i++], Unit.ONE, false);
        }
        xmlGenerator.writeEntry(AttitudeEntryKey.Q1.name(), data[i++], Unit.ONE, false);
        xmlGenerator.writeEntry(AttitudeEntryKey.Q2.name(), data[i++], Unit.ONE, false);
        xmlGenerator.writeEntry(AttitudeEntryKey.Q3.name(), data[i++], Unit.ONE, false);
        if (!first) {
            xmlGenerator.writeEntry(AttitudeEntryKey.QC.name(), data[i++], Unit.ONE, false);
        }
        xmlGenerator.exitSection();
    }

    void writeQuaternionDerivative(XmlGenerator xmlGenerator, boolean first, AbsoluteDate epoch, String[] data) throws IOException {
        xmlGenerator.enterSection(AttitudeEntryKey.quaternionDerivative.name());
        xmlGenerator.writeEntry(AttitudeEntryKey.EPOCH.name(), this.getTimeConverter(), epoch, true);
        int i = 0;
        xmlGenerator.enterSection(AttitudeEntryKey.quaternion.name());
        if (first) {
            xmlGenerator.writeEntry(AttitudeEntryKey.QC.name(), data[i++], Unit.ONE, true);
        }
        xmlGenerator.writeEntry(AttitudeEntryKey.Q1.name(), data[i++], Unit.ONE, true);
        xmlGenerator.writeEntry(AttitudeEntryKey.Q2.name(), data[i++], Unit.ONE, true);
        xmlGenerator.writeEntry(AttitudeEntryKey.Q3.name(), data[i++], Unit.ONE, true);
        if (!first) {
            xmlGenerator.writeEntry(AttitudeEntryKey.QC.name(), data[i++], Unit.ONE, true);
        }
        xmlGenerator.exitSection();
        xmlGenerator.enterSection(AttitudeEntryKey.quaternionRate.name());
        if (first) {
            xmlGenerator.writeEntry(AttitudeEntryKey.QC_DOT.name(), data[i++], Units.ONE_PER_S, true);
        }
        xmlGenerator.writeEntry(AttitudeEntryKey.Q1_DOT.name(), data[i++], Units.ONE_PER_S, true);
        xmlGenerator.writeEntry(AttitudeEntryKey.Q2_DOT.name(), data[i++], Units.ONE_PER_S, true);
        xmlGenerator.writeEntry(AttitudeEntryKey.Q3_DOT.name(), data[i++], Units.ONE_PER_S, true);
        if (!first) {
            xmlGenerator.writeEntry(AttitudeEntryKey.QC_DOT.name(), data[i++], Units.ONE_PER_S, true);
        }
        xmlGenerator.exitSection();
        xmlGenerator.exitSection();
    }

    void writeQuaternionRate(XmlGenerator xmlGenerator, boolean first, RotationOrder order, AbsoluteDate epoch, String[] data) throws IOException {
        xmlGenerator.enterSection(AttitudeEntryKey.quaternionEulerRate.name());
        xmlGenerator.writeEntry(AttitudeEntryKey.EPOCH.name(), this.getTimeConverter(), epoch, true);
        int i = 0;
        xmlGenerator.enterSection(AttitudeEntryKey.quaternion.name());
        if (first) {
            xmlGenerator.writeEntry(AttitudeEntryKey.QC.name(), data[i++], Unit.ONE, true);
        }
        xmlGenerator.writeEntry(AttitudeEntryKey.Q1.name(), data[i++], Unit.ONE, true);
        xmlGenerator.writeEntry(AttitudeEntryKey.Q2.name(), data[i++], Unit.ONE, true);
        xmlGenerator.writeEntry(AttitudeEntryKey.Q3.name(), data[i++], Unit.ONE, true);
        if (!first) {
            xmlGenerator.writeEntry(AttitudeEntryKey.QC.name(), data[i++], Unit.ONE, true);
        }
        xmlGenerator.exitSection();
        xmlGenerator.enterSection(AttitudeEntryKey.rotationRates.name());
        this.writeEulerRate(xmlGenerator, 0, order.name(), data[i++]);
        this.writeEulerRate(xmlGenerator, 1, order.name(), data[i++]);
        this.writeEulerRate(xmlGenerator, 2, order.name(), data[i++]);
        xmlGenerator.exitSection();
        xmlGenerator.exitSection();
    }

    void writeEulerAngle(XmlGenerator xmlGenerator, RotationOrder order, AbsoluteDate epoch, String[] data) throws IOException {
        xmlGenerator.enterSection(AttitudeEntryKey.eulerAngle.name());
        xmlGenerator.writeEntry(AttitudeEntryKey.EPOCH.name(), this.getTimeConverter(), epoch, true);
        int i = 0;
        xmlGenerator.enterSection(AttitudeEntryKey.rotationAngles.name());
        this.writeEulerAngle(xmlGenerator, 0, order.name(), data[i++]);
        this.writeEulerAngle(xmlGenerator, 1, order.name(), data[i++]);
        this.writeEulerAngle(xmlGenerator, 2, order.name(), data[i++]);
        xmlGenerator.exitSection();
        xmlGenerator.exitSection();
    }

    void writeEulerAngleRate(XmlGenerator xmlGenerator, RotationOrder order, AbsoluteDate epoch, String[] data) throws IOException {
        xmlGenerator.enterSection(AttitudeEntryKey.eulerAngle.name());
        xmlGenerator.writeEntry(AttitudeEntryKey.EPOCH.name(), this.getTimeConverter(), epoch, true);
        int i = 0;
        xmlGenerator.enterSection(AttitudeEntryKey.rotationAngles.name());
        this.writeEulerAngle(xmlGenerator, 0, order.name(), data[i++]);
        this.writeEulerAngle(xmlGenerator, 1, order.name(), data[i++]);
        this.writeEulerAngle(xmlGenerator, 2, order.name(), data[i++]);
        xmlGenerator.exitSection();
        xmlGenerator.enterSection(AttitudeEntryKey.rotationRates.name());
        this.writeEulerRate(xmlGenerator, 0, order.name(), data[i++]);
        this.writeEulerRate(xmlGenerator, 1, order.name(), data[i++]);
        this.writeEulerRate(xmlGenerator, 2, order.name(), data[i++]);
        xmlGenerator.exitSection();
        xmlGenerator.exitSection();
    }

    void writeSpin(XmlGenerator xmlGenerator, AbsoluteDate epoch, String[] data) throws IOException {
        xmlGenerator.enterSection(AttitudeEntryKey.spin.name());
        xmlGenerator.writeEntry(AttitudeEntryKey.EPOCH.name(), this.getTimeConverter(), epoch, true);
        int i = 0;
        xmlGenerator.writeEntry(AttitudeEntryKey.SPIN_ALPHA.name(), data[i++], Unit.DEGREE, true);
        xmlGenerator.writeEntry(AttitudeEntryKey.SPIN_DELTA.name(), data[i++], Unit.DEGREE, true);
        xmlGenerator.writeEntry(AttitudeEntryKey.SPIN_ANGLE.name(), data[i++], Unit.DEGREE, true);
        xmlGenerator.writeEntry(AttitudeEntryKey.SPIN_ANGLE_VEL.name(), data[i++], Units.DEG_PER_S, true);
        xmlGenerator.exitSection();
    }

    private void writeEulerAngle(XmlGenerator xmlGenerator, int index, String seq, String angle) throws IOException {
        if (xmlGenerator.writeUnits(Unit.DEGREE)) {
            xmlGenerator.writeTwoAttributesElement(ROTATION + (index + 1), angle, ANGLE_ATTRIBUTE, seq.charAt(index) + ANGLE_SUFFIX, "units", xmlGenerator.siToCcsdsName(Unit.DEGREE.getName()));
        } else {
            xmlGenerator.writeOneAttributeElement(ROTATION + (index + 1), angle, ANGLE_ATTRIBUTE, seq.charAt(index) + ANGLE_SUFFIX);
        }
    }

    private void writeEulerRate(XmlGenerator xmlGenerator, int index, String seq, String rate) throws IOException {
        if (xmlGenerator.writeUnits(Units.DEG_PER_S)) {
            xmlGenerator.writeTwoAttributesElement(ROTATION + (index + 1), rate, RATE_ATTRIBUTE, seq.charAt(index) + RATE_SUFFIX, "units", xmlGenerator.siToCcsdsName(Units.DEG_PER_S.getName()));
        } else {
            xmlGenerator.writeOneAttributeElement(ROTATION + (index + 1), rate, RATE_ATTRIBUTE, seq.charAt(index) + RATE_SUFFIX);
        }
    }

    void startAttitudeBlock(Generator generator) throws IOException {
        generator.enterSection(generator.getFormat() == FileFormat.KVN ? KvnStructureKey.DATA.name() : XmlStructureKey.data.name());
    }

    void endAttitudeBlock(Generator generator) throws IOException {
        generator.exitSection();
    }
}

