/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.files.ccsds.ndm.adm;

import java.util.regex.Pattern;
import org.hipparchus.CalculusFieldElement;
import org.hipparchus.analysis.differentiation.UnivariateDerivative1;
import org.hipparchus.exception.Localizable;
import org.hipparchus.geometry.euclidean.threed.FieldRotation;
import org.hipparchus.geometry.euclidean.threed.Rotation;
import org.hipparchus.geometry.euclidean.threed.RotationConvention;
import org.hipparchus.geometry.euclidean.threed.RotationOrder;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.files.ccsds.definitions.Units;
import org.orekit.files.ccsds.utils.ContextBinding;
import org.orekit.time.AbsoluteDate;
import org.orekit.utils.AccurateFormatter;
import org.orekit.utils.AngularDerivativesFilter;
import org.orekit.utils.TimeStampedAngularCoordinates;
import org.orekit.utils.units.Unit;

public enum AttitudeType {
    QUATERNION("QUATERNION", AngularDerivativesFilter.USE_R, new Unit[]{Unit.ONE, Unit.ONE, Unit.ONE, Unit.ONE}){

        @Override
        public String[] createDataFields(boolean isFirst, boolean isExternal2SpacecraftBody, RotationOrder eulerRotSequence, boolean isSpacecraftBodyRate, TimeStampedAngularCoordinates coordinates) {
            int[] nArray;
            double[] data = new double[4];
            if (isFirst) {
                int[] nArray2 = new int[4];
                nArray2[0] = 0;
                nArray2[1] = 1;
                nArray2[2] = 2;
                nArray = nArray2;
                nArray2[3] = 3;
            } else {
                int[] nArray3 = new int[4];
                nArray3[0] = 3;
                nArray3[1] = 0;
                nArray3[2] = 1;
                nArray = nArray3;
                nArray3[3] = 2;
            }
            int[] quaternionIndex = nArray;
            Rotation rotation = coordinates.getRotation();
            if (!isExternal2SpacecraftBody) {
                rotation = rotation.revert();
            }
            data[quaternionIndex[0]] = rotation.getQ0();
            data[quaternionIndex[1]] = rotation.getQ1();
            data[quaternionIndex[2]] = rotation.getQ2();
            data[quaternionIndex[3]] = rotation.getQ3();
            return 1.QUATERNION.formatData(data);
        }

        @Override
        public TimeStampedAngularCoordinates build(boolean isFirst, boolean isExternal2SpacecraftBody, RotationOrder eulerRotSequence, boolean isSpacecraftBodyRate, AbsoluteDate date, double ... components) {
            Rotation rotation;
            Rotation rotation2 = rotation = isFirst ? new Rotation(components[0], components[1], components[2], components[3], true) : new Rotation(components[3], components[0], components[1], components[2], true);
            if (!isExternal2SpacecraftBody) {
                rotation = rotation.revert();
            }
            return new TimeStampedAngularCoordinates(date, rotation, Vector3D.ZERO, Vector3D.ZERO);
        }
    }
    ,
    QUATERNION_DERIVATIVE("QUATERNION/DERIVATIVE", AngularDerivativesFilter.USE_RR, new Unit[]{Unit.ONE, Unit.ONE, Unit.ONE, Unit.ONE, Units.ONE_PER_S, Units.ONE_PER_S, Units.ONE_PER_S, Units.ONE_PER_S}){

        @Override
        public String[] createDataFields(boolean isFirst, boolean isExternal2SpacecraftBody, RotationOrder eulerRotSequence, boolean isSpacecraftBodyRate, TimeStampedAngularCoordinates coordinates) {
            int[] nArray;
            double[] data = new double[8];
            FieldRotation rotation = coordinates.toUnivariateDerivative1Rotation();
            if (!isExternal2SpacecraftBody) {
                rotation = rotation.revert();
            }
            if (isFirst) {
                int[] nArray2 = new int[8];
                nArray2[0] = 0;
                nArray2[1] = 1;
                nArray2[2] = 2;
                nArray2[3] = 3;
                nArray2[4] = 4;
                nArray2[5] = 5;
                nArray2[6] = 6;
                nArray = nArray2;
                nArray2[7] = 7;
            } else {
                int[] nArray3 = new int[8];
                nArray3[0] = 3;
                nArray3[1] = 0;
                nArray3[2] = 1;
                nArray3[3] = 2;
                nArray3[4] = 7;
                nArray3[5] = 4;
                nArray3[6] = 5;
                nArray = nArray3;
                nArray3[7] = 6;
            }
            int[] quaternionIndex = nArray;
            data[quaternionIndex[0]] = ((UnivariateDerivative1)rotation.getQ0()).getValue();
            data[quaternionIndex[1]] = ((UnivariateDerivative1)rotation.getQ1()).getValue();
            data[quaternionIndex[2]] = ((UnivariateDerivative1)rotation.getQ2()).getValue();
            data[quaternionIndex[3]] = ((UnivariateDerivative1)rotation.getQ3()).getValue();
            data[quaternionIndex[4]] = ((UnivariateDerivative1)rotation.getQ0()).getFirstDerivative();
            data[quaternionIndex[5]] = ((UnivariateDerivative1)rotation.getQ1()).getFirstDerivative();
            data[quaternionIndex[6]] = ((UnivariateDerivative1)rotation.getQ2()).getFirstDerivative();
            data[quaternionIndex[7]] = ((UnivariateDerivative1)rotation.getQ3()).getFirstDerivative();
            return 2.QUATERNION_DERIVATIVE.formatData(data);
        }

        @Override
        public TimeStampedAngularCoordinates build(boolean isFirst, boolean isExternal2SpacecraftBody, RotationOrder eulerRotSequence, boolean isSpacecraftBodyRate, AbsoluteDate date, double ... components) {
            FieldRotation rotation;
            FieldRotation fieldRotation = rotation = isFirst ? new FieldRotation((CalculusFieldElement)new UnivariateDerivative1(components[0], components[4]), (CalculusFieldElement)new UnivariateDerivative1(components[1], components[5]), (CalculusFieldElement)new UnivariateDerivative1(components[2], components[6]), (CalculusFieldElement)new UnivariateDerivative1(components[3], components[7]), true) : new FieldRotation((CalculusFieldElement)new UnivariateDerivative1(components[3], components[7]), (CalculusFieldElement)new UnivariateDerivative1(components[0], components[4]), (CalculusFieldElement)new UnivariateDerivative1(components[1], components[5]), (CalculusFieldElement)new UnivariateDerivative1(components[2], components[6]), true);
            if (!isExternal2SpacecraftBody) {
                rotation = rotation.revert();
            }
            return new TimeStampedAngularCoordinates(date, rotation);
        }
    }
    ,
    QUATERNION_RATE("QUATERNION/RATE", AngularDerivativesFilter.USE_RR, new Unit[]{Unit.ONE, Unit.ONE, Unit.ONE, Unit.ONE, Units.DEG_PER_S, Units.DEG_PER_S, Units.DEG_PER_S}){

        @Override
        public String[] createDataFields(boolean isFirst, boolean isExternal2SpacecraftBody, RotationOrder eulerRotSequence, boolean isSpacecraftBodyRate, TimeStampedAngularCoordinates coordinates) {
            int[] nArray;
            double[] data = new double[7];
            if (isFirst) {
                int[] nArray2 = new int[4];
                nArray2[0] = 0;
                nArray2[1] = 1;
                nArray2[2] = 2;
                nArray = nArray2;
                nArray2[3] = 3;
            } else {
                int[] nArray3 = new int[4];
                nArray3[0] = 3;
                nArray3[1] = 0;
                nArray3[2] = 1;
                nArray = nArray3;
                nArray3[3] = 2;
            }
            int[] quaternionIndex = nArray;
            TimeStampedAngularCoordinates c = isExternal2SpacecraftBody ? coordinates : coordinates.revert();
            Vector3D rotationRate = 3.QUATERNION_RATE.metadataRate(isSpacecraftBodyRate, c.getRotationRate(), c.getRotation());
            data[quaternionIndex[0]] = c.getRotation().getQ0();
            data[quaternionIndex[1]] = c.getRotation().getQ1();
            data[quaternionIndex[2]] = c.getRotation().getQ2();
            data[quaternionIndex[3]] = c.getRotation().getQ3();
            data[4] = rotationRate.getX();
            data[5] = rotationRate.getY();
            data[6] = rotationRate.getZ();
            return 3.QUATERNION_RATE.formatData(data);
        }

        @Override
        public TimeStampedAngularCoordinates build(boolean isFirst, boolean isExternal2SpacecraftBody, RotationOrder eulerRotSequence, boolean isSpacecraftBodyRate, AbsoluteDate date, double ... components) {
            Rotation rotation = isFirst ? new Rotation(components[0], components[1], components[2], components[3], true) : new Rotation(components[3], components[0], components[1], components[2], true);
            Vector3D rotationRate = 3.QUATERNION_RATE.orekitRate(isSpacecraftBodyRate, new Vector3D(components[4], components[5], components[6]), rotation);
            TimeStampedAngularCoordinates ac = new TimeStampedAngularCoordinates(date, rotation, rotationRate, Vector3D.ZERO);
            return isExternal2SpacecraftBody ? ac : ac.revert();
        }
    }
    ,
    EULER_ANGLE("EULER ANGLE", AngularDerivativesFilter.USE_R, new Unit[]{Unit.DEGREE, Unit.DEGREE, Unit.DEGREE}){

        @Override
        public String[] createDataFields(boolean isFirst, boolean isExternal2SpacecraftBody, RotationOrder eulerRotSequence, boolean isSpacecraftBodyRate, TimeStampedAngularCoordinates coordinates) {
            Rotation rotation = coordinates.getRotation();
            if (!isExternal2SpacecraftBody) {
                rotation = rotation.revert();
            }
            double[] data = rotation.getAngles(eulerRotSequence, RotationConvention.FRAME_TRANSFORM);
            return 4.EULER_ANGLE.formatData(data);
        }

        @Override
        public TimeStampedAngularCoordinates build(boolean isFirst, boolean isExternal2SpacecraftBody, RotationOrder eulerRotSequence, boolean isSpacecraftBodyRate, AbsoluteDate date, double ... components) {
            Rotation rotation = new Rotation(eulerRotSequence, RotationConvention.FRAME_TRANSFORM, components[0], components[1], components[2]);
            if (!isExternal2SpacecraftBody) {
                rotation = rotation.revert();
            }
            return new TimeStampedAngularCoordinates(date, rotation, Vector3D.ZERO, Vector3D.ZERO);
        }
    }
    ,
    EULER_ANGLE_RATE("EULER ANGLE/RATE", AngularDerivativesFilter.USE_RR, new Unit[]{Unit.DEGREE, Unit.DEGREE, Unit.DEGREE, Units.DEG_PER_S, Units.DEG_PER_S, Units.DEG_PER_S}){

        @Override
        public String[] createDataFields(boolean isFirst, boolean isExternal2SpacecraftBody, RotationOrder eulerRotSequence, boolean isSpacecraftBodyRate, TimeStampedAngularCoordinates coordinates) {
            double[] data = new double[6];
            TimeStampedAngularCoordinates c = isExternal2SpacecraftBody ? coordinates : coordinates.revert();
            Vector3D rotationRate = 5.EULER_ANGLE_RATE.metadataRate(isSpacecraftBodyRate, c.getRotationRate(), c.getRotation());
            double[] angles = c.getRotation().getAngles(eulerRotSequence, RotationConvention.FRAME_TRANSFORM);
            data[0] = angles[0];
            data[1] = angles[1];
            data[2] = angles[2];
            data[3] = Vector3D.dotProduct((Vector3D)rotationRate, (Vector3D)eulerRotSequence.getA1());
            data[4] = Vector3D.dotProduct((Vector3D)rotationRate, (Vector3D)eulerRotSequence.getA2());
            data[5] = Vector3D.dotProduct((Vector3D)rotationRate, (Vector3D)eulerRotSequence.getA3());
            return 5.EULER_ANGLE_RATE.formatData(data);
        }

        @Override
        public TimeStampedAngularCoordinates build(boolean isFirst, boolean isExternal2SpacecraftBody, RotationOrder eulerRotSequence, boolean isSpacecraftBodyRate, AbsoluteDate date, double ... components) {
            Rotation rotation = new Rotation(eulerRotSequence, RotationConvention.FRAME_TRANSFORM, components[0], components[1], components[2]);
            Vector3D rotationRate = 5.EULER_ANGLE_RATE.orekitRate(isSpacecraftBodyRate, new Vector3D(components[3], eulerRotSequence.getA1(), components[4], eulerRotSequence.getA2(), components[5], eulerRotSequence.getA3()), rotation);
            TimeStampedAngularCoordinates ac = new TimeStampedAngularCoordinates(date, rotation, rotationRate, Vector3D.ZERO);
            return isExternal2SpacecraftBody ? ac : ac.revert();
        }
    }
    ,
    SPIN("SPIN", AngularDerivativesFilter.USE_RR, new Unit[]{Unit.DEGREE, Unit.DEGREE, Unit.DEGREE, Units.DEG_PER_S}){

        @Override
        public String[] createDataFields(boolean isFirst, boolean isExternal2SpacecraftBody, RotationOrder eulerRotSequence, boolean isSpacecraftBodyRate, TimeStampedAngularCoordinates coordinates) {
            double[] data = new double[4];
            double[] angles = coordinates.getRotation().getAngles(RotationOrder.ZYZ, RotationConvention.FRAME_TRANSFORM);
            data[0] = angles[0];
            data[1] = 1.5707963267948966 - angles[1];
            data[2] = angles[2];
            data[3] = coordinates.getRotationRate().getZ();
            return 6.SPIN.formatData(data);
        }

        @Override
        public TimeStampedAngularCoordinates build(boolean isFirst, boolean isExternal2SpacecraftBody, RotationOrder eulerRotSequence, boolean isSpacecraftBodyRate, AbsoluteDate date, double ... components) {
            Rotation rotation = new Rotation(RotationOrder.ZYZ, RotationConvention.FRAME_TRANSFORM, components[0], 1.5707963267948966 - components[1], components[2]);
            Vector3D rotationRate = new Vector3D(0.0, 0.0, components[3]);
            return new TimeStampedAngularCoordinates(date, rotation, rotationRate, Vector3D.ZERO);
        }
    }
    ,
    SPIN_NUTATION("SPIN/NUTATION", AngularDerivativesFilter.USE_RR, new Unit[]{Unit.DEGREE, Unit.DEGREE, Unit.DEGREE, Units.DEG_PER_S, Unit.DEGREE, Unit.SECOND, Unit.DEGREE}){

        @Override
        public String[] createDataFields(boolean isFirst, boolean isExternal2SpacecraftBody, RotationOrder eulerRotSequence, boolean isSpacecraftBodyRate, TimeStampedAngularCoordinates coordinates) {
            throw new OrekitException((Localizable)OrekitMessages.CCSDS_AEM_ATTITUDE_TYPE_NOT_IMPLEMENTED, this.name());
        }

        @Override
        public TimeStampedAngularCoordinates build(boolean isFirst, boolean isExternal2SpacecraftBody, RotationOrder eulerRotSequence, boolean isSpacecraftBodyRate, AbsoluteDate date, double ... components) {
            throw new OrekitException((Localizable)OrekitMessages.CCSDS_AEM_ATTITUDE_TYPE_NOT_IMPLEMENTED, this.name());
        }
    };

    private static final Pattern TYPE_SEPARATORS;
    private final String ccsdsName;
    private final AngularDerivativesFilter filter;
    private final Unit[] units;

    private AttitudeType(String ccsdsName, AngularDerivativesFilter filter, Unit ... units) {
        this.ccsdsName = ccsdsName;
        this.filter = filter;
        this.units = (Unit[])units.clone();
    }

    public String toString() {
        return this.ccsdsName;
    }

    public static AttitudeType parseType(String type) {
        return AttitudeType.valueOf(TYPE_SEPARATORS.matcher(type).replaceAll("_"));
    }

    public abstract String[] createDataFields(boolean var1, boolean var2, RotationOrder var3, boolean var4, TimeStampedAngularCoordinates var5);

    public TimeStampedAngularCoordinates parse(boolean isFirst, boolean isExternal2SpacecraftBody, RotationOrder eulerRotSequence, boolean isSpacecraftBodyRate, ContextBinding context, String[] fields) {
        AbsoluteDate date = context.getTimeSystem().getConverter(context).parse(fields[0]);
        double[] components = new double[fields.length - 1];
        for (int i = 0; i < components.length; ++i) {
            components[i] = this.units[i].toSI(Double.parseDouble(fields[i + 1]));
        }
        return this.build(isFirst, isExternal2SpacecraftBody, eulerRotSequence, isSpacecraftBodyRate, date, components);
    }

    public abstract TimeStampedAngularCoordinates build(boolean var1, boolean var2, RotationOrder var3, boolean var4, AbsoluteDate var5, double ... var6);

    public AngularDerivativesFilter getAngularDerivativesFilter() {
        return this.filter;
    }

    private String[] formatData(double[] data) {
        String[] fields = new String[data.length];
        for (int i = 0; i < data.length; ++i) {
            fields[i] = AccurateFormatter.format(this.units[i].fromSI(data[i]));
        }
        return fields;
    }

    private Vector3D metadataRate(boolean isSpacecraftBodyRate, Vector3D rate, Rotation rotation) {
        return isSpacecraftBodyRate ? rate : rotation.applyInverseTo(rate);
    }

    private Vector3D orekitRate(boolean isSpacecraftBodyRate, Vector3D rate, Rotation rotation) {
        return isSpacecraftBodyRate ? rate : rotation.applyTo(rate);
    }

    static {
        TYPE_SEPARATORS = Pattern.compile("[ _/]+");
    }
}

