/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.files.ccsds.ndm;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.hipparchus.exception.Localizable;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.files.ccsds.ndm.Ndm;
import org.orekit.files.ccsds.ndm.NdmConstituent;
import org.orekit.files.ccsds.ndm.NdmStructureKey;
import org.orekit.files.ccsds.ndm.ParserBuilder;
import org.orekit.files.ccsds.section.CommentsContainer;
import org.orekit.files.ccsds.utils.FileFormat;
import org.orekit.files.ccsds.utils.lexical.ParseToken;
import org.orekit.files.ccsds.utils.lexical.XmlTokenBuilder;
import org.orekit.files.ccsds.utils.parsing.AbstractMessageParser;

public class NdmParser
extends AbstractMessageParser<Ndm> {
    private final ParserBuilder builder;
    private AbstractMessageParser<? extends NdmConstituent<?, ?>> constituentParser;
    private CommentsContainer comments;
    private List<NdmConstituent<?, ?>> constituents;

    public NdmParser(ParserBuilder builder) {
        super(NdmStructureKey.ndm.name(), null);
        this.builder = builder;
    }

    @Override
    public Map<String, XmlTokenBuilder> getSpecialXmlElementsBuilders() {
        Map<String, XmlTokenBuilder> builders = super.getSpecialXmlElementsBuilders();
        builders.putAll(this.builder.buildTdmParser().getSpecialXmlElementsBuilders());
        builders.putAll(this.builder.buildOpmParser().getSpecialXmlElementsBuilders());
        builders.putAll(this.builder.buildOmmParser().getSpecialXmlElementsBuilders());
        builders.putAll(this.builder.buildOemParser().getSpecialXmlElementsBuilders());
        builders.putAll(this.builder.buildOcmParser().getSpecialXmlElementsBuilders());
        builders.putAll(this.builder.buildApmParser().getSpecialXmlElementsBuilders());
        builders.putAll(this.builder.buildAemParser().getSpecialXmlElementsBuilders());
        return builders;
    }

    @Override
    public void reset(FileFormat fileFormat) {
        this.reset(fileFormat, this::processToken);
        this.constituentParser = null;
        this.comments = new CommentsContainer();
        this.constituents = new ArrayList();
    }

    @Override
    public Ndm build() {
        return new Ndm(this.comments.getComments(), this.constituents);
    }

    public boolean addComment(String comment) {
        return this.comments.addComment(comment);
    }

    boolean manageTdmConstituent() {
        return this.manageConstituent(this.builder::buildTdmParser);
    }

    boolean manageOpmConstituent() {
        return this.manageConstituent(this.builder::buildOpmParser);
    }

    boolean manageOmmConstituent() {
        return this.manageConstituent(this.builder::buildOmmParser);
    }

    boolean manageOemConstituent() {
        return this.manageConstituent(this.builder::buildOemParser);
    }

    boolean manageOcmConstituent() {
        return this.manageConstituent(this.builder::buildOcmParser);
    }

    boolean manageApmConstituent() {
        return this.manageConstituent(this.builder::buildApmParser);
    }

    boolean manageAemConstituent() {
        return this.manageConstituent(this.builder::buildAemParser);
    }

    boolean manageConstituent(Supplier<AbstractMessageParser<? extends NdmConstituent<?, ?>>> parserSupplier) {
        this.comments.refuseFurtherComments();
        this.constituentParser = parserSupplier.get();
        this.constituentParser.reset(this.getFileFormat());
        return true;
    }

    private boolean processToken(ParseToken token) {
        if (this.getFileFormat() == FileFormat.KVN) {
            throw new OrekitException((Localizable)OrekitMessages.UNSUPPORTED_FILE_FORMAT, token.getFileName());
        }
        if (this.constituentParser == null) {
            try {
                return NdmStructureKey.valueOf(token.getName()).process(token, this);
            }
            catch (IllegalArgumentException iae) {
                return false;
            }
        }
        this.constituentParser.process(token);
        if (this.constituentParser.wasEndTagSeen()) {
            this.constituents.add((NdmConstituent<?, ?>)this.constituentParser.build());
            this.constituentParser = null;
        }
        return true;
    }
}

