/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.estimation.sequential;

import java.util.ArrayList;
import java.util.List;
import org.hipparchus.exception.Localizable;
import org.hipparchus.linear.MatrixDecomposer;
import org.hipparchus.linear.QRDecomposer;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.estimation.sequential.CovarianceMatrixProvider;
import org.orekit.estimation.sequential.KalmanEstimator;
import org.orekit.propagation.conversion.OrbitDeterminationPropagatorBuilder;
import org.orekit.utils.ParameterDriversList;

public class KalmanEstimatorBuilder {
    private MatrixDecomposer decomposer = new QRDecomposer(1.0E-15);
    private List<OrbitDeterminationPropagatorBuilder> propagatorBuilders = new ArrayList<OrbitDeterminationPropagatorBuilder>();
    private ParameterDriversList estimatedMeasurementsParameters = new ParameterDriversList();
    private List<CovarianceMatrixProvider> processNoiseMatricesProviders = new ArrayList<CovarianceMatrixProvider>();
    private CovarianceMatrixProvider measurementProcessNoiseMatrix = null;

    public KalmanEstimator build() {
        int n = this.propagatorBuilders.size();
        if (n == 0) {
            throw new OrekitException((Localizable)OrekitMessages.NO_PROPAGATOR_CONFIGURED, new Object[0]);
        }
        return new KalmanEstimator(this.decomposer, this.propagatorBuilders, this.processNoiseMatricesProviders, this.estimatedMeasurementsParameters, this.measurementProcessNoiseMatrix);
    }

    public KalmanEstimatorBuilder decomposer(MatrixDecomposer matrixDecomposer) {
        this.decomposer = matrixDecomposer;
        return this;
    }

    public KalmanEstimatorBuilder addPropagationConfiguration(OrbitDeterminationPropagatorBuilder builder, CovarianceMatrixProvider provider) {
        this.propagatorBuilders.add(builder);
        this.processNoiseMatricesProviders.add(provider);
        return this;
    }

    public KalmanEstimatorBuilder estimatedMeasurementsParameters(ParameterDriversList estimatedMeasurementsParams, CovarianceMatrixProvider provider) {
        this.estimatedMeasurementsParameters = estimatedMeasurementsParams;
        this.measurementProcessNoiseMatrix = provider;
        return this;
    }
}

