/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.estimation.measurements.gnss;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import org.hipparchus.CalculusFieldElement;
import org.hipparchus.analysis.differentiation.Gradient;
import org.orekit.estimation.measurements.AbstractMeasurement;
import org.orekit.estimation.measurements.EstimatedMeasurement;
import org.orekit.estimation.measurements.ObservableSatellite;
import org.orekit.propagation.SpacecraftState;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.utils.FieldPVCoordinates;
import org.orekit.utils.PVCoordinates;
import org.orekit.utils.PVCoordinatesProvider;
import org.orekit.utils.ParameterDriver;
import org.orekit.utils.TimeStampedFieldPVCoordinates;
import org.orekit.utils.TimeStampedPVCoordinates;

public class OneWayGNSSRange
extends AbstractMeasurement<OneWayGNSSRange> {
    private final PVCoordinatesProvider remote;
    private final double dtRemote;

    public OneWayGNSSRange(PVCoordinatesProvider remote, double dtRemote, AbsoluteDate date, double range, double sigma, double baseWeight, ObservableSatellite local) {
        super(date, range, sigma, baseWeight, Collections.singletonList(local));
        this.addParameterDriver(local.getClockOffsetDriver());
        this.dtRemote = dtRemote;
        this.remote = remote;
    }

    @Override
    protected EstimatedMeasurement<OneWayGNSSRange> theoreticalEvaluation(int iteration, int evaluation, SpacecraftState[] states) {
        int nbEstimatedParams = 6;
        HashMap<String, Integer> parameterIndices = new HashMap<String, Integer>();
        for (ParameterDriver measurementDriver : this.getParametersDrivers()) {
            if (!measurementDriver.isSelected()) continue;
            parameterIndices.put(measurementDriver.getName(), nbEstimatedParams++);
        }
        SpacecraftState localState = states[0];
        TimeStampedFieldPVCoordinates<Gradient> pvaLocal = OneWayGNSSRange.getCoordinates(localState, 0, nbEstimatedParams);
        TimeStampedPVCoordinates pvaRemote = this.remote.getPVCoordinates(this.getDate(), localState.getFrame());
        Gradient dtLocal = this.getSatellites().get(0).getClockOffsetDriver().getValue(nbEstimatedParams, parameterIndices);
        FieldAbsoluteDate<Gradient> arrivalDate = new FieldAbsoluteDate<Gradient>(this.getDate(), dtLocal.negate());
        FieldPVCoordinates s1Downlink = pvaLocal.shiftedBy((CalculusFieldElement)arrivalDate.durationFrom(pvaLocal.getDate()));
        Gradient tauD = OneWayGNSSRange.signalTimeOfFlight(new TimeStampedFieldPVCoordinates<Gradient>(pvaRemote.getDate(), dtLocal.getField().getOne(), (PVCoordinates)pvaRemote), s1Downlink.getPosition(), arrivalDate);
        double delta = this.getDate().durationFrom(pvaRemote.getDate());
        Gradient deltaMTauD = tauD.negate().add(delta);
        EstimatedMeasurement<OneWayGNSSRange> estimatedRange = new EstimatedMeasurement<OneWayGNSSRange>(this, iteration, evaluation, new SpacecraftState[]{localState.shiftedBy(deltaMTauD.getValue())}, new TimeStampedPVCoordinates[]{pvaRemote.shiftedBy(delta - tauD.getValue()), localState.shiftedBy(delta).getPVCoordinates()});
        Gradient range = tauD.add(dtLocal).subtract(this.dtRemote).multiply(2.99792458E8);
        double[] rangeDerivatives = range.getGradient();
        estimatedRange.setEstimatedValue(range.getValue());
        estimatedRange.setStateDerivatives(0, new double[][]{Arrays.copyOfRange(rangeDerivatives, 0, 6)});
        for (ParameterDriver measurementDriver : this.getParametersDrivers()) {
            Integer index = (Integer)parameterIndices.get(measurementDriver.getName());
            if (index == null) continue;
            estimatedRange.setParameterDerivatives(measurementDriver, rangeDerivatives[index]);
        }
        return estimatedRange;
    }
}

