/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.estimation.measurements.gnss;

import java.util.ArrayList;
import org.hipparchus.util.FastMath;
import org.orekit.estimation.measurements.gnss.CombinationType;
import org.orekit.estimation.measurements.gnss.MeasurementCombination;
import org.orekit.estimation.measurements.gnss.MeasurementCombinationFactory;
import org.orekit.estimation.measurements.gnss.NarrowLaneCombination;
import org.orekit.estimation.measurements.gnss.WideLaneCombination;
import org.orekit.gnss.CombinedObservationData;
import org.orekit.gnss.CombinedObservationDataSet;
import org.orekit.gnss.MeasurementType;
import org.orekit.gnss.ObservationData;
import org.orekit.gnss.ObservationDataSet;
import org.orekit.gnss.SatelliteSystem;

public class MelbourneWubbenaCombination
implements MeasurementCombination {
    private static final double THRESHOLD = 1.0E-10;
    private final SatelliteSystem system;

    MelbourneWubbenaCombination(SatelliteSystem system) {
        this.system = system;
    }

    @Override
    public CombinedObservationDataSet combine(ObservationDataSet observations) {
        WideLaneCombination wideLane = MeasurementCombinationFactory.getWideLaneCombination(this.system);
        CombinedObservationDataSet combinedWL = wideLane.combine(observations);
        NarrowLaneCombination narrowLane = MeasurementCombinationFactory.getNarrowLaneCombination(this.system);
        CombinedObservationDataSet combinedNL = narrowLane.combine(observations);
        ArrayList<CombinedObservationData> combined = new ArrayList<CombinedObservationData>();
        for (CombinedObservationData odWL : combinedWL.getObservationData()) {
            if (odWL.getMeasurementType() != MeasurementType.CARRIER_PHASE) continue;
            for (CombinedObservationData odNL : combinedNL.getObservationData()) {
                boolean isCombinationPossible;
                if (odNL.getMeasurementType() != MeasurementType.PSEUDO_RANGE || !(isCombinationPossible = this.isCombinationPossible(odWL, odNL))) continue;
                double combinedValue = odWL.getValue() - odNL.getValue();
                double combinedFrequency = odWL.getCombinedMHzFrequency();
                ArrayList<ObservationData> usedData = new ArrayList<ObservationData>(4);
                usedData.add(0, odWL.getUsedObservationData().get(0));
                usedData.add(1, odWL.getUsedObservationData().get(1));
                usedData.add(2, odNL.getUsedObservationData().get(0));
                usedData.add(3, odNL.getUsedObservationData().get(1));
                combined.add(new CombinedObservationData(CombinationType.MELBOURNE_WUBBENA, MeasurementType.COMBINED_RANGE_PHASE, combinedValue, combinedFrequency, usedData));
            }
        }
        return new CombinedObservationDataSet(observations.getHeader(), observations.getSatelliteSystem(), observations.getPrnNumber(), observations.getDate(), observations.getRcvrClkOffset(), combined);
    }

    private boolean isCombinationPossible(CombinedObservationData odWL, CombinedObservationData odNL) {
        double[] frequency = new double[4];
        int j = 0;
        for (int i = 0; i < odWL.getUsedObservationData().size(); ++i) {
            frequency[j++] = odWL.getUsedObservationData().get(i).getObservationType().getFrequency(this.system).getMHzFrequency();
            frequency[j++] = odNL.getUsedObservationData().get(i).getObservationType().getFrequency(this.system).getMHzFrequency();
        }
        return FastMath.abs((double)(frequency[0] - frequency[2])) - FastMath.abs((double)(frequency[1] - frequency[3])) < 1.0E-10;
    }

    @Override
    public String getName() {
        return CombinationType.MELBOURNE_WUBBENA.getName();
    }
}

